"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnFilter = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.946Z","fingerprint":"sIU/u95NvivFW36TBRTj6U0+LXX2pRg8rb/oxuvyarg="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnFilterProps`
 *
 * @param properties - the TypeScript properties of a `CfnFilterProps`
 *
 * @returns the result of the validation.
 */
function CfnFilterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('filterAction', cdk.requiredValidator)(properties.filterAction));
    errors.collect(cdk.propertyValidator('filterAction', cdk.validateString)(properties.filterAction));
    errors.collect(cdk.propertyValidator('filterCriteria', cdk.requiredValidator)(properties.filterCriteria));
    errors.collect(cdk.propertyValidator('filterCriteria', CfnFilter_FilterCriteriaPropertyValidator)(properties.filterCriteria));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "CfnFilterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter` resource
 *
 * @param properties - the TypeScript properties of a `CfnFilterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter` resource.
 */
// @ts-ignore TS6133
function cfnFilterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilterPropsValidator(properties).assertSuccess();
    return {
        FilterAction: cdk.stringToCloudFormation(properties.filterAction),
        FilterCriteria: cfnFilterFilterCriteriaPropertyToCloudFormation(properties.filterCriteria),
        Name: cdk.stringToCloudFormation(properties.name),
        Description: cdk.stringToCloudFormation(properties.description),
    };
}
// @ts-ignore TS6133
function CfnFilterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('filterAction', 'FilterAction', cfn_parse.FromCloudFormation.getString(properties.FilterAction));
    ret.addPropertyResult('filterCriteria', 'FilterCriteria', CfnFilterFilterCriteriaPropertyFromCloudFormation(properties.FilterCriteria));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::InspectorV2::Filter`
 *
 *
 *
 * @cloudformationResource AWS::InspectorV2::Filter
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-filter.html
 */
class CfnFilter extends cdk.CfnResource {
    /**
     * Create a new `AWS::InspectorV2::Filter`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnFilter.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_inspectorv2_CfnFilterProps(props);
        cdk.requireProperty(props, 'filterAction', this);
        cdk.requireProperty(props, 'filterCriteria', this);
        cdk.requireProperty(props, 'name', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.filterAction = props.filterAction;
        this.filterCriteria = props.filterCriteria;
        this.name = props.name;
        this.description = props.description;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnFilterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnFilter(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnFilter.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            filterAction: this.filterAction,
            filterCriteria: this.filterCriteria,
            name: this.name,
            description: this.description,
        };
    }
    renderProperties(props) {
        return cfnFilterPropsToCloudFormation(props);
    }
}
exports.CfnFilter = CfnFilter;
_a = JSII_RTTI_SYMBOL_1;
CfnFilter[_a] = { fqn: "monocdk.aws_inspectorv2.CfnFilter", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnFilter.CFN_RESOURCE_TYPE_NAME = "AWS::InspectorV2::Filter";
/**
 * Determine whether the given properties match those of a `DateFilterProperty`
 *
 * @param properties - the TypeScript properties of a `DateFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_DateFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endInclusive', cdk.validateNumber)(properties.endInclusive));
    errors.collect(cdk.propertyValidator('startInclusive', cdk.validateNumber)(properties.startInclusive));
    return errors.wrap('supplied properties not correct for "DateFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.DateFilter` resource
 *
 * @param properties - the TypeScript properties of a `DateFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.DateFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterDateFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_DateFilterPropertyValidator(properties).assertSuccess();
    return {
        EndInclusive: cdk.numberToCloudFormation(properties.endInclusive),
        StartInclusive: cdk.numberToCloudFormation(properties.startInclusive),
    };
}
// @ts-ignore TS6133
function CfnFilterDateFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endInclusive', 'EndInclusive', properties.EndInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.EndInclusive) : undefined);
    ret.addPropertyResult('startInclusive', 'StartInclusive', properties.StartInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.StartInclusive) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FilterCriteriaProperty`
 *
 * @param properties - the TypeScript properties of a `FilterCriteriaProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_FilterCriteriaPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('awsAccountId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.awsAccountId));
    errors.collect(cdk.propertyValidator('componentId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.componentId));
    errors.collect(cdk.propertyValidator('componentType', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.componentType));
    errors.collect(cdk.propertyValidator('ec2InstanceImageId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ec2InstanceImageId));
    errors.collect(cdk.propertyValidator('ec2InstanceSubnetId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ec2InstanceSubnetId));
    errors.collect(cdk.propertyValidator('ec2InstanceVpcId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ec2InstanceVpcId));
    errors.collect(cdk.propertyValidator('ecrImageArchitecture', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ecrImageArchitecture));
    errors.collect(cdk.propertyValidator('ecrImageHash', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ecrImageHash));
    errors.collect(cdk.propertyValidator('ecrImagePushedAt', cdk.listValidator(CfnFilter_DateFilterPropertyValidator))(properties.ecrImagePushedAt));
    errors.collect(cdk.propertyValidator('ecrImageRegistry', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ecrImageRegistry));
    errors.collect(cdk.propertyValidator('ecrImageRepositoryName', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ecrImageRepositoryName));
    errors.collect(cdk.propertyValidator('ecrImageTags', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.ecrImageTags));
    errors.collect(cdk.propertyValidator('findingArn', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.findingArn));
    errors.collect(cdk.propertyValidator('findingStatus', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.findingStatus));
    errors.collect(cdk.propertyValidator('findingType', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.findingType));
    errors.collect(cdk.propertyValidator('firstObservedAt', cdk.listValidator(CfnFilter_DateFilterPropertyValidator))(properties.firstObservedAt));
    errors.collect(cdk.propertyValidator('inspectorScore', cdk.listValidator(CfnFilter_NumberFilterPropertyValidator))(properties.inspectorScore));
    errors.collect(cdk.propertyValidator('lastObservedAt', cdk.listValidator(CfnFilter_DateFilterPropertyValidator))(properties.lastObservedAt));
    errors.collect(cdk.propertyValidator('networkProtocol', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.networkProtocol));
    errors.collect(cdk.propertyValidator('portRange', cdk.listValidator(CfnFilter_PortRangeFilterPropertyValidator))(properties.portRange));
    errors.collect(cdk.propertyValidator('relatedVulnerabilities', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.relatedVulnerabilities));
    errors.collect(cdk.propertyValidator('resourceId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.resourceId));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnFilter_MapFilterPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.resourceType));
    errors.collect(cdk.propertyValidator('severity', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.severity));
    errors.collect(cdk.propertyValidator('title', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.title));
    errors.collect(cdk.propertyValidator('updatedAt', cdk.listValidator(CfnFilter_DateFilterPropertyValidator))(properties.updatedAt));
    errors.collect(cdk.propertyValidator('vendorSeverity', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.vendorSeverity));
    errors.collect(cdk.propertyValidator('vulnerabilityId', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.vulnerabilityId));
    errors.collect(cdk.propertyValidator('vulnerabilitySource', cdk.listValidator(CfnFilter_StringFilterPropertyValidator))(properties.vulnerabilitySource));
    errors.collect(cdk.propertyValidator('vulnerablePackages', cdk.listValidator(CfnFilter_PackageFilterPropertyValidator))(properties.vulnerablePackages));
    return errors.wrap('supplied properties not correct for "FilterCriteriaProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.FilterCriteria` resource
 *
 * @param properties - the TypeScript properties of a `FilterCriteriaProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.FilterCriteria` resource.
 */
// @ts-ignore TS6133
function cfnFilterFilterCriteriaPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_FilterCriteriaPropertyValidator(properties).assertSuccess();
    return {
        AwsAccountId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.awsAccountId),
        ComponentId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.componentId),
        ComponentType: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.componentType),
        Ec2InstanceImageId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ec2InstanceImageId),
        Ec2InstanceSubnetId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ec2InstanceSubnetId),
        Ec2InstanceVpcId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ec2InstanceVpcId),
        EcrImageArchitecture: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ecrImageArchitecture),
        EcrImageHash: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ecrImageHash),
        EcrImagePushedAt: cdk.listMapper(cfnFilterDateFilterPropertyToCloudFormation)(properties.ecrImagePushedAt),
        EcrImageRegistry: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ecrImageRegistry),
        EcrImageRepositoryName: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ecrImageRepositoryName),
        EcrImageTags: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.ecrImageTags),
        FindingArn: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.findingArn),
        FindingStatus: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.findingStatus),
        FindingType: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.findingType),
        FirstObservedAt: cdk.listMapper(cfnFilterDateFilterPropertyToCloudFormation)(properties.firstObservedAt),
        InspectorScore: cdk.listMapper(cfnFilterNumberFilterPropertyToCloudFormation)(properties.inspectorScore),
        LastObservedAt: cdk.listMapper(cfnFilterDateFilterPropertyToCloudFormation)(properties.lastObservedAt),
        NetworkProtocol: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.networkProtocol),
        PortRange: cdk.listMapper(cfnFilterPortRangeFilterPropertyToCloudFormation)(properties.portRange),
        RelatedVulnerabilities: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.relatedVulnerabilities),
        ResourceId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.resourceId),
        ResourceTags: cdk.listMapper(cfnFilterMapFilterPropertyToCloudFormation)(properties.resourceTags),
        ResourceType: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.resourceType),
        Severity: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.severity),
        Title: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.title),
        UpdatedAt: cdk.listMapper(cfnFilterDateFilterPropertyToCloudFormation)(properties.updatedAt),
        VendorSeverity: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.vendorSeverity),
        VulnerabilityId: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.vulnerabilityId),
        VulnerabilitySource: cdk.listMapper(cfnFilterStringFilterPropertyToCloudFormation)(properties.vulnerabilitySource),
        VulnerablePackages: cdk.listMapper(cfnFilterPackageFilterPropertyToCloudFormation)(properties.vulnerablePackages),
    };
}
// @ts-ignore TS6133
function CfnFilterFilterCriteriaPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('awsAccountId', 'AwsAccountId', properties.AwsAccountId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.AwsAccountId) : undefined);
    ret.addPropertyResult('componentId', 'ComponentId', properties.ComponentId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.ComponentId) : undefined);
    ret.addPropertyResult('componentType', 'ComponentType', properties.ComponentType != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.ComponentType) : undefined);
    ret.addPropertyResult('ec2InstanceImageId', 'Ec2InstanceImageId', properties.Ec2InstanceImageId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.Ec2InstanceImageId) : undefined);
    ret.addPropertyResult('ec2InstanceSubnetId', 'Ec2InstanceSubnetId', properties.Ec2InstanceSubnetId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.Ec2InstanceSubnetId) : undefined);
    ret.addPropertyResult('ec2InstanceVpcId', 'Ec2InstanceVpcId', properties.Ec2InstanceVpcId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.Ec2InstanceVpcId) : undefined);
    ret.addPropertyResult('ecrImageArchitecture', 'EcrImageArchitecture', properties.EcrImageArchitecture != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.EcrImageArchitecture) : undefined);
    ret.addPropertyResult('ecrImageHash', 'EcrImageHash', properties.EcrImageHash != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.EcrImageHash) : undefined);
    ret.addPropertyResult('ecrImagePushedAt', 'EcrImagePushedAt', properties.EcrImagePushedAt != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterDateFilterPropertyFromCloudFormation)(properties.EcrImagePushedAt) : undefined);
    ret.addPropertyResult('ecrImageRegistry', 'EcrImageRegistry', properties.EcrImageRegistry != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.EcrImageRegistry) : undefined);
    ret.addPropertyResult('ecrImageRepositoryName', 'EcrImageRepositoryName', properties.EcrImageRepositoryName != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.EcrImageRepositoryName) : undefined);
    ret.addPropertyResult('ecrImageTags', 'EcrImageTags', properties.EcrImageTags != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.EcrImageTags) : undefined);
    ret.addPropertyResult('findingArn', 'FindingArn', properties.FindingArn != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.FindingArn) : undefined);
    ret.addPropertyResult('findingStatus', 'FindingStatus', properties.FindingStatus != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.FindingStatus) : undefined);
    ret.addPropertyResult('findingType', 'FindingType', properties.FindingType != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.FindingType) : undefined);
    ret.addPropertyResult('firstObservedAt', 'FirstObservedAt', properties.FirstObservedAt != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterDateFilterPropertyFromCloudFormation)(properties.FirstObservedAt) : undefined);
    ret.addPropertyResult('inspectorScore', 'InspectorScore', properties.InspectorScore != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterNumberFilterPropertyFromCloudFormation)(properties.InspectorScore) : undefined);
    ret.addPropertyResult('lastObservedAt', 'LastObservedAt', properties.LastObservedAt != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterDateFilterPropertyFromCloudFormation)(properties.LastObservedAt) : undefined);
    ret.addPropertyResult('networkProtocol', 'NetworkProtocol', properties.NetworkProtocol != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.NetworkProtocol) : undefined);
    ret.addPropertyResult('portRange', 'PortRange', properties.PortRange != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterPortRangeFilterPropertyFromCloudFormation)(properties.PortRange) : undefined);
    ret.addPropertyResult('relatedVulnerabilities', 'RelatedVulnerabilities', properties.RelatedVulnerabilities != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.RelatedVulnerabilities) : undefined);
    ret.addPropertyResult('resourceId', 'ResourceId', properties.ResourceId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.ResourceId) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterMapFilterPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceType', 'ResourceType', properties.ResourceType != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.ResourceType) : undefined);
    ret.addPropertyResult('severity', 'Severity', properties.Severity != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.Severity) : undefined);
    ret.addPropertyResult('title', 'Title', properties.Title != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.Title) : undefined);
    ret.addPropertyResult('updatedAt', 'UpdatedAt', properties.UpdatedAt != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterDateFilterPropertyFromCloudFormation)(properties.UpdatedAt) : undefined);
    ret.addPropertyResult('vendorSeverity', 'VendorSeverity', properties.VendorSeverity != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.VendorSeverity) : undefined);
    ret.addPropertyResult('vulnerabilityId', 'VulnerabilityId', properties.VulnerabilityId != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.VulnerabilityId) : undefined);
    ret.addPropertyResult('vulnerabilitySource', 'VulnerabilitySource', properties.VulnerabilitySource != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterStringFilterPropertyFromCloudFormation)(properties.VulnerabilitySource) : undefined);
    ret.addPropertyResult('vulnerablePackages', 'VulnerablePackages', properties.VulnerablePackages != null ? cfn_parse.FromCloudFormation.getArray(CfnFilterPackageFilterPropertyFromCloudFormation)(properties.VulnerablePackages) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MapFilterProperty`
 *
 * @param properties - the TypeScript properties of a `MapFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_MapFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comparison', cdk.requiredValidator)(properties.comparison));
    errors.collect(cdk.propertyValidator('comparison', cdk.validateString)(properties.comparison));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "MapFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.MapFilter` resource
 *
 * @param properties - the TypeScript properties of a `MapFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.MapFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterMapFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_MapFilterPropertyValidator(properties).assertSuccess();
    return {
        Comparison: cdk.stringToCloudFormation(properties.comparison),
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnFilterMapFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comparison', 'Comparison', cfn_parse.FromCloudFormation.getString(properties.Comparison));
    ret.addPropertyResult('key', 'Key', properties.Key != null ? cfn_parse.FromCloudFormation.getString(properties.Key) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NumberFilterProperty`
 *
 * @param properties - the TypeScript properties of a `NumberFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_NumberFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('lowerInclusive', cdk.validateNumber)(properties.lowerInclusive));
    errors.collect(cdk.propertyValidator('upperInclusive', cdk.validateNumber)(properties.upperInclusive));
    return errors.wrap('supplied properties not correct for "NumberFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.NumberFilter` resource
 *
 * @param properties - the TypeScript properties of a `NumberFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.NumberFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterNumberFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_NumberFilterPropertyValidator(properties).assertSuccess();
    return {
        LowerInclusive: cdk.numberToCloudFormation(properties.lowerInclusive),
        UpperInclusive: cdk.numberToCloudFormation(properties.upperInclusive),
    };
}
// @ts-ignore TS6133
function CfnFilterNumberFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('lowerInclusive', 'LowerInclusive', properties.LowerInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.LowerInclusive) : undefined);
    ret.addPropertyResult('upperInclusive', 'UpperInclusive', properties.UpperInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.UpperInclusive) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PackageFilterProperty`
 *
 * @param properties - the TypeScript properties of a `PackageFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_PackageFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('architecture', CfnFilter_StringFilterPropertyValidator)(properties.architecture));
    errors.collect(cdk.propertyValidator('epoch', CfnFilter_NumberFilterPropertyValidator)(properties.epoch));
    errors.collect(cdk.propertyValidator('name', CfnFilter_StringFilterPropertyValidator)(properties.name));
    errors.collect(cdk.propertyValidator('release', CfnFilter_StringFilterPropertyValidator)(properties.release));
    errors.collect(cdk.propertyValidator('sourceLayerHash', CfnFilter_StringFilterPropertyValidator)(properties.sourceLayerHash));
    errors.collect(cdk.propertyValidator('version', CfnFilter_StringFilterPropertyValidator)(properties.version));
    return errors.wrap('supplied properties not correct for "PackageFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.PackageFilter` resource
 *
 * @param properties - the TypeScript properties of a `PackageFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.PackageFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterPackageFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_PackageFilterPropertyValidator(properties).assertSuccess();
    return {
        Architecture: cfnFilterStringFilterPropertyToCloudFormation(properties.architecture),
        Epoch: cfnFilterNumberFilterPropertyToCloudFormation(properties.epoch),
        Name: cfnFilterStringFilterPropertyToCloudFormation(properties.name),
        Release: cfnFilterStringFilterPropertyToCloudFormation(properties.release),
        SourceLayerHash: cfnFilterStringFilterPropertyToCloudFormation(properties.sourceLayerHash),
        Version: cfnFilterStringFilterPropertyToCloudFormation(properties.version),
    };
}
// @ts-ignore TS6133
function CfnFilterPackageFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('architecture', 'Architecture', properties.Architecture != null ? CfnFilterStringFilterPropertyFromCloudFormation(properties.Architecture) : undefined);
    ret.addPropertyResult('epoch', 'Epoch', properties.Epoch != null ? CfnFilterNumberFilterPropertyFromCloudFormation(properties.Epoch) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? CfnFilterStringFilterPropertyFromCloudFormation(properties.Name) : undefined);
    ret.addPropertyResult('release', 'Release', properties.Release != null ? CfnFilterStringFilterPropertyFromCloudFormation(properties.Release) : undefined);
    ret.addPropertyResult('sourceLayerHash', 'SourceLayerHash', properties.SourceLayerHash != null ? CfnFilterStringFilterPropertyFromCloudFormation(properties.SourceLayerHash) : undefined);
    ret.addPropertyResult('version', 'Version', properties.Version != null ? CfnFilterStringFilterPropertyFromCloudFormation(properties.Version) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PortRangeFilterProperty`
 *
 * @param properties - the TypeScript properties of a `PortRangeFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_PortRangeFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('beginInclusive', cdk.validateNumber)(properties.beginInclusive));
    errors.collect(cdk.propertyValidator('endInclusive', cdk.validateNumber)(properties.endInclusive));
    return errors.wrap('supplied properties not correct for "PortRangeFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.PortRangeFilter` resource
 *
 * @param properties - the TypeScript properties of a `PortRangeFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.PortRangeFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterPortRangeFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_PortRangeFilterPropertyValidator(properties).assertSuccess();
    return {
        BeginInclusive: cdk.numberToCloudFormation(properties.beginInclusive),
        EndInclusive: cdk.numberToCloudFormation(properties.endInclusive),
    };
}
// @ts-ignore TS6133
function CfnFilterPortRangeFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('beginInclusive', 'BeginInclusive', properties.BeginInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.BeginInclusive) : undefined);
    ret.addPropertyResult('endInclusive', 'EndInclusive', properties.EndInclusive != null ? cfn_parse.FromCloudFormation.getNumber(properties.EndInclusive) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `StringFilterProperty`
 *
 * @param properties - the TypeScript properties of a `StringFilterProperty`
 *
 * @returns the result of the validation.
 */
function CfnFilter_StringFilterPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('comparison', cdk.requiredValidator)(properties.comparison));
    errors.collect(cdk.propertyValidator('comparison', cdk.validateString)(properties.comparison));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "StringFilterProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.StringFilter` resource
 *
 * @param properties - the TypeScript properties of a `StringFilterProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::InspectorV2::Filter.StringFilter` resource.
 */
// @ts-ignore TS6133
function cfnFilterStringFilterPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnFilter_StringFilterPropertyValidator(properties).assertSuccess();
    return {
        Comparison: cdk.stringToCloudFormation(properties.comparison),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnFilterStringFilterPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('comparison', 'Comparison', cfn_parse.FromCloudFormation.getString(properties.Comparison));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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