"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExampleConstruct = void 0;
const cdk = require("../../core");
const lib_1 = require("../lib");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
class ExampleConstruct extends core_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        /// !show
        const user = new lib_1.User(this, 'MyUser', { password: cdk.SecretValue.plainText('1234') });
        const group = new lib_1.Group(this, 'MyGroup');
        const policy = new lib_1.Policy(this, 'MyPolicy');
        policy.attachToUser(user);
        group.attachInlinePolicy(policy);
    }
}
exports.ExampleConstruct = ExampleConstruct;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXhhbXBsZS5hdHRhY2hpbmcubGl0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXhhbXBsZS5hdHRhY2hpbmcubGl0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLGtDQUFrQztBQUVsQyxnQ0FBNkM7QUFFN0MsaUdBQWlHO0FBQ2pHLDhEQUE4RDtBQUM5RCxxQ0FBdUM7QUFFdkMsTUFBYSxnQkFBaUIsU0FBUSxnQkFBUztJQUM3QyxZQUFZLEtBQTJCLEVBQUUsRUFBVTtRQUNqRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLFNBQVM7UUFDVCxNQUFNLElBQUksR0FBRyxJQUFJLFVBQUksQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLEVBQUUsUUFBUSxFQUFFLEdBQUcsQ0FBQyxXQUFXLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxFQUFFLENBQUMsQ0FBQztRQUN2RixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxJQUFJLEVBQUUsU0FBUyxDQUFDLENBQUM7UUFFekMsTUFBTSxNQUFNLEdBQUcsSUFBSSxZQUFNLENBQUMsSUFBSSxFQUFFLFVBQVUsQ0FBQyxDQUFDO1FBQzVDLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDMUIsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0tBRWxDO0NBQ0Y7QUFiRCw0Q0FhQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCAqIGFzIGNvbnN0cnVjdHMgZnJvbSAnY29uc3RydWN0cyc7XG5pbXBvcnQgeyBHcm91cCwgUG9saWN5LCBVc2VyIH0gZnJvbSAnLi4vbGliJztcblxuLy8ga2VlcCB0aGlzIGltcG9ydCBzZXBhcmF0ZSBmcm9tIG90aGVyIGltcG9ydHMgdG8gcmVkdWNlIGNoYW5jZSBmb3IgbWVyZ2UgY29uZmxpY3RzIHdpdGggdjItbWFpblxuLy8gZXNsaW50LWRpc2FibGUtbmV4dC1saW5lIG5vLWR1cGxpY2F0ZS1pbXBvcnRzLCBpbXBvcnQvb3JkZXJcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJy4uLy4uL2NvcmUnO1xuXG5leHBvcnQgY2xhc3MgRXhhbXBsZUNvbnN0cnVjdCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBjb25zdHJ1Y3RzLkNvbnN0cnVjdCwgaWQ6IHN0cmluZykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICAvLy8gIXNob3dcbiAgICBjb25zdCB1c2VyID0gbmV3IFVzZXIodGhpcywgJ015VXNlcicsIHsgcGFzc3dvcmQ6IGNkay5TZWNyZXRWYWx1ZS5wbGFpblRleHQoJzEyMzQnKSB9KTtcbiAgICBjb25zdCBncm91cCA9IG5ldyBHcm91cCh0aGlzLCAnTXlHcm91cCcpO1xuXG4gICAgY29uc3QgcG9saWN5ID0gbmV3IFBvbGljeSh0aGlzLCAnTXlQb2xpY3knKTtcbiAgICBwb2xpY3kuYXR0YWNoVG9Vc2VyKHVzZXIpO1xuICAgIGdyb3VwLmF0dGFjaElubGluZVBvbGljeShwb2xpY3kpO1xuICAgIC8vLyAhaGlkZVxuICB9XG59XG4iXX0=