"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImmutableRole = void 0;
const core_1 = require("../../../core");
/**
 * An immutable wrapper around an IRole
 *
 * This wrapper ignores all mutating operations, like attaching policies or
 * adding policy statements.
 *
 * Useful in cases where you want to turn off CDK's automatic permissions
 * management, and instead have full control over all permissions.
 *
 * Note: if you want to ignore all mutations for an externally defined role
 * which was imported into the CDK with {@link Role.fromRoleArn}, you don't have to use this class -
 * simply pass the property mutable = false when calling {@link Role.fromRoleArn}.
 */
class ImmutableRole extends core_1.Resource {
    constructor(scope, id, role, addGrantsToResources) {
        super(scope, id, {
            account: role.env.account,
            region: role.env.region,
        });
        this.role = role;
        this.addGrantsToResources = addGrantsToResources;
        this.assumeRoleAction = this.role.assumeRoleAction;
        this.policyFragment = this.role.policyFragment;
        this.grantPrincipal = this;
        this.principalAccount = this.role.principalAccount;
        this.roleArn = this.role.roleArn;
        this.roleName = this.role.roleName;
        this.stack = this.role.stack;
        // implement IDependable privately
        core_1.DependableTrait.implement(this, {
            dependencyRoots: [role],
        });
    }
    attachInlinePolicy(_policy) {
    }
    addManagedPolicy(_policy) {
    }
    addToPolicy(statement) {
        return this.addToPrincipalPolicy(statement).statementAdded;
    }
    addToPrincipalPolicy(_statement) {
        // If we return `false`, the grants will try to add the statement to the resource
        // (if possible).
        const pretendSuccess = !this.addGrantsToResources;
        return { statementAdded: pretendSuccess, policyDependable: new core_1.ConcreteDependable() };
    }
    grant(grantee, ...actions) {
        return this.role.grant(grantee, ...actions);
    }
    grantPassRole(grantee) {
        return this.role.grantPassRole(grantee);
    }
}
exports.ImmutableRole = ImmutableRole;
//# sourceMappingURL=data:application/json;base64,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