"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EndpointGroup = exports.HealthCheckProtocol = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
const _accelerator_security_group_1 = require("./_accelerator-security-group");
const ga = require("./globalaccelerator.generated");
/**
 * The protocol for the connections from clients to the accelerator.
 */
var HealthCheckProtocol;
(function (HealthCheckProtocol) {
    /**
     * TCP
     */
    HealthCheckProtocol["TCP"] = "TCP";
    /**
     * HTTP
     */
    HealthCheckProtocol["HTTP"] = "HTTP";
    /**
     * HTTPS
     */
    HealthCheckProtocol["HTTPS"] = "HTTPS";
})(HealthCheckProtocol = exports.HealthCheckProtocol || (exports.HealthCheckProtocol = {}));
/**
 * EndpointGroup construct
 */
class EndpointGroup extends cdk.Resource {
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f;
        super(scope, id);
        /**
         * The array of the endpoints in this endpoint group
         */
        this.endpoints = new Array();
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_EndpointGroupProps(props);
        const resource = new ga.CfnEndpointGroup(this, 'Resource', {
            listenerArn: props.listener.listenerArn,
            endpointGroupRegion: (_b = props.region) !== null && _b !== void 0 ? _b : cdk.Lazy.string({ produce: () => this.firstEndpointRegion() }),
            endpointConfigurations: cdk.Lazy.any({ produce: () => this.renderEndpoints() }, { omitEmptyArray: true }),
            healthCheckIntervalSeconds: (_c = props.healthCheckInterval) === null || _c === void 0 ? void 0 : _c.toSeconds({ integral: true }),
            healthCheckPath: props.healthCheckPath,
            healthCheckPort: props.healthCheckPort,
            healthCheckProtocol: props.healthCheckProtocol,
            thresholdCount: props.healthCheckThreshold,
            trafficDialPercentage: props.trafficDialPercentage,
            portOverrides: (_d = props.portOverrides) === null || _d === void 0 ? void 0 : _d.map(o => ({
                endpointPort: o.endpointPort,
                listenerPort: o.listenerPort,
            })),
        });
        this.endpointGroupArn = resource.attrEndpointGroupArn;
        this.endpointGroupName = (_e = props.endpointGroupName) !== null && _e !== void 0 ? _e : resource.logicalId;
        for (const endpoint of (_f = props.endpoints) !== null && _f !== void 0 ? _f : []) {
            this.addEndpoint(endpoint);
        }
    }
    /**
     * import from ARN
     */
    static fromEndpointGroupArn(scope, id, endpointGroupArn) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.endpointGroupArn = endpointGroupArn;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add an endpoint
     */
    addEndpoint(endpoint) {
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_IEndpoint(endpoint);
        this.endpoints.push(endpoint);
    }
    /**
     * Return an object that represents the Accelerator's Security Group
     *
     * Uses a Custom Resource to look up the Security Group that Accelerator
     * creates at deploy time. Requires your VPC ID to perform the lookup.
     *
     * The Security Group will only be created if you enable **Client IP
     * Preservation** on any of the endpoints.
     *
     * You cannot manipulate the rules inside this security group, but you can
     * use this security group as a Peer in Connections rules on other
     * constructs.
     */
    connectionsPeer(id, vpc) {
        jsiiDeprecationWarnings.monocdk_aws_ec2_IVpc(vpc);
        return _accelerator_security_group_1.AcceleratorSecurityGroupPeer.fromVpc(this, id, vpc, this);
    }
    renderEndpoints() {
        return this.endpoints.map(e => e.renderEndpointConfiguration());
    }
    /**
     * Return the first (readable) region of the endpoints in this group
     */
    firstEndpointRegion() {
        for (const endpoint of this.endpoints) {
            if (endpoint.region) {
                return endpoint.region;
            }
        }
        return cdk.Stack.of(this).region;
    }
}
exports.EndpointGroup = EndpointGroup;
_a = JSII_RTTI_SYMBOL_1;
EndpointGroup[_a] = { fqn: "monocdk.aws_globalaccelerator.EndpointGroup", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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