"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use a Network Load Balancer as a Global Accelerator Endpoint
 */
class NetworkLoadBalancerEndpoint {
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_INetworkLoadBalancer(loadBalancer);
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_endpoints_NetworkLoadBalancerEndpointProps(options);
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
        };
    }
}
exports.NetworkLoadBalancerEndpoint = NetworkLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.NetworkLoadBalancerEndpoint", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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