"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an EC2 Instance as a Global Accelerator Endpoint
 */
class InstanceEndpoint {
    constructor(instance, options = {}) {
        this.instance = instance;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_ec2_IInstance(instance);
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_endpoints_InstanceEndpointProps(options);
        _util_1.validateWeight(options.weight);
        this.region = instance.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.instance.instanceId,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.InstanceEndpoint = InstanceEndpoint;
_a = JSII_RTTI_SYMBOL_1;
InstanceEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.InstanceEndpoint", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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