"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerEndpoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _util_1 = require("./_util");
/**
 * Use an Application Load Balancer as a Global Accelerator Endpoint
 */
class ApplicationLoadBalancerEndpoint {
    constructor(loadBalancer, options = {}) {
        this.loadBalancer = loadBalancer;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_IApplicationLoadBalancer(loadBalancer);
        jsiiDeprecationWarnings.monocdk_aws_globalaccelerator_endpoints_ApplicationLoadBalancerEndpointOptions(options);
        _util_1.validateWeight(options.weight);
        this.region = loadBalancer.env.region;
    }
    renderEndpointConfiguration() {
        return {
            endpointId: this.loadBalancer.loadBalancerArn,
            weight: this.options.weight,
            clientIpPreservationEnabled: this.options.preserveClientIp,
        };
    }
}
exports.ApplicationLoadBalancerEndpoint = ApplicationLoadBalancerEndpoint;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancerEndpoint[_a] = { fqn: "monocdk.aws_globalaccelerator_endpoints.ApplicationLoadBalancerEndpoint", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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