"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnPolicy = exports.CfnNotificationChannel = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.743Z","fingerprint":"1AugTTQflwKJp5FDQWDzS7HRa6fNNXfYVRFXVRbLkWM="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnNotificationChannelProps`
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the result of the validation.
 */
function CfnNotificationChannelPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.requiredValidator)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsRoleName', cdk.validateString)(properties.snsRoleName));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    return errors.wrap('supplied properties not correct for "CfnNotificationChannelProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource
 *
 * @param properties - the TypeScript properties of a `CfnNotificationChannelProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::NotificationChannel` resource.
 */
// @ts-ignore TS6133
function cfnNotificationChannelPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnNotificationChannelPropsValidator(properties).assertSuccess();
    return {
        SnsRoleName: cdk.stringToCloudFormation(properties.snsRoleName),
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
    };
}
// @ts-ignore TS6133
function CfnNotificationChannelPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsRoleName', 'SnsRoleName', cfn_parse.FromCloudFormation.getString(properties.SnsRoleName));
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::NotificationChannel`
 *
 * Designates the IAM role and Amazon Simple Notification Service (SNS) topic to use to record SNS logs.
 *
 * To perform this action outside of the console, you must configure the SNS topic to allow the role `AWSServiceRoleForFMS` to publish SNS logs. For more information, see [Firewall Manager required permissions for API actions](https://docs.aws.amazon.com/waf/latest/developerguide/fms-api-permissions-ref.html) in the *AWS Firewall Manager Developer Guide* .
 *
 * @cloudformationResource AWS::FMS::NotificationChannel
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-notificationchannel.html
 */
class CfnNotificationChannel extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::NotificationChannel`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_fms_CfnNotificationChannelProps(props);
        cdk.requireProperty(props, 'snsRoleName', this);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsRoleName = props.snsRoleName;
        this.snsTopicArn = props.snsTopicArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnNotificationChannelPropsFromCloudFormation(resourceProperties);
        const ret = new CfnNotificationChannel(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsRoleName: this.snsRoleName,
            snsTopicArn: this.snsTopicArn,
        };
    }
    renderProperties(props) {
        return cfnNotificationChannelPropsToCloudFormation(props);
    }
}
exports.CfnNotificationChannel = CfnNotificationChannel;
_a = JSII_RTTI_SYMBOL_1;
CfnNotificationChannel[_a] = { fqn: "monocdk.aws_fms.CfnNotificationChannel", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnNotificationChannel.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::NotificationChannel";
/**
 * Determine whether the given properties match those of a `CfnPolicyProps`
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the result of the validation.
 */
function CfnPolicyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deleteAllPolicyResources', cdk.validateBoolean)(properties.deleteAllPolicyResources));
    errors.collect(cdk.propertyValidator('excludeMap', CfnPolicy_IEMapPropertyValidator)(properties.excludeMap));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.requiredValidator)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('excludeResourceTags', cdk.validateBoolean)(properties.excludeResourceTags));
    errors.collect(cdk.propertyValidator('includeMap', CfnPolicy_IEMapPropertyValidator)(properties.includeMap));
    errors.collect(cdk.propertyValidator('policyName', cdk.requiredValidator)(properties.policyName));
    errors.collect(cdk.propertyValidator('policyName', cdk.validateString)(properties.policyName));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.requiredValidator)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('remediationEnabled', cdk.validateBoolean)(properties.remediationEnabled));
    errors.collect(cdk.propertyValidator('resourceTags', cdk.listValidator(CfnPolicy_ResourceTagPropertyValidator))(properties.resourceTags));
    errors.collect(cdk.propertyValidator('resourceType', cdk.requiredValidator)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceType', cdk.validateString)(properties.resourceType));
    errors.collect(cdk.propertyValidator('resourceTypeList', cdk.listValidator(cdk.validateString))(properties.resourceTypeList));
    errors.collect(cdk.propertyValidator('resourcesCleanUp', cdk.validateBoolean)(properties.resourcesCleanUp));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.requiredValidator)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('securityServicePolicyData', cdk.validateObject)(properties.securityServicePolicyData));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(CfnPolicy_PolicyTagPropertyValidator))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnPolicyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy` resource
 *
 * @param properties - the TypeScript properties of a `CfnPolicyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicyPropsValidator(properties).assertSuccess();
    return {
        ExcludeResourceTags: cdk.booleanToCloudFormation(properties.excludeResourceTags),
        PolicyName: cdk.stringToCloudFormation(properties.policyName),
        RemediationEnabled: cdk.booleanToCloudFormation(properties.remediationEnabled),
        ResourceType: cdk.stringToCloudFormation(properties.resourceType),
        SecurityServicePolicyData: cdk.objectToCloudFormation(properties.securityServicePolicyData),
        DeleteAllPolicyResources: cdk.booleanToCloudFormation(properties.deleteAllPolicyResources),
        ExcludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.excludeMap),
        IncludeMap: cfnPolicyIEMapPropertyToCloudFormation(properties.includeMap),
        ResourcesCleanUp: cdk.booleanToCloudFormation(properties.resourcesCleanUp),
        ResourceTags: cdk.listMapper(cfnPolicyResourceTagPropertyToCloudFormation)(properties.resourceTags),
        ResourceTypeList: cdk.listMapper(cdk.stringToCloudFormation)(properties.resourceTypeList),
        Tags: cdk.listMapper(cfnPolicyPolicyTagPropertyToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnPolicyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('excludeResourceTags', 'ExcludeResourceTags', cfn_parse.FromCloudFormation.getBoolean(properties.ExcludeResourceTags));
    ret.addPropertyResult('policyName', 'PolicyName', cfn_parse.FromCloudFormation.getString(properties.PolicyName));
    ret.addPropertyResult('remediationEnabled', 'RemediationEnabled', cfn_parse.FromCloudFormation.getBoolean(properties.RemediationEnabled));
    ret.addPropertyResult('resourceType', 'ResourceType', cfn_parse.FromCloudFormation.getString(properties.ResourceType));
    ret.addPropertyResult('securityServicePolicyData', 'SecurityServicePolicyData', cfn_parse.FromCloudFormation.getAny(properties.SecurityServicePolicyData));
    ret.addPropertyResult('deleteAllPolicyResources', 'DeleteAllPolicyResources', properties.DeleteAllPolicyResources != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DeleteAllPolicyResources) : undefined);
    ret.addPropertyResult('excludeMap', 'ExcludeMap', properties.ExcludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.ExcludeMap) : undefined);
    ret.addPropertyResult('includeMap', 'IncludeMap', properties.IncludeMap != null ? CfnPolicyIEMapPropertyFromCloudFormation(properties.IncludeMap) : undefined);
    ret.addPropertyResult('resourcesCleanUp', 'ResourcesCleanUp', properties.ResourcesCleanUp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ResourcesCleanUp) : undefined);
    ret.addPropertyResult('resourceTags', 'ResourceTags', properties.ResourceTags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyResourceTagPropertyFromCloudFormation)(properties.ResourceTags) : undefined);
    ret.addPropertyResult('resourceTypeList', 'ResourceTypeList', properties.ResourceTypeList != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ResourceTypeList) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(CfnPolicyPolicyTagPropertyFromCloudFormation)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::FMS::Policy`
 *
 * An AWS Firewall Manager policy.
 *
 * Firewall Manager provides the following types of policies:
 *
 * - An AWS Shield Advanced policy, which applies Shield Advanced protection to specified accounts and resources.
 * - An AWS WAF policy (type WAFV2), which defines rule groups to run first in the corresponding AWS WAF web ACL and rule groups to run last in the web ACL.
 * - An AWS WAF Classic policy, which defines a rule group. AWS WAF Classic doesn't support rule groups in Amazon CloudFront , so, to create AWS WAF Classic policies through CloudFront , you first need to create your rule groups outside of CloudFront .
 * - A security group policy, which manages VPC security groups across your AWS organization.
 * - An AWS Network Firewall policy, which provides firewall rules to filter network traffic in specified Amazon VPCs.
 * - A DNS Firewall policy, which provides Amazon Route 53 Resolver DNS Firewall rules to filter DNS queries for specified Amazon VPCs.
 *
 * Each policy is specific to one of the types. If you want to enforce more than one policy type across accounts, create multiple policies. You can create multiple policies for each type.
 *
 * These policies require some setup to use. For more information, see the sections on prerequisites and getting started under [AWS Firewall Manager](https://docs.aws.amazon.com/waf/latest/developerguide/fms-prereq.html) .
 *
 * @cloudformationResource AWS::FMS::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-fms-policy.html
 */
class CfnPolicy extends cdk.CfnResource {
    /**
     * Create a new `AWS::FMS::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPolicy.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_fms_CfnPolicyProps(props);
        cdk.requireProperty(props, 'excludeResourceTags', this);
        cdk.requireProperty(props, 'policyName', this);
        cdk.requireProperty(props, 'remediationEnabled', this);
        cdk.requireProperty(props, 'resourceType', this);
        cdk.requireProperty(props, 'securityServicePolicyData', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.excludeResourceTags = props.excludeResourceTags;
        this.policyName = props.policyName;
        this.remediationEnabled = props.remediationEnabled;
        this.resourceType = props.resourceType;
        this.securityServicePolicyData = props.securityServicePolicyData;
        this.deleteAllPolicyResources = props.deleteAllPolicyResources;
        this.excludeMap = props.excludeMap;
        this.includeMap = props.includeMap;
        this.resourcesCleanUp = props.resourcesCleanUp;
        this.resourceTags = props.resourceTags;
        this.resourceTypeList = props.resourceTypeList;
        this.tags = props.tags;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPolicyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPolicy(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPolicy.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            excludeResourceTags: this.excludeResourceTags,
            policyName: this.policyName,
            remediationEnabled: this.remediationEnabled,
            resourceType: this.resourceType,
            securityServicePolicyData: this.securityServicePolicyData,
            deleteAllPolicyResources: this.deleteAllPolicyResources,
            excludeMap: this.excludeMap,
            includeMap: this.includeMap,
            resourcesCleanUp: this.resourcesCleanUp,
            resourceTags: this.resourceTags,
            resourceTypeList: this.resourceTypeList,
            tags: this.tags,
        };
    }
    renderProperties(props) {
        return cfnPolicyPropsToCloudFormation(props);
    }
}
exports.CfnPolicy = CfnPolicy;
_b = JSII_RTTI_SYMBOL_1;
CfnPolicy[_b] = { fqn: "monocdk.aws_fms.CfnPolicy", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPolicy.CFN_RESOURCE_TYPE_NAME = "AWS::FMS::Policy";
/**
 * Determine whether the given properties match those of a `IEMapProperty`
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_IEMapPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('account', cdk.listValidator(cdk.validateString))(properties.account));
    errors.collect(cdk.propertyValidator('orgunit', cdk.listValidator(cdk.validateString))(properties.orgunit));
    return errors.wrap('supplied properties not correct for "IEMapProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource
 *
 * @param properties - the TypeScript properties of a `IEMapProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.IEMap` resource.
 */
// @ts-ignore TS6133
function cfnPolicyIEMapPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_IEMapPropertyValidator(properties).assertSuccess();
    return {
        ACCOUNT: cdk.listMapper(cdk.stringToCloudFormation)(properties.account),
        ORGUNIT: cdk.listMapper(cdk.stringToCloudFormation)(properties.orgunit),
    };
}
// @ts-ignore TS6133
function CfnPolicyIEMapPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('account', 'ACCOUNT', properties.ACCOUNT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ACCOUNT) : undefined);
    ret.addPropertyResult('orgunit', 'ORGUNIT', properties.ORGUNIT != null ? cfn_parse.FromCloudFormation.getStringArray(properties.ORGUNIT) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PolicyTagProperty`
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_PolicyTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "PolicyTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource
 *
 * @param properties - the TypeScript properties of a `PolicyTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.PolicyTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyPolicyTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_PolicyTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyPolicyTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceTagProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the result of the validation.
 */
function CfnPolicy_ResourceTagPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('key', cdk.requiredValidator)(properties.key));
    errors.collect(cdk.propertyValidator('key', cdk.validateString)(properties.key));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceTagProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource
 *
 * @param properties - the TypeScript properties of a `ResourceTagProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::FMS::Policy.ResourceTag` resource.
 */
// @ts-ignore TS6133
function cfnPolicyResourceTagPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPolicy_ResourceTagPropertyValidator(properties).assertSuccess();
    return {
        Key: cdk.stringToCloudFormation(properties.key),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnPolicyResourceTagPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('key', 'Key', cfn_parse.FromCloudFormation.getString(properties.Key));
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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