"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SfnStateMachine = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use a StepFunctions state machine as a target for Amazon EventBridge rules.
 */
class SfnStateMachine {
    constructor(machine, props = {}) {
        var _b;
        this.machine = machine;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_stepfunctions_IStateMachine(machine);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_SfnStateMachineProps(props);
        if (props.role) {
            props.role.grant(new iam.ServicePrincipal('events.amazonaws.com'));
        }
        // no statements are passed because we are configuring permissions by using grant* helper below
        this.role = (_b = props.role) !== null && _b !== void 0 ? _b : util_1.singletonEventRole(machine, []);
        machine.grantStartExecution(this.role);
    }
    /**
     * Returns a properties that are used in an Rule to trigger this State Machine
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sns-permissions
     */
    bind(_rule, _id) {
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.machine.stateMachineArn,
            role: this.role,
            input: this.props.input,
            targetResource: this.machine,
        };
    }
}
exports.SfnStateMachine = SfnStateMachine;
_a = JSII_RTTI_SYMBOL_1;
SfnStateMachine[_a] = { fqn: "monocdk.aws_events_targets.SfnStateMachine", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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