"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseStream = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Customize the Firehose Stream Event Target
 */
class KinesisFirehoseStream {
    constructor(stream, props = {}) {
        this.stream = stream;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_kinesisfirehose_CfnDeliveryStream(stream);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_KinesisFirehoseStreamProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this Firehose Stream as a
     * result from a Event Bridge event.
     */
    bind(_rule, _id) {
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        const policyStatements = [new iam.PolicyStatement({
                actions: ['firehose:PutRecord', 'firehose:PutRecordBatch'],
                resources: [this.stream.attrArn],
            })];
        return {
            arn: this.stream.attrArn,
            role: util_1.singletonEventRole(this.stream, policyStatements),
            input: this.props.message,
            targetResource: this.stream,
        };
    }
}
exports.KinesisFirehoseStream = KinesisFirehoseStream;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseStream[_a] = { fqn: "monocdk.aws_events_targets.KinesisFirehoseStream", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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