"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventBus = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Notify an existing Event Bus of an event
 */
class EventBus {
    constructor(eventBus, props = {}) {
        this.eventBus = eventBus;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_events_IEventBus(eventBus);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_EventBusProps(props);
    }
    bind(rule, _id) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        if (this.props.role) {
            this.props.role.addToPrincipalPolicy(this.putEventStatement());
        }
        const role = (_b = this.props.role) !== null && _b !== void 0 ? _b : util_1.singletonEventRole(rule, [this.putEventStatement()]);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        return {
            arn: this.eventBus.eventBusArn,
            deadLetterConfig: this.props.deadLetterQueue ? { arn: (_c = this.props.deadLetterQueue) === null || _c === void 0 ? void 0 : _c.queueArn } : undefined,
            role,
        };
    }
    putEventStatement() {
        return new iam.PolicyStatement({
            actions: ['events:PutEvents'],
            resources: [this.eventBus.eventBusArn],
        });
    }
}
exports.EventBus = EventBus;
_a = JSII_RTTI_SYMBOL_1;
EventBus[_a] = { fqn: "monocdk.aws_events_targets.EventBus", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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