"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodePipeline = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Allows the pipeline to be used as an EventBridge rule target.
 */
class CodePipeline {
    constructor(pipeline, options = {}) {
        this.pipeline = pipeline;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IPipeline(pipeline);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_CodePipelineTargetOptions(options);
    }
    bind(_rule, _id) {
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        return {
            ...util_1.bindBaseTargetConfig(this.options),
            id: '',
            arn: this.pipeline.pipelineArn,
            role: this.options.eventRole || util_1.singletonEventRole(this.pipeline, [new iam.PolicyStatement({
                    resources: [this.pipeline.pipelineArn],
                    actions: ['codepipeline:StartPipelineExecution'],
                })]),
            targetResource: this.pipeline,
        };
    }
}
exports.CodePipeline = CodePipeline;
_a = JSII_RTTI_SYMBOL_1;
CodePipeline[_a] = { fqn: "monocdk.aws_events_targets.CodePipeline", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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