"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProject = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Start a CodeBuild build when an Amazon EventBridge rule is triggered.
 */
class CodeBuildProject {
    constructor(project, props = {}) {
        this.project = project;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_codebuild_IProject(project);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_CodeBuildProjectProps(props);
    }
    /**
     * Allows using build projects as event rule targets.
     */
    bind(_rule, _id) {
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        if (this.props.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...util_1.bindBaseTargetConfig(this.props),
            arn: this.project.projectArn,
            role: this.props.eventRole || util_1.singletonEventRole(this.project, [
                new iam.PolicyStatement({
                    actions: ['codebuild:StartBuild'],
                    resources: [this.project.projectArn],
                }),
            ]),
            input: this.props.event,
            targetResource: this.project,
        };
    }
}
exports.CodeBuildProject = CodeBuildProject;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildProject[_a] = { fqn: "monocdk.aws_events_targets.CodeBuildProject", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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