"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsApi = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const events = require("../../aws-events");
const iam = require("../../aws-iam");
const lambda = require("../../aws-lambda");
const core_1 = require("../../core");
const sdk_api_metadata_generated_1 = require("./sdk-api-metadata.generated");
const util_1 = require("./util");
const awsSdkMetadata = sdk_api_metadata_generated_1.metadata;
/**
 * Use an AWS Lambda function that makes API calls as an event rule target.
 */
class AwsApi {
    constructor(props) {
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_events_targets_AwsApiProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this AwsApi as a
     * result from an EventBridge event.
     */
    bind(rule, id) {
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        const handler = new lambda.SingletonFunction(rule, `${rule.node.id}${id}Handler`, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'aws-api-handler')),
            runtime: lambda.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            uuid: 'b4cf1abd-4e4f-4bc6-9944-1af7ccd9ec37',
            lambdaPurpose: 'AWS',
        });
        checkServiceExists(this.props.service, handler);
        if (this.props.policyStatement) {
            handler.addToRolePolicy(this.props.policyStatement);
        }
        else {
            handler.addToRolePolicy(new iam.PolicyStatement({
                actions: [awsSdkToIamAction(this.props.service, this.props.action)],
                resources: ['*'],
            }));
        }
        // Allow handler to be called from rule
        util_1.addLambdaPermission(rule, handler);
        const input = {
            service: this.props.service,
            action: this.props.action,
            parameters: this.props.parameters,
            catchErrorPattern: this.props.catchErrorPattern,
            apiVersion: this.props.apiVersion,
        };
        return {
            arn: handler.functionArn,
            input: events.RuleTargetInput.fromObject(input),
            targetResource: handler,
        };
    }
}
exports.AwsApi = AwsApi;
_a = JSII_RTTI_SYMBOL_1;
AwsApi[_a] = { fqn: "monocdk.aws_events_targets.AwsApi", version: "1.149.0" };
/**
 * Check if the given service exists in the AWS SDK. If not, a warning will be raised.
 * @param service Service name
 */
function checkServiceExists(service, handler) {
    const sdkService = awsSdkMetadata[service.toLowerCase()];
    if (!sdkService) {
        core_1.Annotations.of(handler).addWarning(`Service ${service} does not exist in the AWS SDK. Check the list of available \
services and actions from https://docs.aws.amazon.com/AWSJavaScriptSDK/latest/index.html`);
    }
}
/**
 * Transform SDK service/action to IAM action using metadata from aws-sdk module.
 */
function awsSdkToIamAction(service, action) {
    const srv = service.toLowerCase();
    const iamService = awsSdkMetadata[srv].prefix || srv;
    const iamAction = action.charAt(0).toUpperCase() + action.slice(1);
    return `${iamService}:${iamAction}`;
}
//# sourceMappingURL=data:application/json;base64,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