"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGateway = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Gateway REST APIs as a target for Amazon EventBridge rules.
 */
class ApiGateway {
    constructor(restApi, props) {
        this.restApi = restApi;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_apigateway_RestApi(restApi);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_ApiGatewayProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger this API Gateway REST APIs
     * as a result from an EventBridge event.
     *
     * @see https://docs.aws.amazon.com/eventbridge/latest/userguide/resource-based-policies-eventbridge.html#sqs-permissions
     */
    bind(rule, _id) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m, _o, _p, _q, _r, _s;
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(rule);
        if ((_b = this.props) === null || _b === void 0 ? void 0 : _b.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(rule, this.props.deadLetterQueue);
        }
        const wildcardCountsInPath = (_f = (_e = (_d = (_c = this.props) === null || _c === void 0 ? void 0 : _c.path) === null || _d === void 0 ? void 0 : _d.match(/\*/g)) === null || _e === void 0 ? void 0 : _e.length) !== null && _f !== void 0 ? _f : 0;
        if (wildcardCountsInPath !== (((_g = this.props) === null || _g === void 0 ? void 0 : _g.pathParameterValues) || []).length) {
            throw new Error('The number of wildcards in the path does not match the number of path pathParameterValues.');
        }
        const restApiArn = this.restApi.arnForExecuteApi((_h = this.props) === null || _h === void 0 ? void 0 : _h.method, ((_j = this.props) === null || _j === void 0 ? void 0 : _j.path) || '/', ((_k = this.props) === null || _k === void 0 ? void 0 : _k.stage) || this.restApi.deploymentStage.stageName);
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: restApiArn,
            role: ((_l = this.props) === null || _l === void 0 ? void 0 : _l.eventRole) || util_1.singletonEventRole(this.restApi, [new iam.PolicyStatement({
                    resources: [restApiArn],
                    actions: [
                        'execute-api:Invoke',
                        'execute-api:ManageConnections',
                    ],
                })]),
            deadLetterConfig: ((_m = this.props) === null || _m === void 0 ? void 0 : _m.deadLetterQueue) && { arn: (_o = this.props.deadLetterQueue) === null || _o === void 0 ? void 0 : _o.queueArn },
            input: (_p = this.props) === null || _p === void 0 ? void 0 : _p.postBody,
            targetResource: this.restApi,
            httpParameters: {
                headerParameters: (_q = this.props) === null || _q === void 0 ? void 0 : _q.headerParameters,
                queryStringParameters: (_r = this.props) === null || _r === void 0 ? void 0 : _r.queryStringParameters,
                pathParameterValues: (_s = this.props) === null || _s === void 0 ? void 0 : _s.pathParameterValues,
            },
        };
    }
}
exports.ApiGateway = ApiGateway;
_a = JSII_RTTI_SYMBOL_1;
ApiGateway[_a] = { fqn: "monocdk.aws_events_targets.ApiGateway", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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