"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("../../aws-iam");
const util_1 = require("./util");
/**
 * Use an API Destination rule target.
 */
class ApiDestination {
    constructor(apiDestination, props = {}) {
        this.apiDestination = apiDestination;
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_events_IApiDestination(apiDestination);
        jsiiDeprecationWarnings.monocdk_aws_events_targets_ApiDestinationProps(props);
    }
    /**
     * Returns a RuleTarget that can be used to trigger API destinations
     * from an EventBridge event.
     */
    bind(_rule, _id) {
        var _b, _c, _d, _e, _f;
        jsiiDeprecationWarnings.monocdk_aws_events_IRule(_rule);
        const httpParameters = ((_c = (_b = !!this.props.headerParameters) !== null && _b !== void 0 ? _b : !!this.props.pathParameterValues) !== null && _c !== void 0 ? _c : !!this.props.queryStringParameters) ? {
            headerParameters: this.props.headerParameters,
            pathParameterValues: this.props.pathParameterValues,
            queryStringParameters: this.props.queryStringParameters,
        } : undefined;
        if ((_d = this.props) === null || _d === void 0 ? void 0 : _d.deadLetterQueue) {
            util_1.addToDeadLetterQueueResourcePolicy(_rule, this.props.deadLetterQueue);
        }
        return {
            ...(this.props ? util_1.bindBaseTargetConfig(this.props) : {}),
            arn: this.apiDestination.apiDestinationArn,
            role: (_f = (_e = this.props) === null || _e === void 0 ? void 0 : _e.eventRole) !== null && _f !== void 0 ? _f : util_1.singletonEventRole(this.apiDestination, [new iam.PolicyStatement({
                    resources: [this.apiDestination.apiDestinationArn],
                    actions: ['events:InvokeApiDestination'],
                })]),
            input: this.props.event,
            targetResource: this.apiDestination,
            httpParameters,
        };
    }
}
exports.ApiDestination = ApiDestination;
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "monocdk.aws_events_targets.ApiDestination", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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