"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderUserData = void 0;
const core_1 = require("../../core");
const spot_interrupt_handler_1 = require("./spot-interrupt-handler");
function renderUserData(clusterName, autoScalingGroup, options = {}) {
    var _a;
    const stack = core_1.Stack.of(autoScalingGroup);
    // determine logical id of ASG so we can signal cloudformation
    const cfn = autoScalingGroup.node.defaultChild;
    const asgLogicalId = cfn.logicalId;
    const extraArgs = new Array();
    extraArgs.push(`--use-max-pods ${(_a = options.useMaxPods) !== null && _a !== void 0 ? _a : true}`);
    if (options.awsApiRetryAttempts) {
        extraArgs.push(`--aws-api-retry-attempts ${options.awsApiRetryAttempts}`);
    }
    if (options.enableDockerBridge) {
        extraArgs.push('--enable-docker-bridge');
    }
    if (options.dockerConfigJson) {
        extraArgs.push(`--docker-config-json '${options.dockerConfigJson}'`);
    }
    if (options.additionalArgs) {
        extraArgs.push(options.additionalArgs);
    }
    const commandLineSuffix = extraArgs.join(' ');
    const kubeletExtraArgsSuffix = options.kubeletExtraArgs || '';
    // determine lifecycle label based on whether the ASG has a spot price.
    const lifecycleLabel = autoScalingGroup.spotPrice ? spot_interrupt_handler_1.LifecycleLabel.SPOT : spot_interrupt_handler_1.LifecycleLabel.ON_DEMAND;
    const withTaints = autoScalingGroup.spotPrice ? '--register-with-taints=spotInstance=true:PreferNoSchedule' : '';
    const kubeletExtraArgs = `--node-labels lifecycle=${lifecycleLabel} ${withTaints} ${kubeletExtraArgsSuffix}`.trim();
    return [
        'set -o xtrace',
        `/etc/eks/bootstrap.sh ${clusterName} --kubelet-extra-args "${kubeletExtraArgs}" ${commandLineSuffix}`.trim(),
        `/opt/aws/bin/cfn-signal --exit-code $? --stack ${stack.stackName} --resource ${asgLogicalId} --region ${stack.region}`,
    ];
}
exports.renderUserData = renderUserData;
//# sourceMappingURL=data:application/json;base64,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