"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessPoint = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const efs_generated_1 = require("./efs.generated");
class AccessPointBase extends core_1.Resource {
}
/**
 * Represents the AccessPoint
 */
class AccessPoint extends AccessPointBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_efs_AccessPointProps(props);
        const resource = new efs_generated_1.CfnAccessPoint(this, 'Resource', {
            fileSystemId: props.fileSystem.fileSystemId,
            rootDirectory: {
                creationInfo: props.createAcl ? {
                    ownerGid: props.createAcl.ownerGid,
                    ownerUid: props.createAcl.ownerUid,
                    permissions: props.createAcl.permissions,
                } : undefined,
                path: props.path,
            },
            posixUser: props.posixUser ? {
                uid: props.posixUser.uid,
                gid: props.posixUser.gid,
                secondaryGids: props.posixUser.secondaryGids,
            } : undefined,
        });
        this.accessPointId = resource.ref;
        this.accessPointArn = core_1.Stack.of(scope).formatArn({
            service: 'elasticfilesystem',
            resource: 'access-point',
            resourceName: this.accessPointId,
        });
        this.fileSystem = props.fileSystem;
    }
    /**
     * Import an existing Access Point by attributes
     */
    static fromAccessPointAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_efs_AccessPointAttributes(attrs);
        return new ImportedAccessPoint(scope, id, attrs);
    }
    /**
     * Import an existing Access Point by id
     */
    static fromAccessPointId(scope, id, accessPointId) {
        return new ImportedAccessPoint(scope, id, {
            accessPointId: accessPointId,
        });
    }
}
exports.AccessPoint = AccessPoint;
_a = JSII_RTTI_SYMBOL_1;
AccessPoint[_a] = { fqn: "monocdk.aws_efs.AccessPoint", version: "1.149.0" };
class ImportedAccessPoint extends AccessPointBase {
    constructor(scope, id, attrs) {
        super(scope, id);
        if (!attrs.accessPointId) {
            if (!attrs.accessPointArn) {
                throw new Error('One of accessPointId or AccessPointArn is required!');
            }
            this.accessPointArn = attrs.accessPointArn;
            let maybeApId = core_1.Stack.of(scope).splitArn(attrs.accessPointArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            if (!maybeApId) {
                throw new Error('ARN for AccessPoint must provide the resource name.');
            }
            this.accessPointId = maybeApId;
        }
        else {
            if (attrs.accessPointArn) {
                throw new Error('Only one of accessPointId or AccessPointArn can be provided!');
            }
            this.accessPointId = attrs.accessPointId;
            this.accessPointArn = core_1.Stack.of(scope).formatArn({
                service: 'elasticfilesystem',
                resource: 'access-point',
                resourceName: attrs.accessPointId,
            });
        }
        this._fileSystem = attrs.fileSystem;
    }
    get fileSystem() {
        if (!this._fileSystem) {
            throw new Error("fileSystem is only available if 'fromAccessPointAttributes()' is used and a fileSystem is passed in as an attribute.");
        }
        return this._fileSystem;
    }
}
//# sourceMappingURL=data:application/json;base64,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