"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlacementConstraint = exports.PlacementStrategy = exports.BinPackResource = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2_service_1 = require("./ec2/ec2-service");
/**
 * Instance resource used for bin packing
 */
var BinPackResource;
(function (BinPackResource) {
    /**
     * Fill up hosts' CPU allocations first
     */
    BinPackResource["CPU"] = "cpu";
    /**
     * Fill up hosts' memory allocations first
     */
    BinPackResource["MEMORY"] = "memory";
})(BinPackResource = exports.BinPackResource || (exports.BinPackResource = {}));
/**
 * The placement strategies to use for tasks in the service. For more information, see
 * [Amazon ECS Task Placement Strategies](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html).
 *
 * Tasks will preferentially be placed on instances that match these rules.
 */
class PlacementStrategy {
    /**
     * Constructs a new instance of the PlacementStrategy class.
     */
    constructor(json) {
        this.json = json;
    }
    /**
     * Places tasks evenly across all container instances in the cluster.
     */
    static spreadAcrossInstances() {
        return new PlacementStrategy([{ type: 'spread', field: ec2_service_1.BuiltInAttributes.INSTANCE_ID }]);
    }
    /**
     * Places tasks evenly based on the specified value.
     *
     * You can use one of the built-in attributes found on `BuiltInAttributes`
     * or supply your own custom instance attributes. If more than one attribute
     * is supplied, spreading is done in order.
     *
     * @default attributes instanceId
     */
    static spreadAcross(...fields) {
        if (fields.length === 0) {
            throw new Error('spreadAcross: give at least one field to spread by');
        }
        return new PlacementStrategy(fields.map(field => ({ type: 'spread', field })));
    }
    /**
     * Places tasks on container instances with the least available amount of CPU capacity.
     *
     * This minimizes the number of instances in use.
     */
    static packedByCpu() {
        return PlacementStrategy.packedBy(BinPackResource.CPU);
    }
    /**
     * Places tasks on container instances with the least available amount of memory capacity.
     *
     * This minimizes the number of instances in use.
     */
    static packedByMemory() {
        return PlacementStrategy.packedBy(BinPackResource.MEMORY);
    }
    /**
     * Places tasks on the container instances with the least available capacity of the specified resource.
     */
    static packedBy(resource) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_BinPackResource(resource);
        return new PlacementStrategy([{ type: 'binpack', field: resource }]);
    }
    /**
     * Places tasks randomly.
     */
    static randomly() {
        return new PlacementStrategy([{ type: 'random' }]);
    }
    /**
     * Return the placement JSON
     */
    toJson() {
        return this.json;
    }
}
exports.PlacementStrategy = PlacementStrategy;
_a = JSII_RTTI_SYMBOL_1;
PlacementStrategy[_a] = { fqn: "monocdk.aws_ecs.PlacementStrategy", version: "1.149.0" };
/**
 * The placement constraints to use for tasks in the service. For more information, see
 * [Amazon ECS Task Placement Constraints](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html).
 *
 * Tasks will only be placed on instances that match these rules.
 */
class PlacementConstraint {
    /**
     * Constructs a new instance of the PlacementConstraint class.
     */
    constructor(json) {
        this.json = json;
    }
    /**
     * Use distinctInstance to ensure that each task in a particular group is running on a different container instance.
     */
    static distinctInstances() {
        return new PlacementConstraint([{ type: 'distinctInstance' }]);
    }
    /**
     * Use memberOf to restrict the selection to a group of valid candidates specified by a query expression.
     *
     * Multiple expressions can be specified. For more information, see
     * [Cluster Query Language](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html).
     *
     * You can specify multiple expressions in one call. The tasks will only be placed on instances matching all expressions.
     *
     * @see https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html
     */
    static memberOf(...expressions) {
        return new PlacementConstraint(expressions.map(expression => ({ type: 'memberOf', expression })));
    }
    /**
     * Return the placement JSON
     */
    toJson() {
        return this.json;
    }
}
exports.PlacementConstraint = PlacementConstraint;
_b = JSII_RTTI_SYMBOL_1;
PlacementConstraint[_b] = { fqn: "monocdk.aws_ecs.PlacementConstraint", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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