"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyslogLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to syslog Logs.
 */
class SyslogLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the SyslogLogDriver class.
     *
     * @param props the syslog log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_ecs_SyslogLogDriverProps(props);
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        return {
            logDriver: 'syslog',
            options: utils_1.stringifyOptions({
                'syslog-address': this.props.address,
                'syslog-facility': this.props.facility,
                'syslog-tls-ca-cert': this.props.tlsCaCert,
                'syslog-tls-cert': this.props.tlsCert,
                'syslog-tls-key': this.props.tlsKey,
                'syslog-tls-skip-verify': this.props.tlsSkipVerify,
                'syslog-format': this.props.format,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.SyslogLogDriver = SyslogLogDriver;
_a = JSII_RTTI_SYMBOL_1;
SyslogLogDriver[_a] = { fqn: "monocdk.aws_ecs.SyslogLogDriver", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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