"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogDrivers = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_log_driver_1 = require("./aws-log-driver");
const firelens_log_driver_1 = require("./firelens-log-driver");
const fluentd_log_driver_1 = require("./fluentd-log-driver");
const gelf_log_driver_1 = require("./gelf-log-driver");
const journald_log_driver_1 = require("./journald-log-driver");
const json_file_log_driver_1 = require("./json-file-log-driver");
const splunk_log_driver_1 = require("./splunk-log-driver");
const syslog_log_driver_1 = require("./syslog-log-driver");
/**
 * The base class for log drivers.
 */
class LogDrivers {
    /**
     * Creates a log driver configuration that sends log information to CloudWatch Logs.
     */
    static awsLogs(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_AwsLogDriverProps(props);
        return new aws_log_driver_1.AwsLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to fluentd Logs.
     */
    static fluentd(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_FluentdLogDriverProps(props);
        return new fluentd_log_driver_1.FluentdLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to gelf Logs.
     */
    static gelf(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_GelfLogDriverProps(props);
        return new gelf_log_driver_1.GelfLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to journald Logs.
     */
    static journald(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_JournaldLogDriverProps(props);
        return new journald_log_driver_1.JournaldLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to json-file Logs.
     */
    static jsonFile(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_JsonFileLogDriverProps(props);
        return new json_file_log_driver_1.JsonFileLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to splunk Logs.
     */
    static splunk(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_SplunkLogDriverProps(props);
        return new splunk_log_driver_1.SplunkLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to syslog Logs.
     */
    static syslog(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_SyslogLogDriverProps(props);
        return new syslog_log_driver_1.SyslogLogDriver(props);
    }
    /**
     * Creates a log driver configuration that sends log information to firelens log router.
     * For detail configurations, please refer to Amazon ECS FireLens Examples:
     * https://github.com/aws-samples/amazon-ecs-firelens-examples
     */
    static firelens(props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_FireLensLogDriverProps(props);
        return new firelens_log_driver_1.FireLensLogDriver(props);
    }
}
exports.LogDrivers = LogDrivers;
_a = JSII_RTTI_SYMBOL_1;
LogDrivers[_a] = { fqn: "monocdk.aws_ecs.LogDrivers", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9nLWRyaXZlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2ctZHJpdmVycy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxxREFBbUU7QUFDbkUsK0RBQWtGO0FBQ2xGLDZEQUErRTtBQUMvRSx1REFBc0U7QUFDdEUsK0RBQWtGO0FBQ2xGLGlFQUFtRjtBQUVuRiwyREFBNEU7QUFDNUUsMkRBQTRFO0FBRTVFOztHQUVHO0FBQ0gsTUFBYSxVQUFVO0lBQ3JCOztPQUVHO0lBQ0ksTUFBTSxDQUFDLE9BQU8sQ0FBQyxLQUF3Qjs7UUFDNUMsT0FBTyxJQUFJLDZCQUFZLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDaEM7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxPQUFPLENBQUMsS0FBNkI7O1FBQ2pELE9BQU8sSUFBSSxxQ0FBZ0IsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNwQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLElBQUksQ0FBQyxLQUF5Qjs7UUFDMUMsT0FBTyxJQUFJLCtCQUFhLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDakM7SUFFRDs7T0FFRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsS0FBOEI7O1FBQ25ELE9BQU8sSUFBSSx1Q0FBaUIsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNyQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUE4Qjs7UUFDbkQsT0FBTyxJQUFJLHdDQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ3JDO0lBRUQ7O09BRUc7SUFDSSxNQUFNLENBQUMsTUFBTSxDQUFDLEtBQTJCOztRQUM5QyxPQUFPLElBQUksbUNBQWUsQ0FBQyxLQUFLLENBQUMsQ0FBQztLQUNuQztJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUE0Qjs7UUFDL0MsT0FBTyxJQUFJLG1DQUFlLENBQUMsS0FBSyxDQUFDLENBQUM7S0FDbkM7SUFFRDs7OztPQUlHO0lBQ0ksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUE2Qjs7UUFDbEQsT0FBTyxJQUFJLHVDQUFpQixDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQ3JDOztBQXpESCxnQ0EwREMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBd3NMb2dEcml2ZXIsIEF3c0xvZ0RyaXZlclByb3BzIH0gZnJvbSAnLi9hd3MtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBGaXJlTGVuc0xvZ0RyaXZlciwgRmlyZUxlbnNMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vZmlyZWxlbnMtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBGbHVlbnRkTG9nRHJpdmVyLCBGbHVlbnRkTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL2ZsdWVudGQtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBHZWxmTG9nRHJpdmVyLCBHZWxmTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL2dlbGYtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBKb3VybmFsZExvZ0RyaXZlciwgSm91cm5hbGRMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vam91cm5hbGQtbG9nLWRyaXZlcic7XG5pbXBvcnQgeyBKc29uRmlsZUxvZ0RyaXZlciwgSnNvbkZpbGVMb2dEcml2ZXJQcm9wcyB9IGZyb20gJy4vanNvbi1maWxlLWxvZy1kcml2ZXInO1xuaW1wb3J0IHsgTG9nRHJpdmVyIH0gZnJvbSAnLi9sb2ctZHJpdmVyJztcbmltcG9ydCB7IFNwbHVua0xvZ0RyaXZlciwgU3BsdW5rTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL3NwbHVuay1sb2ctZHJpdmVyJztcbmltcG9ydCB7IFN5c2xvZ0xvZ0RyaXZlciwgU3lzbG9nTG9nRHJpdmVyUHJvcHMgfSBmcm9tICcuL3N5c2xvZy1sb2ctZHJpdmVyJztcblxuLyoqXG4gKiBUaGUgYmFzZSBjbGFzcyBmb3IgbG9nIGRyaXZlcnMuXG4gKi9cbmV4cG9ydCBjbGFzcyBMb2dEcml2ZXJzIHtcbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBsb2cgZHJpdmVyIGNvbmZpZ3VyYXRpb24gdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8gQ2xvdWRXYXRjaCBMb2dzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBhd3NMb2dzKHByb3BzOiBBd3NMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgcmV0dXJuIG5ldyBBd3NMb2dEcml2ZXIocHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBsb2cgZHJpdmVyIGNvbmZpZ3VyYXRpb24gdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8gZmx1ZW50ZCBMb2dzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmbHVlbnRkKHByb3BzPzogRmx1ZW50ZExvZ0RyaXZlclByb3BzKTogTG9nRHJpdmVyIHtcbiAgICByZXR1cm4gbmV3IEZsdWVudGRMb2dEcml2ZXIocHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBsb2cgZHJpdmVyIGNvbmZpZ3VyYXRpb24gdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8gZ2VsZiBMb2dzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBnZWxmKHByb3BzOiBHZWxmTG9nRHJpdmVyUHJvcHMpOiBMb2dEcml2ZXIge1xuICAgIHJldHVybiBuZXcgR2VsZkxvZ0RyaXZlcihwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBqb3VybmFsZCBMb2dzLlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBqb3VybmFsZChwcm9wcz86IEpvdXJuYWxkTG9nRHJpdmVyUHJvcHMpOiBMb2dEcml2ZXIge1xuICAgIHJldHVybiBuZXcgSm91cm5hbGRMb2dEcml2ZXIocHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBsb2cgZHJpdmVyIGNvbmZpZ3VyYXRpb24gdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8ganNvbi1maWxlIExvZ3MuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGpzb25GaWxlKHByb3BzPzogSnNvbkZpbGVMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgcmV0dXJuIG5ldyBKc29uRmlsZUxvZ0RyaXZlcihwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBzcGx1bmsgTG9ncy5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgc3BsdW5rKHByb3BzOiBTcGx1bmtMb2dEcml2ZXJQcm9wcyk6IExvZ0RyaXZlciB7XG4gICAgcmV0dXJuIG5ldyBTcGx1bmtMb2dEcml2ZXIocHJvcHMpO1xuICB9XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSBsb2cgZHJpdmVyIGNvbmZpZ3VyYXRpb24gdGhhdCBzZW5kcyBsb2cgaW5mb3JtYXRpb24gdG8gc3lzbG9nIExvZ3MuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHN5c2xvZyhwcm9wcz86IFN5c2xvZ0xvZ0RyaXZlclByb3BzKTogTG9nRHJpdmVyIHtcbiAgICByZXR1cm4gbmV3IFN5c2xvZ0xvZ0RyaXZlcihwcm9wcyk7XG4gIH1cblxuICAvKipcbiAgICogQ3JlYXRlcyBhIGxvZyBkcml2ZXIgY29uZmlndXJhdGlvbiB0aGF0IHNlbmRzIGxvZyBpbmZvcm1hdGlvbiB0byBmaXJlbGVucyBsb2cgcm91dGVyLlxuICAgKiBGb3IgZGV0YWlsIGNvbmZpZ3VyYXRpb25zLCBwbGVhc2UgcmVmZXIgdG8gQW1hem9uIEVDUyBGaXJlTGVucyBFeGFtcGxlczpcbiAgICogaHR0cHM6Ly9naXRodWIuY29tL2F3cy1zYW1wbGVzL2FtYXpvbi1lY3MtZmlyZWxlbnMtZXhhbXBsZXNcbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZmlyZWxlbnMocHJvcHM6IEZpcmVMZW5zTG9nRHJpdmVyUHJvcHMpOiBMb2dEcml2ZXIge1xuICAgIHJldHVybiBuZXcgRmlyZUxlbnNMb2dEcml2ZXIocHJvcHMpO1xuICB9XG59XG4iXX0=