"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.JsonFileLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to json-file Logs.
 */
class JsonFileLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the JsonFileLogDriver class.
     *
     * @param props the json-file log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_ecs_JsonFileLogDriverProps(props);
        // Validation
        if (props.maxFile && props.maxFile < 0) {
            throw new Error('`maxFile` must be a positive integer.');
        }
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        return {
            logDriver: 'json-file',
            options: utils_1.stringifyOptions({
                'max-size': this.props.maxSize,
                'max-file': this.props.maxFile,
                'compress': this.props.compress,
                'labels': utils_1.joinWithCommas(this.props.labels),
                'env': utils_1.joinWithCommas(this.props.env),
                'env-regex': this.props.envRegex,
            }),
        };
    }
}
exports.JsonFileLogDriver = JsonFileLogDriver;
_a = JSII_RTTI_SYMBOL_1;
JsonFileLogDriver[_a] = { fqn: "monocdk.aws_ecs.JsonFileLogDriver", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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