"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FluentdLogDriver = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const log_driver_1 = require("./log-driver");
const utils_1 = require("./utils");
/**
 * A log driver that sends log information to journald Logs.
 */
class FluentdLogDriver extends log_driver_1.LogDriver {
    /**
     * Constructs a new instance of the FluentdLogDriver class.
     *
     * @param props the fluentd log driver configuration options.
     */
    constructor(props = {}) {
        super();
        this.props = props;
        jsiiDeprecationWarnings.monocdk_aws_ecs_FluentdLogDriverProps(props);
    }
    /**
     * Called when the log driver is configured on a container
     */
    bind(_scope, _containerDefinition) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(_containerDefinition);
        return {
            logDriver: 'fluentd',
            options: utils_1.stringifyOptions({
                'fluentd-address': this.props.address,
                'fluentd-async-connect': this.props.asyncConnect,
                'fluentd-buffer-limit': this.props.bufferLimit,
                'fluentd-retry-wait': this.props.retryWait && this.props.retryWait.toSeconds(),
                'fluentd-max-retries': this.props.maxRetries,
                'fluentd-sub-second-precision': this.props.subSecondPrecision,
                ...utils_1.renderCommonLogDriverOptions(this.props),
            }),
        };
    }
}
exports.FluentdLogDriver = FluentdLogDriver;
_a = JSII_RTTI_SYMBOL_1;
FluentdLogDriver[_a] = { fqn: "monocdk.aws_ecs.FluentdLogDriver", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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