"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TmpfsMountOption = exports.DevicePermission = exports.Capability = exports.LinuxParameters = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_1 = require("../../core");
/**
 * Linux-specific options that are applied to the container.
 */
class LinuxParameters extends core_1.Construct {
    /**
     * Constructs a new instance of the LinuxParameters class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        /**
         * Capabilities to be added
         */
        this.capAdd = new Array();
        /**
         * Capabilities to be dropped
         */
        this.capDrop = new Array();
        /**
         * Device mounts
         */
        this.devices = new Array();
        /**
         * TmpFs mounts
         */
        this.tmpfs = new Array();
        jsiiDeprecationWarnings.monocdk_aws_ecs_LinuxParametersProps(props);
        this.sharedMemorySize = props.sharedMemorySize;
        this.initProcessEnabled = props.initProcessEnabled;
    }
    /**
     * Adds one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     */
    addCapabilities(...cap) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Capability(cap);
        this.capAdd.push(...cap);
    }
    /**
     * Removes one or more Linux capabilities to the Docker configuration of a container.
     *
     * Only works with EC2 launch type.
     */
    dropCapabilities(...cap) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Capability(cap);
        this.capDrop.push(...cap);
    }
    /**
     * Adds one or more host devices to a container.
     */
    addDevices(...device) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Device(device);
        this.devices.push(...device);
    }
    /**
     * Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     *
     * Only works with EC2 launch type.
     */
    addTmpfs(...tmpfs) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Tmpfs(tmpfs);
        this.tmpfs.push(...tmpfs);
    }
    /**
     * Renders the Linux parameters to a CloudFormation object.
     */
    renderLinuxParameters() {
        return {
            initProcessEnabled: this.initProcessEnabled,
            sharedMemorySize: this.sharedMemorySize,
            capabilities: {
                add: cdk.Lazy.list({ produce: () => this.capAdd }, { omitEmpty: true }),
                drop: cdk.Lazy.list({ produce: () => this.capDrop }, { omitEmpty: true }),
            },
            devices: cdk.Lazy.any({ produce: () => this.devices.map(renderDevice) }, { omitEmptyArray: true }),
            tmpfs: cdk.Lazy.any({ produce: () => this.tmpfs.map(renderTmpfs) }, { omitEmptyArray: true }),
        };
    }
}
exports.LinuxParameters = LinuxParameters;
_a = JSII_RTTI_SYMBOL_1;
LinuxParameters[_a] = { fqn: "monocdk.aws_ecs.LinuxParameters", version: "1.149.0" };
function renderDevice(device) {
    return {
        containerPath: device.containerPath,
        hostPath: device.hostPath,
        permissions: device.permissions,
    };
}
function renderTmpfs(tmpfs) {
    return {
        containerPath: tmpfs.containerPath,
        size: tmpfs.size,
        mountOptions: tmpfs.mountOptions,
    };
}
/**
 * A Linux capability
 */
var Capability;
(function (Capability) {
    Capability["ALL"] = "ALL";
    Capability["AUDIT_CONTROL"] = "AUDIT_CONTROL";
    Capability["AUDIT_WRITE"] = "AUDIT_WRITE";
    Capability["BLOCK_SUSPEND"] = "BLOCK_SUSPEND";
    Capability["CHOWN"] = "CHOWN";
    Capability["DAC_OVERRIDE"] = "DAC_OVERRIDE";
    Capability["DAC_READ_SEARCH"] = "DAC_READ_SEARCH";
    Capability["FOWNER"] = "FOWNER";
    Capability["FSETID"] = "FSETID";
    Capability["IPC_LOCK"] = "IPC_LOCK";
    Capability["IPC_OWNER"] = "IPC_OWNER";
    Capability["KILL"] = "KILL";
    Capability["LEASE"] = "LEASE";
    Capability["LINUX_IMMUTABLE"] = "LINUX_IMMUTABLE";
    Capability["MAC_ADMIN"] = "MAC_ADMIN";
    Capability["MAC_OVERRIDE"] = "MAC_OVERRIDE";
    Capability["MKNOD"] = "MKNOD";
    Capability["NET_ADMIN"] = "NET_ADMIN";
    Capability["NET_BIND_SERVICE"] = "NET_BIND_SERVICE";
    Capability["NET_BROADCAST"] = "NET_BROADCAST";
    Capability["NET_RAW"] = "NET_RAW";
    Capability["SETFCAP"] = "SETFCAP";
    Capability["SETGID"] = "SETGID";
    Capability["SETPCAP"] = "SETPCAP";
    Capability["SETUID"] = "SETUID";
    Capability["SYS_ADMIN"] = "SYS_ADMIN";
    Capability["SYS_BOOT"] = "SYS_BOOT";
    Capability["SYS_CHROOT"] = "SYS_CHROOT";
    Capability["SYS_MODULE"] = "SYS_MODULE";
    Capability["SYS_NICE"] = "SYS_NICE";
    Capability["SYS_PACCT"] = "SYS_PACCT";
    Capability["SYS_PTRACE"] = "SYS_PTRACE";
    Capability["SYS_RAWIO"] = "SYS_RAWIO";
    Capability["SYS_RESOURCE"] = "SYS_RESOURCE";
    Capability["SYS_TIME"] = "SYS_TIME";
    Capability["SYS_TTY_CONFIG"] = "SYS_TTY_CONFIG";
    Capability["SYSLOG"] = "SYSLOG";
    Capability["WAKE_ALARM"] = "WAKE_ALARM";
})(Capability = exports.Capability || (exports.Capability = {}));
/**
 * Permissions for device access
 */
var DevicePermission;
(function (DevicePermission) {
    /**
     * Read
     */
    DevicePermission["READ"] = "read";
    /**
     * Write
     */
    DevicePermission["WRITE"] = "write";
    /**
     * Make a node
     */
    DevicePermission["MKNOD"] = "mknod";
})(DevicePermission = exports.DevicePermission || (exports.DevicePermission = {}));
/**
 * The supported options for a tmpfs mount for a container.
 */
var TmpfsMountOption;
(function (TmpfsMountOption) {
    TmpfsMountOption["DEFAULTS"] = "defaults";
    TmpfsMountOption["RO"] = "ro";
    TmpfsMountOption["RW"] = "rw";
    TmpfsMountOption["SUID"] = "suid";
    TmpfsMountOption["NOSUID"] = "nosuid";
    TmpfsMountOption["DEV"] = "dev";
    TmpfsMountOption["NODEV"] = "nodev";
    TmpfsMountOption["EXEC"] = "exec";
    TmpfsMountOption["NOEXEC"] = "noexec";
    TmpfsMountOption["SYNC"] = "sync";
    TmpfsMountOption["ASYNC"] = "async";
    TmpfsMountOption["DIRSYNC"] = "dirsync";
    TmpfsMountOption["REMOUNT"] = "remount";
    TmpfsMountOption["MAND"] = "mand";
    TmpfsMountOption["NOMAND"] = "nomand";
    TmpfsMountOption["ATIME"] = "atime";
    TmpfsMountOption["NOATIME"] = "noatime";
    TmpfsMountOption["DIRATIME"] = "diratime";
    TmpfsMountOption["NODIRATIME"] = "nodiratime";
    TmpfsMountOption["BIND"] = "bind";
    TmpfsMountOption["RBIND"] = "rbind";
    TmpfsMountOption["UNBINDABLE"] = "unbindable";
    TmpfsMountOption["RUNBINDABLE"] = "runbindable";
    TmpfsMountOption["PRIVATE"] = "private";
    TmpfsMountOption["RPRIVATE"] = "rprivate";
    TmpfsMountOption["SHARED"] = "shared";
    TmpfsMountOption["RSHARED"] = "rshared";
    TmpfsMountOption["SLAVE"] = "slave";
    TmpfsMountOption["RSLAVE"] = "rslave";
    TmpfsMountOption["RELATIME"] = "relatime";
    TmpfsMountOption["NORELATIME"] = "norelatime";
    TmpfsMountOption["STRICTATIME"] = "strictatime";
    TmpfsMountOption["NOSTRICTATIME"] = "nostrictatime";
    TmpfsMountOption["MODE"] = "mode";
    TmpfsMountOption["UID"] = "uid";
    TmpfsMountOption["GID"] = "gid";
    TmpfsMountOption["NR_INODES"] = "nr_inodes";
    TmpfsMountOption["NR_BLOCKS"] = "nr_blocks";
    TmpfsMountOption["MPOL"] = "mpol";
})(TmpfsMountOption = exports.TmpfsMountOption || (exports.TmpfsMountOption = {}));
//# sourceMappingURL=data:application/json;base64,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