"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EcrImage = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const container_image_1 = require("../container-image");
/**
 * An image from an Amazon ECR repository.
 */
class EcrImage extends container_image_1.ContainerImage {
    /**
     * Constructs a new instance of the EcrImage class.
     */
    constructor(repository, tagOrDigest) {
        super();
        this.repository = repository;
        this.tagOrDigest = tagOrDigest;
        jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        if (tagOrDigest === null || tagOrDigest === void 0 ? void 0 : tagOrDigest.startsWith('sha256:')) {
            this.imageName = this.repository.repositoryUriForDigest(this.tagOrDigest);
        }
        else {
            this.imageName = this.repository.repositoryUriForTag(this.tagOrDigest);
        }
    }
    bind(_scope, containerDefinition) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_ContainerDefinition(containerDefinition);
        this.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
        return {
            imageName: this.imageName,
        };
    }
}
exports.EcrImage = EcrImage;
_a = JSII_RTTI_SYMBOL_1;
EcrImage[_a] = { fqn: "monocdk.aws_ecs.EcrImage", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWNyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZWNyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUVBLHdEQUEwRTtBQU0xRTs7R0FFRztBQUNILE1BQWEsUUFBUyxTQUFRLGdDQUFjO0lBVTFDOztPQUVHO0lBQ0gsWUFBNkIsVUFBMkIsRUFBbUIsV0FBbUI7UUFDNUYsS0FBSyxFQUFFLENBQUM7UUFEbUIsZUFBVSxHQUFWLFVBQVUsQ0FBaUI7UUFBbUIsZ0JBQVcsR0FBWCxXQUFXLENBQVE7O1FBRzVGLElBQUksV0FBVyxhQUFYLFdBQVcsdUJBQVgsV0FBVyxDQUFFLFVBQVUsQ0FBQyxTQUFTLEdBQUc7WUFDdEMsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUMzRTthQUFNO1lBQ0wsSUFBSSxDQUFDLFNBQVMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLElBQUksQ0FBQyxXQUFXLENBQUMsQ0FBQztTQUN4RTtLQUNGO0lBRU0sSUFBSSxDQUFDLE1BQXFCLEVBQUUsbUJBQXdDOzs7UUFDekUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxTQUFTLENBQUMsbUJBQW1CLENBQUMsY0FBYyxDQUFDLG1CQUFtQixFQUFFLENBQUMsQ0FBQztRQUVwRixPQUFPO1lBQ0wsU0FBUyxFQUFFLElBQUksQ0FBQyxTQUFTO1NBQzFCLENBQUM7S0FDSDs7QUE3QkgsNEJBOEJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgZWNyIGZyb20gJy4uLy4uLy4uL2F3cy1lY3InO1xuaW1wb3J0IHsgQ29udGFpbmVyRGVmaW5pdGlvbiB9IGZyb20gJy4uL2NvbnRhaW5lci1kZWZpbml0aW9uJztcbmltcG9ydCB7IENvbnRhaW5lckltYWdlLCBDb250YWluZXJJbWFnZUNvbmZpZyB9IGZyb20gJy4uL2NvbnRhaW5lci1pbWFnZSc7XG5cbi8vIHYyIC0ga2VlcCB0aGlzIGltcG9ydCBhcyBhIHNlcGFyYXRlIHNlY3Rpb24gdG8gcmVkdWNlIG1lcmdlIGNvbmZsaWN0IHdoZW4gZm9yd2FyZCBtZXJnaW5nIHdpdGggdGhlIHYyIGJyYW5jaC5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZVxuaW1wb3J0IHsgQ29uc3RydWN0IGFzIENvcmVDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi8uLi9jb3JlJztcblxuLyoqXG4gKiBBbiBpbWFnZSBmcm9tIGFuIEFtYXpvbiBFQ1IgcmVwb3NpdG9yeS5cbiAqL1xuZXhwb3J0IGNsYXNzIEVjckltYWdlIGV4dGVuZHMgQ29udGFpbmVySW1hZ2Uge1xuICAvKipcbiAgICogVGhlIGltYWdlIG5hbWUuIEltYWdlcyBpbiBBbWF6b24gRUNSIHJlcG9zaXRvcmllcyBjYW4gYmUgc3BlY2lmaWVkIGJ5IGVpdGhlciB1c2luZyB0aGUgZnVsbCByZWdpc3RyeS9yZXBvc2l0b3J5OnRhZyBvclxuICAgKiByZWdpc3RyeS9yZXBvc2l0b3J5QGRpZ2VzdC5cbiAgICpcbiAgICogRm9yIGV4YW1wbGUsIDAxMjM0NTY3ODkxMC5ka3IuZWNyLjxyZWdpb24tbmFtZT4uYW1hem9uYXdzLmNvbS88cmVwb3NpdG9yeS1uYW1lPjpsYXRlc3Qgb3JcbiAgICogMDEyMzQ1Njc4OTEwLmRrci5lY3IuPHJlZ2lvbi1uYW1lPi5hbWF6b25hd3MuY29tLzxyZXBvc2l0b3J5LW5hbWU+QHNoYTI1Njo5NGFmZDFmMmU2NGQ5MDhiYzkwZGJjYTAwMzVhNWI1NjdFWEFNUExFLlxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGltYWdlTmFtZTogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBDb25zdHJ1Y3RzIGEgbmV3IGluc3RhbmNlIG9mIHRoZSBFY3JJbWFnZSBjbGFzcy5cbiAgICovXG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgcmVhZG9ubHkgcmVwb3NpdG9yeTogZWNyLklSZXBvc2l0b3J5LCBwcml2YXRlIHJlYWRvbmx5IHRhZ09yRGlnZXN0OiBzdHJpbmcpIHtcbiAgICBzdXBlcigpO1xuXG4gICAgaWYgKHRhZ09yRGlnZXN0Py5zdGFydHNXaXRoKCdzaGEyNTY6JykpIHtcbiAgICAgIHRoaXMuaW1hZ2VOYW1lID0gdGhpcy5yZXBvc2l0b3J5LnJlcG9zaXRvcnlVcmlGb3JEaWdlc3QodGhpcy50YWdPckRpZ2VzdCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRoaXMuaW1hZ2VOYW1lID0gdGhpcy5yZXBvc2l0b3J5LnJlcG9zaXRvcnlVcmlGb3JUYWcodGhpcy50YWdPckRpZ2VzdCk7XG4gICAgfVxuICB9XG5cbiAgcHVibGljIGJpbmQoX3Njb3BlOiBDb3JlQ29uc3RydWN0LCBjb250YWluZXJEZWZpbml0aW9uOiBDb250YWluZXJEZWZpbml0aW9uKTogQ29udGFpbmVySW1hZ2VDb25maWcge1xuICAgIHRoaXMucmVwb3NpdG9yeS5ncmFudFB1bGwoY29udGFpbmVyRGVmaW5pdGlvbi50YXNrRGVmaW5pdGlvbi5vYnRhaW5FeGVjdXRpb25Sb2xlKCkpO1xuXG4gICAgcmV0dXJuIHtcbiAgICAgIGltYWdlTmFtZTogdGhpcy5pbWFnZU5hbWUsXG4gICAgfTtcbiAgfVxufVxuIl19