"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalTaskDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _imported_task_definition_1 = require("../../lib/base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an External cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class ExternalTaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Constructs a new instance of the ExternalTaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EXTERNAL,
            networkMode: task_definition_1.NetworkMode.BRIDGE,
        });
        jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalTaskDefinitionProps(props);
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, externalTaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: externalTaskDefinitionArn,
        });
    }
    /**
     * Imports an existing External task definition from its attributes
     */
    static fromExternalTaskDefinitionAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalTaskDefinitionAttributes(attrs);
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.EXTERNAL,
            networkMode: task_definition_1.NetworkMode.BRIDGE,
            taskRole: attrs.taskRole,
        });
    }
    /**
     * Overridden method to throw error, as volumes are not supported for external task definitions
     */
    addVolume(_volume) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Volume(_volume);
        throw new Error('External task definitions doesnt support volumes');
    }
    /**
     * Overriden method to throw error as interface accelerators are not supported for external tasks
     */
    addInferenceAccelerator(_inferenceAccelerator) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_InferenceAccelerator(_inferenceAccelerator);
        throw new Error('Cannot use inference accelerators on tasks that run on External service');
    }
}
exports.ExternalTaskDefinition = ExternalTaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
ExternalTaskDefinition[_a] = { fqn: "monocdk.aws_ecs.ExternalTaskDefinition", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZXh0ZXJuYWwtdGFzay1kZWZpbml0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZXh0ZXJuYWwtdGFzay1kZWZpbml0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLHdGQUFrRjtBQUNsRiw2REFTaUM7QUF1QmpDOzs7O0dBSUc7QUFDSCxNQUFhLHNCQUF1QixTQUFRLGdDQUFjO0lBMkJ4RDs7T0FFRztJQUNILFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBcUMsRUFBRTtRQUMvRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLEdBQUcsS0FBSztZQUNSLGFBQWEsRUFBRSwrQkFBYSxDQUFDLFFBQVE7WUFDckMsV0FBVyxFQUFFLDZCQUFXLENBQUMsTUFBTTtTQUNoQyxDQUFDLENBQUM7O0tBQ0o7SUFsQ0Q7O09BRUc7SUFDSSxNQUFNLENBQUMsd0JBQXdCLENBQUMsS0FBZ0IsRUFBRSxFQUFVLEVBQUUseUJBQWlDO1FBQ3BHLE9BQU8sSUFBSSxrREFBc0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQzNDLGlCQUFpQixFQUFFLHlCQUF5QjtTQUM3QyxDQUFDLENBQUM7S0FDSjtJQUVEOztPQUVHO0lBQ0ksTUFBTSxDQUFDLG9DQUFvQyxDQUNoRCxLQUFnQixFQUNoQixFQUFVLEVBQ1YsS0FBdUM7O1FBRXZDLE9BQU8sSUFBSSxrREFBc0IsQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQzNDLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUI7WUFDMUMsYUFBYSxFQUFFLCtCQUFhLENBQUMsUUFBUTtZQUNyQyxXQUFXLEVBQUUsNkJBQVcsQ0FBQyxNQUFNO1lBQy9CLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtTQUN6QixDQUFDLENBQUM7S0FDSjtJQWFEOztPQUVHO0lBQ0ksU0FBUyxDQUFDLE9BQWU7O1FBQzlCLE1BQU0sSUFBSSxLQUFLLENBQUMsa0RBQWtELENBQUMsQ0FBQztLQUNyRTtJQUVEOztPQUVHO0lBQ0ksdUJBQXVCLENBQUMscUJBQTJDOztRQUN4RSxNQUFNLElBQUksS0FBSyxDQUFDLHlFQUF5RSxDQUFDLENBQUM7S0FDNUY7O0FBbERILHdEQW1EQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSW1wb3J0ZWRUYXNrRGVmaW5pdGlvbiB9IGZyb20gJy4uLy4uL2xpYi9iYXNlL19pbXBvcnRlZC10YXNrLWRlZmluaXRpb24nO1xuaW1wb3J0IHtcbiAgQ29tbW9uVGFza0RlZmluaXRpb25BdHRyaWJ1dGVzLFxuICBDb21tb25UYXNrRGVmaW5pdGlvblByb3BzLFxuICBDb21wYXRpYmlsaXR5LFxuICBJbmZlcmVuY2VBY2NlbGVyYXRvcixcbiAgSVRhc2tEZWZpbml0aW9uLFxuICBOZXR3b3JrTW9kZSxcbiAgVGFza0RlZmluaXRpb24sXG4gIFZvbHVtZSxcbn0gZnJvbSAnLi4vYmFzZS90YXNrLWRlZmluaXRpb24nO1xuXG4vKipcbiAqIFRoZSBwcm9wZXJ0aWVzIGZvciBhIHRhc2sgZGVmaW5pdGlvbiBydW4gb24gYW4gRXh0ZXJuYWwgY2x1c3Rlci5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFeHRlcm5hbFRhc2tEZWZpbml0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25UYXNrRGVmaW5pdGlvblByb3BzIHtcblxufVxuXG4vKipcbiAqIFRoZSBpbnRlcmZhY2Ugb2YgYSB0YXNrIGRlZmluaXRpb24gcnVuIG9uIGFuIEV4dGVybmFsIGNsdXN0ZXIuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgSUV4dGVybmFsVGFza0RlZmluaXRpb24gZXh0ZW5kcyBJVGFza0RlZmluaXRpb24ge1xuXG59XG5cbi8qKlxuICogQXR0cmlidXRlcyB1c2VkIHRvIGltcG9ydCBhbiBleGlzdGluZyBFeHRlcm5hbCB0YXNrIGRlZmluaXRpb25cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBFeHRlcm5hbFRhc2tEZWZpbml0aW9uQXR0cmlidXRlcyBleHRlbmRzIENvbW1vblRhc2tEZWZpbml0aW9uQXR0cmlidXRlcyB7XG5cbn1cblxuLyoqXG4gKiBUaGUgZGV0YWlscyBvZiBhIHRhc2sgZGVmaW5pdGlvbiBydW4gb24gYW4gRXh0ZXJuYWwgY2x1c3Rlci5cbiAqXG4gKiBAcmVzb3VyY2UgQVdTOjpFQ1M6OlRhc2tEZWZpbml0aW9uXG4gKi9cbmV4cG9ydCBjbGFzcyBFeHRlcm5hbFRhc2tEZWZpbml0aW9uIGV4dGVuZHMgVGFza0RlZmluaXRpb24gaW1wbGVtZW50cyBJRXh0ZXJuYWxUYXNrRGVmaW5pdGlvbiB7XG5cbiAgLyoqXG4gICAqIEltcG9ydHMgYSB0YXNrIGRlZmluaXRpb24gZnJvbSB0aGUgc3BlY2lmaWVkIHRhc2sgZGVmaW5pdGlvbiBBUk4uXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIGZyb21FYzJUYXNrRGVmaW5pdGlvbkFybihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBleHRlcm5hbFRhc2tEZWZpbml0aW9uQXJuOiBzdHJpbmcpOiBJRXh0ZXJuYWxUYXNrRGVmaW5pdGlvbiB7XG4gICAgcmV0dXJuIG5ldyBJbXBvcnRlZFRhc2tEZWZpbml0aW9uKHNjb3BlLCBpZCwge1xuICAgICAgdGFza0RlZmluaXRpb25Bcm46IGV4dGVybmFsVGFza0RlZmluaXRpb25Bcm4sXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogSW1wb3J0cyBhbiBleGlzdGluZyBFeHRlcm5hbCB0YXNrIGRlZmluaXRpb24gZnJvbSBpdHMgYXR0cmlidXRlc1xuICAgKi9cbiAgcHVibGljIHN0YXRpYyBmcm9tRXh0ZXJuYWxUYXNrRGVmaW5pdGlvbkF0dHJpYnV0ZXMoXG4gICAgc2NvcGU6IENvbnN0cnVjdCxcbiAgICBpZDogc3RyaW5nLFxuICAgIGF0dHJzOiBFeHRlcm5hbFRhc2tEZWZpbml0aW9uQXR0cmlidXRlcyxcbiAgKTogSUV4dGVybmFsVGFza0RlZmluaXRpb24ge1xuICAgIHJldHVybiBuZXcgSW1wb3J0ZWRUYXNrRGVmaW5pdGlvbihzY29wZSwgaWQsIHtcbiAgICAgIHRhc2tEZWZpbml0aW9uQXJuOiBhdHRycy50YXNrRGVmaW5pdGlvbkFybixcbiAgICAgIGNvbXBhdGliaWxpdHk6IENvbXBhdGliaWxpdHkuRVhURVJOQUwsXG4gICAgICBuZXR3b3JrTW9kZTogTmV0d29ya01vZGUuQlJJREdFLFxuICAgICAgdGFza1JvbGU6IGF0dHJzLnRhc2tSb2xlLFxuICAgIH0pO1xuICB9XG5cbiAgLyoqXG4gICAqIENvbnN0cnVjdHMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhlIEV4dGVybmFsVGFza0RlZmluaXRpb24gY2xhc3MuXG4gICAqL1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRXh0ZXJuYWxUYXNrRGVmaW5pdGlvblByb3BzID0ge30pIHtcbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgY29tcGF0aWJpbGl0eTogQ29tcGF0aWJpbGl0eS5FWFRFUk5BTCxcbiAgICAgIG5ldHdvcmtNb2RlOiBOZXR3b3JrTW9kZS5CUklER0UsXG4gICAgfSk7XG4gIH1cblxuICAvKipcbiAgICogT3ZlcnJpZGRlbiBtZXRob2QgdG8gdGhyb3cgZXJyb3IsIGFzIHZvbHVtZXMgYXJlIG5vdCBzdXBwb3J0ZWQgZm9yIGV4dGVybmFsIHRhc2sgZGVmaW5pdGlvbnNcbiAgICovXG4gIHB1YmxpYyBhZGRWb2x1bWUoX3ZvbHVtZTogVm9sdW1lKSB7XG4gICAgdGhyb3cgbmV3IEVycm9yKCdFeHRlcm5hbCB0YXNrIGRlZmluaXRpb25zIGRvZXNudCBzdXBwb3J0IHZvbHVtZXMnKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBPdmVycmlkZW4gbWV0aG9kIHRvIHRocm93IGVycm9yIGFzIGludGVyZmFjZSBhY2NlbGVyYXRvcnMgYXJlIG5vdCBzdXBwb3J0ZWQgZm9yIGV4dGVybmFsIHRhc2tzXG4gICAqL1xuICBwdWJsaWMgYWRkSW5mZXJlbmNlQWNjZWxlcmF0b3IoX2luZmVyZW5jZUFjY2VsZXJhdG9yOiBJbmZlcmVuY2VBY2NlbGVyYXRvcikge1xuICAgIHRocm93IG5ldyBFcnJvcignQ2Fubm90IHVzZSBpbmZlcmVuY2UgYWNjZWxlcmF0b3JzIG9uIHRhc2tzIHRoYXQgcnVuIG9uIEV4dGVybmFsIHNlcnZpY2UnKTtcbiAgfVxufVxuIl19