"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExternalService = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../../core");
const base_service_1 = require("../base/base-service");
const from_service_attributes_1 = require("../base/from-service-attributes");
const task_definition_1 = require("../base/task-definition");
/**
 * This creates a service using the External launch type on an ECS cluster.
 *
 * @resource AWS::ECS::Service
 */
class ExternalService extends base_service_1.BaseService {
    /**
     * Constructs a new instance of the ExternalService class.
     */
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalServiceProps(props);
        if (props.minHealthyPercent !== undefined && props.maxHealthyPercent !== undefined && props.minHealthyPercent >= props.maxHealthyPercent) {
            throw new Error('Minimum healthy percent must be less than maximum healthy percent.');
        }
        if (props.taskDefinition.compatibility !== task_definition_1.Compatibility.EXTERNAL) {
            throw new Error('Supplied TaskDefinition is not configured for compatibility with ECS Anywhere cluster');
        }
        if (props.cluster.defaultCloudMapNamespace !== undefined) {
            throw new Error(`Cloud map integration is not supported for External service ${props.cluster.defaultCloudMapNamespace}`);
        }
        if (props.cloudMapOptions !== undefined) {
            throw new Error('Cloud map options are not supported for External service');
        }
        if (props.enableExecuteCommand !== undefined) {
            throw new Error('Enable Execute Command options are not supported for External service');
        }
        if (props.capacityProviderStrategies !== undefined) {
            throw new Error('Capacity Providers are not supported for External service');
        }
        const propagateTagsFromSource = (_b = props.propagateTags) !== null && _b !== void 0 ? _b : base_service_1.PropagatedTagSource.NONE;
        super(scope, id, {
            ...props,
            desiredCount: props.desiredCount,
            maxHealthyPercent: props.maxHealthyPercent === undefined ? 100 : props.maxHealthyPercent,
            minHealthyPercent: props.minHealthyPercent === undefined ? 0 : props.minHealthyPercent,
            launchType: base_service_1.LaunchType.EXTERNAL,
            propagateTags: propagateTagsFromSource,
            enableECSManagedTags: props.enableECSManagedTags,
        }, {
            cluster: props.cluster.clusterName,
            taskDefinition: ((_c = props.deploymentController) === null || _c === void 0 ? void 0 : _c.type) === base_service_1.DeploymentControllerType.EXTERNAL ? undefined : props.taskDefinition.taskDefinitionArn,
        }, props.taskDefinition);
        this.node.addValidation({
            validate: () => !this.taskDefinition.defaultContainer ? ['A TaskDefinition must have at least one essential container'] : [],
        });
        this.node.addValidation({
            validate: () => this.networkConfiguration !== undefined ? ['Network configurations not supported for an external service'] : [],
        });
    }
    /**
     * Imports from the specified service ARN.
     */
    static fromExternalServiceArn(scope, id, externalServiceArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = externalServiceArn;
                this.serviceName = core_1.Stack.of(scope).splitArn(externalServiceArn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Imports from the specified service attrributes.
     */
    static fromExternalServiceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_ExternalServiceAttributes(attrs);
        return from_service_attributes_1.fromServiceAtrributes(scope, id, attrs);
    }
    /**
     * Overriden method to throw error as `attachToApplicationTargetGroup` is not supported for external service
     */
    attachToApplicationTargetGroup(_targetGroup) {
        jsiiDeprecationWarnings.monocdk_aws_elasticloadbalancingv2_IApplicationTargetGroup(_targetGroup);
        throw new Error('Application load balancer cannot be attached to an external service');
    }
    /**
     * Overriden method to throw error as `loadBalancerTarget` is not supported for external service
     */
    loadBalancerTarget(_options) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_LoadBalancerTargetOptions(_options);
        throw new Error('External service cannot be attached as load balancer targets');
    }
    /**
     * Overriden method to throw error as `registerLoadBalancerTargets` is not supported for external service
     */
    registerLoadBalancerTargets(..._targets) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_EcsTarget(_targets);
        throw new Error('External service cannot be registered as load balancer targets');
    }
    /**
     * Overriden method to throw error as `configureAwsVpcNetworkingWithSecurityGroups` is not supported for external service
     */
    // eslint-disable-next-line max-len, no-unused-vars
    configureAwsVpcNetworkingWithSecurityGroups(_vpc, _assignPublicIp, _vpcSubnets, _securityGroups) {
        jsiiDeprecationWarnings.monocdk_aws_ec2_IVpc(_vpc);
        jsiiDeprecationWarnings.monocdk_aws_ec2_SubnetSelection(_vpcSubnets);
        throw new Error('Only Bridge network mode is supported for external service');
    }
    /**
     * Overriden method to throw error as `autoScaleTaskCount` is not supported for external service
     */
    autoScaleTaskCount(_props) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_EnableScalingProps(_props);
        throw new Error('Autoscaling not supported for external service');
    }
    /**
     * Overriden method to throw error as `enableCloudMap` is not supported for external service
     */
    enableCloudMap(_options) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_CloudMapOptions(_options);
        throw new Error('Cloud map integration not supported for an external service');
    }
    /**
     * Overriden method to throw error as `associateCloudMapService` is not supported for external service
     */
    associateCloudMapService(_options) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_AssociateCloudMapServiceOptions(_options);
        throw new Error('Cloud map service association is not supported for an external service');
    }
}
exports.ExternalService = ExternalService;
_a = JSII_RTTI_SYMBOL_1;
ExternalService[_a] = { fqn: "monocdk.aws_ecs.ExternalService", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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