"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EnvironmentFileType = exports.S3EnvironmentFile = exports.AssetEnvironmentFile = exports.EnvironmentFile = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_assets_1 = require("../../aws-s3-assets");
/**
 * Constructs for types of environment files
 */
class EnvironmentFile {
    /**
     * Loads the environment file from a local disk path.
     *
     * @param path Local disk path
     * @param options
     */
    static fromAsset(path, options) {
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_AssetOptions(options);
        return new AssetEnvironmentFile(path, options);
    }
    /**
     * Loads the environment file from an S3 bucket.
     *
     * @returns `S3EnvironmentFile` associated with the specified S3 object.
     * @param bucket The S3 bucket
     * @param key The object key
     * @param objectVersion Optional S3 object version
     */
    static fromBucket(bucket, key, objectVersion) {
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        return new S3EnvironmentFile(bucket, key, objectVersion);
    }
}
exports.EnvironmentFile = EnvironmentFile;
_a = JSII_RTTI_SYMBOL_1;
EnvironmentFile[_a] = { fqn: "monocdk.aws_ecs.EnvironmentFile", version: "1.149.0" };
/**
 * Environment file from a local directory.
 */
class AssetEnvironmentFile extends EnvironmentFile {
    /**
     * @param path The path to the asset file or directory.
     * @param options
     */
    constructor(path, options = {}) {
        super();
        this.path = path;
        this.options = options;
        jsiiDeprecationWarnings.monocdk_aws_s3_assets_AssetOptions(options);
    }
    bind(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        // If the same AssetCode is used multiple times, retain only the first instantiation.
        if (!this.asset) {
            this.asset = new aws_s3_assets_1.Asset(scope, 'EnvironmentFile', {
                path: this.path,
                ...this.options,
            });
        }
        if (!this.asset.isFile) {
            throw new Error(`Asset must be a single file (${this.path})`);
        }
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.asset.s3BucketName,
                objectKey: this.asset.s3ObjectKey,
            },
        };
    }
}
exports.AssetEnvironmentFile = AssetEnvironmentFile;
_b = JSII_RTTI_SYMBOL_1;
AssetEnvironmentFile[_b] = { fqn: "monocdk.aws_ecs.AssetEnvironmentFile", version: "1.149.0" };
/**
 * Environment file from S3.
 */
class S3EnvironmentFile extends EnvironmentFile {
    constructor(bucket, key, objectVersion) {
        super();
        this.key = key;
        this.objectVersion = objectVersion;
        jsiiDeprecationWarnings.monocdk_aws_s3_IBucket(bucket);
        if (!bucket.bucketName) {
            throw new Error('bucketName is undefined for the provided bucket');
        }
        this.bucketName = bucket.bucketName;
    }
    bind(_scope) {
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        return {
            fileType: EnvironmentFileType.S3,
            s3Location: {
                bucketName: this.bucketName,
                objectKey: this.key,
                objectVersion: this.objectVersion,
            },
        };
    }
}
exports.S3EnvironmentFile = S3EnvironmentFile;
_c = JSII_RTTI_SYMBOL_1;
S3EnvironmentFile[_c] = { fqn: "monocdk.aws_ecs.S3EnvironmentFile", version: "1.149.0" };
/**
 * Type of environment file to be included in the container definition
 */
var EnvironmentFileType;
(function (EnvironmentFileType) {
    /**
     * Environment file hosted on S3, referenced by object ARN
     */
    EnvironmentFileType["S3"] = "s3";
})(EnvironmentFileType = exports.EnvironmentFileType || (exports.EnvironmentFileType = {}));
//# sourceMappingURL=data:application/json;base64,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