"use strict";
var _a, _b, _c, _d, _e, _f, _g;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnTaskSet = exports.CfnTaskDefinition = exports.CfnService = exports.CfnPrimaryTaskSet = exports.CfnClusterCapacityProviderAssociations = exports.CfnCluster = exports.CfnCapacityProvider = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:41:58.921Z","fingerprint":"PqQy28xF3OkqU+lWVOjREKeRH1gE/pBjbJ8NtSQwZ+c="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnCapacityProviderProps`
 *
 * @param properties - the TypeScript properties of a `CfnCapacityProviderProps`
 *
 * @returns the result of the validation.
 */
function CfnCapacityProviderPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupProvider', cdk.requiredValidator)(properties.autoScalingGroupProvider));
    errors.collect(cdk.propertyValidator('autoScalingGroupProvider', CfnCapacityProvider_AutoScalingGroupProviderPropertyValidator)(properties.autoScalingGroupProvider));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnCapacityProviderProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider` resource
 *
 * @param properties - the TypeScript properties of a `CfnCapacityProviderProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider` resource.
 */
// @ts-ignore TS6133
function cfnCapacityProviderPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCapacityProviderPropsValidator(properties).assertSuccess();
    return {
        AutoScalingGroupProvider: cfnCapacityProviderAutoScalingGroupProviderPropertyToCloudFormation(properties.autoScalingGroupProvider),
        Name: cdk.stringToCloudFormation(properties.name),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnCapacityProviderPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupProvider', 'AutoScalingGroupProvider', CfnCapacityProviderAutoScalingGroupProviderPropertyFromCloudFormation(properties.AutoScalingGroupProvider));
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::CapacityProvider`
 *
 * The `AWS::ECS::CapacityProvider` resource creates an Amazon Elastic Container Service (Amazon ECS) capacity provider. Capacity providers are associated with an Amazon ECS cluster and are used in capacity provider strategies to facilitate cluster auto scaling.
 *
 * Only capacity providers using an Auto Scaling group can be created. Amazon ECS tasks on AWS Fargate use the `FARGATE` and `FARGATE_SPOT` capacity providers which are already created and available to all accounts in Regions supported by AWS Fargate .
 *
 * @cloudformationResource AWS::ECS::CapacityProvider
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-capacityprovider.html
 */
class CfnCapacityProvider extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::CapacityProvider`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCapacityProvider.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnCapacityProviderProps(props);
        cdk.requireProperty(props, 'autoScalingGroupProvider', this);
        this.autoScalingGroupProvider = props.autoScalingGroupProvider;
        this.name = props.name;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::ECS::CapacityProvider", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCapacityProviderPropsFromCloudFormation(resourceProperties);
        const ret = new CfnCapacityProvider(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCapacityProvider.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            autoScalingGroupProvider: this.autoScalingGroupProvider,
            name: this.name,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnCapacityProviderPropsToCloudFormation(props);
    }
}
exports.CfnCapacityProvider = CfnCapacityProvider;
_a = JSII_RTTI_SYMBOL_1;
CfnCapacityProvider[_a] = { fqn: "monocdk.aws_ecs.CfnCapacityProvider", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCapacityProvider.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::CapacityProvider";
/**
 * Determine whether the given properties match those of a `AutoScalingGroupProviderProperty`
 *
 * @param properties - the TypeScript properties of a `AutoScalingGroupProviderProperty`
 *
 * @returns the result of the validation.
 */
function CfnCapacityProvider_AutoScalingGroupProviderPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoScalingGroupArn', cdk.requiredValidator)(properties.autoScalingGroupArn));
    errors.collect(cdk.propertyValidator('autoScalingGroupArn', cdk.validateString)(properties.autoScalingGroupArn));
    errors.collect(cdk.propertyValidator('managedScaling', CfnCapacityProvider_ManagedScalingPropertyValidator)(properties.managedScaling));
    errors.collect(cdk.propertyValidator('managedTerminationProtection', cdk.validateString)(properties.managedTerminationProtection));
    return errors.wrap('supplied properties not correct for "AutoScalingGroupProviderProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider.AutoScalingGroupProvider` resource
 *
 * @param properties - the TypeScript properties of a `AutoScalingGroupProviderProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider.AutoScalingGroupProvider` resource.
 */
// @ts-ignore TS6133
function cfnCapacityProviderAutoScalingGroupProviderPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCapacityProvider_AutoScalingGroupProviderPropertyValidator(properties).assertSuccess();
    return {
        AutoScalingGroupArn: cdk.stringToCloudFormation(properties.autoScalingGroupArn),
        ManagedScaling: cfnCapacityProviderManagedScalingPropertyToCloudFormation(properties.managedScaling),
        ManagedTerminationProtection: cdk.stringToCloudFormation(properties.managedTerminationProtection),
    };
}
// @ts-ignore TS6133
function CfnCapacityProviderAutoScalingGroupProviderPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoScalingGroupArn', 'AutoScalingGroupArn', cfn_parse.FromCloudFormation.getString(properties.AutoScalingGroupArn));
    ret.addPropertyResult('managedScaling', 'ManagedScaling', properties.ManagedScaling != null ? CfnCapacityProviderManagedScalingPropertyFromCloudFormation(properties.ManagedScaling) : undefined);
    ret.addPropertyResult('managedTerminationProtection', 'ManagedTerminationProtection', properties.ManagedTerminationProtection != null ? cfn_parse.FromCloudFormation.getString(properties.ManagedTerminationProtection) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ManagedScalingProperty`
 *
 * @param properties - the TypeScript properties of a `ManagedScalingProperty`
 *
 * @returns the result of the validation.
 */
function CfnCapacityProvider_ManagedScalingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('instanceWarmupPeriod', cdk.validateNumber)(properties.instanceWarmupPeriod));
    errors.collect(cdk.propertyValidator('maximumScalingStepSize', cdk.validateNumber)(properties.maximumScalingStepSize));
    errors.collect(cdk.propertyValidator('minimumScalingStepSize', cdk.validateNumber)(properties.minimumScalingStepSize));
    errors.collect(cdk.propertyValidator('status', cdk.validateString)(properties.status));
    errors.collect(cdk.propertyValidator('targetCapacity', cdk.validateNumber)(properties.targetCapacity));
    return errors.wrap('supplied properties not correct for "ManagedScalingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider.ManagedScaling` resource
 *
 * @param properties - the TypeScript properties of a `ManagedScalingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::CapacityProvider.ManagedScaling` resource.
 */
// @ts-ignore TS6133
function cfnCapacityProviderManagedScalingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCapacityProvider_ManagedScalingPropertyValidator(properties).assertSuccess();
    return {
        InstanceWarmupPeriod: cdk.numberToCloudFormation(properties.instanceWarmupPeriod),
        MaximumScalingStepSize: cdk.numberToCloudFormation(properties.maximumScalingStepSize),
        MinimumScalingStepSize: cdk.numberToCloudFormation(properties.minimumScalingStepSize),
        Status: cdk.stringToCloudFormation(properties.status),
        TargetCapacity: cdk.numberToCloudFormation(properties.targetCapacity),
    };
}
// @ts-ignore TS6133
function CfnCapacityProviderManagedScalingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('instanceWarmupPeriod', 'InstanceWarmupPeriod', properties.InstanceWarmupPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.InstanceWarmupPeriod) : undefined);
    ret.addPropertyResult('maximumScalingStepSize', 'MaximumScalingStepSize', properties.MaximumScalingStepSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumScalingStepSize) : undefined);
    ret.addPropertyResult('minimumScalingStepSize', 'MinimumScalingStepSize', properties.MinimumScalingStepSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinimumScalingStepSize) : undefined);
    ret.addPropertyResult('status', 'Status', properties.Status != null ? cfn_parse.FromCloudFormation.getString(properties.Status) : undefined);
    ret.addPropertyResult('targetCapacity', 'TargetCapacity', properties.TargetCapacity != null ? cfn_parse.FromCloudFormation.getNumber(properties.TargetCapacity) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnClusterProps`
 *
 * @param properties - the TypeScript properties of a `CfnClusterProps`
 *
 * @returns the result of the validation.
 */
function CfnClusterPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('capacityProviders', cdk.listValidator(cdk.validateString))(properties.capacityProviders));
    errors.collect(cdk.propertyValidator('clusterName', cdk.validateString)(properties.clusterName));
    errors.collect(cdk.propertyValidator('clusterSettings', cdk.listValidator(CfnCluster_ClusterSettingsPropertyValidator))(properties.clusterSettings));
    errors.collect(cdk.propertyValidator('configuration', CfnCluster_ClusterConfigurationPropertyValidator)(properties.configuration));
    errors.collect(cdk.propertyValidator('defaultCapacityProviderStrategy', cdk.listValidator(CfnCluster_CapacityProviderStrategyItemPropertyValidator))(properties.defaultCapacityProviderStrategy));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnClusterProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster` resource
 *
 * @param properties - the TypeScript properties of a `CfnClusterProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster` resource.
 */
// @ts-ignore TS6133
function cfnClusterPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnClusterPropsValidator(properties).assertSuccess();
    return {
        CapacityProviders: cdk.listMapper(cdk.stringToCloudFormation)(properties.capacityProviders),
        ClusterName: cdk.stringToCloudFormation(properties.clusterName),
        ClusterSettings: cdk.listMapper(cfnClusterClusterSettingsPropertyToCloudFormation)(properties.clusterSettings),
        Configuration: cfnClusterClusterConfigurationPropertyToCloudFormation(properties.configuration),
        DefaultCapacityProviderStrategy: cdk.listMapper(cfnClusterCapacityProviderStrategyItemPropertyToCloudFormation)(properties.defaultCapacityProviderStrategy),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnClusterPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('capacityProviders', 'CapacityProviders', properties.CapacityProviders != null ? cfn_parse.FromCloudFormation.getStringArray(properties.CapacityProviders) : undefined);
    ret.addPropertyResult('clusterName', 'ClusterName', properties.ClusterName != null ? cfn_parse.FromCloudFormation.getString(properties.ClusterName) : undefined);
    ret.addPropertyResult('clusterSettings', 'ClusterSettings', properties.ClusterSettings != null ? cfn_parse.FromCloudFormation.getArray(CfnClusterClusterSettingsPropertyFromCloudFormation)(properties.ClusterSettings) : undefined);
    ret.addPropertyResult('configuration', 'Configuration', properties.Configuration != null ? CfnClusterClusterConfigurationPropertyFromCloudFormation(properties.Configuration) : undefined);
    ret.addPropertyResult('defaultCapacityProviderStrategy', 'DefaultCapacityProviderStrategy', properties.DefaultCapacityProviderStrategy != null ? cfn_parse.FromCloudFormation.getArray(CfnClusterCapacityProviderStrategyItemPropertyFromCloudFormation)(properties.DefaultCapacityProviderStrategy) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::Cluster`
 *
 * The `AWS::ECS::Cluster` resource creates an Amazon Elastic Container Service (Amazon ECS) cluster.
 *
 * @cloudformationResource AWS::ECS::Cluster
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html
 */
class CfnCluster extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::Cluster`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnCluster.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnClusterProps(props);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.capacityProviders = props.capacityProviders;
        this.clusterName = props.clusterName;
        this.clusterSettings = props.clusterSettings;
        this.configuration = props.configuration;
        this.defaultCapacityProviderStrategy = props.defaultCapacityProviderStrategy;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::ECS::Cluster", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnClusterPropsFromCloudFormation(resourceProperties);
        const ret = new CfnCluster(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCluster.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            capacityProviders: this.capacityProviders,
            clusterName: this.clusterName,
            clusterSettings: this.clusterSettings,
            configuration: this.configuration,
            defaultCapacityProviderStrategy: this.defaultCapacityProviderStrategy,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnClusterPropsToCloudFormation(props);
    }
}
exports.CfnCluster = CfnCluster;
_b = JSII_RTTI_SYMBOL_1;
CfnCluster[_b] = { fqn: "monocdk.aws_ecs.CfnCluster", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCluster.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::Cluster";
/**
 * Determine whether the given properties match those of a `CapacityProviderStrategyItemProperty`
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnCluster_CapacityProviderStrategyItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('base', cdk.validateNumber)(properties.base));
    errors.collect(cdk.propertyValidator('capacityProvider', cdk.validateString)(properties.capacityProvider));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "CapacityProviderStrategyItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster.CapacityProviderStrategyItem` resource
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster.CapacityProviderStrategyItem` resource.
 */
// @ts-ignore TS6133
function cfnClusterCapacityProviderStrategyItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCluster_CapacityProviderStrategyItemPropertyValidator(properties).assertSuccess();
    return {
        Base: cdk.numberToCloudFormation(properties.base),
        CapacityProvider: cdk.stringToCloudFormation(properties.capacityProvider),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnClusterCapacityProviderStrategyItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('base', 'Base', properties.Base != null ? cfn_parse.FromCloudFormation.getNumber(properties.Base) : undefined);
    ret.addPropertyResult('capacityProvider', 'CapacityProvider', properties.CapacityProvider != null ? cfn_parse.FromCloudFormation.getString(properties.CapacityProvider) : undefined);
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnCluster_ClusterConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('executeCommandConfiguration', CfnCluster_ExecuteCommandConfigurationPropertyValidator)(properties.executeCommandConfiguration));
    return errors.wrap('supplied properties not correct for "ClusterConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster.ClusterConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ClusterConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster.ClusterConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnClusterClusterConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCluster_ClusterConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ExecuteCommandConfiguration: cfnClusterExecuteCommandConfigurationPropertyToCloudFormation(properties.executeCommandConfiguration),
    };
}
// @ts-ignore TS6133
function CfnClusterClusterConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('executeCommandConfiguration', 'ExecuteCommandConfiguration', properties.ExecuteCommandConfiguration != null ? CfnClusterExecuteCommandConfigurationPropertyFromCloudFormation(properties.ExecuteCommandConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ClusterSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `ClusterSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnCluster_ClusterSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ClusterSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster.ClusterSettings` resource
 *
 * @param properties - the TypeScript properties of a `ClusterSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster.ClusterSettings` resource.
 */
// @ts-ignore TS6133
function cfnClusterClusterSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCluster_ClusterSettingsPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnClusterClusterSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExecuteCommandConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ExecuteCommandConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnCluster_ExecuteCommandConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('logConfiguration', CfnCluster_ExecuteCommandLogConfigurationPropertyValidator)(properties.logConfiguration));
    errors.collect(cdk.propertyValidator('logging', cdk.validateString)(properties.logging));
    return errors.wrap('supplied properties not correct for "ExecuteCommandConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster.ExecuteCommandConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ExecuteCommandConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster.ExecuteCommandConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnClusterExecuteCommandConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCluster_ExecuteCommandConfigurationPropertyValidator(properties).assertSuccess();
    return {
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        LogConfiguration: cfnClusterExecuteCommandLogConfigurationPropertyToCloudFormation(properties.logConfiguration),
        Logging: cdk.stringToCloudFormation(properties.logging),
    };
}
// @ts-ignore TS6133
function CfnClusterExecuteCommandConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('logConfiguration', 'LogConfiguration', properties.LogConfiguration != null ? CfnClusterExecuteCommandLogConfigurationPropertyFromCloudFormation(properties.LogConfiguration) : undefined);
    ret.addPropertyResult('logging', 'Logging', properties.Logging != null ? cfn_parse.FromCloudFormation.getString(properties.Logging) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ExecuteCommandLogConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ExecuteCommandLogConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnCluster_ExecuteCommandLogConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cloudWatchEncryptionEnabled', cdk.validateBoolean)(properties.cloudWatchEncryptionEnabled));
    errors.collect(cdk.propertyValidator('cloudWatchLogGroupName', cdk.validateString)(properties.cloudWatchLogGroupName));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('s3EncryptionEnabled', cdk.validateBoolean)(properties.s3EncryptionEnabled));
    errors.collect(cdk.propertyValidator('s3KeyPrefix', cdk.validateString)(properties.s3KeyPrefix));
    return errors.wrap('supplied properties not correct for "ExecuteCommandLogConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Cluster.ExecuteCommandLogConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ExecuteCommandLogConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Cluster.ExecuteCommandLogConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnClusterExecuteCommandLogConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCluster_ExecuteCommandLogConfigurationPropertyValidator(properties).assertSuccess();
    return {
        CloudWatchEncryptionEnabled: cdk.booleanToCloudFormation(properties.cloudWatchEncryptionEnabled),
        CloudWatchLogGroupName: cdk.stringToCloudFormation(properties.cloudWatchLogGroupName),
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        S3EncryptionEnabled: cdk.booleanToCloudFormation(properties.s3EncryptionEnabled),
        S3KeyPrefix: cdk.stringToCloudFormation(properties.s3KeyPrefix),
    };
}
// @ts-ignore TS6133
function CfnClusterExecuteCommandLogConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cloudWatchEncryptionEnabled', 'CloudWatchEncryptionEnabled', properties.CloudWatchEncryptionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CloudWatchEncryptionEnabled) : undefined);
    ret.addPropertyResult('cloudWatchLogGroupName', 'CloudWatchLogGroupName', properties.CloudWatchLogGroupName != null ? cfn_parse.FromCloudFormation.getString(properties.CloudWatchLogGroupName) : undefined);
    ret.addPropertyResult('s3BucketName', 'S3BucketName', properties.S3BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketName) : undefined);
    ret.addPropertyResult('s3EncryptionEnabled', 'S3EncryptionEnabled', properties.S3EncryptionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.S3EncryptionEnabled) : undefined);
    ret.addPropertyResult('s3KeyPrefix', 'S3KeyPrefix', properties.S3KeyPrefix != null ? cfn_parse.FromCloudFormation.getString(properties.S3KeyPrefix) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnClusterCapacityProviderAssociationsProps`
 *
 * @param properties - the TypeScript properties of a `CfnClusterCapacityProviderAssociationsProps`
 *
 * @returns the result of the validation.
 */
function CfnClusterCapacityProviderAssociationsPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('capacityProviders', cdk.requiredValidator)(properties.capacityProviders));
    errors.collect(cdk.propertyValidator('capacityProviders', cdk.listValidator(cdk.validateString))(properties.capacityProviders));
    errors.collect(cdk.propertyValidator('cluster', cdk.requiredValidator)(properties.cluster));
    errors.collect(cdk.propertyValidator('cluster', cdk.validateString)(properties.cluster));
    errors.collect(cdk.propertyValidator('defaultCapacityProviderStrategy', cdk.requiredValidator)(properties.defaultCapacityProviderStrategy));
    errors.collect(cdk.propertyValidator('defaultCapacityProviderStrategy', cdk.listValidator(CfnClusterCapacityProviderAssociations_CapacityProviderStrategyPropertyValidator))(properties.defaultCapacityProviderStrategy));
    return errors.wrap('supplied properties not correct for "CfnClusterCapacityProviderAssociationsProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::ClusterCapacityProviderAssociations` resource
 *
 * @param properties - the TypeScript properties of a `CfnClusterCapacityProviderAssociationsProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::ClusterCapacityProviderAssociations` resource.
 */
// @ts-ignore TS6133
function cfnClusterCapacityProviderAssociationsPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnClusterCapacityProviderAssociationsPropsValidator(properties).assertSuccess();
    return {
        CapacityProviders: cdk.listMapper(cdk.stringToCloudFormation)(properties.capacityProviders),
        Cluster: cdk.stringToCloudFormation(properties.cluster),
        DefaultCapacityProviderStrategy: cdk.listMapper(cfnClusterCapacityProviderAssociationsCapacityProviderStrategyPropertyToCloudFormation)(properties.defaultCapacityProviderStrategy),
    };
}
// @ts-ignore TS6133
function CfnClusterCapacityProviderAssociationsPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('capacityProviders', 'CapacityProviders', cfn_parse.FromCloudFormation.getStringArray(properties.CapacityProviders));
    ret.addPropertyResult('cluster', 'Cluster', cfn_parse.FromCloudFormation.getString(properties.Cluster));
    ret.addPropertyResult('defaultCapacityProviderStrategy', 'DefaultCapacityProviderStrategy', cfn_parse.FromCloudFormation.getArray(CfnClusterCapacityProviderAssociationsCapacityProviderStrategyPropertyFromCloudFormation)(properties.DefaultCapacityProviderStrategy));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::ClusterCapacityProviderAssociations`
 *
 * The `AWS::ECS::ClusterCapacityProviderAssociations` resource associates one or more capacity providers and a default capacity provider strategy with a cluster.
 *
 * @cloudformationResource AWS::ECS::ClusterCapacityProviderAssociations
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-clustercapacityproviderassociations.html
 */
class CfnClusterCapacityProviderAssociations extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::ClusterCapacityProviderAssociations`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnClusterCapacityProviderAssociations.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnClusterCapacityProviderAssociationsProps(props);
        cdk.requireProperty(props, 'capacityProviders', this);
        cdk.requireProperty(props, 'cluster', this);
        cdk.requireProperty(props, 'defaultCapacityProviderStrategy', this);
        this.capacityProviders = props.capacityProviders;
        this.cluster = props.cluster;
        this.defaultCapacityProviderStrategy = props.defaultCapacityProviderStrategy;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnClusterCapacityProviderAssociationsPropsFromCloudFormation(resourceProperties);
        const ret = new CfnClusterCapacityProviderAssociations(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnClusterCapacityProviderAssociations.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            capacityProviders: this.capacityProviders,
            cluster: this.cluster,
            defaultCapacityProviderStrategy: this.defaultCapacityProviderStrategy,
        };
    }
    renderProperties(props) {
        return cfnClusterCapacityProviderAssociationsPropsToCloudFormation(props);
    }
}
exports.CfnClusterCapacityProviderAssociations = CfnClusterCapacityProviderAssociations;
_c = JSII_RTTI_SYMBOL_1;
CfnClusterCapacityProviderAssociations[_c] = { fqn: "monocdk.aws_ecs.CfnClusterCapacityProviderAssociations", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnClusterCapacityProviderAssociations.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::ClusterCapacityProviderAssociations";
/**
 * Determine whether the given properties match those of a `CapacityProviderStrategyProperty`
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyProperty`
 *
 * @returns the result of the validation.
 */
function CfnClusterCapacityProviderAssociations_CapacityProviderStrategyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('base', cdk.validateNumber)(properties.base));
    errors.collect(cdk.propertyValidator('capacityProvider', cdk.requiredValidator)(properties.capacityProvider));
    errors.collect(cdk.propertyValidator('capacityProvider', cdk.validateString)(properties.capacityProvider));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "CapacityProviderStrategyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::ClusterCapacityProviderAssociations.CapacityProviderStrategy` resource
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::ClusterCapacityProviderAssociations.CapacityProviderStrategy` resource.
 */
// @ts-ignore TS6133
function cfnClusterCapacityProviderAssociationsCapacityProviderStrategyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnClusterCapacityProviderAssociations_CapacityProviderStrategyPropertyValidator(properties).assertSuccess();
    return {
        Base: cdk.numberToCloudFormation(properties.base),
        CapacityProvider: cdk.stringToCloudFormation(properties.capacityProvider),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnClusterCapacityProviderAssociationsCapacityProviderStrategyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('base', 'Base', properties.Base != null ? cfn_parse.FromCloudFormation.getNumber(properties.Base) : undefined);
    ret.addPropertyResult('capacityProvider', 'CapacityProvider', cfn_parse.FromCloudFormation.getString(properties.CapacityProvider));
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnPrimaryTaskSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnPrimaryTaskSetProps`
 *
 * @returns the result of the validation.
 */
function CfnPrimaryTaskSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cluster', cdk.requiredValidator)(properties.cluster));
    errors.collect(cdk.propertyValidator('cluster', cdk.validateString)(properties.cluster));
    errors.collect(cdk.propertyValidator('service', cdk.requiredValidator)(properties.service));
    errors.collect(cdk.propertyValidator('service', cdk.validateString)(properties.service));
    errors.collect(cdk.propertyValidator('taskSetId', cdk.requiredValidator)(properties.taskSetId));
    errors.collect(cdk.propertyValidator('taskSetId', cdk.validateString)(properties.taskSetId));
    return errors.wrap('supplied properties not correct for "CfnPrimaryTaskSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::PrimaryTaskSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnPrimaryTaskSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::PrimaryTaskSet` resource.
 */
// @ts-ignore TS6133
function cfnPrimaryTaskSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnPrimaryTaskSetPropsValidator(properties).assertSuccess();
    return {
        Cluster: cdk.stringToCloudFormation(properties.cluster),
        Service: cdk.stringToCloudFormation(properties.service),
        TaskSetId: cdk.stringToCloudFormation(properties.taskSetId),
    };
}
// @ts-ignore TS6133
function CfnPrimaryTaskSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cluster', 'Cluster', cfn_parse.FromCloudFormation.getString(properties.Cluster));
    ret.addPropertyResult('service', 'Service', cfn_parse.FromCloudFormation.getString(properties.Service));
    ret.addPropertyResult('taskSetId', 'TaskSetId', cfn_parse.FromCloudFormation.getString(properties.TaskSetId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::PrimaryTaskSet`
 *
 * Specifies which task set in a service is the primary task set. Any parameters that are updated on the primary task set in a service will transition to the service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide* .
 *
 * @cloudformationResource AWS::ECS::PrimaryTaskSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-primarytaskset.html
 */
class CfnPrimaryTaskSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::PrimaryTaskSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnPrimaryTaskSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnPrimaryTaskSetProps(props);
        cdk.requireProperty(props, 'cluster', this);
        cdk.requireProperty(props, 'service', this);
        cdk.requireProperty(props, 'taskSetId', this);
        this.cluster = props.cluster;
        this.service = props.service;
        this.taskSetId = props.taskSetId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnPrimaryTaskSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnPrimaryTaskSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnPrimaryTaskSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            cluster: this.cluster,
            service: this.service,
            taskSetId: this.taskSetId,
        };
    }
    renderProperties(props) {
        return cfnPrimaryTaskSetPropsToCloudFormation(props);
    }
}
exports.CfnPrimaryTaskSet = CfnPrimaryTaskSet;
_d = JSII_RTTI_SYMBOL_1;
CfnPrimaryTaskSet[_d] = { fqn: "monocdk.aws_ecs.CfnPrimaryTaskSet", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnPrimaryTaskSet.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::PrimaryTaskSet";
/**
 * Determine whether the given properties match those of a `CfnServiceProps`
 *
 * @param properties - the TypeScript properties of a `CfnServiceProps`
 *
 * @returns the result of the validation.
 */
function CfnServicePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('capacityProviderStrategy', cdk.listValidator(CfnService_CapacityProviderStrategyItemPropertyValidator))(properties.capacityProviderStrategy));
    errors.collect(cdk.propertyValidator('cluster', cdk.validateString)(properties.cluster));
    errors.collect(cdk.propertyValidator('deploymentConfiguration', CfnService_DeploymentConfigurationPropertyValidator)(properties.deploymentConfiguration));
    errors.collect(cdk.propertyValidator('deploymentController', CfnService_DeploymentControllerPropertyValidator)(properties.deploymentController));
    errors.collect(cdk.propertyValidator('desiredCount', cdk.validateNumber)(properties.desiredCount));
    errors.collect(cdk.propertyValidator('enableEcsManagedTags', cdk.validateBoolean)(properties.enableEcsManagedTags));
    errors.collect(cdk.propertyValidator('enableExecuteCommand', cdk.validateBoolean)(properties.enableExecuteCommand));
    errors.collect(cdk.propertyValidator('healthCheckGracePeriodSeconds', cdk.validateNumber)(properties.healthCheckGracePeriodSeconds));
    errors.collect(cdk.propertyValidator('launchType', cdk.validateString)(properties.launchType));
    errors.collect(cdk.propertyValidator('loadBalancers', cdk.listValidator(CfnService_LoadBalancerPropertyValidator))(properties.loadBalancers));
    errors.collect(cdk.propertyValidator('networkConfiguration', CfnService_NetworkConfigurationPropertyValidator)(properties.networkConfiguration));
    errors.collect(cdk.propertyValidator('placementConstraints', cdk.listValidator(CfnService_PlacementConstraintPropertyValidator))(properties.placementConstraints));
    errors.collect(cdk.propertyValidator('placementStrategies', cdk.listValidator(CfnService_PlacementStrategyPropertyValidator))(properties.placementStrategies));
    errors.collect(cdk.propertyValidator('platformVersion', cdk.validateString)(properties.platformVersion));
    errors.collect(cdk.propertyValidator('propagateTags', cdk.validateString)(properties.propagateTags));
    errors.collect(cdk.propertyValidator('role', cdk.validateString)(properties.role));
    errors.collect(cdk.propertyValidator('schedulingStrategy', cdk.validateString)(properties.schedulingStrategy));
    errors.collect(cdk.propertyValidator('serviceName', cdk.validateString)(properties.serviceName));
    errors.collect(cdk.propertyValidator('serviceRegistries', cdk.listValidator(CfnService_ServiceRegistryPropertyValidator))(properties.serviceRegistries));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('taskDefinition', cdk.validateString)(properties.taskDefinition));
    return errors.wrap('supplied properties not correct for "CfnServiceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service` resource
 *
 * @param properties - the TypeScript properties of a `CfnServiceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service` resource.
 */
// @ts-ignore TS6133
function cfnServicePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnServicePropsValidator(properties).assertSuccess();
    return {
        CapacityProviderStrategy: cdk.listMapper(cfnServiceCapacityProviderStrategyItemPropertyToCloudFormation)(properties.capacityProviderStrategy),
        Cluster: cdk.stringToCloudFormation(properties.cluster),
        DeploymentConfiguration: cfnServiceDeploymentConfigurationPropertyToCloudFormation(properties.deploymentConfiguration),
        DeploymentController: cfnServiceDeploymentControllerPropertyToCloudFormation(properties.deploymentController),
        DesiredCount: cdk.numberToCloudFormation(properties.desiredCount),
        EnableECSManagedTags: cdk.booleanToCloudFormation(properties.enableEcsManagedTags),
        EnableExecuteCommand: cdk.booleanToCloudFormation(properties.enableExecuteCommand),
        HealthCheckGracePeriodSeconds: cdk.numberToCloudFormation(properties.healthCheckGracePeriodSeconds),
        LaunchType: cdk.stringToCloudFormation(properties.launchType),
        LoadBalancers: cdk.listMapper(cfnServiceLoadBalancerPropertyToCloudFormation)(properties.loadBalancers),
        NetworkConfiguration: cfnServiceNetworkConfigurationPropertyToCloudFormation(properties.networkConfiguration),
        PlacementConstraints: cdk.listMapper(cfnServicePlacementConstraintPropertyToCloudFormation)(properties.placementConstraints),
        PlacementStrategies: cdk.listMapper(cfnServicePlacementStrategyPropertyToCloudFormation)(properties.placementStrategies),
        PlatformVersion: cdk.stringToCloudFormation(properties.platformVersion),
        PropagateTags: cdk.stringToCloudFormation(properties.propagateTags),
        Role: cdk.stringToCloudFormation(properties.role),
        SchedulingStrategy: cdk.stringToCloudFormation(properties.schedulingStrategy),
        ServiceName: cdk.stringToCloudFormation(properties.serviceName),
        ServiceRegistries: cdk.listMapper(cfnServiceServiceRegistryPropertyToCloudFormation)(properties.serviceRegistries),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TaskDefinition: cdk.stringToCloudFormation(properties.taskDefinition),
    };
}
// @ts-ignore TS6133
function CfnServicePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('capacityProviderStrategy', 'CapacityProviderStrategy', properties.CapacityProviderStrategy != null ? cfn_parse.FromCloudFormation.getArray(CfnServiceCapacityProviderStrategyItemPropertyFromCloudFormation)(properties.CapacityProviderStrategy) : undefined);
    ret.addPropertyResult('cluster', 'Cluster', properties.Cluster != null ? cfn_parse.FromCloudFormation.getString(properties.Cluster) : undefined);
    ret.addPropertyResult('deploymentConfiguration', 'DeploymentConfiguration', properties.DeploymentConfiguration != null ? CfnServiceDeploymentConfigurationPropertyFromCloudFormation(properties.DeploymentConfiguration) : undefined);
    ret.addPropertyResult('deploymentController', 'DeploymentController', properties.DeploymentController != null ? CfnServiceDeploymentControllerPropertyFromCloudFormation(properties.DeploymentController) : undefined);
    ret.addPropertyResult('desiredCount', 'DesiredCount', properties.DesiredCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.DesiredCount) : undefined);
    ret.addPropertyResult('enableEcsManagedTags', 'EnableECSManagedTags', properties.EnableECSManagedTags != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableECSManagedTags) : undefined);
    ret.addPropertyResult('enableExecuteCommand', 'EnableExecuteCommand', properties.EnableExecuteCommand != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableExecuteCommand) : undefined);
    ret.addPropertyResult('healthCheckGracePeriodSeconds', 'HealthCheckGracePeriodSeconds', properties.HealthCheckGracePeriodSeconds != null ? cfn_parse.FromCloudFormation.getNumber(properties.HealthCheckGracePeriodSeconds) : undefined);
    ret.addPropertyResult('launchType', 'LaunchType', properties.LaunchType != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchType) : undefined);
    ret.addPropertyResult('loadBalancers', 'LoadBalancers', properties.LoadBalancers != null ? cfn_parse.FromCloudFormation.getArray(CfnServiceLoadBalancerPropertyFromCloudFormation)(properties.LoadBalancers) : undefined);
    ret.addPropertyResult('networkConfiguration', 'NetworkConfiguration', properties.NetworkConfiguration != null ? CfnServiceNetworkConfigurationPropertyFromCloudFormation(properties.NetworkConfiguration) : undefined);
    ret.addPropertyResult('placementConstraints', 'PlacementConstraints', properties.PlacementConstraints != null ? cfn_parse.FromCloudFormation.getArray(CfnServicePlacementConstraintPropertyFromCloudFormation)(properties.PlacementConstraints) : undefined);
    ret.addPropertyResult('placementStrategies', 'PlacementStrategies', properties.PlacementStrategies != null ? cfn_parse.FromCloudFormation.getArray(CfnServicePlacementStrategyPropertyFromCloudFormation)(properties.PlacementStrategies) : undefined);
    ret.addPropertyResult('platformVersion', 'PlatformVersion', properties.PlatformVersion != null ? cfn_parse.FromCloudFormation.getString(properties.PlatformVersion) : undefined);
    ret.addPropertyResult('propagateTags', 'PropagateTags', properties.PropagateTags != null ? cfn_parse.FromCloudFormation.getString(properties.PropagateTags) : undefined);
    ret.addPropertyResult('role', 'Role', properties.Role != null ? cfn_parse.FromCloudFormation.getString(properties.Role) : undefined);
    ret.addPropertyResult('schedulingStrategy', 'SchedulingStrategy', properties.SchedulingStrategy != null ? cfn_parse.FromCloudFormation.getString(properties.SchedulingStrategy) : undefined);
    ret.addPropertyResult('serviceName', 'ServiceName', properties.ServiceName != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceName) : undefined);
    ret.addPropertyResult('serviceRegistries', 'ServiceRegistries', properties.ServiceRegistries != null ? cfn_parse.FromCloudFormation.getArray(CfnServiceServiceRegistryPropertyFromCloudFormation)(properties.ServiceRegistries) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('taskDefinition', 'TaskDefinition', properties.TaskDefinition != null ? cfn_parse.FromCloudFormation.getString(properties.TaskDefinition) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::Service`
 *
 * The `AWS::ECS::Service` resource creates an Amazon Elastic Container Service (Amazon ECS) service that runs and maintains the requested number of tasks and associated load balancers.
 *
 * @cloudformationResource AWS::ECS::Service
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html
 */
class CfnService extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::Service`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnService.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnServiceProps(props);
        this.attrName = cdk.Token.asString(this.getAtt('Name'));
        this.attrServiceArn = cdk.Token.asString(this.getAtt('ServiceArn'));
        this.capacityProviderStrategy = props.capacityProviderStrategy;
        this.cluster = props.cluster;
        this.deploymentConfiguration = props.deploymentConfiguration;
        this.deploymentController = props.deploymentController;
        this.desiredCount = props.desiredCount;
        this.enableEcsManagedTags = props.enableEcsManagedTags;
        this.enableExecuteCommand = props.enableExecuteCommand;
        this.healthCheckGracePeriodSeconds = props.healthCheckGracePeriodSeconds;
        this.launchType = props.launchType;
        this.loadBalancers = props.loadBalancers;
        this.networkConfiguration = props.networkConfiguration;
        this.placementConstraints = props.placementConstraints;
        this.placementStrategies = props.placementStrategies;
        this.platformVersion = props.platformVersion;
        this.propagateTags = props.propagateTags;
        this.role = props.role;
        this.schedulingStrategy = props.schedulingStrategy;
        this.serviceName = props.serviceName;
        this.serviceRegistries = props.serviceRegistries;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::ECS::Service", props.tags, { tagPropertyName: 'tags' });
        this.taskDefinition = props.taskDefinition;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnServicePropsFromCloudFormation(resourceProperties);
        const ret = new CfnService(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnService.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            capacityProviderStrategy: this.capacityProviderStrategy,
            cluster: this.cluster,
            deploymentConfiguration: this.deploymentConfiguration,
            deploymentController: this.deploymentController,
            desiredCount: this.desiredCount,
            enableEcsManagedTags: this.enableEcsManagedTags,
            enableExecuteCommand: this.enableExecuteCommand,
            healthCheckGracePeriodSeconds: this.healthCheckGracePeriodSeconds,
            launchType: this.launchType,
            loadBalancers: this.loadBalancers,
            networkConfiguration: this.networkConfiguration,
            placementConstraints: this.placementConstraints,
            placementStrategies: this.placementStrategies,
            platformVersion: this.platformVersion,
            propagateTags: this.propagateTags,
            role: this.role,
            schedulingStrategy: this.schedulingStrategy,
            serviceName: this.serviceName,
            serviceRegistries: this.serviceRegistries,
            tags: this.tags.renderTags(),
            taskDefinition: this.taskDefinition,
        };
    }
    renderProperties(props) {
        return cfnServicePropsToCloudFormation(props);
    }
}
exports.CfnService = CfnService;
_e = JSII_RTTI_SYMBOL_1;
CfnService[_e] = { fqn: "monocdk.aws_ecs.CfnService", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnService.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::Service";
/**
 * Determine whether the given properties match those of a `AwsVpcConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AwsVpcConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_AwsVpcConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('assignPublicIp', cdk.validateString)(properties.assignPublicIp));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "AwsVpcConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.AwsVpcConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AwsVpcConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.AwsVpcConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnServiceAwsVpcConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_AwsVpcConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AssignPublicIp: cdk.stringToCloudFormation(properties.assignPublicIp),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnServiceAwsVpcConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('assignPublicIp', 'AssignPublicIp', properties.AssignPublicIp != null ? cfn_parse.FromCloudFormation.getString(properties.AssignPublicIp) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CapacityProviderStrategyItemProperty`
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyItemProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_CapacityProviderStrategyItemPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('base', cdk.validateNumber)(properties.base));
    errors.collect(cdk.propertyValidator('capacityProvider', cdk.validateString)(properties.capacityProvider));
    errors.collect(cdk.propertyValidator('weight', cdk.validateNumber)(properties.weight));
    return errors.wrap('supplied properties not correct for "CapacityProviderStrategyItemProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.CapacityProviderStrategyItem` resource
 *
 * @param properties - the TypeScript properties of a `CapacityProviderStrategyItemProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.CapacityProviderStrategyItem` resource.
 */
// @ts-ignore TS6133
function cfnServiceCapacityProviderStrategyItemPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_CapacityProviderStrategyItemPropertyValidator(properties).assertSuccess();
    return {
        Base: cdk.numberToCloudFormation(properties.base),
        CapacityProvider: cdk.stringToCloudFormation(properties.capacityProvider),
        Weight: cdk.numberToCloudFormation(properties.weight),
    };
}
// @ts-ignore TS6133
function CfnServiceCapacityProviderStrategyItemPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('base', 'Base', properties.Base != null ? cfn_parse.FromCloudFormation.getNumber(properties.Base) : undefined);
    ret.addPropertyResult('capacityProvider', 'CapacityProvider', properties.CapacityProvider != null ? cfn_parse.FromCloudFormation.getString(properties.CapacityProvider) : undefined);
    ret.addPropertyResult('weight', 'Weight', properties.Weight != null ? cfn_parse.FromCloudFormation.getNumber(properties.Weight) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeploymentCircuitBreakerProperty`
 *
 * @param properties - the TypeScript properties of a `DeploymentCircuitBreakerProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_DeploymentCircuitBreakerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enable', cdk.requiredValidator)(properties.enable));
    errors.collect(cdk.propertyValidator('enable', cdk.validateBoolean)(properties.enable));
    errors.collect(cdk.propertyValidator('rollback', cdk.requiredValidator)(properties.rollback));
    errors.collect(cdk.propertyValidator('rollback', cdk.validateBoolean)(properties.rollback));
    return errors.wrap('supplied properties not correct for "DeploymentCircuitBreakerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentCircuitBreaker` resource
 *
 * @param properties - the TypeScript properties of a `DeploymentCircuitBreakerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentCircuitBreaker` resource.
 */
// @ts-ignore TS6133
function cfnServiceDeploymentCircuitBreakerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_DeploymentCircuitBreakerPropertyValidator(properties).assertSuccess();
    return {
        Enable: cdk.booleanToCloudFormation(properties.enable),
        Rollback: cdk.booleanToCloudFormation(properties.rollback),
    };
}
// @ts-ignore TS6133
function CfnServiceDeploymentCircuitBreakerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('enable', 'Enable', cfn_parse.FromCloudFormation.getBoolean(properties.Enable));
    ret.addPropertyResult('rollback', 'Rollback', cfn_parse.FromCloudFormation.getBoolean(properties.Rollback));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeploymentConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DeploymentConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_DeploymentConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deploymentCircuitBreaker', CfnService_DeploymentCircuitBreakerPropertyValidator)(properties.deploymentCircuitBreaker));
    errors.collect(cdk.propertyValidator('maximumPercent', cdk.validateNumber)(properties.maximumPercent));
    errors.collect(cdk.propertyValidator('minimumHealthyPercent', cdk.validateNumber)(properties.minimumHealthyPercent));
    return errors.wrap('supplied properties not correct for "DeploymentConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DeploymentConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnServiceDeploymentConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_DeploymentConfigurationPropertyValidator(properties).assertSuccess();
    return {
        DeploymentCircuitBreaker: cfnServiceDeploymentCircuitBreakerPropertyToCloudFormation(properties.deploymentCircuitBreaker),
        MaximumPercent: cdk.numberToCloudFormation(properties.maximumPercent),
        MinimumHealthyPercent: cdk.numberToCloudFormation(properties.minimumHealthyPercent),
    };
}
// @ts-ignore TS6133
function CfnServiceDeploymentConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deploymentCircuitBreaker', 'DeploymentCircuitBreaker', properties.DeploymentCircuitBreaker != null ? CfnServiceDeploymentCircuitBreakerPropertyFromCloudFormation(properties.DeploymentCircuitBreaker) : undefined);
    ret.addPropertyResult('maximumPercent', 'MaximumPercent', properties.MaximumPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaximumPercent) : undefined);
    ret.addPropertyResult('minimumHealthyPercent', 'MinimumHealthyPercent', properties.MinimumHealthyPercent != null ? cfn_parse.FromCloudFormation.getNumber(properties.MinimumHealthyPercent) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeploymentControllerProperty`
 *
 * @param properties - the TypeScript properties of a `DeploymentControllerProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_DeploymentControllerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "DeploymentControllerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentController` resource
 *
 * @param properties - the TypeScript properties of a `DeploymentControllerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.DeploymentController` resource.
 */
// @ts-ignore TS6133
function cfnServiceDeploymentControllerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_DeploymentControllerPropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnServiceDeploymentControllerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LoadBalancerProperty`
 *
 * @param properties - the TypeScript properties of a `LoadBalancerProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_LoadBalancerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerPort', cdk.requiredValidator)(properties.containerPort));
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.validateString)(properties.loadBalancerName));
    errors.collect(cdk.propertyValidator('targetGroupArn', cdk.validateString)(properties.targetGroupArn));
    return errors.wrap('supplied properties not correct for "LoadBalancerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.LoadBalancer` resource
 *
 * @param properties - the TypeScript properties of a `LoadBalancerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.LoadBalancer` resource.
 */
// @ts-ignore TS6133
function cfnServiceLoadBalancerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_LoadBalancerPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        LoadBalancerName: cdk.stringToCloudFormation(properties.loadBalancerName),
        TargetGroupArn: cdk.stringToCloudFormation(properties.targetGroupArn),
    };
}
// @ts-ignore TS6133
function CfnServiceLoadBalancerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('containerPort', 'ContainerPort', cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort));
    ret.addPropertyResult('loadBalancerName', 'LoadBalancerName', properties.LoadBalancerName != null ? cfn_parse.FromCloudFormation.getString(properties.LoadBalancerName) : undefined);
    ret.addPropertyResult('targetGroupArn', 'TargetGroupArn', properties.TargetGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.TargetGroupArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_NetworkConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('awsvpcConfiguration', CfnService_AwsVpcConfigurationPropertyValidator)(properties.awsvpcConfiguration));
    return errors.wrap('supplied properties not correct for "NetworkConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.NetworkConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.NetworkConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnServiceNetworkConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_NetworkConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AwsvpcConfiguration: cfnServiceAwsVpcConfigurationPropertyToCloudFormation(properties.awsvpcConfiguration),
    };
}
// @ts-ignore TS6133
function CfnServiceNetworkConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('awsvpcConfiguration', 'AwsvpcConfiguration', properties.AwsvpcConfiguration != null ? CfnServiceAwsVpcConfigurationPropertyFromCloudFormation(properties.AwsvpcConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PlacementConstraintProperty`
 *
 * @param properties - the TypeScript properties of a `PlacementConstraintProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_PlacementConstraintPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "PlacementConstraintProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.PlacementConstraint` resource
 *
 * @param properties - the TypeScript properties of a `PlacementConstraintProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.PlacementConstraint` resource.
 */
// @ts-ignore TS6133
function cfnServicePlacementConstraintPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_PlacementConstraintPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnServicePlacementConstraintPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', properties.Expression != null ? cfn_parse.FromCloudFormation.getString(properties.Expression) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PlacementStrategyProperty`
 *
 * @param properties - the TypeScript properties of a `PlacementStrategyProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_PlacementStrategyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('field', cdk.validateString)(properties.field));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "PlacementStrategyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.PlacementStrategy` resource
 *
 * @param properties - the TypeScript properties of a `PlacementStrategyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.PlacementStrategy` resource.
 */
// @ts-ignore TS6133
function cfnServicePlacementStrategyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_PlacementStrategyPropertyValidator(properties).assertSuccess();
    return {
        Field: cdk.stringToCloudFormation(properties.field),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnServicePlacementStrategyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('field', 'Field', properties.Field != null ? cfn_parse.FromCloudFormation.getString(properties.Field) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServiceRegistryProperty`
 *
 * @param properties - the TypeScript properties of a `ServiceRegistryProperty`
 *
 * @returns the result of the validation.
 */
function CfnService_ServiceRegistryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('registryArn', cdk.validateString)(properties.registryArn));
    return errors.wrap('supplied properties not correct for "ServiceRegistryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::Service.ServiceRegistry` resource
 *
 * @param properties - the TypeScript properties of a `ServiceRegistryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::Service.ServiceRegistry` resource.
 */
// @ts-ignore TS6133
function cfnServiceServiceRegistryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnService_ServiceRegistryPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        Port: cdk.numberToCloudFormation(properties.port),
        RegistryArn: cdk.stringToCloudFormation(properties.registryArn),
    };
}
// @ts-ignore TS6133
function CfnServiceServiceRegistryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('containerPort', 'ContainerPort', properties.ContainerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('registryArn', 'RegistryArn', properties.RegistryArn != null ? cfn_parse.FromCloudFormation.getString(properties.RegistryArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTaskDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnTaskDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerDefinitions', cdk.listValidator(CfnTaskDefinition_ContainerDefinitionPropertyValidator))(properties.containerDefinitions));
    errors.collect(cdk.propertyValidator('cpu', cdk.validateString)(properties.cpu));
    errors.collect(cdk.propertyValidator('ephemeralStorage', CfnTaskDefinition_EphemeralStoragePropertyValidator)(properties.ephemeralStorage));
    errors.collect(cdk.propertyValidator('executionRoleArn', cdk.validateString)(properties.executionRoleArn));
    errors.collect(cdk.propertyValidator('family', cdk.validateString)(properties.family));
    errors.collect(cdk.propertyValidator('inferenceAccelerators', cdk.listValidator(CfnTaskDefinition_InferenceAcceleratorPropertyValidator))(properties.inferenceAccelerators));
    errors.collect(cdk.propertyValidator('ipcMode', cdk.validateString)(properties.ipcMode));
    errors.collect(cdk.propertyValidator('memory', cdk.validateString)(properties.memory));
    errors.collect(cdk.propertyValidator('networkMode', cdk.validateString)(properties.networkMode));
    errors.collect(cdk.propertyValidator('pidMode', cdk.validateString)(properties.pidMode));
    errors.collect(cdk.propertyValidator('placementConstraints', cdk.listValidator(CfnTaskDefinition_TaskDefinitionPlacementConstraintPropertyValidator))(properties.placementConstraints));
    errors.collect(cdk.propertyValidator('proxyConfiguration', CfnTaskDefinition_ProxyConfigurationPropertyValidator)(properties.proxyConfiguration));
    errors.collect(cdk.propertyValidator('requiresCompatibilities', cdk.listValidator(cdk.validateString))(properties.requiresCompatibilities));
    errors.collect(cdk.propertyValidator('runtimePlatform', CfnTaskDefinition_RuntimePlatformPropertyValidator)(properties.runtimePlatform));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('taskRoleArn', cdk.validateString)(properties.taskRoleArn));
    errors.collect(cdk.propertyValidator('volumes', cdk.listValidator(CfnTaskDefinition_VolumePropertyValidator))(properties.volumes));
    return errors.wrap('supplied properties not correct for "CfnTaskDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnTaskDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinitionPropsValidator(properties).assertSuccess();
    return {
        ContainerDefinitions: cdk.listMapper(cfnTaskDefinitionContainerDefinitionPropertyToCloudFormation)(properties.containerDefinitions),
        Cpu: cdk.stringToCloudFormation(properties.cpu),
        EphemeralStorage: cfnTaskDefinitionEphemeralStoragePropertyToCloudFormation(properties.ephemeralStorage),
        ExecutionRoleArn: cdk.stringToCloudFormation(properties.executionRoleArn),
        Family: cdk.stringToCloudFormation(properties.family),
        InferenceAccelerators: cdk.listMapper(cfnTaskDefinitionInferenceAcceleratorPropertyToCloudFormation)(properties.inferenceAccelerators),
        IpcMode: cdk.stringToCloudFormation(properties.ipcMode),
        Memory: cdk.stringToCloudFormation(properties.memory),
        NetworkMode: cdk.stringToCloudFormation(properties.networkMode),
        PidMode: cdk.stringToCloudFormation(properties.pidMode),
        PlacementConstraints: cdk.listMapper(cfnTaskDefinitionTaskDefinitionPlacementConstraintPropertyToCloudFormation)(properties.placementConstraints),
        ProxyConfiguration: cfnTaskDefinitionProxyConfigurationPropertyToCloudFormation(properties.proxyConfiguration),
        RequiresCompatibilities: cdk.listMapper(cdk.stringToCloudFormation)(properties.requiresCompatibilities),
        RuntimePlatform: cfnTaskDefinitionRuntimePlatformPropertyToCloudFormation(properties.runtimePlatform),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TaskRoleArn: cdk.stringToCloudFormation(properties.taskRoleArn),
        Volumes: cdk.listMapper(cfnTaskDefinitionVolumePropertyToCloudFormation)(properties.volumes),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerDefinitions', 'ContainerDefinitions', properties.ContainerDefinitions != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionContainerDefinitionPropertyFromCloudFormation)(properties.ContainerDefinitions) : undefined);
    ret.addPropertyResult('cpu', 'Cpu', properties.Cpu != null ? cfn_parse.FromCloudFormation.getString(properties.Cpu) : undefined);
    ret.addPropertyResult('ephemeralStorage', 'EphemeralStorage', properties.EphemeralStorage != null ? CfnTaskDefinitionEphemeralStoragePropertyFromCloudFormation(properties.EphemeralStorage) : undefined);
    ret.addPropertyResult('executionRoleArn', 'ExecutionRoleArn', properties.ExecutionRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ExecutionRoleArn) : undefined);
    ret.addPropertyResult('family', 'Family', properties.Family != null ? cfn_parse.FromCloudFormation.getString(properties.Family) : undefined);
    ret.addPropertyResult('inferenceAccelerators', 'InferenceAccelerators', properties.InferenceAccelerators != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionInferenceAcceleratorPropertyFromCloudFormation)(properties.InferenceAccelerators) : undefined);
    ret.addPropertyResult('ipcMode', 'IpcMode', properties.IpcMode != null ? cfn_parse.FromCloudFormation.getString(properties.IpcMode) : undefined);
    ret.addPropertyResult('memory', 'Memory', properties.Memory != null ? cfn_parse.FromCloudFormation.getString(properties.Memory) : undefined);
    ret.addPropertyResult('networkMode', 'NetworkMode', properties.NetworkMode != null ? cfn_parse.FromCloudFormation.getString(properties.NetworkMode) : undefined);
    ret.addPropertyResult('pidMode', 'PidMode', properties.PidMode != null ? cfn_parse.FromCloudFormation.getString(properties.PidMode) : undefined);
    ret.addPropertyResult('placementConstraints', 'PlacementConstraints', properties.PlacementConstraints != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionTaskDefinitionPlacementConstraintPropertyFromCloudFormation)(properties.PlacementConstraints) : undefined);
    ret.addPropertyResult('proxyConfiguration', 'ProxyConfiguration', properties.ProxyConfiguration != null ? CfnTaskDefinitionProxyConfigurationPropertyFromCloudFormation(properties.ProxyConfiguration) : undefined);
    ret.addPropertyResult('requiresCompatibilities', 'RequiresCompatibilities', properties.RequiresCompatibilities != null ? cfn_parse.FromCloudFormation.getStringArray(properties.RequiresCompatibilities) : undefined);
    ret.addPropertyResult('runtimePlatform', 'RuntimePlatform', properties.RuntimePlatform != null ? CfnTaskDefinitionRuntimePlatformPropertyFromCloudFormation(properties.RuntimePlatform) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('taskRoleArn', 'TaskRoleArn', properties.TaskRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.TaskRoleArn) : undefined);
    ret.addPropertyResult('volumes', 'Volumes', properties.Volumes != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionVolumePropertyFromCloudFormation)(properties.Volumes) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::TaskDefinition`
 *
 * The `AWS::ECS::TaskDefinition` resource describes the container and volume definitions of an Amazon Elastic Container Service (Amazon ECS) task. You can specify which Docker images to use, the required resources, and other configurations related to launching the task definition through an Amazon ECS service or task.
 *
 * @cloudformationResource AWS::ECS::TaskDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html
 */
class CfnTaskDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::TaskDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnTaskDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnTaskDefinitionProps(props);
        this.attrTaskDefinitionArn = cdk.Token.asString(this.getAtt('TaskDefinitionArn'));
        this.containerDefinitions = props.containerDefinitions;
        this.cpu = props.cpu;
        this.ephemeralStorage = props.ephemeralStorage;
        this.executionRoleArn = props.executionRoleArn;
        this.family = props.family;
        this.inferenceAccelerators = props.inferenceAccelerators;
        this.ipcMode = props.ipcMode;
        this.memory = props.memory;
        this.networkMode = props.networkMode;
        this.pidMode = props.pidMode;
        this.placementConstraints = props.placementConstraints;
        this.proxyConfiguration = props.proxyConfiguration;
        this.requiresCompatibilities = props.requiresCompatibilities;
        this.runtimePlatform = props.runtimePlatform;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::ECS::TaskDefinition", props.tags, { tagPropertyName: 'tags' });
        this.taskRoleArn = props.taskRoleArn;
        this.volumes = props.volumes;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTaskDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTaskDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTaskDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            containerDefinitions: this.containerDefinitions,
            cpu: this.cpu,
            ephemeralStorage: this.ephemeralStorage,
            executionRoleArn: this.executionRoleArn,
            family: this.family,
            inferenceAccelerators: this.inferenceAccelerators,
            ipcMode: this.ipcMode,
            memory: this.memory,
            networkMode: this.networkMode,
            pidMode: this.pidMode,
            placementConstraints: this.placementConstraints,
            proxyConfiguration: this.proxyConfiguration,
            requiresCompatibilities: this.requiresCompatibilities,
            runtimePlatform: this.runtimePlatform,
            tags: this.tags.renderTags(),
            taskRoleArn: this.taskRoleArn,
            volumes: this.volumes,
        };
    }
    renderProperties(props) {
        return cfnTaskDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnTaskDefinition = CfnTaskDefinition;
_f = JSII_RTTI_SYMBOL_1;
CfnTaskDefinition[_f] = { fqn: "monocdk.aws_ecs.CfnTaskDefinition", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTaskDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::TaskDefinition";
/**
 * Determine whether the given properties match those of a `AuthorizationConfigProperty`
 *
 * @param properties - the TypeScript properties of a `AuthorizationConfigProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_AuthorizationConfigPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('accessPointId', cdk.validateString)(properties.accessPointId));
    errors.collect(cdk.propertyValidator('iam', cdk.validateString)(properties.iam));
    return errors.wrap('supplied properties not correct for "AuthorizationConfigProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.AuthorizationConfig` resource
 *
 * @param properties - the TypeScript properties of a `AuthorizationConfigProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.AuthorizationConfig` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionAuthorizationConfigPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_AuthorizationConfigPropertyValidator(properties).assertSuccess();
    return {
        AccessPointId: cdk.stringToCloudFormation(properties.accessPointId),
        IAM: cdk.stringToCloudFormation(properties.iam),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionAuthorizationConfigPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('accessPointId', 'AccessPointId', properties.AccessPointId != null ? cfn_parse.FromCloudFormation.getString(properties.AccessPointId) : undefined);
    ret.addPropertyResult('iam', 'IAM', properties.IAM != null ? cfn_parse.FromCloudFormation.getString(properties.IAM) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContainerDefinitionProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerDefinitionProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_ContainerDefinitionPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('command', cdk.listValidator(cdk.validateString))(properties.command));
    errors.collect(cdk.propertyValidator('cpu', cdk.validateNumber)(properties.cpu));
    errors.collect(cdk.propertyValidator('dependsOn', cdk.listValidator(CfnTaskDefinition_ContainerDependencyPropertyValidator))(properties.dependsOn));
    errors.collect(cdk.propertyValidator('disableNetworking', cdk.validateBoolean)(properties.disableNetworking));
    errors.collect(cdk.propertyValidator('dnsSearchDomains', cdk.listValidator(cdk.validateString))(properties.dnsSearchDomains));
    errors.collect(cdk.propertyValidator('dnsServers', cdk.listValidator(cdk.validateString))(properties.dnsServers));
    errors.collect(cdk.propertyValidator('dockerLabels', cdk.hashValidator(cdk.validateString))(properties.dockerLabels));
    errors.collect(cdk.propertyValidator('dockerSecurityOptions', cdk.listValidator(cdk.validateString))(properties.dockerSecurityOptions));
    errors.collect(cdk.propertyValidator('entryPoint', cdk.listValidator(cdk.validateString))(properties.entryPoint));
    errors.collect(cdk.propertyValidator('environment', cdk.listValidator(CfnTaskDefinition_KeyValuePairPropertyValidator))(properties.environment));
    errors.collect(cdk.propertyValidator('environmentFiles', cdk.listValidator(CfnTaskDefinition_EnvironmentFilePropertyValidator))(properties.environmentFiles));
    errors.collect(cdk.propertyValidator('essential', cdk.validateBoolean)(properties.essential));
    errors.collect(cdk.propertyValidator('extraHosts', cdk.listValidator(CfnTaskDefinition_HostEntryPropertyValidator))(properties.extraHosts));
    errors.collect(cdk.propertyValidator('firelensConfiguration', CfnTaskDefinition_FirelensConfigurationPropertyValidator)(properties.firelensConfiguration));
    errors.collect(cdk.propertyValidator('healthCheck', CfnTaskDefinition_HealthCheckPropertyValidator)(properties.healthCheck));
    errors.collect(cdk.propertyValidator('hostname', cdk.validateString)(properties.hostname));
    errors.collect(cdk.propertyValidator('image', cdk.validateString)(properties.image));
    errors.collect(cdk.propertyValidator('interactive', cdk.validateBoolean)(properties.interactive));
    errors.collect(cdk.propertyValidator('links', cdk.listValidator(cdk.validateString))(properties.links));
    errors.collect(cdk.propertyValidator('linuxParameters', CfnTaskDefinition_LinuxParametersPropertyValidator)(properties.linuxParameters));
    errors.collect(cdk.propertyValidator('logConfiguration', CfnTaskDefinition_LogConfigurationPropertyValidator)(properties.logConfiguration));
    errors.collect(cdk.propertyValidator('memory', cdk.validateNumber)(properties.memory));
    errors.collect(cdk.propertyValidator('memoryReservation', cdk.validateNumber)(properties.memoryReservation));
    errors.collect(cdk.propertyValidator('mountPoints', cdk.listValidator(CfnTaskDefinition_MountPointPropertyValidator))(properties.mountPoints));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('portMappings', cdk.listValidator(CfnTaskDefinition_PortMappingPropertyValidator))(properties.portMappings));
    errors.collect(cdk.propertyValidator('privileged', cdk.validateBoolean)(properties.privileged));
    errors.collect(cdk.propertyValidator('pseudoTerminal', cdk.validateBoolean)(properties.pseudoTerminal));
    errors.collect(cdk.propertyValidator('readonlyRootFilesystem', cdk.validateBoolean)(properties.readonlyRootFilesystem));
    errors.collect(cdk.propertyValidator('repositoryCredentials', CfnTaskDefinition_RepositoryCredentialsPropertyValidator)(properties.repositoryCredentials));
    errors.collect(cdk.propertyValidator('resourceRequirements', cdk.listValidator(CfnTaskDefinition_ResourceRequirementPropertyValidator))(properties.resourceRequirements));
    errors.collect(cdk.propertyValidator('secrets', cdk.listValidator(CfnTaskDefinition_SecretPropertyValidator))(properties.secrets));
    errors.collect(cdk.propertyValidator('startTimeout', cdk.validateNumber)(properties.startTimeout));
    errors.collect(cdk.propertyValidator('stopTimeout', cdk.validateNumber)(properties.stopTimeout));
    errors.collect(cdk.propertyValidator('systemControls', cdk.listValidator(CfnTaskDefinition_SystemControlPropertyValidator))(properties.systemControls));
    errors.collect(cdk.propertyValidator('ulimits', cdk.listValidator(CfnTaskDefinition_UlimitPropertyValidator))(properties.ulimits));
    errors.collect(cdk.propertyValidator('user', cdk.validateString)(properties.user));
    errors.collect(cdk.propertyValidator('volumesFrom', cdk.listValidator(CfnTaskDefinition_VolumeFromPropertyValidator))(properties.volumesFrom));
    errors.collect(cdk.propertyValidator('workingDirectory', cdk.validateString)(properties.workingDirectory));
    return errors.wrap('supplied properties not correct for "ContainerDefinitionProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ContainerDefinition` resource
 *
 * @param properties - the TypeScript properties of a `ContainerDefinitionProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ContainerDefinition` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionContainerDefinitionPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_ContainerDefinitionPropertyValidator(properties).assertSuccess();
    return {
        Command: cdk.listMapper(cdk.stringToCloudFormation)(properties.command),
        Cpu: cdk.numberToCloudFormation(properties.cpu),
        DependsOn: cdk.listMapper(cfnTaskDefinitionContainerDependencyPropertyToCloudFormation)(properties.dependsOn),
        DisableNetworking: cdk.booleanToCloudFormation(properties.disableNetworking),
        DnsSearchDomains: cdk.listMapper(cdk.stringToCloudFormation)(properties.dnsSearchDomains),
        DnsServers: cdk.listMapper(cdk.stringToCloudFormation)(properties.dnsServers),
        DockerLabels: cdk.hashMapper(cdk.stringToCloudFormation)(properties.dockerLabels),
        DockerSecurityOptions: cdk.listMapper(cdk.stringToCloudFormation)(properties.dockerSecurityOptions),
        EntryPoint: cdk.listMapper(cdk.stringToCloudFormation)(properties.entryPoint),
        Environment: cdk.listMapper(cfnTaskDefinitionKeyValuePairPropertyToCloudFormation)(properties.environment),
        EnvironmentFiles: cdk.listMapper(cfnTaskDefinitionEnvironmentFilePropertyToCloudFormation)(properties.environmentFiles),
        Essential: cdk.booleanToCloudFormation(properties.essential),
        ExtraHosts: cdk.listMapper(cfnTaskDefinitionHostEntryPropertyToCloudFormation)(properties.extraHosts),
        FirelensConfiguration: cfnTaskDefinitionFirelensConfigurationPropertyToCloudFormation(properties.firelensConfiguration),
        HealthCheck: cfnTaskDefinitionHealthCheckPropertyToCloudFormation(properties.healthCheck),
        Hostname: cdk.stringToCloudFormation(properties.hostname),
        Image: cdk.stringToCloudFormation(properties.image),
        Interactive: cdk.booleanToCloudFormation(properties.interactive),
        Links: cdk.listMapper(cdk.stringToCloudFormation)(properties.links),
        LinuxParameters: cfnTaskDefinitionLinuxParametersPropertyToCloudFormation(properties.linuxParameters),
        LogConfiguration: cfnTaskDefinitionLogConfigurationPropertyToCloudFormation(properties.logConfiguration),
        Memory: cdk.numberToCloudFormation(properties.memory),
        MemoryReservation: cdk.numberToCloudFormation(properties.memoryReservation),
        MountPoints: cdk.listMapper(cfnTaskDefinitionMountPointPropertyToCloudFormation)(properties.mountPoints),
        Name: cdk.stringToCloudFormation(properties.name),
        PortMappings: cdk.listMapper(cfnTaskDefinitionPortMappingPropertyToCloudFormation)(properties.portMappings),
        Privileged: cdk.booleanToCloudFormation(properties.privileged),
        PseudoTerminal: cdk.booleanToCloudFormation(properties.pseudoTerminal),
        ReadonlyRootFilesystem: cdk.booleanToCloudFormation(properties.readonlyRootFilesystem),
        RepositoryCredentials: cfnTaskDefinitionRepositoryCredentialsPropertyToCloudFormation(properties.repositoryCredentials),
        ResourceRequirements: cdk.listMapper(cfnTaskDefinitionResourceRequirementPropertyToCloudFormation)(properties.resourceRequirements),
        Secrets: cdk.listMapper(cfnTaskDefinitionSecretPropertyToCloudFormation)(properties.secrets),
        StartTimeout: cdk.numberToCloudFormation(properties.startTimeout),
        StopTimeout: cdk.numberToCloudFormation(properties.stopTimeout),
        SystemControls: cdk.listMapper(cfnTaskDefinitionSystemControlPropertyToCloudFormation)(properties.systemControls),
        Ulimits: cdk.listMapper(cfnTaskDefinitionUlimitPropertyToCloudFormation)(properties.ulimits),
        User: cdk.stringToCloudFormation(properties.user),
        VolumesFrom: cdk.listMapper(cfnTaskDefinitionVolumeFromPropertyToCloudFormation)(properties.volumesFrom),
        WorkingDirectory: cdk.stringToCloudFormation(properties.workingDirectory),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionContainerDefinitionPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('command', 'Command', properties.Command != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Command) : undefined);
    ret.addPropertyResult('cpu', 'Cpu', properties.Cpu != null ? cfn_parse.FromCloudFormation.getNumber(properties.Cpu) : undefined);
    ret.addPropertyResult('dependsOn', 'DependsOn', properties.DependsOn != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionContainerDependencyPropertyFromCloudFormation)(properties.DependsOn) : undefined);
    ret.addPropertyResult('disableNetworking', 'DisableNetworking', properties.DisableNetworking != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DisableNetworking) : undefined);
    ret.addPropertyResult('dnsSearchDomains', 'DnsSearchDomains', properties.DnsSearchDomains != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DnsSearchDomains) : undefined);
    ret.addPropertyResult('dnsServers', 'DnsServers', properties.DnsServers != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DnsServers) : undefined);
    ret.addPropertyResult('dockerLabels', 'DockerLabels', properties.DockerLabels != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.DockerLabels) : undefined);
    ret.addPropertyResult('dockerSecurityOptions', 'DockerSecurityOptions', properties.DockerSecurityOptions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.DockerSecurityOptions) : undefined);
    ret.addPropertyResult('entryPoint', 'EntryPoint', properties.EntryPoint != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EntryPoint) : undefined);
    ret.addPropertyResult('environment', 'Environment', properties.Environment != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionKeyValuePairPropertyFromCloudFormation)(properties.Environment) : undefined);
    ret.addPropertyResult('environmentFiles', 'EnvironmentFiles', properties.EnvironmentFiles != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionEnvironmentFilePropertyFromCloudFormation)(properties.EnvironmentFiles) : undefined);
    ret.addPropertyResult('essential', 'Essential', properties.Essential != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Essential) : undefined);
    ret.addPropertyResult('extraHosts', 'ExtraHosts', properties.ExtraHosts != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionHostEntryPropertyFromCloudFormation)(properties.ExtraHosts) : undefined);
    ret.addPropertyResult('firelensConfiguration', 'FirelensConfiguration', properties.FirelensConfiguration != null ? CfnTaskDefinitionFirelensConfigurationPropertyFromCloudFormation(properties.FirelensConfiguration) : undefined);
    ret.addPropertyResult('healthCheck', 'HealthCheck', properties.HealthCheck != null ? CfnTaskDefinitionHealthCheckPropertyFromCloudFormation(properties.HealthCheck) : undefined);
    ret.addPropertyResult('hostname', 'Hostname', properties.Hostname != null ? cfn_parse.FromCloudFormation.getString(properties.Hostname) : undefined);
    ret.addPropertyResult('image', 'Image', properties.Image != null ? cfn_parse.FromCloudFormation.getString(properties.Image) : undefined);
    ret.addPropertyResult('interactive', 'Interactive', properties.Interactive != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Interactive) : undefined);
    ret.addPropertyResult('links', 'Links', properties.Links != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Links) : undefined);
    ret.addPropertyResult('linuxParameters', 'LinuxParameters', properties.LinuxParameters != null ? CfnTaskDefinitionLinuxParametersPropertyFromCloudFormation(properties.LinuxParameters) : undefined);
    ret.addPropertyResult('logConfiguration', 'LogConfiguration', properties.LogConfiguration != null ? CfnTaskDefinitionLogConfigurationPropertyFromCloudFormation(properties.LogConfiguration) : undefined);
    ret.addPropertyResult('memory', 'Memory', properties.Memory != null ? cfn_parse.FromCloudFormation.getNumber(properties.Memory) : undefined);
    ret.addPropertyResult('memoryReservation', 'MemoryReservation', properties.MemoryReservation != null ? cfn_parse.FromCloudFormation.getNumber(properties.MemoryReservation) : undefined);
    ret.addPropertyResult('mountPoints', 'MountPoints', properties.MountPoints != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionMountPointPropertyFromCloudFormation)(properties.MountPoints) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('portMappings', 'PortMappings', properties.PortMappings != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionPortMappingPropertyFromCloudFormation)(properties.PortMappings) : undefined);
    ret.addPropertyResult('privileged', 'Privileged', properties.Privileged != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Privileged) : undefined);
    ret.addPropertyResult('pseudoTerminal', 'PseudoTerminal', properties.PseudoTerminal != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PseudoTerminal) : undefined);
    ret.addPropertyResult('readonlyRootFilesystem', 'ReadonlyRootFilesystem', properties.ReadonlyRootFilesystem != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadonlyRootFilesystem) : undefined);
    ret.addPropertyResult('repositoryCredentials', 'RepositoryCredentials', properties.RepositoryCredentials != null ? CfnTaskDefinitionRepositoryCredentialsPropertyFromCloudFormation(properties.RepositoryCredentials) : undefined);
    ret.addPropertyResult('resourceRequirements', 'ResourceRequirements', properties.ResourceRequirements != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionResourceRequirementPropertyFromCloudFormation)(properties.ResourceRequirements) : undefined);
    ret.addPropertyResult('secrets', 'Secrets', properties.Secrets != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionSecretPropertyFromCloudFormation)(properties.Secrets) : undefined);
    ret.addPropertyResult('startTimeout', 'StartTimeout', properties.StartTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.StartTimeout) : undefined);
    ret.addPropertyResult('stopTimeout', 'StopTimeout', properties.StopTimeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.StopTimeout) : undefined);
    ret.addPropertyResult('systemControls', 'SystemControls', properties.SystemControls != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionSystemControlPropertyFromCloudFormation)(properties.SystemControls) : undefined);
    ret.addPropertyResult('ulimits', 'Ulimits', properties.Ulimits != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionUlimitPropertyFromCloudFormation)(properties.Ulimits) : undefined);
    ret.addPropertyResult('user', 'User', properties.User != null ? cfn_parse.FromCloudFormation.getString(properties.User) : undefined);
    ret.addPropertyResult('volumesFrom', 'VolumesFrom', properties.VolumesFrom != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionVolumeFromPropertyFromCloudFormation)(properties.VolumesFrom) : undefined);
    ret.addPropertyResult('workingDirectory', 'WorkingDirectory', properties.WorkingDirectory != null ? cfn_parse.FromCloudFormation.getString(properties.WorkingDirectory) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ContainerDependencyProperty`
 *
 * @param properties - the TypeScript properties of a `ContainerDependencyProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_ContainerDependencyPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('condition', cdk.validateString)(properties.condition));
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    return errors.wrap('supplied properties not correct for "ContainerDependencyProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ContainerDependency` resource
 *
 * @param properties - the TypeScript properties of a `ContainerDependencyProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ContainerDependency` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionContainerDependencyPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_ContainerDependencyPropertyValidator(properties).assertSuccess();
    return {
        Condition: cdk.stringToCloudFormation(properties.condition),
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionContainerDependencyPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('condition', 'Condition', properties.Condition != null ? cfn_parse.FromCloudFormation.getString(properties.Condition) : undefined);
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DeviceProperty`
 *
 * @param properties - the TypeScript properties of a `DeviceProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_DevicePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerPath', cdk.validateString)(properties.containerPath));
    errors.collect(cdk.propertyValidator('hostPath', cdk.validateString)(properties.hostPath));
    errors.collect(cdk.propertyValidator('permissions', cdk.listValidator(cdk.validateString))(properties.permissions));
    return errors.wrap('supplied properties not correct for "DeviceProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Device` resource
 *
 * @param properties - the TypeScript properties of a `DeviceProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Device` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionDevicePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_DevicePropertyValidator(properties).assertSuccess();
    return {
        ContainerPath: cdk.stringToCloudFormation(properties.containerPath),
        HostPath: cdk.stringToCloudFormation(properties.hostPath),
        Permissions: cdk.listMapper(cdk.stringToCloudFormation)(properties.permissions),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionDevicePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerPath', 'ContainerPath', properties.ContainerPath != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerPath) : undefined);
    ret.addPropertyResult('hostPath', 'HostPath', properties.HostPath != null ? cfn_parse.FromCloudFormation.getString(properties.HostPath) : undefined);
    ret.addPropertyResult('permissions', 'Permissions', properties.Permissions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Permissions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DockerVolumeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `DockerVolumeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_DockerVolumeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('autoprovision', cdk.validateBoolean)(properties.autoprovision));
    errors.collect(cdk.propertyValidator('driver', cdk.validateString)(properties.driver));
    errors.collect(cdk.propertyValidator('driverOpts', cdk.hashValidator(cdk.validateString))(properties.driverOpts));
    errors.collect(cdk.propertyValidator('labels', cdk.hashValidator(cdk.validateString))(properties.labels));
    errors.collect(cdk.propertyValidator('scope', cdk.validateString)(properties.scope));
    return errors.wrap('supplied properties not correct for "DockerVolumeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.DockerVolumeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `DockerVolumeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.DockerVolumeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionDockerVolumeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_DockerVolumeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Autoprovision: cdk.booleanToCloudFormation(properties.autoprovision),
        Driver: cdk.stringToCloudFormation(properties.driver),
        DriverOpts: cdk.hashMapper(cdk.stringToCloudFormation)(properties.driverOpts),
        Labels: cdk.hashMapper(cdk.stringToCloudFormation)(properties.labels),
        Scope: cdk.stringToCloudFormation(properties.scope),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionDockerVolumeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('autoprovision', 'Autoprovision', properties.Autoprovision != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Autoprovision) : undefined);
    ret.addPropertyResult('driver', 'Driver', properties.Driver != null ? cfn_parse.FromCloudFormation.getString(properties.Driver) : undefined);
    ret.addPropertyResult('driverOpts', 'DriverOpts', properties.DriverOpts != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.DriverOpts) : undefined);
    ret.addPropertyResult('labels', 'Labels', properties.Labels != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Labels) : undefined);
    ret.addPropertyResult('scope', 'Scope', properties.Scope != null ? cfn_parse.FromCloudFormation.getString(properties.Scope) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EfsVolumeConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `EfsVolumeConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_EfsVolumeConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authorizationConfig', CfnTaskDefinition_AuthorizationConfigPropertyValidator)(properties.authorizationConfig));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.requiredValidator)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('fileSystemId', cdk.validateString)(properties.fileSystemId));
    errors.collect(cdk.propertyValidator('rootDirectory', cdk.validateString)(properties.rootDirectory));
    errors.collect(cdk.propertyValidator('transitEncryption', cdk.validateString)(properties.transitEncryption));
    errors.collect(cdk.propertyValidator('transitEncryptionPort', cdk.validateNumber)(properties.transitEncryptionPort));
    return errors.wrap('supplied properties not correct for "EfsVolumeConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EfsVolumeConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `EfsVolumeConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EfsVolumeConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionEfsVolumeConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_EfsVolumeConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AuthorizationConfig: cfnTaskDefinitionAuthorizationConfigPropertyToCloudFormation(properties.authorizationConfig),
        FileSystemId: cdk.stringToCloudFormation(properties.fileSystemId),
        RootDirectory: cdk.stringToCloudFormation(properties.rootDirectory),
        TransitEncryption: cdk.stringToCloudFormation(properties.transitEncryption),
        TransitEncryptionPort: cdk.numberToCloudFormation(properties.transitEncryptionPort),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionEfsVolumeConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authorizationConfig', 'AuthorizationConfig', properties.AuthorizationConfig != null ? CfnTaskDefinitionAuthorizationConfigPropertyFromCloudFormation(properties.AuthorizationConfig) : undefined);
    ret.addPropertyResult('fileSystemId', 'FileSystemId', cfn_parse.FromCloudFormation.getString(properties.FileSystemId));
    ret.addPropertyResult('rootDirectory', 'RootDirectory', properties.RootDirectory != null ? cfn_parse.FromCloudFormation.getString(properties.RootDirectory) : undefined);
    ret.addPropertyResult('transitEncryption', 'TransitEncryption', properties.TransitEncryption != null ? cfn_parse.FromCloudFormation.getString(properties.TransitEncryption) : undefined);
    ret.addPropertyResult('transitEncryptionPort', 'TransitEncryptionPort', properties.TransitEncryptionPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.TransitEncryptionPort) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EnvironmentFileProperty`
 *
 * @param properties - the TypeScript properties of a `EnvironmentFileProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_EnvironmentFilePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "EnvironmentFileProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EnvironmentFile` resource
 *
 * @param properties - the TypeScript properties of a `EnvironmentFileProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EnvironmentFile` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionEnvironmentFilePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_EnvironmentFilePropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionEnvironmentFilePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `EphemeralStorageProperty`
 *
 * @param properties - the TypeScript properties of a `EphemeralStorageProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_EphemeralStoragePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sizeInGiB', cdk.validateNumber)(properties.sizeInGiB));
    return errors.wrap('supplied properties not correct for "EphemeralStorageProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EphemeralStorage` resource
 *
 * @param properties - the TypeScript properties of a `EphemeralStorageProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.EphemeralStorage` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionEphemeralStoragePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_EphemeralStoragePropertyValidator(properties).assertSuccess();
    return {
        SizeInGiB: cdk.numberToCloudFormation(properties.sizeInGiB),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionEphemeralStoragePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sizeInGiB', 'SizeInGiB', properties.SizeInGiB != null ? cfn_parse.FromCloudFormation.getNumber(properties.SizeInGiB) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `FirelensConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `FirelensConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_FirelensConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('options', cdk.hashValidator(cdk.validateString))(properties.options));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "FirelensConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.FirelensConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `FirelensConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.FirelensConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionFirelensConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_FirelensConfigurationPropertyValidator(properties).assertSuccess();
    return {
        Options: cdk.hashMapper(cdk.stringToCloudFormation)(properties.options),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionFirelensConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('options', 'Options', properties.Options != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Options) : undefined);
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HealthCheckProperty`
 *
 * @param properties - the TypeScript properties of a `HealthCheckProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_HealthCheckPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('command', cdk.listValidator(cdk.validateString))(properties.command));
    errors.collect(cdk.propertyValidator('interval', cdk.validateNumber)(properties.interval));
    errors.collect(cdk.propertyValidator('retries', cdk.validateNumber)(properties.retries));
    errors.collect(cdk.propertyValidator('startPeriod', cdk.validateNumber)(properties.startPeriod));
    errors.collect(cdk.propertyValidator('timeout', cdk.validateNumber)(properties.timeout));
    return errors.wrap('supplied properties not correct for "HealthCheckProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HealthCheck` resource
 *
 * @param properties - the TypeScript properties of a `HealthCheckProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HealthCheck` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionHealthCheckPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_HealthCheckPropertyValidator(properties).assertSuccess();
    return {
        Command: cdk.listMapper(cdk.stringToCloudFormation)(properties.command),
        Interval: cdk.numberToCloudFormation(properties.interval),
        Retries: cdk.numberToCloudFormation(properties.retries),
        StartPeriod: cdk.numberToCloudFormation(properties.startPeriod),
        Timeout: cdk.numberToCloudFormation(properties.timeout),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionHealthCheckPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('command', 'Command', properties.Command != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Command) : undefined);
    ret.addPropertyResult('interval', 'Interval', properties.Interval != null ? cfn_parse.FromCloudFormation.getNumber(properties.Interval) : undefined);
    ret.addPropertyResult('retries', 'Retries', properties.Retries != null ? cfn_parse.FromCloudFormation.getNumber(properties.Retries) : undefined);
    ret.addPropertyResult('startPeriod', 'StartPeriod', properties.StartPeriod != null ? cfn_parse.FromCloudFormation.getNumber(properties.StartPeriod) : undefined);
    ret.addPropertyResult('timeout', 'Timeout', properties.Timeout != null ? cfn_parse.FromCloudFormation.getNumber(properties.Timeout) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HostEntryProperty`
 *
 * @param properties - the TypeScript properties of a `HostEntryProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_HostEntryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hostname', cdk.validateString)(properties.hostname));
    errors.collect(cdk.propertyValidator('ipAddress', cdk.validateString)(properties.ipAddress));
    return errors.wrap('supplied properties not correct for "HostEntryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HostEntry` resource
 *
 * @param properties - the TypeScript properties of a `HostEntryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HostEntry` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionHostEntryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_HostEntryPropertyValidator(properties).assertSuccess();
    return {
        Hostname: cdk.stringToCloudFormation(properties.hostname),
        IpAddress: cdk.stringToCloudFormation(properties.ipAddress),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionHostEntryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hostname', 'Hostname', properties.Hostname != null ? cfn_parse.FromCloudFormation.getString(properties.Hostname) : undefined);
    ret.addPropertyResult('ipAddress', 'IpAddress', properties.IpAddress != null ? cfn_parse.FromCloudFormation.getString(properties.IpAddress) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `HostVolumePropertiesProperty`
 *
 * @param properties - the TypeScript properties of a `HostVolumePropertiesProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_HostVolumePropertiesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('sourcePath', cdk.validateString)(properties.sourcePath));
    return errors.wrap('supplied properties not correct for "HostVolumePropertiesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HostVolumeProperties` resource
 *
 * @param properties - the TypeScript properties of a `HostVolumePropertiesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.HostVolumeProperties` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionHostVolumePropertiesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_HostVolumePropertiesPropertyValidator(properties).assertSuccess();
    return {
        SourcePath: cdk.stringToCloudFormation(properties.sourcePath),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionHostVolumePropertiesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('sourcePath', 'SourcePath', properties.SourcePath != null ? cfn_parse.FromCloudFormation.getString(properties.SourcePath) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `InferenceAcceleratorProperty`
 *
 * @param properties - the TypeScript properties of a `InferenceAcceleratorProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_InferenceAcceleratorPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('deviceName', cdk.validateString)(properties.deviceName));
    errors.collect(cdk.propertyValidator('deviceType', cdk.validateString)(properties.deviceType));
    return errors.wrap('supplied properties not correct for "InferenceAcceleratorProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.InferenceAccelerator` resource
 *
 * @param properties - the TypeScript properties of a `InferenceAcceleratorProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.InferenceAccelerator` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionInferenceAcceleratorPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_InferenceAcceleratorPropertyValidator(properties).assertSuccess();
    return {
        DeviceName: cdk.stringToCloudFormation(properties.deviceName),
        DeviceType: cdk.stringToCloudFormation(properties.deviceType),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionInferenceAcceleratorPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('deviceName', 'DeviceName', properties.DeviceName != null ? cfn_parse.FromCloudFormation.getString(properties.DeviceName) : undefined);
    ret.addPropertyResult('deviceType', 'DeviceType', properties.DeviceType != null ? cfn_parse.FromCloudFormation.getString(properties.DeviceType) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KernelCapabilitiesProperty`
 *
 * @param properties - the TypeScript properties of a `KernelCapabilitiesProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_KernelCapabilitiesPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('add', cdk.listValidator(cdk.validateString))(properties.add));
    errors.collect(cdk.propertyValidator('drop', cdk.listValidator(cdk.validateString))(properties.drop));
    return errors.wrap('supplied properties not correct for "KernelCapabilitiesProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.KernelCapabilities` resource
 *
 * @param properties - the TypeScript properties of a `KernelCapabilitiesProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.KernelCapabilities` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionKernelCapabilitiesPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_KernelCapabilitiesPropertyValidator(properties).assertSuccess();
    return {
        Add: cdk.listMapper(cdk.stringToCloudFormation)(properties.add),
        Drop: cdk.listMapper(cdk.stringToCloudFormation)(properties.drop),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionKernelCapabilitiesPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('add', 'Add', properties.Add != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Add) : undefined);
    ret.addPropertyResult('drop', 'Drop', properties.Drop != null ? cfn_parse.FromCloudFormation.getStringArray(properties.Drop) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KeyValuePairProperty`
 *
 * @param properties - the TypeScript properties of a `KeyValuePairProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_KeyValuePairPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "KeyValuePairProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.KeyValuePair` resource
 *
 * @param properties - the TypeScript properties of a `KeyValuePairProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.KeyValuePair` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionKeyValuePairPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_KeyValuePairPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionKeyValuePairPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LinuxParametersProperty`
 *
 * @param properties - the TypeScript properties of a `LinuxParametersProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_LinuxParametersPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('capabilities', CfnTaskDefinition_KernelCapabilitiesPropertyValidator)(properties.capabilities));
    errors.collect(cdk.propertyValidator('devices', cdk.listValidator(CfnTaskDefinition_DevicePropertyValidator))(properties.devices));
    errors.collect(cdk.propertyValidator('initProcessEnabled', cdk.validateBoolean)(properties.initProcessEnabled));
    errors.collect(cdk.propertyValidator('maxSwap', cdk.validateNumber)(properties.maxSwap));
    errors.collect(cdk.propertyValidator('sharedMemorySize', cdk.validateNumber)(properties.sharedMemorySize));
    errors.collect(cdk.propertyValidator('swappiness', cdk.validateNumber)(properties.swappiness));
    errors.collect(cdk.propertyValidator('tmpfs', cdk.listValidator(CfnTaskDefinition_TmpfsPropertyValidator))(properties.tmpfs));
    return errors.wrap('supplied properties not correct for "LinuxParametersProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.LinuxParameters` resource
 *
 * @param properties - the TypeScript properties of a `LinuxParametersProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.LinuxParameters` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionLinuxParametersPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_LinuxParametersPropertyValidator(properties).assertSuccess();
    return {
        Capabilities: cfnTaskDefinitionKernelCapabilitiesPropertyToCloudFormation(properties.capabilities),
        Devices: cdk.listMapper(cfnTaskDefinitionDevicePropertyToCloudFormation)(properties.devices),
        InitProcessEnabled: cdk.booleanToCloudFormation(properties.initProcessEnabled),
        MaxSwap: cdk.numberToCloudFormation(properties.maxSwap),
        SharedMemorySize: cdk.numberToCloudFormation(properties.sharedMemorySize),
        Swappiness: cdk.numberToCloudFormation(properties.swappiness),
        Tmpfs: cdk.listMapper(cfnTaskDefinitionTmpfsPropertyToCloudFormation)(properties.tmpfs),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionLinuxParametersPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('capabilities', 'Capabilities', properties.Capabilities != null ? CfnTaskDefinitionKernelCapabilitiesPropertyFromCloudFormation(properties.Capabilities) : undefined);
    ret.addPropertyResult('devices', 'Devices', properties.Devices != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionDevicePropertyFromCloudFormation)(properties.Devices) : undefined);
    ret.addPropertyResult('initProcessEnabled', 'InitProcessEnabled', properties.InitProcessEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.InitProcessEnabled) : undefined);
    ret.addPropertyResult('maxSwap', 'MaxSwap', properties.MaxSwap != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxSwap) : undefined);
    ret.addPropertyResult('sharedMemorySize', 'SharedMemorySize', properties.SharedMemorySize != null ? cfn_parse.FromCloudFormation.getNumber(properties.SharedMemorySize) : undefined);
    ret.addPropertyResult('swappiness', 'Swappiness', properties.Swappiness != null ? cfn_parse.FromCloudFormation.getNumber(properties.Swappiness) : undefined);
    ret.addPropertyResult('tmpfs', 'Tmpfs', properties.Tmpfs != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionTmpfsPropertyFromCloudFormation)(properties.Tmpfs) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LogConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_LogConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('logDriver', cdk.requiredValidator)(properties.logDriver));
    errors.collect(cdk.propertyValidator('logDriver', cdk.validateString)(properties.logDriver));
    errors.collect(cdk.propertyValidator('options', cdk.hashValidator(cdk.validateString))(properties.options));
    errors.collect(cdk.propertyValidator('secretOptions', cdk.listValidator(CfnTaskDefinition_SecretPropertyValidator))(properties.secretOptions));
    return errors.wrap('supplied properties not correct for "LogConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.LogConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `LogConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.LogConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionLogConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_LogConfigurationPropertyValidator(properties).assertSuccess();
    return {
        LogDriver: cdk.stringToCloudFormation(properties.logDriver),
        Options: cdk.hashMapper(cdk.stringToCloudFormation)(properties.options),
        SecretOptions: cdk.listMapper(cfnTaskDefinitionSecretPropertyToCloudFormation)(properties.secretOptions),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionLogConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('logDriver', 'LogDriver', cfn_parse.FromCloudFormation.getString(properties.LogDriver));
    ret.addPropertyResult('options', 'Options', properties.Options != null ? cfn_parse.FromCloudFormation.getMap(cfn_parse.FromCloudFormation.getString)(properties.Options) : undefined);
    ret.addPropertyResult('secretOptions', 'SecretOptions', properties.SecretOptions != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionSecretPropertyFromCloudFormation)(properties.SecretOptions) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MountPointProperty`
 *
 * @param properties - the TypeScript properties of a `MountPointProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_MountPointPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerPath', cdk.validateString)(properties.containerPath));
    errors.collect(cdk.propertyValidator('readOnly', cdk.validateBoolean)(properties.readOnly));
    errors.collect(cdk.propertyValidator('sourceVolume', cdk.validateString)(properties.sourceVolume));
    return errors.wrap('supplied properties not correct for "MountPointProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.MountPoint` resource
 *
 * @param properties - the TypeScript properties of a `MountPointProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.MountPoint` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionMountPointPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_MountPointPropertyValidator(properties).assertSuccess();
    return {
        ContainerPath: cdk.stringToCloudFormation(properties.containerPath),
        ReadOnly: cdk.booleanToCloudFormation(properties.readOnly),
        SourceVolume: cdk.stringToCloudFormation(properties.sourceVolume),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionMountPointPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerPath', 'ContainerPath', properties.ContainerPath != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerPath) : undefined);
    ret.addPropertyResult('readOnly', 'ReadOnly', properties.ReadOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadOnly) : undefined);
    ret.addPropertyResult('sourceVolume', 'SourceVolume', properties.SourceVolume != null ? cfn_parse.FromCloudFormation.getString(properties.SourceVolume) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PortMappingProperty`
 *
 * @param properties - the TypeScript properties of a `PortMappingProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_PortMappingPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('hostPort', cdk.validateNumber)(properties.hostPort));
    errors.collect(cdk.propertyValidator('protocol', cdk.validateString)(properties.protocol));
    return errors.wrap('supplied properties not correct for "PortMappingProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.PortMapping` resource
 *
 * @param properties - the TypeScript properties of a `PortMappingProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.PortMapping` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionPortMappingPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_PortMappingPropertyValidator(properties).assertSuccess();
    return {
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        HostPort: cdk.numberToCloudFormation(properties.hostPort),
        Protocol: cdk.stringToCloudFormation(properties.protocol),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionPortMappingPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerPort', 'ContainerPort', properties.ContainerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort) : undefined);
    ret.addPropertyResult('hostPort', 'HostPort', properties.HostPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.HostPort) : undefined);
    ret.addPropertyResult('protocol', 'Protocol', properties.Protocol != null ? cfn_parse.FromCloudFormation.getString(properties.Protocol) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ProxyConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `ProxyConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_ProxyConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.requiredValidator)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('proxyConfigurationProperties', cdk.listValidator(CfnTaskDefinition_KeyValuePairPropertyValidator))(properties.proxyConfigurationProperties));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "ProxyConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ProxyConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `ProxyConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ProxyConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionProxyConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_ProxyConfigurationPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ProxyConfigurationProperties: cdk.listMapper(cfnTaskDefinitionKeyValuePairPropertyToCloudFormation)(properties.proxyConfigurationProperties),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionProxyConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', cfn_parse.FromCloudFormation.getString(properties.ContainerName));
    ret.addPropertyResult('proxyConfigurationProperties', 'ProxyConfigurationProperties', properties.ProxyConfigurationProperties != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskDefinitionKeyValuePairPropertyFromCloudFormation)(properties.ProxyConfigurationProperties) : undefined);
    ret.addPropertyResult('type', 'Type', properties.Type != null ? cfn_parse.FromCloudFormation.getString(properties.Type) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RepositoryCredentialsProperty`
 *
 * @param properties - the TypeScript properties of a `RepositoryCredentialsProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_RepositoryCredentialsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('credentialsParameter', cdk.validateString)(properties.credentialsParameter));
    return errors.wrap('supplied properties not correct for "RepositoryCredentialsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.RepositoryCredentials` resource
 *
 * @param properties - the TypeScript properties of a `RepositoryCredentialsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.RepositoryCredentials` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionRepositoryCredentialsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_RepositoryCredentialsPropertyValidator(properties).assertSuccess();
    return {
        CredentialsParameter: cdk.stringToCloudFormation(properties.credentialsParameter),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionRepositoryCredentialsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('credentialsParameter', 'CredentialsParameter', properties.CredentialsParameter != null ? cfn_parse.FromCloudFormation.getString(properties.CredentialsParameter) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ResourceRequirementProperty`
 *
 * @param properties - the TypeScript properties of a `ResourceRequirementProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_ResourceRequirementPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    errors.collect(cdk.propertyValidator('value', cdk.requiredValidator)(properties.value));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "ResourceRequirementProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ResourceRequirement` resource
 *
 * @param properties - the TypeScript properties of a `ResourceRequirementProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.ResourceRequirement` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionResourceRequirementPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_ResourceRequirementPropertyValidator(properties).assertSuccess();
    return {
        Type: cdk.stringToCloudFormation(properties.type),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionResourceRequirementPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addPropertyResult('value', 'Value', cfn_parse.FromCloudFormation.getString(properties.Value));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RuntimePlatformProperty`
 *
 * @param properties - the TypeScript properties of a `RuntimePlatformProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_RuntimePlatformPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cpuArchitecture', cdk.validateString)(properties.cpuArchitecture));
    errors.collect(cdk.propertyValidator('operatingSystemFamily', cdk.validateString)(properties.operatingSystemFamily));
    return errors.wrap('supplied properties not correct for "RuntimePlatformProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.RuntimePlatform` resource
 *
 * @param properties - the TypeScript properties of a `RuntimePlatformProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.RuntimePlatform` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionRuntimePlatformPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_RuntimePlatformPropertyValidator(properties).assertSuccess();
    return {
        CpuArchitecture: cdk.stringToCloudFormation(properties.cpuArchitecture),
        OperatingSystemFamily: cdk.stringToCloudFormation(properties.operatingSystemFamily),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionRuntimePlatformPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cpuArchitecture', 'CpuArchitecture', properties.CpuArchitecture != null ? cfn_parse.FromCloudFormation.getString(properties.CpuArchitecture) : undefined);
    ret.addPropertyResult('operatingSystemFamily', 'OperatingSystemFamily', properties.OperatingSystemFamily != null ? cfn_parse.FromCloudFormation.getString(properties.OperatingSystemFamily) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SecretProperty`
 *
 * @param properties - the TypeScript properties of a `SecretProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_SecretPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('valueFrom', cdk.requiredValidator)(properties.valueFrom));
    errors.collect(cdk.propertyValidator('valueFrom', cdk.validateString)(properties.valueFrom));
    return errors.wrap('supplied properties not correct for "SecretProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Secret` resource
 *
 * @param properties - the TypeScript properties of a `SecretProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Secret` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionSecretPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_SecretPropertyValidator(properties).assertSuccess();
    return {
        Name: cdk.stringToCloudFormation(properties.name),
        ValueFrom: cdk.stringToCloudFormation(properties.valueFrom),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionSecretPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('valueFrom', 'ValueFrom', cfn_parse.FromCloudFormation.getString(properties.ValueFrom));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SystemControlProperty`
 *
 * @param properties - the TypeScript properties of a `SystemControlProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_SystemControlPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('namespace', cdk.validateString)(properties.namespace));
    errors.collect(cdk.propertyValidator('value', cdk.validateString)(properties.value));
    return errors.wrap('supplied properties not correct for "SystemControlProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.SystemControl` resource
 *
 * @param properties - the TypeScript properties of a `SystemControlProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.SystemControl` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionSystemControlPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_SystemControlPropertyValidator(properties).assertSuccess();
    return {
        Namespace: cdk.stringToCloudFormation(properties.namespace),
        Value: cdk.stringToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionSystemControlPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('namespace', 'Namespace', properties.Namespace != null ? cfn_parse.FromCloudFormation.getString(properties.Namespace) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getString(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TaskDefinitionPlacementConstraintProperty`
 *
 * @param properties - the TypeScript properties of a `TaskDefinitionPlacementConstraintProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_TaskDefinitionPlacementConstraintPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('expression', cdk.validateString)(properties.expression));
    errors.collect(cdk.propertyValidator('type', cdk.requiredValidator)(properties.type));
    errors.collect(cdk.propertyValidator('type', cdk.validateString)(properties.type));
    return errors.wrap('supplied properties not correct for "TaskDefinitionPlacementConstraintProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.TaskDefinitionPlacementConstraint` resource
 *
 * @param properties - the TypeScript properties of a `TaskDefinitionPlacementConstraintProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.TaskDefinitionPlacementConstraint` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionTaskDefinitionPlacementConstraintPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_TaskDefinitionPlacementConstraintPropertyValidator(properties).assertSuccess();
    return {
        Expression: cdk.stringToCloudFormation(properties.expression),
        Type: cdk.stringToCloudFormation(properties.type),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionTaskDefinitionPlacementConstraintPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('expression', 'Expression', properties.Expression != null ? cfn_parse.FromCloudFormation.getString(properties.Expression) : undefined);
    ret.addPropertyResult('type', 'Type', cfn_parse.FromCloudFormation.getString(properties.Type));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `TmpfsProperty`
 *
 * @param properties - the TypeScript properties of a `TmpfsProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_TmpfsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerPath', cdk.validateString)(properties.containerPath));
    errors.collect(cdk.propertyValidator('mountOptions', cdk.listValidator(cdk.validateString))(properties.mountOptions));
    errors.collect(cdk.propertyValidator('size', cdk.requiredValidator)(properties.size));
    errors.collect(cdk.propertyValidator('size', cdk.validateNumber)(properties.size));
    return errors.wrap('supplied properties not correct for "TmpfsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Tmpfs` resource
 *
 * @param properties - the TypeScript properties of a `TmpfsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Tmpfs` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionTmpfsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_TmpfsPropertyValidator(properties).assertSuccess();
    return {
        ContainerPath: cdk.stringToCloudFormation(properties.containerPath),
        MountOptions: cdk.listMapper(cdk.stringToCloudFormation)(properties.mountOptions),
        Size: cdk.numberToCloudFormation(properties.size),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionTmpfsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerPath', 'ContainerPath', properties.ContainerPath != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerPath) : undefined);
    ret.addPropertyResult('mountOptions', 'MountOptions', properties.MountOptions != null ? cfn_parse.FromCloudFormation.getStringArray(properties.MountOptions) : undefined);
    ret.addPropertyResult('size', 'Size', cfn_parse.FromCloudFormation.getNumber(properties.Size));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `UlimitProperty`
 *
 * @param properties - the TypeScript properties of a `UlimitProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_UlimitPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('hardLimit', cdk.requiredValidator)(properties.hardLimit));
    errors.collect(cdk.propertyValidator('hardLimit', cdk.validateNumber)(properties.hardLimit));
    errors.collect(cdk.propertyValidator('name', cdk.requiredValidator)(properties.name));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    errors.collect(cdk.propertyValidator('softLimit', cdk.requiredValidator)(properties.softLimit));
    errors.collect(cdk.propertyValidator('softLimit', cdk.validateNumber)(properties.softLimit));
    return errors.wrap('supplied properties not correct for "UlimitProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Ulimit` resource
 *
 * @param properties - the TypeScript properties of a `UlimitProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Ulimit` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionUlimitPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_UlimitPropertyValidator(properties).assertSuccess();
    return {
        HardLimit: cdk.numberToCloudFormation(properties.hardLimit),
        Name: cdk.stringToCloudFormation(properties.name),
        SoftLimit: cdk.numberToCloudFormation(properties.softLimit),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionUlimitPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('hardLimit', 'HardLimit', cfn_parse.FromCloudFormation.getNumber(properties.HardLimit));
    ret.addPropertyResult('name', 'Name', cfn_parse.FromCloudFormation.getString(properties.Name));
    ret.addPropertyResult('softLimit', 'SoftLimit', cfn_parse.FromCloudFormation.getNumber(properties.SoftLimit));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VolumeProperty`
 *
 * @param properties - the TypeScript properties of a `VolumeProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_VolumePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('dockerVolumeConfiguration', CfnTaskDefinition_DockerVolumeConfigurationPropertyValidator)(properties.dockerVolumeConfiguration));
    errors.collect(cdk.propertyValidator('efsVolumeConfiguration', CfnTaskDefinition_EfsVolumeConfigurationPropertyValidator)(properties.efsVolumeConfiguration));
    errors.collect(cdk.propertyValidator('host', CfnTaskDefinition_HostVolumePropertiesPropertyValidator)(properties.host));
    errors.collect(cdk.propertyValidator('name', cdk.validateString)(properties.name));
    return errors.wrap('supplied properties not correct for "VolumeProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Volume` resource
 *
 * @param properties - the TypeScript properties of a `VolumeProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.Volume` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionVolumePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_VolumePropertyValidator(properties).assertSuccess();
    return {
        DockerVolumeConfiguration: cfnTaskDefinitionDockerVolumeConfigurationPropertyToCloudFormation(properties.dockerVolumeConfiguration),
        EfsVolumeConfiguration: cfnTaskDefinitionEfsVolumeConfigurationPropertyToCloudFormation(properties.efsVolumeConfiguration),
        Host: cfnTaskDefinitionHostVolumePropertiesPropertyToCloudFormation(properties.host),
        Name: cdk.stringToCloudFormation(properties.name),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionVolumePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('dockerVolumeConfiguration', 'DockerVolumeConfiguration', properties.DockerVolumeConfiguration != null ? CfnTaskDefinitionDockerVolumeConfigurationPropertyFromCloudFormation(properties.DockerVolumeConfiguration) : undefined);
    ret.addPropertyResult('efsVolumeConfiguration', 'EfsVolumeConfiguration', properties.EfsVolumeConfiguration != null ? CfnTaskDefinitionEfsVolumeConfigurationPropertyFromCloudFormation(properties.EfsVolumeConfiguration) : undefined);
    ret.addPropertyResult('host', 'Host', properties.Host != null ? CfnTaskDefinitionHostVolumePropertiesPropertyFromCloudFormation(properties.Host) : undefined);
    ret.addPropertyResult('name', 'Name', properties.Name != null ? cfn_parse.FromCloudFormation.getString(properties.Name) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `VolumeFromProperty`
 *
 * @param properties - the TypeScript properties of a `VolumeFromProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskDefinition_VolumeFromPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('readOnly', cdk.validateBoolean)(properties.readOnly));
    errors.collect(cdk.propertyValidator('sourceContainer', cdk.validateString)(properties.sourceContainer));
    return errors.wrap('supplied properties not correct for "VolumeFromProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.VolumeFrom` resource
 *
 * @param properties - the TypeScript properties of a `VolumeFromProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskDefinition.VolumeFrom` resource.
 */
// @ts-ignore TS6133
function cfnTaskDefinitionVolumeFromPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskDefinition_VolumeFromPropertyValidator(properties).assertSuccess();
    return {
        ReadOnly: cdk.booleanToCloudFormation(properties.readOnly),
        SourceContainer: cdk.stringToCloudFormation(properties.sourceContainer),
    };
}
// @ts-ignore TS6133
function CfnTaskDefinitionVolumeFromPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('readOnly', 'ReadOnly', properties.ReadOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ReadOnly) : undefined);
    ret.addPropertyResult('sourceContainer', 'SourceContainer', properties.SourceContainer != null ? cfn_parse.FromCloudFormation.getString(properties.SourceContainer) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnTaskSetProps`
 *
 * @param properties - the TypeScript properties of a `CfnTaskSetProps`
 *
 * @returns the result of the validation.
 */
function CfnTaskSetPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cluster', cdk.requiredValidator)(properties.cluster));
    errors.collect(cdk.propertyValidator('cluster', cdk.validateString)(properties.cluster));
    errors.collect(cdk.propertyValidator('externalId', cdk.validateString)(properties.externalId));
    errors.collect(cdk.propertyValidator('launchType', cdk.validateString)(properties.launchType));
    errors.collect(cdk.propertyValidator('loadBalancers', cdk.listValidator(CfnTaskSet_LoadBalancerPropertyValidator))(properties.loadBalancers));
    errors.collect(cdk.propertyValidator('networkConfiguration', CfnTaskSet_NetworkConfigurationPropertyValidator)(properties.networkConfiguration));
    errors.collect(cdk.propertyValidator('platformVersion', cdk.validateString)(properties.platformVersion));
    errors.collect(cdk.propertyValidator('scale', CfnTaskSet_ScalePropertyValidator)(properties.scale));
    errors.collect(cdk.propertyValidator('service', cdk.requiredValidator)(properties.service));
    errors.collect(cdk.propertyValidator('service', cdk.validateString)(properties.service));
    errors.collect(cdk.propertyValidator('serviceRegistries', cdk.listValidator(CfnTaskSet_ServiceRegistryPropertyValidator))(properties.serviceRegistries));
    errors.collect(cdk.propertyValidator('taskDefinition', cdk.requiredValidator)(properties.taskDefinition));
    errors.collect(cdk.propertyValidator('taskDefinition', cdk.validateString)(properties.taskDefinition));
    return errors.wrap('supplied properties not correct for "CfnTaskSetProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet` resource
 *
 * @param properties - the TypeScript properties of a `CfnTaskSetProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSetPropsValidator(properties).assertSuccess();
    return {
        Cluster: cdk.stringToCloudFormation(properties.cluster),
        Service: cdk.stringToCloudFormation(properties.service),
        TaskDefinition: cdk.stringToCloudFormation(properties.taskDefinition),
        ExternalId: cdk.stringToCloudFormation(properties.externalId),
        LaunchType: cdk.stringToCloudFormation(properties.launchType),
        LoadBalancers: cdk.listMapper(cfnTaskSetLoadBalancerPropertyToCloudFormation)(properties.loadBalancers),
        NetworkConfiguration: cfnTaskSetNetworkConfigurationPropertyToCloudFormation(properties.networkConfiguration),
        PlatformVersion: cdk.stringToCloudFormation(properties.platformVersion),
        Scale: cfnTaskSetScalePropertyToCloudFormation(properties.scale),
        ServiceRegistries: cdk.listMapper(cfnTaskSetServiceRegistryPropertyToCloudFormation)(properties.serviceRegistries),
    };
}
// @ts-ignore TS6133
function CfnTaskSetPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('cluster', 'Cluster', cfn_parse.FromCloudFormation.getString(properties.Cluster));
    ret.addPropertyResult('service', 'Service', cfn_parse.FromCloudFormation.getString(properties.Service));
    ret.addPropertyResult('taskDefinition', 'TaskDefinition', cfn_parse.FromCloudFormation.getString(properties.TaskDefinition));
    ret.addPropertyResult('externalId', 'ExternalId', properties.ExternalId != null ? cfn_parse.FromCloudFormation.getString(properties.ExternalId) : undefined);
    ret.addPropertyResult('launchType', 'LaunchType', properties.LaunchType != null ? cfn_parse.FromCloudFormation.getString(properties.LaunchType) : undefined);
    ret.addPropertyResult('loadBalancers', 'LoadBalancers', properties.LoadBalancers != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskSetLoadBalancerPropertyFromCloudFormation)(properties.LoadBalancers) : undefined);
    ret.addPropertyResult('networkConfiguration', 'NetworkConfiguration', properties.NetworkConfiguration != null ? CfnTaskSetNetworkConfigurationPropertyFromCloudFormation(properties.NetworkConfiguration) : undefined);
    ret.addPropertyResult('platformVersion', 'PlatformVersion', properties.PlatformVersion != null ? cfn_parse.FromCloudFormation.getString(properties.PlatformVersion) : undefined);
    ret.addPropertyResult('scale', 'Scale', properties.Scale != null ? CfnTaskSetScalePropertyFromCloudFormation(properties.Scale) : undefined);
    ret.addPropertyResult('serviceRegistries', 'ServiceRegistries', properties.ServiceRegistries != null ? cfn_parse.FromCloudFormation.getArray(CfnTaskSetServiceRegistryPropertyFromCloudFormation)(properties.ServiceRegistries) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::ECS::TaskSet`
 *
 * Create a task set in the specified cluster and service. This is used when a service uses the `EXTERNAL` deployment controller type. For more information, see [Amazon ECS Deployment Types](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html) in the *Amazon Elastic Container Service Developer Guide* .
 *
 * @cloudformationResource AWS::ECS::TaskSet
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskset.html
 */
class CfnTaskSet extends cdk.CfnResource {
    /**
     * Create a new `AWS::ECS::TaskSet`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnTaskSet.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_ecs_CfnTaskSetProps(props);
        cdk.requireProperty(props, 'cluster', this);
        cdk.requireProperty(props, 'service', this);
        cdk.requireProperty(props, 'taskDefinition', this);
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.cluster = props.cluster;
        this.service = props.service;
        this.taskDefinition = props.taskDefinition;
        this.externalId = props.externalId;
        this.launchType = props.launchType;
        this.loadBalancers = props.loadBalancers;
        this.networkConfiguration = props.networkConfiguration;
        this.platformVersion = props.platformVersion;
        this.scale = props.scale;
        this.serviceRegistries = props.serviceRegistries;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnTaskSetPropsFromCloudFormation(resourceProperties);
        const ret = new CfnTaskSet(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnTaskSet.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            cluster: this.cluster,
            service: this.service,
            taskDefinition: this.taskDefinition,
            externalId: this.externalId,
            launchType: this.launchType,
            loadBalancers: this.loadBalancers,
            networkConfiguration: this.networkConfiguration,
            platformVersion: this.platformVersion,
            scale: this.scale,
            serviceRegistries: this.serviceRegistries,
        };
    }
    renderProperties(props) {
        return cfnTaskSetPropsToCloudFormation(props);
    }
}
exports.CfnTaskSet = CfnTaskSet;
_g = JSII_RTTI_SYMBOL_1;
CfnTaskSet[_g] = { fqn: "monocdk.aws_ecs.CfnTaskSet", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnTaskSet.CFN_RESOURCE_TYPE_NAME = "AWS::ECS::TaskSet";
/**
 * Determine whether the given properties match those of a `AwsVpcConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `AwsVpcConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskSet_AwsVpcConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('assignPublicIp', cdk.validateString)(properties.assignPublicIp));
    errors.collect(cdk.propertyValidator('securityGroups', cdk.listValidator(cdk.validateString))(properties.securityGroups));
    errors.collect(cdk.propertyValidator('subnets', cdk.requiredValidator)(properties.subnets));
    errors.collect(cdk.propertyValidator('subnets', cdk.listValidator(cdk.validateString))(properties.subnets));
    return errors.wrap('supplied properties not correct for "AwsVpcConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet.AwsVpcConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `AwsVpcConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet.AwsVpcConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetAwsVpcConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSet_AwsVpcConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AssignPublicIp: cdk.stringToCloudFormation(properties.assignPublicIp),
        SecurityGroups: cdk.listMapper(cdk.stringToCloudFormation)(properties.securityGroups),
        Subnets: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnets),
    };
}
// @ts-ignore TS6133
function CfnTaskSetAwsVpcConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('assignPublicIp', 'AssignPublicIp', properties.AssignPublicIp != null ? cfn_parse.FromCloudFormation.getString(properties.AssignPublicIp) : undefined);
    ret.addPropertyResult('securityGroups', 'SecurityGroups', properties.SecurityGroups != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SecurityGroups) : undefined);
    ret.addPropertyResult('subnets', 'Subnets', cfn_parse.FromCloudFormation.getStringArray(properties.Subnets));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `LoadBalancerProperty`
 *
 * @param properties - the TypeScript properties of a `LoadBalancerProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskSet_LoadBalancerPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('loadBalancerName', cdk.validateString)(properties.loadBalancerName));
    errors.collect(cdk.propertyValidator('targetGroupArn', cdk.validateString)(properties.targetGroupArn));
    return errors.wrap('supplied properties not correct for "LoadBalancerProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet.LoadBalancer` resource
 *
 * @param properties - the TypeScript properties of a `LoadBalancerProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet.LoadBalancer` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetLoadBalancerPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSet_LoadBalancerPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        LoadBalancerName: cdk.stringToCloudFormation(properties.loadBalancerName),
        TargetGroupArn: cdk.stringToCloudFormation(properties.targetGroupArn),
    };
}
// @ts-ignore TS6133
function CfnTaskSetLoadBalancerPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('containerPort', 'ContainerPort', properties.ContainerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort) : undefined);
    ret.addPropertyResult('loadBalancerName', 'LoadBalancerName', properties.LoadBalancerName != null ? cfn_parse.FromCloudFormation.getString(properties.LoadBalancerName) : undefined);
    ret.addPropertyResult('targetGroupArn', 'TargetGroupArn', properties.TargetGroupArn != null ? cfn_parse.FromCloudFormation.getString(properties.TargetGroupArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NetworkConfigurationProperty`
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskSet_NetworkConfigurationPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('awsVpcConfiguration', CfnTaskSet_AwsVpcConfigurationPropertyValidator)(properties.awsVpcConfiguration));
    return errors.wrap('supplied properties not correct for "NetworkConfigurationProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet.NetworkConfiguration` resource
 *
 * @param properties - the TypeScript properties of a `NetworkConfigurationProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet.NetworkConfiguration` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetNetworkConfigurationPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSet_NetworkConfigurationPropertyValidator(properties).assertSuccess();
    return {
        AwsVpcConfiguration: cfnTaskSetAwsVpcConfigurationPropertyToCloudFormation(properties.awsVpcConfiguration),
    };
}
// @ts-ignore TS6133
function CfnTaskSetNetworkConfigurationPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('awsVpcConfiguration', 'AwsVpcConfiguration', properties.AwsVpcConfiguration != null ? CfnTaskSetAwsVpcConfigurationPropertyFromCloudFormation(properties.AwsVpcConfiguration) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ScaleProperty`
 *
 * @param properties - the TypeScript properties of a `ScaleProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskSet_ScalePropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('unit', cdk.validateString)(properties.unit));
    errors.collect(cdk.propertyValidator('value', cdk.validateNumber)(properties.value));
    return errors.wrap('supplied properties not correct for "ScaleProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet.Scale` resource
 *
 * @param properties - the TypeScript properties of a `ScaleProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet.Scale` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetScalePropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSet_ScalePropertyValidator(properties).assertSuccess();
    return {
        Unit: cdk.stringToCloudFormation(properties.unit),
        Value: cdk.numberToCloudFormation(properties.value),
    };
}
// @ts-ignore TS6133
function CfnTaskSetScalePropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('unit', 'Unit', properties.Unit != null ? cfn_parse.FromCloudFormation.getString(properties.Unit) : undefined);
    ret.addPropertyResult('value', 'Value', properties.Value != null ? cfn_parse.FromCloudFormation.getNumber(properties.Value) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ServiceRegistryProperty`
 *
 * @param properties - the TypeScript properties of a `ServiceRegistryProperty`
 *
 * @returns the result of the validation.
 */
function CfnTaskSet_ServiceRegistryPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('containerName', cdk.validateString)(properties.containerName));
    errors.collect(cdk.propertyValidator('containerPort', cdk.validateNumber)(properties.containerPort));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('registryArn', cdk.validateString)(properties.registryArn));
    return errors.wrap('supplied properties not correct for "ServiceRegistryProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::ECS::TaskSet.ServiceRegistry` resource
 *
 * @param properties - the TypeScript properties of a `ServiceRegistryProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::ECS::TaskSet.ServiceRegistry` resource.
 */
// @ts-ignore TS6133
function cfnTaskSetServiceRegistryPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnTaskSet_ServiceRegistryPropertyValidator(properties).assertSuccess();
    return {
        ContainerName: cdk.stringToCloudFormation(properties.containerName),
        ContainerPort: cdk.numberToCloudFormation(properties.containerPort),
        Port: cdk.numberToCloudFormation(properties.port),
        RegistryArn: cdk.stringToCloudFormation(properties.registryArn),
    };
}
// @ts-ignore TS6133
function CfnTaskSetServiceRegistryPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('containerName', 'ContainerName', properties.ContainerName != null ? cfn_parse.FromCloudFormation.getString(properties.ContainerName) : undefined);
    ret.addPropertyResult('containerPort', 'ContainerPort', properties.ContainerPort != null ? cfn_parse.FromCloudFormation.getNumber(properties.ContainerPort) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('registryArn', 'RegistryArn', properties.RegistryArn != null ? cfn_parse.FromCloudFormation.getString(properties.RegistryArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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