"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2TaskDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const _imported_task_definition_1 = require("../base/_imported-task-definition");
const task_definition_1 = require("../base/task-definition");
/**
 * The details of a task definition run on an EC2 cluster.
 *
 * @resource AWS::ECS::TaskDefinition
 */
class Ec2TaskDefinition extends task_definition_1.TaskDefinition {
    /**
     * Constructs a new instance of the Ec2TaskDefinition class.
     */
    constructor(scope, id, props = {}) {
        super(scope, id, {
            ...props,
            compatibility: task_definition_1.Compatibility.EC2,
            placementConstraints: props.placementConstraints,
            ipcMode: props.ipcMode,
            pidMode: props.pidMode,
            inferenceAccelerators: props.inferenceAccelerators,
        });
        jsiiDeprecationWarnings.monocdk_aws_ecs_Ec2TaskDefinitionProps(props);
    }
    /**
     * Imports a task definition from the specified task definition ARN.
     */
    static fromEc2TaskDefinitionArn(scope, id, ec2TaskDefinitionArn) {
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: ec2TaskDefinitionArn,
        });
    }
    /**
     * Imports an existing Ec2 task definition from its attributes
     */
    static fromEc2TaskDefinitionAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_Ec2TaskDefinitionAttributes(attrs);
        return new _imported_task_definition_1.ImportedTaskDefinition(scope, id, {
            taskDefinitionArn: attrs.taskDefinitionArn,
            compatibility: task_definition_1.Compatibility.EC2,
            networkMode: attrs.networkMode,
            taskRole: attrs.taskRole,
        });
    }
}
exports.Ec2TaskDefinition = Ec2TaskDefinition;
_a = JSII_RTTI_SYMBOL_1;
Ec2TaskDefinition[_a] = { fqn: "monocdk.aws_ecs.Ec2TaskDefinition", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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