"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerImage = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ecr_assets_1 = require("../../aws-ecr-assets");
/**
 * Constructs for types of container images
 */
class ContainerImage {
    /**
     * Reference an image on DockerHub or another online registry
     */
    static fromRegistry(name, props = {}) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_RepositoryImageProps(props);
        return new repository_1.RepositoryImage(name, props);
    }
    /**
     * Reference an image in an ECR repository
     */
    static fromEcrRepository(repository, tag = 'latest') {
        jsiiDeprecationWarnings.monocdk_aws_ecr_IRepository(repository);
        return new ecr_1.EcrImage(repository, tag);
    }
    /**
     * Reference an image that's constructed directly from sources on disk.
     *
     * If you already have a `DockerImageAsset` instance, you can use the
     * `ContainerImage.fromDockerImageAsset` method instead.
     *
     * @param directory The directory containing the Dockerfile
     */
    static fromAsset(directory, props = {}) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_AssetImageProps(props);
        return new asset_image_1.AssetImage(directory, props);
    }
    /**
     * Use an existing `DockerImageAsset` for this container image.
     *
     * @param asset The `DockerImageAsset` to use for this container definition.
     */
    static fromDockerImageAsset(asset) {
        jsiiDeprecationWarnings.monocdk_aws_ecr_assets_DockerImageAsset(asset);
        return {
            bind(_scope, containerDefinition) {
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
    /**
     * Use an existing tarball for this container image.
     *
     * Use this method if the container image has already been created by another process (e.g. jib)
     * and you want to add it as a container image asset.
     *
     * @param tarballFile Absolute path to the tarball. You can use language-specific idioms (such as `__dirname` in Node.js)
     *                    to create an absolute path based on the current script running directory.
     */
    static fromTarball(tarballFile) {
        return {
            bind(scope, containerDefinition) {
                const asset = new aws_ecr_assets_1.TarballImageAsset(scope, 'Tarball', { tarballFile });
                asset.repository.grantPull(containerDefinition.taskDefinition.obtainExecutionRole());
                return {
                    imageName: asset.imageUri,
                };
            },
        };
    }
}
exports.ContainerImage = ContainerImage;
_a = JSII_RTTI_SYMBOL_1;
ContainerImage[_a] = { fqn: "monocdk.aws_ecs.ContainerImage", version: "1.149.0" };
const asset_image_1 = require("./images/asset-image");
const ecr_1 = require("./images/ecr");
const repository_1 = require("./images/repository");
//# sourceMappingURL=data:application/json;base64,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