"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ScalableTaskCount = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const appscaling = require("../../../aws-applicationautoscaling");
/**
 * The scalable attribute representing task count.
 */
class ScalableTaskCount extends appscaling.BaseScalableAttribute {
    /**
     * Constructs a new instance of the ScalableTaskCount class.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        jsiiDeprecationWarnings.monocdk_aws_ecs_ScalableTaskCountProps(props);
    }
    /**
     * Scales in or out based on a specified scheduled time.
     */
    scaleOnSchedule(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_ScalingSchedule(props);
        return super.doScaleOnSchedule(id, props);
    }
    /**
     * Scales in or out based on a specified metric value.
     */
    scaleOnMetric(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_applicationautoscaling_BasicStepScalingPolicyProps(props);
        return super.doScaleOnMetric(id, props);
    }
    /**
     * Scales in or out to achieve a target CPU utilization.
     */
    scaleOnCpuUtilization(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_CpuUtilizationScalingProps(props);
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ECS_SERVICE_AVERAGE_CPU_UTILIZATION,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            targetValue: props.targetUtilizationPercent,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target memory utilization.
     */
    scaleOnMemoryUtilization(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_MemoryUtilizationScalingProps(props);
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION,
            targetValue: props.targetUtilizationPercent,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target Application Load Balancer request count per target.
     */
    scaleOnRequestCount(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_RequestCountScalingProps(props);
        const resourceLabel = props.targetGroup.firstLoadBalancerFullName +
            '/' + props.targetGroup.targetGroupFullName;
        return super.doScaleToTrackMetric(id, {
            predefinedMetric: appscaling.PredefinedMetric.ALB_REQUEST_COUNT_PER_TARGET,
            resourceLabel,
            targetValue: props.requestsPerTarget,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
    /**
     * Scales in or out to achieve a target on a custom metric.
     */
    scaleToTrackCustomMetric(id, props) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_TrackCustomMetricProps(props);
        return super.doScaleToTrackMetric(id, {
            customMetric: props.metric,
            targetValue: props.targetValue,
            policyName: props.policyName,
            disableScaleIn: props.disableScaleIn,
            scaleInCooldown: props.scaleInCooldown,
            scaleOutCooldown: props.scaleOutCooldown,
        });
    }
}
exports.ScalableTaskCount = ScalableTaskCount;
_a = JSII_RTTI_SYMBOL_1;
ScalableTaskCount[_a] = { fqn: "monocdk.aws_ecs.ScalableTaskCount", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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