"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.fromServiceAtrributes = void 0;
const core_1 = require("../../../core");
function fromServiceAtrributes(scope, id, attrs) {
    if ((attrs.serviceArn && attrs.serviceName) || (!attrs.serviceArn && !attrs.serviceName)) {
        throw new Error('You can only specify either serviceArn or serviceName.');
    }
    const stack = core_1.Stack.of(scope);
    let name;
    let arn;
    if (attrs.serviceName) {
        name = attrs.serviceName;
        arn = stack.formatArn({
            partition: stack.partition,
            service: 'ecs',
            region: stack.region,
            account: stack.account,
            resource: 'service',
            resourceName: name,
        });
    }
    else {
        arn = attrs.serviceArn;
        name = stack.splitArn(arn, core_1.ArnFormat.SLASH_RESOURCE_NAME).resourceName;
    }
    class Import extends core_1.Resource {
        constructor() {
            super(...arguments);
            this.serviceArn = arn;
            this.serviceName = name;
            this.cluster = attrs.cluster;
        }
    }
    return new Import(scope, id, {
        environmentFromArn: arn,
    });
}
exports.fromServiceAtrributes = fromServiceAtrributes;
//# sourceMappingURL=data:application/json;base64,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