"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ImportedTaskDefinition = void 0;
const core_1 = require("../../../core");
const task_definition_1 = require("./task-definition");
/**
 * Task definition reference of an imported task
 */
class ImportedTaskDefinition extends core_1.Resource {
    constructor(scope, id, props) {
        var _a;
        super(scope, id);
        /**
         * Execution role for this task definition
         */
        this.executionRole = undefined;
        this.compatibility = (_a = props.compatibility) !== null && _a !== void 0 ? _a : task_definition_1.Compatibility.EC2_AND_FARGATE;
        this.taskDefinitionArn = props.taskDefinitionArn;
        this._taskRole = props.taskRole;
        this._networkMode = props.networkMode;
    }
    get networkMode() {
        if (this._networkMode == undefined) {
            throw new Error('This operation requires the networkMode in ImportedTaskDefinition to be defined. ' +
                'Add the \'networkMode\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._networkMode;
        }
    }
    get taskRole() {
        if (this._taskRole == undefined) {
            throw new Error('This operation requires the taskRole in ImportedTaskDefinition to be defined. ' +
                'Add the \'taskRole\' in ImportedTaskDefinitionProps to instantiate ImportedTaskDefinition');
        }
        else {
            return this._taskRole;
        }
    }
    /**
     * Return true if the task definition can be run on an EC2 cluster
     */
    get isEc2Compatible() {
        return task_definition_1.isEc2Compatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a Fargate cluster
     */
    get isFargateCompatible() {
        return task_definition_1.isFargateCompatible(this.compatibility);
    }
    /**
     * Return true if the task definition can be run on a ECS Anywhere cluster
     */
    get isExternalCompatible() {
        return task_definition_1.isExternalCompatible(this.compatibility);
    }
}
exports.ImportedTaskDefinition = ImportedTaskDefinition;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX2ltcG9ydGVkLXRhc2stZGVmaW5pdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIl9pbXBvcnRlZC10YXNrLWRlZmluaXRpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQ0Esd0NBQXlDO0FBSXpDLHVEQUEySDtBQWlDM0g7O0dBRUc7QUFDSCxNQUFhLHNCQUF1QixTQUFRLGVBQVE7SUEwQmxELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7O1FBQzFFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFoQm5COztXQUVHO1FBQ00sa0JBQWEsR0FBVyxTQUFTLENBQUM7UUFlekMsSUFBSSxDQUFDLGFBQWEsU0FBRyxLQUFLLENBQUMsYUFBYSxtQ0FBSSwrQkFBYSxDQUFDLGVBQWUsQ0FBQztRQUMxRSxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1FBQ2pELElBQUksQ0FBQyxTQUFTLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUNoQyxJQUFJLENBQUMsWUFBWSxHQUFHLEtBQUssQ0FBQyxXQUFXLENBQUM7S0FDdkM7SUFFRCxJQUFXLFdBQVc7UUFDcEIsSUFBSSxJQUFJLENBQUMsWUFBWSxJQUFJLFNBQVMsRUFBRTtZQUNsQyxNQUFNLElBQUksS0FBSyxDQUFDLG1GQUFtRjtnQkFDakcsOEZBQThGLENBQUMsQ0FBQztTQUNuRzthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDO1NBQzFCO0tBQ0Y7SUFFRCxJQUFXLFFBQVE7UUFDakIsSUFBSSxJQUFJLENBQUMsU0FBUyxJQUFJLFNBQVMsRUFBRTtZQUMvQixNQUFNLElBQUksS0FBSyxDQUFDLGdGQUFnRjtnQkFDOUYsMkZBQTJGLENBQUMsQ0FBQztTQUNoRzthQUFNO1lBQ0wsT0FBTyxJQUFJLENBQUMsU0FBUyxDQUFDO1NBQ3ZCO0tBQ0Y7SUFFRDs7T0FFRztJQUNILElBQVcsZUFBZTtRQUN4QixPQUFPLGlDQUFlLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxDQUFDO0tBQzVDO0lBRUQ7O09BRUc7SUFDSCxJQUFXLG1CQUFtQjtRQUM1QixPQUFPLHFDQUFtQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztLQUNoRDtJQUVEOztPQUVHO0lBQ0gsSUFBVyxvQkFBb0I7UUFDN0IsT0FBTyxzQ0FBb0IsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDakQ7Q0FDRjtBQXpFRCx3REF5RUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJUm9sZSB9IGZyb20gJy4uLy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0IHsgUmVzb3VyY2UgfSBmcm9tICcuLi8uLi8uLi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuaW1wb3J0IHsgSUVjMlRhc2tEZWZpbml0aW9uIH0gZnJvbSAnLi4vZWMyL2VjMi10YXNrLWRlZmluaXRpb24nO1xuaW1wb3J0IHsgSUZhcmdhdGVUYXNrRGVmaW5pdGlvbiB9IGZyb20gJy4uL2ZhcmdhdGUvZmFyZ2F0ZS10YXNrLWRlZmluaXRpb24nO1xuaW1wb3J0IHsgQ29tcGF0aWJpbGl0eSwgTmV0d29ya01vZGUsIGlzRWMyQ29tcGF0aWJsZSwgaXNGYXJnYXRlQ29tcGF0aWJsZSwgaXNFeHRlcm5hbENvbXBhdGlibGUgfSBmcm9tICcuL3Rhc2stZGVmaW5pdGlvbic7XG5cbi8qKlxuICogVGhlIHByb3BlcnRpZXMgb2YgSW1wb3J0ZWRUYXNrRGVmaW5pdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIEltcG9ydGVkVGFza0RlZmluaXRpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgYXJuIG9mIHRoZSB0YXNrIGRlZmluaXRpb25cbiAgICovXG4gIHJlYWRvbmx5IHRhc2tEZWZpbml0aW9uQXJuOiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFdoYXQgbGF1bmNoIHR5cGVzIHRoaXMgdGFzayBkZWZpbml0aW9uIHNob3VsZCBiZSBjb21wYXRpYmxlIHdpdGguXG4gICAqXG4gICAqIEBkZWZhdWx0IENvbXBhdGliaWxpdHkuRUMyX0FORF9GQVJHQVRFXG4gICAqL1xuICByZWFkb25seSBjb21wYXRpYmlsaXR5PzogQ29tcGF0aWJpbGl0eTtcblxuICAvKipcbiAgICogVGhlIG5ldHdvcmtpbmcgbW9kZSB0byB1c2UgZm9yIHRoZSBjb250YWluZXJzIGluIHRoZSB0YXNrLlxuICAgKlxuICAgKiBAZGVmYXVsdCBOZXR3b3JrIG1vZGUgY2Fubm90IGJlIHByb3ZpZGVkIHRvIHRoZSBpbXBvcnRlZCB0YXNrLlxuICAgKi9cbiAgcmVhZG9ubHkgbmV0d29ya01vZGU/OiBOZXR3b3JrTW9kZTtcblxuICAvKipcbiAgICogVGhlIG5hbWUgb2YgdGhlIElBTSByb2xlIHRoYXQgZ3JhbnRzIGNvbnRhaW5lcnMgaW4gdGhlIHRhc2sgcGVybWlzc2lvbiB0byBjYWxsIEFXUyBBUElzIG9uIHlvdXIgYmVoYWxmLlxuICAgKlxuICAgKiBAZGVmYXVsdCBQZXJtaXNzaW9ucyBjYW5ub3QgYmUgZ3JhbnRlZCB0byB0aGUgaW1wb3J0ZWQgdGFzay5cbiAgICovXG4gIHJlYWRvbmx5IHRhc2tSb2xlPzogSVJvbGU7XG59XG5cbi8qKlxuICogVGFzayBkZWZpbml0aW9uIHJlZmVyZW5jZSBvZiBhbiBpbXBvcnRlZCB0YXNrXG4gKi9cbmV4cG9ydCBjbGFzcyBJbXBvcnRlZFRhc2tEZWZpbml0aW9uIGV4dGVuZHMgUmVzb3VyY2UgaW1wbGVtZW50cyBJRWMyVGFza0RlZmluaXRpb24sIElGYXJnYXRlVGFza0RlZmluaXRpb24ge1xuICAvKipcbiAgICogV2hhdCBsYXVuY2ggdHlwZXMgdGhpcyB0YXNrIGRlZmluaXRpb24gc2hvdWxkIGJlIGNvbXBhdGlibGUgd2l0aC5cbiAgICovXG4gIHJlYWRvbmx5IGNvbXBhdGliaWxpdHk6IENvbXBhdGliaWxpdHk7XG5cbiAgLyoqXG4gICAqIEFSTiBvZiB0aGlzIHRhc2sgZGVmaW5pdGlvblxuICAgKi9cbiAgcmVhZG9ubHkgdGFza0RlZmluaXRpb25Bcm46IHN0cmluZztcblxuICAvKipcbiAgICogRXhlY3V0aW9uIHJvbGUgZm9yIHRoaXMgdGFzayBkZWZpbml0aW9uXG4gICAqL1xuICByZWFkb25seSBleGVjdXRpb25Sb2xlPzogSVJvbGUgPSB1bmRlZmluZWQ7XG5cbiAgLyoqXG4gICAqIFRoZSBuZXR3b3JraW5nIG1vZGUgdG8gdXNlIGZvciB0aGUgY29udGFpbmVycyBpbiB0aGUgdGFzay5cbiAgICovXG4gIHJlYWRvbmx5IF9uZXR3b3JrTW9kZT86IE5ldHdvcmtNb2RlO1xuXG4gIC8qKlxuICAgKiBUaGUgbmFtZSBvZiB0aGUgSUFNIHJvbGUgdGhhdCBncmFudHMgY29udGFpbmVycyBpbiB0aGUgdGFzayBwZXJtaXNzaW9uIHRvIGNhbGwgQVdTIEFQSXMgb24geW91ciBiZWhhbGYuXG4gICAqL1xuICByZWFkb25seSBfdGFza1JvbGU/OiBJUm9sZTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogSW1wb3J0ZWRUYXNrRGVmaW5pdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIHRoaXMuY29tcGF0aWJpbGl0eSA9IHByb3BzLmNvbXBhdGliaWxpdHkgPz8gQ29tcGF0aWJpbGl0eS5FQzJfQU5EX0ZBUkdBVEU7XG4gICAgdGhpcy50YXNrRGVmaW5pdGlvbkFybiA9IHByb3BzLnRhc2tEZWZpbml0aW9uQXJuO1xuICAgIHRoaXMuX3Rhc2tSb2xlID0gcHJvcHMudGFza1JvbGU7XG4gICAgdGhpcy5fbmV0d29ya01vZGUgPSBwcm9wcy5uZXR3b3JrTW9kZTtcbiAgfVxuXG4gIHB1YmxpYyBnZXQgbmV0d29ya01vZGUoKTogTmV0d29ya01vZGUge1xuICAgIGlmICh0aGlzLl9uZXR3b3JrTW9kZSA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcignVGhpcyBvcGVyYXRpb24gcmVxdWlyZXMgdGhlIG5ldHdvcmtNb2RlIGluIEltcG9ydGVkVGFza0RlZmluaXRpb24gdG8gYmUgZGVmaW5lZC4gJyArXG4gICAgICAgICdBZGQgdGhlIFxcJ25ldHdvcmtNb2RlXFwnIGluIEltcG9ydGVkVGFza0RlZmluaXRpb25Qcm9wcyB0byBpbnN0YW50aWF0ZSBJbXBvcnRlZFRhc2tEZWZpbml0aW9uJyk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJldHVybiB0aGlzLl9uZXR3b3JrTW9kZTtcbiAgICB9XG4gIH1cblxuICBwdWJsaWMgZ2V0IHRhc2tSb2xlKCk6IElSb2xlIHtcbiAgICBpZiAodGhpcy5fdGFza1JvbGUgPT0gdW5kZWZpbmVkKSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoJ1RoaXMgb3BlcmF0aW9uIHJlcXVpcmVzIHRoZSB0YXNrUm9sZSBpbiBJbXBvcnRlZFRhc2tEZWZpbml0aW9uIHRvIGJlIGRlZmluZWQuICcgK1xuICAgICAgICAnQWRkIHRoZSBcXCd0YXNrUm9sZVxcJyBpbiBJbXBvcnRlZFRhc2tEZWZpbml0aW9uUHJvcHMgdG8gaW5zdGFudGlhdGUgSW1wb3J0ZWRUYXNrRGVmaW5pdGlvbicpO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gdGhpcy5fdGFza1JvbGU7XG4gICAgfVxuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0cnVlIGlmIHRoZSB0YXNrIGRlZmluaXRpb24gY2FuIGJlIHJ1biBvbiBhbiBFQzIgY2x1c3RlclxuICAgKi9cbiAgcHVibGljIGdldCBpc0VjMkNvbXBhdGlibGUoKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIGlzRWMyQ29tcGF0aWJsZSh0aGlzLmNvbXBhdGliaWxpdHkpO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybiB0cnVlIGlmIHRoZSB0YXNrIGRlZmluaXRpb24gY2FuIGJlIHJ1biBvbiBhIEZhcmdhdGUgY2x1c3RlclxuICAgKi9cbiAgcHVibGljIGdldCBpc0ZhcmdhdGVDb21wYXRpYmxlKCk6IGJvb2xlYW4ge1xuICAgIHJldHVybiBpc0ZhcmdhdGVDb21wYXRpYmxlKHRoaXMuY29tcGF0aWJpbGl0eSk7XG4gIH1cblxuICAvKipcbiAgICogUmV0dXJuIHRydWUgaWYgdGhlIHRhc2sgZGVmaW5pdGlvbiBjYW4gYmUgcnVuIG9uIGEgRUNTIEFueXdoZXJlIGNsdXN0ZXJcbiAgICovXG4gIHB1YmxpYyBnZXQgaXNFeHRlcm5hbENvbXBhdGlibGUoKTogYm9vbGVhbiB7XG4gICAgcmV0dXJuIGlzRXh0ZXJuYWxDb21wYXRpYmxlKHRoaXMuY29tcGF0aWJpbGl0eSk7XG4gIH1cbn1cbiJdfQ==