"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BottleRocketImage = exports.BottlerocketEcsVariant = exports.EcsOptimizedImage = exports.EcsOptimizedAmi = exports.WindowsOptimizedVersion = exports.AmiHardwareType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const ec2 = require("../../aws-ec2");
const ssm = require("../../aws-ssm");
/**
 * The ECS-optimized AMI variant to use. For more information, see
 * [Amazon ECS-optimized AMIs](https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html).
 */
var AmiHardwareType;
(function (AmiHardwareType) {
    /**
     * Use the standard Amazon ECS-optimized AMI.
     */
    AmiHardwareType["STANDARD"] = "Standard";
    /**
     * Use the Amazon ECS GPU-optimized AMI.
     */
    AmiHardwareType["GPU"] = "GPU";
    /**
     * Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     */
    AmiHardwareType["ARM"] = "ARM64";
})(AmiHardwareType = exports.AmiHardwareType || (exports.AmiHardwareType = {}));
/**
 * ECS-optimized Windows version list
 */
var WindowsOptimizedVersion;
(function (WindowsOptimizedVersion) {
    WindowsOptimizedVersion["SERVER_2019"] = "2019";
    WindowsOptimizedVersion["SERVER_2016"] = "2016";
})(WindowsOptimizedVersion = exports.WindowsOptimizedVersion || (exports.WindowsOptimizedVersion = {}));
/*
 * TODO:v2.0.0 remove EcsOptimizedAmi
 */
/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM
 *
 * @deprecated see {@link EcsOptimizedImage#amazonLinux}, {@link EcsOptimizedImage#amazonLinux} and {@link EcsOptimizedImage#windows}
 */
class EcsOptimizedAmi {
    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    constructor(props) {
        var _d;
        jsiiDeprecationWarnings.print("monocdk.aws_ecs.EcsOptimizedAmi", "see {@link EcsOptimizedImage#amazonLinux}, {@link EcsOptimizedImage#amazonLinux} and {@link EcsOptimizedImage#windows}");
        jsiiDeprecationWarnings.monocdk_aws_ecs_EcsOptimizedAmiProps(props);
        this.hwType = (props && props.hardwareType) || AmiHardwareType.STANDARD;
        if (props && props.generation) { // generation defined in the props object
            if (props.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX && this.hwType !== AmiHardwareType.STANDARD) {
                throw new Error('Amazon Linux does not support special hardware type. Use Amazon Linux 2 instead');
            }
            else if (props.windowsVersion) {
                throw new Error('"windowsVersion" and Linux image "generation" cannot be both set');
            }
            else {
                this.generation = props.generation;
            }
        }
        else if (props && props.windowsVersion) {
            if (this.hwType !== AmiHardwareType.STANDARD) {
                throw new Error('Windows Server does not support special hardware type');
            }
            else {
                this.windowsVersion = props.windowsVersion;
            }
        }
        else { // generation not defined in props object
            // always default to Amazon Linux v2 regardless of HW
            this.generation = ec2.AmazonLinuxGeneration.AMAZON_LINUX_2;
        }
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.windowsVersion ? `windows_server/${this.windowsVersion}/english/full/` : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
        this.cachedInContext = (_d = props === null || props === void 0 ? void 0 : props.cachedInContext) !== null && _d !== void 0 ? _d : false;
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        jsiiDeprecationWarnings.print("monocdk.aws_ecs.EcsOptimizedAmi#getImage", "see {@link EcsOptimizedImage#amazonLinux}, {@link EcsOptimizedImage#amazonLinux} and {@link EcsOptimizedImage#windows}");
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        const osType = this.windowsVersion ? ec2.OperatingSystemType.WINDOWS : ec2.OperatingSystemType.LINUX;
        return {
            imageId: ami,
            osType,
            userData: ec2.UserData.forOperatingSystem(osType),
        };
    }
}
exports.EcsOptimizedAmi = EcsOptimizedAmi;
_a = JSII_RTTI_SYMBOL_1;
EcsOptimizedAmi[_a] = { fqn: "monocdk.aws_ecs.EcsOptimizedAmi", version: "1.149.0" };
/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM
 */
class EcsOptimizedImage {
    /**
     * Constructs a new instance of the EcsOptimizedAmi class.
     */
    constructor(props) {
        var _d;
        this.hwType = props && props.hardwareType;
        if (props.windowsVersion) {
            this.windowsVersion = props.windowsVersion;
        }
        else if (props.generation) {
            this.generation = props.generation;
        }
        else {
            throw new Error('This error should never be thrown');
        }
        // set the SSM parameter name
        this.amiParameterName = '/aws/service/ecs/optimized-ami/'
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX ? 'amazon-linux/' : '')
            + (this.generation === ec2.AmazonLinuxGeneration.AMAZON_LINUX_2 ? 'amazon-linux-2/' : '')
            + (this.windowsVersion ? `windows_server/${this.windowsVersion}/english/full/` : '')
            + (this.hwType === AmiHardwareType.GPU ? 'gpu/' : '')
            + (this.hwType === AmiHardwareType.ARM ? 'arm64/' : '')
            + 'recommended/image_id';
        this.cachedInContext = (_d = props === null || props === void 0 ? void 0 : props.cachedInContext) !== null && _d !== void 0 ? _d : false;
    }
    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM
     *
     * @param hardwareType ECS-optimized AMI variant to use
     */
    static amazonLinux2(hardwareType = AmiHardwareType.STANDARD, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_AmiHardwareType(hardwareType);
        jsiiDeprecationWarnings.monocdk_aws_ecs_EcsOptimizedImageOptions(options);
        return new EcsOptimizedImage({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX_2,
            hardwareType,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM
     */
    static amazonLinux(options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_EcsOptimizedImageOptions(options);
        return new EcsOptimizedImage({
            generation: ec2.AmazonLinuxGeneration.AMAZON_LINUX,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Construct a Windows image from the latest ECS Optimized AMI published in SSM
     *
     * @param windowsVersion Windows Version to use
     */
    static windows(windowsVersion, options = {}) {
        jsiiDeprecationWarnings.monocdk_aws_ecs_WindowsOptimizedVersion(windowsVersion);
        jsiiDeprecationWarnings.monocdk_aws_ecs_EcsOptimizedImageOptions(options);
        return new EcsOptimizedImage({
            windowsVersion,
            cachedInContext: options.cachedInContext,
        });
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        const osType = this.windowsVersion ? ec2.OperatingSystemType.WINDOWS : ec2.OperatingSystemType.LINUX;
        return {
            imageId: ami,
            osType,
            userData: ec2.UserData.forOperatingSystem(osType),
        };
    }
}
exports.EcsOptimizedImage = EcsOptimizedImage;
_b = JSII_RTTI_SYMBOL_1;
EcsOptimizedImage[_b] = { fqn: "monocdk.aws_ecs.EcsOptimizedImage", version: "1.149.0" };
/**
 * Amazon ECS variant
 */
var BottlerocketEcsVariant;
(function (BottlerocketEcsVariant) {
    /**
     * aws-ecs-1 variant
     */
    BottlerocketEcsVariant["AWS_ECS_1"] = "aws-ecs-1";
})(BottlerocketEcsVariant = exports.BottlerocketEcsVariant || (exports.BottlerocketEcsVariant = {}));
/**
 * Construct an Bottlerocket image from the latest AMI published in SSM
 */
class BottleRocketImage {
    /**
     * Constructs a new instance of the BottleRocketImage class.
     */
    constructor(props = {}) {
        var _d, _e, _f;
        jsiiDeprecationWarnings.monocdk_aws_ecs_BottleRocketImageProps(props);
        this.variant = (_d = props.variant) !== null && _d !== void 0 ? _d : BottlerocketEcsVariant.AWS_ECS_1;
        this.architecture = (_e = props.architecture) !== null && _e !== void 0 ? _e : ec2.InstanceArchitecture.X86_64;
        // set the SSM parameter name
        this.amiParameterName = `/aws/service/bottlerocket/${this.variant}/${this.architecture}/latest/image_id`;
        this.cachedInContext = (_f = props.cachedInContext) !== null && _f !== void 0 ? _f : false;
    }
    /**
     * Return the correct image
     */
    getImage(scope) {
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        const ami = lookupImage(scope, this.cachedInContext, this.amiParameterName);
        return {
            imageId: ami,
            osType: ec2.OperatingSystemType.LINUX,
            userData: ec2.UserData.custom(''),
        };
    }
}
exports.BottleRocketImage = BottleRocketImage;
_c = JSII_RTTI_SYMBOL_1;
BottleRocketImage[_c] = { fqn: "monocdk.aws_ecs.BottleRocketImage", version: "1.149.0" };
function lookupImage(scope, cachedInContext, parameterName) {
    return cachedInContext
        ? ssm.StringParameter.valueFromLookup(scope, parameterName)
        : ssm.StringParameter.valueForTypedStringParameter(scope, parameterName, ssm.ParameterType.AWS_EC2_IMAGE_ID);
}
//# sourceMappingURL=data:application/json;base64,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