"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const path = require("path");
const ec2 = require("../../../aws-ec2");
const ecs = require("../../../aws-ecs");
const events = require("../../../aws-events");
const cdk = require("../../../core");
const lib_1 = require("../../lib");
const app = new cdk.App();
class EventStack extends cdk.Stack {
    constructor(scope, id) {
        super(scope, id);
        const vpc = new ec2.Vpc(this, 'Vpc', { maxAzs: 1 });
        const cluster = new ecs.Cluster(this, 'FargateCluster', { vpc });
        // Create the scheduled task
        new lib_1.ScheduledFargateTask(this, 'ScheduledFargateTask', {
            cluster,
            scheduledFargateTaskImageOptions: {
                image: new ecs.AssetImage(path.join(__dirname, '..', 'demo-image')),
                memoryLimitMiB: 512,
                cpu: 256,
                environment: { TRIGGER: 'CloudWatch Events' },
            },
            desiredTaskCount: 2,
            schedule: events.Schedule.rate(cdk.Duration.minutes(2)),
        });
    }
}
new EventStack(app, 'aws-fargate-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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