"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.TarballImageAsset = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const ecr = require("../../aws-ecr");
const core_1 = require("../../core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("../../core");
/**
 * An asset that represents a Docker image.
 *
 * The image will loaded from an existing tarball and uploaded to an ECR repository.
 */
class TarballImageAsset extends core_2.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_ecr_assets_TarballImageAssetProps(props);
        if (!fs.existsSync(props.tarballFile)) {
            throw new Error(`Cannot find file at ${props.tarballFile}`);
        }
        const stagedTarball = new core_1.AssetStaging(this, 'Staging', { sourcePath: props.tarballFile });
        this.sourceHash = stagedTarball.assetHash;
        this.assetHash = stagedTarball.assetHash;
        const stage = core_1.Stage.of(this);
        const relativePathInOutDir = stage ? path.relative(stage.assetOutdir, stagedTarball.absoluteStagedPath) : stagedTarball.absoluteStagedPath;
        const stack = core_1.Stack.of(this);
        const location = stack.synthesizer.addDockerImageAsset({
            sourceHash: stagedTarball.assetHash,
            executable: [
                'sh',
                '-c',
                `docker load -i ${relativePathInOutDir} | sed "s/Loaded image: //g"`,
            ],
        });
        this.repository = ecr.Repository.fromRepositoryName(this, 'Repository', location.repositoryName);
        this.imageUri = location.imageUri;
    }
}
exports.TarballImageAsset = TarballImageAsset;
_a = JSII_RTTI_SYMBOL_1;
TarballImageAsset[_a] = { fqn: "monocdk.aws_ecr_assets.TarballImageAsset", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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