"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoDBMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DynamoDBMetrics {
    static conditionalCheckFailedRequestsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConditionalCheckFailedRequests',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static consumedReadCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConsumedReadCapacityUnits',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static consumedWriteCapacityUnitsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConsumedWriteCapacityUnits',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static provisionedReadCapacityUnitsAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ProvisionedReadCapacityUnits',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static provisionedWriteCapacityUnitsAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ProvisionedWriteCapacityUnits',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readThrottleEventsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReadThrottleEvents',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static timeToLiveDeletedItemCountSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'TimeToLiveDeletedItemCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static transactionConflictAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'TransactionConflict',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static writeThrottleEventsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'WriteThrottleEvents',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static successfulRequestLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'SuccessfulRequestLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static systemErrorsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'SystemErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static throttledRequestsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ThrottledRequests',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static returnedItemCountSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReturnedItemCount',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static onlineIndexConsumedWriteCapacitySum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'OnlineIndexConsumedWriteCapacity',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static onlineIndexPercentageProgressAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'OnlineIndexPercentageProgress',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static onlineIndexThrottleEventsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'OnlineIndexThrottleEvents',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static ageOfOldestUnreplicatedRecordAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AgeOfOldestUnreplicatedRecord',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static consumedChangeDataCaptureUnitsAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ConsumedChangeDataCaptureUnits',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static throttledPutRecordCountAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ThrottledPutRecordCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static pendingReplicationCountAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'PendingReplicationCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static replicationLatencyAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReplicationLatency',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static returnedBytesAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReturnedBytes',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static returnedRecordsCountAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'ReturnedRecordsCount',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static accountMaxReadsMaximum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountMaxReads',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static accountMaxTableLevelReadsMaximum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountMaxTableLevelReads',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static accountMaxTableLevelWritesMaximum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountMaxTableLevelWrites',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static accountMaxWritesMaximum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountMaxWrites',
            dimensionsMap: dimensions,
            statistic: 'Maximum',
        };
    }
    static accountProvisionedReadCapacityUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountProvisionedReadCapacityUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static accountProvisionedWriteCapacityUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'AccountProvisionedWriteCapacityUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static maxProvisionedTableReadCapacityUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'MaxProvisionedTableReadCapacityUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static maxProvisionedTableWriteCapacityUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'MaxProvisionedTableWriteCapacityUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static userErrorsSum(dimensions) {
        return {
            namespace: 'AWS/DynamoDB',
            metricName: 'UserErrors',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DynamoDBMetrics = DynamoDBMetrics;
//# sourceMappingURL=data:application/json;base64,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