"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ClusterParameterGroup = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const docdb_generated_1 = require("./docdb.generated");
/**
 * A new cluster or instance parameter group
 */
class ClusterParameterGroupBase extends core_1.Resource {
    /**
     * Imports a parameter group
     */
    static fromParameterGroupName(scope, id, parameterGroupName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.parameterGroupName = parameterGroupName;
            }
        }
        return new Import(scope, id);
    }
}
/**
 * A cluster parameter group
 *
 * @resource AWS::DocDB::DBClusterParameterGroup
 */
class ClusterParameterGroup extends ClusterParameterGroupBase {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_docdb_ClusterParameterGroupProps(props);
        const resource = new docdb_generated_1.CfnDBClusterParameterGroup(this, 'Resource', {
            name: props.dbClusterParameterGroupName,
            description: props.description || `Cluster parameter group for ${props.family}`,
            family: props.family,
            parameters: props.parameters,
        });
        this.parameterGroupName = resource.ref;
    }
}
exports.ClusterParameterGroup = ClusterParameterGroup;
_a = JSII_RTTI_SYMBOL_1;
ClusterParameterGroup[_a] = { fqn: "monocdk.aws_docdb.ClusterParameterGroup", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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