"use strict";
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocDBMetrics = void 0;
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
class DocDBMetrics {
    static cpuUtilizationAverage(dimensions) {
        return {
            namespace: 'AWS/DocDB',
            metricName: 'CPUUtilization',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static databaseConnectionsAverage(dimensions) {
        return {
            namespace: 'AWS/DocDB',
            metricName: 'DatabaseConnections',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static engineUptimeAverage(dimensions) {
        return {
            namespace: 'AWS/DocDB',
            metricName: 'EngineUptime',
            dimensionsMap: dimensions,
            statistic: 'Average',
        };
    }
    static readThroughputSum(dimensions) {
        return {
            namespace: 'AWS/DocDB',
            metricName: 'ReadThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
    static writeThroughputSum(dimensions) {
        return {
            namespace: 'AWS/DocDB',
            metricName: 'WriteThroughput',
            dimensionsMap: dimensions,
            statistic: 'Sum',
        };
    }
}
exports.DocDBMetrics = DocDBMetrics;
//# sourceMappingURL=data:application/json;base64,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