"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DatabaseSecret = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_secretsmanager_1 = require("../../aws-secretsmanager");
const core_1 = require("../../core");
/**
 *
 * A database secret.
 *
 * @resource AWS::SecretsManager::Secret
 */
class DatabaseSecret extends aws_secretsmanager_1.Secret {
    constructor(scope, id, props) {
        var _b, _c;
        jsiiDeprecationWarnings.monocdk_aws_docdb_DatabaseSecretProps(props);
        const excludedCharacters = (_b = props.excludeCharacters) !== null && _b !== void 0 ? _b : '"@/';
        super(scope, id, {
            secretName: props.secretName,
            description: `Generated by the CDK for stack: ${core_1.Aws.STACK_NAME}`,
            encryptionKey: props.encryptionKey,
            // The CloudFormation resource provider for AWS::DocDB::DBCluster currently limits the DocDB master password to
            // 41 characters when pulling the password from secrets manager using a CloudFormation reference. This does not
            // line up with the CloudFormation resource specification which states a maximum of 100 characters:
            //
            // https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-docdb-dbcluster.html#cfn-docdb-dbcluster-masteruserpassword
            //
            // When attempting to exceed 41 characters, a deployment fails with the message:
            // Length of value for property {/MasterUserPassword} is greater than maximum allowed length {41}
            generateSecretString: {
                passwordLength: 41,
                secretStringTemplate: JSON.stringify({
                    username: props.username,
                    masterarn: (_c = props.masterSecret) === null || _c === void 0 ? void 0 : _c.secretArn,
                }),
                generateStringKey: 'password',
                excludeCharacters: excludedCharacters,
            },
        });
        this._excludedCharacters = excludedCharacters;
    }
}
exports.DatabaseSecret = DatabaseSecret;
_a = JSII_RTTI_SYMBOL_1;
DatabaseSecret[_a] = { fqn: "monocdk.aws_docdb.DatabaseSecret", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YWJhc2Utc2VjcmV0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGF0YWJhc2Utc2VjcmV0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7OztBQUNBLGlFQUEyRDtBQUMzRCxxQ0FBaUM7QUF5Q2pDOzs7OztHQUtHO0FBQ0gsTUFBYSxjQUFlLFNBQVEsMkJBQU07SUFReEMsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUEwQjs7O1FBQ2xFLE1BQU0sa0JBQWtCLFNBQUcsS0FBSyxDQUFDLGlCQUFpQixtQ0FBSSxLQUFLLENBQUM7UUFFNUQsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVU7WUFDNUIsV0FBVyxFQUFFLG1DQUFtQyxVQUFHLENBQUMsVUFBVSxFQUFFO1lBQ2hFLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQywrR0FBK0c7WUFDL0csK0dBQStHO1lBQy9HLG1HQUFtRztZQUNuRyxFQUFFO1lBQ0YsMElBQTBJO1lBQzFJLEVBQUU7WUFDRixnRkFBZ0Y7WUFDaEYsaUdBQWlHO1lBQ2pHLG9CQUFvQixFQUFFO2dCQUNwQixjQUFjLEVBQUUsRUFBRTtnQkFDbEIsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLFNBQVMsQ0FBQztvQkFDbkMsUUFBUSxFQUFFLEtBQUssQ0FBQyxRQUFRO29CQUN4QixTQUFTLFFBQUUsS0FBSyxDQUFDLFlBQVksMENBQUUsU0FBUztpQkFDekMsQ0FBQztnQkFDRixpQkFBaUIsRUFBRSxVQUFVO2dCQUM3QixpQkFBaUIsRUFBRSxrQkFBa0I7YUFDdEM7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsbUJBQW1CLEdBQUcsa0JBQWtCLENBQUM7S0FDL0M7O0FBbkNILHdDQW9DQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IElLZXkgfSBmcm9tICcuLi8uLi9hd3Mta21zJztcbmltcG9ydCB7IElTZWNyZXQsIFNlY3JldCB9IGZyb20gJy4uLy4uL2F3cy1zZWNyZXRzbWFuYWdlcic7XG5pbXBvcnQgeyBBd3MgfSBmcm9tICcuLi8uLi9jb3JlJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG4vKipcbiAqIENvbnN0cnVjdGlvbiBwcm9wZXJ0aWVzIGZvciBhIERhdGFiYXNlU2VjcmV0LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIERhdGFiYXNlU2VjcmV0UHJvcHMge1xuICAvKipcbiAgICogVGhlIHVzZXJuYW1lLlxuICAgKi9cbiAgcmVhZG9ubHkgdXNlcm5hbWU6IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEtNUyBrZXkgdG8gdXNlIHRvIGVuY3J5cHQgdGhlIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgZGVmYXVsdCBtYXN0ZXIga2V5XG4gICAqL1xuICByZWFkb25seSBlbmNyeXB0aW9uS2V5PzogSUtleTtcblxuICAvKipcbiAgICogVGhlIHBoeXNpY2FsIG5hbWUgb2YgdGhlIHNlY3JldFxuICAgKlxuICAgKiBAZGVmYXVsdCBTZWNyZXRzbWFuYWdlciB3aWxsIGdlbmVyYXRlIGEgcGh5c2ljYWwgbmFtZSBmb3IgdGhlIHNlY3JldFxuICAgKi9cbiAgcmVhZG9ubHkgc2VjcmV0TmFtZT86IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIG1hc3RlciBzZWNyZXQgd2hpY2ggd2lsbCBiZSB1c2VkIHRvIHJvdGF0ZSB0aGlzIHNlY3JldC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBtYXN0ZXIgc2VjcmV0IGluZm9ybWF0aW9uIHdpbGwgYmUgaW5jbHVkZWRcbiAgICovXG4gIHJlYWRvbmx5IG1hc3RlclNlY3JldD86IElTZWNyZXQ7XG5cbiAgLyoqXG4gICAqIENoYXJhY3RlcnMgdG8gbm90IGluY2x1ZGUgaW4gdGhlIGdlbmVyYXRlZCBwYXNzd29yZC5cbiAgICpcbiAgICogQGRlZmF1bHQgXCJcXFwiQC9cIlxuICAgKi9cbiAgcmVhZG9ubHkgZXhjbHVkZUNoYXJhY3RlcnM/OiBzdHJpbmc7XG59XG5cbi8qKlxuICpcbiAqIEEgZGF0YWJhc2Ugc2VjcmV0LlxuICpcbiAqIEByZXNvdXJjZSBBV1M6OlNlY3JldHNNYW5hZ2VyOjpTZWNyZXRcbiAqL1xuZXhwb3J0IGNsYXNzIERhdGFiYXNlU2VjcmV0IGV4dGVuZHMgU2VjcmV0IHtcblxuICAvKipcbiAgICogdGhlIGV4Y2x1ZGVkIGNoYXJhY3RlcnMgZm9yIHRoaXMgU2VjcmV0XG4gICAqIEBpbnRlcm5hbFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IF9leGNsdWRlZENoYXJhY3RlcnM6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogRGF0YWJhc2VTZWNyZXRQcm9wcykge1xuICAgIGNvbnN0IGV4Y2x1ZGVkQ2hhcmFjdGVycyA9IHByb3BzLmV4Y2x1ZGVDaGFyYWN0ZXJzID8/ICdcIkAvJztcblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgc2VjcmV0TmFtZTogcHJvcHMuc2VjcmV0TmFtZSxcbiAgICAgIGRlc2NyaXB0aW9uOiBgR2VuZXJhdGVkIGJ5IHRoZSBDREsgZm9yIHN0YWNrOiAke0F3cy5TVEFDS19OQU1FfWAsXG4gICAgICBlbmNyeXB0aW9uS2V5OiBwcm9wcy5lbmNyeXB0aW9uS2V5LFxuICAgICAgLy8gVGhlIENsb3VkRm9ybWF0aW9uIHJlc291cmNlIHByb3ZpZGVyIGZvciBBV1M6OkRvY0RCOjpEQkNsdXN0ZXIgY3VycmVudGx5IGxpbWl0cyB0aGUgRG9jREIgbWFzdGVyIHBhc3N3b3JkIHRvXG4gICAgICAvLyA0MSBjaGFyYWN0ZXJzIHdoZW4gcHVsbGluZyB0aGUgcGFzc3dvcmQgZnJvbSBzZWNyZXRzIG1hbmFnZXIgdXNpbmcgYSBDbG91ZEZvcm1hdGlvbiByZWZlcmVuY2UuIFRoaXMgZG9lcyBub3RcbiAgICAgIC8vIGxpbmUgdXAgd2l0aCB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2Ugc3BlY2lmaWNhdGlvbiB3aGljaCBzdGF0ZXMgYSBtYXhpbXVtIG9mIDEwMCBjaGFyYWN0ZXJzOlxuICAgICAgLy9cbiAgICAgIC8vIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1kb2NkYi1kYmNsdXN0ZXIuaHRtbCNjZm4tZG9jZGItZGJjbHVzdGVyLW1hc3RlcnVzZXJwYXNzd29yZFxuICAgICAgLy9cbiAgICAgIC8vIFdoZW4gYXR0ZW1wdGluZyB0byBleGNlZWQgNDEgY2hhcmFjdGVycywgYSBkZXBsb3ltZW50IGZhaWxzIHdpdGggdGhlIG1lc3NhZ2U6XG4gICAgICAvLyBMZW5ndGggb2YgdmFsdWUgZm9yIHByb3BlcnR5IHsvTWFzdGVyVXNlclBhc3N3b3JkfSBpcyBncmVhdGVyIHRoYW4gbWF4aW11bSBhbGxvd2VkIGxlbmd0aCB7NDF9XG4gICAgICBnZW5lcmF0ZVNlY3JldFN0cmluZzoge1xuICAgICAgICBwYXNzd29yZExlbmd0aDogNDEsXG4gICAgICAgIHNlY3JldFN0cmluZ1RlbXBsYXRlOiBKU09OLnN0cmluZ2lmeSh7XG4gICAgICAgICAgdXNlcm5hbWU6IHByb3BzLnVzZXJuYW1lLFxuICAgICAgICAgIG1hc3RlcmFybjogcHJvcHMubWFzdGVyU2VjcmV0Py5zZWNyZXRBcm4sXG4gICAgICAgIH0pLFxuICAgICAgICBnZW5lcmF0ZVN0cmluZ0tleTogJ3Bhc3N3b3JkJyxcbiAgICAgICAgZXhjbHVkZUNoYXJhY3RlcnM6IGV4Y2x1ZGVkQ2hhcmFjdGVycyxcbiAgICAgIH0sXG4gICAgfSk7XG5cbiAgICB0aGlzLl9leGNsdWRlZENoYXJhY3RlcnMgPSBleGNsdWRlZENoYXJhY3RlcnM7XG4gIH1cbn1cbiJdfQ==