"use strict";
var _a, _b, _c, _d, _e, _f;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicationTask = exports.CfnReplicationSubnetGroup = exports.CfnReplicationInstance = exports.CfnEventSubscription = exports.CfnEndpoint = exports.CfnCertificate = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.758Z","fingerprint":"vDQW/lig7kwKU4mulHzzBMgi+kDPxC67MYaL3cY/MG8="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnCertificateProps`
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the result of the validation.
 */
function CfnCertificatePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateIdentifier', cdk.validateString)(properties.certificateIdentifier));
    errors.collect(cdk.propertyValidator('certificatePem', cdk.validateString)(properties.certificatePem));
    errors.collect(cdk.propertyValidator('certificateWallet', cdk.validateString)(properties.certificateWallet));
    return errors.wrap('supplied properties not correct for "CfnCertificateProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Certificate` resource
 *
 * @param properties - the TypeScript properties of a `CfnCertificateProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Certificate` resource.
 */
// @ts-ignore TS6133
function cfnCertificatePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnCertificatePropsValidator(properties).assertSuccess();
    return {
        CertificateIdentifier: cdk.stringToCloudFormation(properties.certificateIdentifier),
        CertificatePem: cdk.stringToCloudFormation(properties.certificatePem),
        CertificateWallet: cdk.stringToCloudFormation(properties.certificateWallet),
    };
}
// @ts-ignore TS6133
function CfnCertificatePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('certificateIdentifier', 'CertificateIdentifier', properties.CertificateIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateIdentifier) : undefined);
    ret.addPropertyResult('certificatePem', 'CertificatePem', properties.CertificatePem != null ? cfn_parse.FromCloudFormation.getString(properties.CertificatePem) : undefined);
    ret.addPropertyResult('certificateWallet', 'CertificateWallet', properties.CertificateWallet != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateWallet) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::Certificate`
 *
 * The `AWS::DMS::Certificate` resource creates an SSL certificate that encrypts connections between AWS DMS endpoints and the replication instance.
 *
 * @cloudformationResource AWS::DMS::Certificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-certificate.html
 */
class CfnCertificate extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props = {}) {
        super(scope, id, { type: CfnCertificate.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnCertificateProps(props);
        this.certificateIdentifier = props.certificateIdentifier;
        this.certificatePem = props.certificatePem;
        this.certificateWallet = props.certificateWallet;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnCertificatePropsFromCloudFormation(resourceProperties);
        const ret = new CfnCertificate(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnCertificate.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            certificateIdentifier: this.certificateIdentifier,
            certificatePem: this.certificatePem,
            certificateWallet: this.certificateWallet,
        };
    }
    renderProperties(props) {
        return cfnCertificatePropsToCloudFormation(props);
    }
}
exports.CfnCertificate = CfnCertificate;
_a = JSII_RTTI_SYMBOL_1;
CfnCertificate[_a] = { fqn: "monocdk.aws_dms.CfnCertificate", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnCertificate.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Certificate";
/**
 * Determine whether the given properties match those of a `CfnEndpointProps`
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the result of the validation.
 */
function CfnEndpointPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('certificateArn', cdk.validateString)(properties.certificateArn));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('docDbSettings', CfnEndpoint_DocDbSettingsPropertyValidator)(properties.docDbSettings));
    errors.collect(cdk.propertyValidator('dynamoDbSettings', CfnEndpoint_DynamoDbSettingsPropertyValidator)(properties.dynamoDbSettings));
    errors.collect(cdk.propertyValidator('elasticsearchSettings', CfnEndpoint_ElasticsearchSettingsPropertyValidator)(properties.elasticsearchSettings));
    errors.collect(cdk.propertyValidator('endpointIdentifier', cdk.validateString)(properties.endpointIdentifier));
    errors.collect(cdk.propertyValidator('endpointType', cdk.requiredValidator)(properties.endpointType));
    errors.collect(cdk.propertyValidator('endpointType', cdk.validateString)(properties.endpointType));
    errors.collect(cdk.propertyValidator('engineName', cdk.requiredValidator)(properties.engineName));
    errors.collect(cdk.propertyValidator('engineName', cdk.validateString)(properties.engineName));
    errors.collect(cdk.propertyValidator('extraConnectionAttributes', cdk.validateString)(properties.extraConnectionAttributes));
    errors.collect(cdk.propertyValidator('gcpMySqlSettings', CfnEndpoint_GcpMySQLSettingsPropertyValidator)(properties.gcpMySqlSettings));
    errors.collect(cdk.propertyValidator('ibmDb2Settings', CfnEndpoint_IbmDb2SettingsPropertyValidator)(properties.ibmDb2Settings));
    errors.collect(cdk.propertyValidator('kafkaSettings', CfnEndpoint_KafkaSettingsPropertyValidator)(properties.kafkaSettings));
    errors.collect(cdk.propertyValidator('kinesisSettings', CfnEndpoint_KinesisSettingsPropertyValidator)(properties.kinesisSettings));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('microsoftSqlServerSettings', CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator)(properties.microsoftSqlServerSettings));
    errors.collect(cdk.propertyValidator('mongoDbSettings', CfnEndpoint_MongoDbSettingsPropertyValidator)(properties.mongoDbSettings));
    errors.collect(cdk.propertyValidator('mySqlSettings', CfnEndpoint_MySqlSettingsPropertyValidator)(properties.mySqlSettings));
    errors.collect(cdk.propertyValidator('neptuneSettings', CfnEndpoint_NeptuneSettingsPropertyValidator)(properties.neptuneSettings));
    errors.collect(cdk.propertyValidator('oracleSettings', CfnEndpoint_OracleSettingsPropertyValidator)(properties.oracleSettings));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('postgreSqlSettings', CfnEndpoint_PostgreSqlSettingsPropertyValidator)(properties.postgreSqlSettings));
    errors.collect(cdk.propertyValidator('redisSettings', CfnEndpoint_RedisSettingsPropertyValidator)(properties.redisSettings));
    errors.collect(cdk.propertyValidator('redshiftSettings', CfnEndpoint_RedshiftSettingsPropertyValidator)(properties.redshiftSettings));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('s3Settings', CfnEndpoint_S3SettingsPropertyValidator)(properties.s3Settings));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('sslMode', cdk.validateString)(properties.sslMode));
    errors.collect(cdk.propertyValidator('sybaseSettings', CfnEndpoint_SybaseSettingsPropertyValidator)(properties.sybaseSettings));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "CfnEndpointProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint` resource
 *
 * @param properties - the TypeScript properties of a `CfnEndpointProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint` resource.
 */
// @ts-ignore TS6133
function cfnEndpointPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpointPropsValidator(properties).assertSuccess();
    return {
        EndpointType: cdk.stringToCloudFormation(properties.endpointType),
        EngineName: cdk.stringToCloudFormation(properties.engineName),
        CertificateArn: cdk.stringToCloudFormation(properties.certificateArn),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DocDbSettings: cfnEndpointDocDbSettingsPropertyToCloudFormation(properties.docDbSettings),
        DynamoDbSettings: cfnEndpointDynamoDbSettingsPropertyToCloudFormation(properties.dynamoDbSettings),
        ElasticsearchSettings: cfnEndpointElasticsearchSettingsPropertyToCloudFormation(properties.elasticsearchSettings),
        EndpointIdentifier: cdk.stringToCloudFormation(properties.endpointIdentifier),
        ExtraConnectionAttributes: cdk.stringToCloudFormation(properties.extraConnectionAttributes),
        GcpMySQLSettings: cfnEndpointGcpMySQLSettingsPropertyToCloudFormation(properties.gcpMySqlSettings),
        IbmDb2Settings: cfnEndpointIbmDb2SettingsPropertyToCloudFormation(properties.ibmDb2Settings),
        KafkaSettings: cfnEndpointKafkaSettingsPropertyToCloudFormation(properties.kafkaSettings),
        KinesisSettings: cfnEndpointKinesisSettingsPropertyToCloudFormation(properties.kinesisSettings),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MicrosoftSqlServerSettings: cfnEndpointMicrosoftSqlServerSettingsPropertyToCloudFormation(properties.microsoftSqlServerSettings),
        MongoDbSettings: cfnEndpointMongoDbSettingsPropertyToCloudFormation(properties.mongoDbSettings),
        MySqlSettings: cfnEndpointMySqlSettingsPropertyToCloudFormation(properties.mySqlSettings),
        NeptuneSettings: cfnEndpointNeptuneSettingsPropertyToCloudFormation(properties.neptuneSettings),
        OracleSettings: cfnEndpointOracleSettingsPropertyToCloudFormation(properties.oracleSettings),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        PostgreSqlSettings: cfnEndpointPostgreSqlSettingsPropertyToCloudFormation(properties.postgreSqlSettings),
        RedisSettings: cfnEndpointRedisSettingsPropertyToCloudFormation(properties.redisSettings),
        RedshiftSettings: cfnEndpointRedshiftSettingsPropertyToCloudFormation(properties.redshiftSettings),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        S3Settings: cfnEndpointS3SettingsPropertyToCloudFormation(properties.s3Settings),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SslMode: cdk.stringToCloudFormation(properties.sslMode),
        SybaseSettings: cfnEndpointSybaseSettingsPropertyToCloudFormation(properties.sybaseSettings),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointType', 'EndpointType', cfn_parse.FromCloudFormation.getString(properties.EndpointType));
    ret.addPropertyResult('engineName', 'EngineName', cfn_parse.FromCloudFormation.getString(properties.EngineName));
    ret.addPropertyResult('certificateArn', 'CertificateArn', properties.CertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.CertificateArn) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('docDbSettings', 'DocDbSettings', properties.DocDbSettings != null ? CfnEndpointDocDbSettingsPropertyFromCloudFormation(properties.DocDbSettings) : undefined);
    ret.addPropertyResult('dynamoDbSettings', 'DynamoDbSettings', properties.DynamoDbSettings != null ? CfnEndpointDynamoDbSettingsPropertyFromCloudFormation(properties.DynamoDbSettings) : undefined);
    ret.addPropertyResult('elasticsearchSettings', 'ElasticsearchSettings', properties.ElasticsearchSettings != null ? CfnEndpointElasticsearchSettingsPropertyFromCloudFormation(properties.ElasticsearchSettings) : undefined);
    ret.addPropertyResult('endpointIdentifier', 'EndpointIdentifier', properties.EndpointIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointIdentifier) : undefined);
    ret.addPropertyResult('extraConnectionAttributes', 'ExtraConnectionAttributes', properties.ExtraConnectionAttributes != null ? cfn_parse.FromCloudFormation.getString(properties.ExtraConnectionAttributes) : undefined);
    ret.addPropertyResult('gcpMySqlSettings', 'GcpMySQLSettings', properties.GcpMySQLSettings != null ? CfnEndpointGcpMySQLSettingsPropertyFromCloudFormation(properties.GcpMySQLSettings) : undefined);
    ret.addPropertyResult('ibmDb2Settings', 'IbmDb2Settings', properties.IbmDb2Settings != null ? CfnEndpointIbmDb2SettingsPropertyFromCloudFormation(properties.IbmDb2Settings) : undefined);
    ret.addPropertyResult('kafkaSettings', 'KafkaSettings', properties.KafkaSettings != null ? CfnEndpointKafkaSettingsPropertyFromCloudFormation(properties.KafkaSettings) : undefined);
    ret.addPropertyResult('kinesisSettings', 'KinesisSettings', properties.KinesisSettings != null ? CfnEndpointKinesisSettingsPropertyFromCloudFormation(properties.KinesisSettings) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('microsoftSqlServerSettings', 'MicrosoftSqlServerSettings', properties.MicrosoftSqlServerSettings != null ? CfnEndpointMicrosoftSqlServerSettingsPropertyFromCloudFormation(properties.MicrosoftSqlServerSettings) : undefined);
    ret.addPropertyResult('mongoDbSettings', 'MongoDbSettings', properties.MongoDbSettings != null ? CfnEndpointMongoDbSettingsPropertyFromCloudFormation(properties.MongoDbSettings) : undefined);
    ret.addPropertyResult('mySqlSettings', 'MySqlSettings', properties.MySqlSettings != null ? CfnEndpointMySqlSettingsPropertyFromCloudFormation(properties.MySqlSettings) : undefined);
    ret.addPropertyResult('neptuneSettings', 'NeptuneSettings', properties.NeptuneSettings != null ? CfnEndpointNeptuneSettingsPropertyFromCloudFormation(properties.NeptuneSettings) : undefined);
    ret.addPropertyResult('oracleSettings', 'OracleSettings', properties.OracleSettings != null ? CfnEndpointOracleSettingsPropertyFromCloudFormation(properties.OracleSettings) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('postgreSqlSettings', 'PostgreSqlSettings', properties.PostgreSqlSettings != null ? CfnEndpointPostgreSqlSettingsPropertyFromCloudFormation(properties.PostgreSqlSettings) : undefined);
    ret.addPropertyResult('redisSettings', 'RedisSettings', properties.RedisSettings != null ? CfnEndpointRedisSettingsPropertyFromCloudFormation(properties.RedisSettings) : undefined);
    ret.addPropertyResult('redshiftSettings', 'RedshiftSettings', properties.RedshiftSettings != null ? CfnEndpointRedshiftSettingsPropertyFromCloudFormation(properties.RedshiftSettings) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('s3Settings', 'S3Settings', properties.S3Settings != null ? CfnEndpointS3SettingsPropertyFromCloudFormation(properties.S3Settings) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('sslMode', 'SslMode', properties.SslMode != null ? cfn_parse.FromCloudFormation.getString(properties.SslMode) : undefined);
    ret.addPropertyResult('sybaseSettings', 'SybaseSettings', properties.SybaseSettings != null ? CfnEndpointSybaseSettingsPropertyFromCloudFormation(properties.SybaseSettings) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::Endpoint`
 *
 * The `AWS::DMS::Endpoint` resource creates an AWS DMS endpoint.
 *
 * Currently, the only endpoint setting types that AWS CloudFormation supports are *DynamoDBSettings* , *ElasticSearchSettings* , and *NeptuneSettings* .
 *
 * @cloudformationResource AWS::DMS::Endpoint
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-endpoint.html
 */
class CfnEndpoint extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::Endpoint`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEndpoint.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnEndpointProps(props);
        cdk.requireProperty(props, 'endpointType', this);
        cdk.requireProperty(props, 'engineName', this);
        this.attrExternalId = cdk.Token.asString(this.getAtt('ExternalId'));
        this.endpointType = props.endpointType;
        this.engineName = props.engineName;
        this.certificateArn = props.certificateArn;
        this.databaseName = props.databaseName;
        this.docDbSettings = props.docDbSettings;
        this.dynamoDbSettings = props.dynamoDbSettings;
        this.elasticsearchSettings = props.elasticsearchSettings;
        this.endpointIdentifier = props.endpointIdentifier;
        this.extraConnectionAttributes = props.extraConnectionAttributes;
        this.gcpMySqlSettings = props.gcpMySqlSettings;
        this.ibmDb2Settings = props.ibmDb2Settings;
        this.kafkaSettings = props.kafkaSettings;
        this.kinesisSettings = props.kinesisSettings;
        this.kmsKeyId = props.kmsKeyId;
        this.microsoftSqlServerSettings = props.microsoftSqlServerSettings;
        this.mongoDbSettings = props.mongoDbSettings;
        this.mySqlSettings = props.mySqlSettings;
        this.neptuneSettings = props.neptuneSettings;
        this.oracleSettings = props.oracleSettings;
        this.password = props.password;
        this.port = props.port;
        this.postgreSqlSettings = props.postgreSqlSettings;
        this.redisSettings = props.redisSettings;
        this.redshiftSettings = props.redshiftSettings;
        this.resourceIdentifier = props.resourceIdentifier;
        this.s3Settings = props.s3Settings;
        this.serverName = props.serverName;
        this.sslMode = props.sslMode;
        this.sybaseSettings = props.sybaseSettings;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::Endpoint", props.tags, { tagPropertyName: 'tags' });
        this.username = props.username;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEndpointPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEndpoint(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEndpoint.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            endpointType: this.endpointType,
            engineName: this.engineName,
            certificateArn: this.certificateArn,
            databaseName: this.databaseName,
            docDbSettings: this.docDbSettings,
            dynamoDbSettings: this.dynamoDbSettings,
            elasticsearchSettings: this.elasticsearchSettings,
            endpointIdentifier: this.endpointIdentifier,
            extraConnectionAttributes: this.extraConnectionAttributes,
            gcpMySqlSettings: this.gcpMySqlSettings,
            ibmDb2Settings: this.ibmDb2Settings,
            kafkaSettings: this.kafkaSettings,
            kinesisSettings: this.kinesisSettings,
            kmsKeyId: this.kmsKeyId,
            microsoftSqlServerSettings: this.microsoftSqlServerSettings,
            mongoDbSettings: this.mongoDbSettings,
            mySqlSettings: this.mySqlSettings,
            neptuneSettings: this.neptuneSettings,
            oracleSettings: this.oracleSettings,
            password: this.password,
            port: this.port,
            postgreSqlSettings: this.postgreSqlSettings,
            redisSettings: this.redisSettings,
            redshiftSettings: this.redshiftSettings,
            resourceIdentifier: this.resourceIdentifier,
            s3Settings: this.s3Settings,
            serverName: this.serverName,
            sslMode: this.sslMode,
            sybaseSettings: this.sybaseSettings,
            tags: this.tags.renderTags(),
            username: this.username,
        };
    }
    renderProperties(props) {
        return cfnEndpointPropsToCloudFormation(props);
    }
}
exports.CfnEndpoint = CfnEndpoint;
_b = JSII_RTTI_SYMBOL_1;
CfnEndpoint[_b] = { fqn: "monocdk.aws_dms.CfnEndpoint", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEndpoint.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::Endpoint";
/**
 * Determine whether the given properties match those of a `DocDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DocDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_DocDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "DocDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DocDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `DocDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DocDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointDocDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_DocDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointDocDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `DynamoDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `DynamoDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_DynamoDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "DynamoDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DynamoDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `DynamoDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.DynamoDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointDynamoDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_DynamoDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointDynamoDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `ElasticsearchSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `ElasticsearchSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_ElasticsearchSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('endpointUri', cdk.validateString)(properties.endpointUri));
    errors.collect(cdk.propertyValidator('errorRetryDuration', cdk.validateNumber)(properties.errorRetryDuration));
    errors.collect(cdk.propertyValidator('fullLoadErrorPercentage', cdk.validateNumber)(properties.fullLoadErrorPercentage));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "ElasticsearchSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.ElasticsearchSettings` resource
 *
 * @param properties - the TypeScript properties of a `ElasticsearchSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.ElasticsearchSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointElasticsearchSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_ElasticsearchSettingsPropertyValidator(properties).assertSuccess();
    return {
        EndpointUri: cdk.stringToCloudFormation(properties.endpointUri),
        ErrorRetryDuration: cdk.numberToCloudFormation(properties.errorRetryDuration),
        FullLoadErrorPercentage: cdk.numberToCloudFormation(properties.fullLoadErrorPercentage),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointElasticsearchSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('endpointUri', 'EndpointUri', properties.EndpointUri != null ? cfn_parse.FromCloudFormation.getString(properties.EndpointUri) : undefined);
    ret.addPropertyResult('errorRetryDuration', 'ErrorRetryDuration', properties.ErrorRetryDuration != null ? cfn_parse.FromCloudFormation.getNumber(properties.ErrorRetryDuration) : undefined);
    ret.addPropertyResult('fullLoadErrorPercentage', 'FullLoadErrorPercentage', properties.FullLoadErrorPercentage != null ? cfn_parse.FromCloudFormation.getNumber(properties.FullLoadErrorPercentage) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `GcpMySQLSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `GcpMySQLSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_GcpMySQLSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('afterConnectScript', cdk.validateString)(properties.afterConnectScript));
    errors.collect(cdk.propertyValidator('cleanSourceMetadataOnMismatch', cdk.validateBoolean)(properties.cleanSourceMetadataOnMismatch));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('eventsPollInterval', cdk.validateNumber)(properties.eventsPollInterval));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('parallelLoadThreads', cdk.validateNumber)(properties.parallelLoadThreads));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('serverTimezone', cdk.validateString)(properties.serverTimezone));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "GcpMySQLSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.GcpMySQLSettings` resource
 *
 * @param properties - the TypeScript properties of a `GcpMySQLSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.GcpMySQLSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointGcpMySQLSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_GcpMySQLSettingsPropertyValidator(properties).assertSuccess();
    return {
        AfterConnectScript: cdk.stringToCloudFormation(properties.afterConnectScript),
        CleanSourceMetadataOnMismatch: cdk.booleanToCloudFormation(properties.cleanSourceMetadataOnMismatch),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        EventsPollInterval: cdk.numberToCloudFormation(properties.eventsPollInterval),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        ParallelLoadThreads: cdk.numberToCloudFormation(properties.parallelLoadThreads),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        ServerTimezone: cdk.stringToCloudFormation(properties.serverTimezone),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointGcpMySQLSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('afterConnectScript', 'AfterConnectScript', properties.AfterConnectScript != null ? cfn_parse.FromCloudFormation.getString(properties.AfterConnectScript) : undefined);
    ret.addPropertyResult('cleanSourceMetadataOnMismatch', 'CleanSourceMetadataOnMismatch', properties.CleanSourceMetadataOnMismatch != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CleanSourceMetadataOnMismatch) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('eventsPollInterval', 'EventsPollInterval', properties.EventsPollInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.EventsPollInterval) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('parallelLoadThreads', 'ParallelLoadThreads', properties.ParallelLoadThreads != null ? cfn_parse.FromCloudFormation.getNumber(properties.ParallelLoadThreads) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('serverTimezone', 'ServerTimezone', properties.ServerTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.ServerTimezone) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `IbmDb2SettingsProperty`
 *
 * @param properties - the TypeScript properties of a `IbmDb2SettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_IbmDb2SettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "IbmDb2SettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.IbmDb2Settings` resource
 *
 * @param properties - the TypeScript properties of a `IbmDb2SettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.IbmDb2Settings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointIbmDb2SettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_IbmDb2SettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointIbmDb2SettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KafkaSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KafkaSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_KafkaSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('broker', cdk.validateString)(properties.broker));
    errors.collect(cdk.propertyValidator('includeControlDetails', cdk.validateBoolean)(properties.includeControlDetails));
    errors.collect(cdk.propertyValidator('includeNullAndEmpty', cdk.validateBoolean)(properties.includeNullAndEmpty));
    errors.collect(cdk.propertyValidator('includeTableAlterOperations', cdk.validateBoolean)(properties.includeTableAlterOperations));
    errors.collect(cdk.propertyValidator('includeTransactionDetails', cdk.validateBoolean)(properties.includeTransactionDetails));
    errors.collect(cdk.propertyValidator('noHexPrefix', cdk.validateBoolean)(properties.noHexPrefix));
    errors.collect(cdk.propertyValidator('partitionIncludeSchemaTable', cdk.validateBoolean)(properties.partitionIncludeSchemaTable));
    errors.collect(cdk.propertyValidator('saslPassword', cdk.validateString)(properties.saslPassword));
    errors.collect(cdk.propertyValidator('saslUserName', cdk.validateString)(properties.saslUserName));
    errors.collect(cdk.propertyValidator('securityProtocol', cdk.validateString)(properties.securityProtocol));
    errors.collect(cdk.propertyValidator('sslCaCertificateArn', cdk.validateString)(properties.sslCaCertificateArn));
    errors.collect(cdk.propertyValidator('sslClientCertificateArn', cdk.validateString)(properties.sslClientCertificateArn));
    errors.collect(cdk.propertyValidator('sslClientKeyArn', cdk.validateString)(properties.sslClientKeyArn));
    errors.collect(cdk.propertyValidator('sslClientKeyPassword', cdk.validateString)(properties.sslClientKeyPassword));
    errors.collect(cdk.propertyValidator('topic', cdk.validateString)(properties.topic));
    return errors.wrap('supplied properties not correct for "KafkaSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KafkaSettings` resource
 *
 * @param properties - the TypeScript properties of a `KafkaSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KafkaSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointKafkaSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_KafkaSettingsPropertyValidator(properties).assertSuccess();
    return {
        Broker: cdk.stringToCloudFormation(properties.broker),
        IncludeControlDetails: cdk.booleanToCloudFormation(properties.includeControlDetails),
        IncludeNullAndEmpty: cdk.booleanToCloudFormation(properties.includeNullAndEmpty),
        IncludeTableAlterOperations: cdk.booleanToCloudFormation(properties.includeTableAlterOperations),
        IncludeTransactionDetails: cdk.booleanToCloudFormation(properties.includeTransactionDetails),
        NoHexPrefix: cdk.booleanToCloudFormation(properties.noHexPrefix),
        PartitionIncludeSchemaTable: cdk.booleanToCloudFormation(properties.partitionIncludeSchemaTable),
        SaslPassword: cdk.stringToCloudFormation(properties.saslPassword),
        SaslUserName: cdk.stringToCloudFormation(properties.saslUserName),
        SecurityProtocol: cdk.stringToCloudFormation(properties.securityProtocol),
        SslCaCertificateArn: cdk.stringToCloudFormation(properties.sslCaCertificateArn),
        SslClientCertificateArn: cdk.stringToCloudFormation(properties.sslClientCertificateArn),
        SslClientKeyArn: cdk.stringToCloudFormation(properties.sslClientKeyArn),
        SslClientKeyPassword: cdk.stringToCloudFormation(properties.sslClientKeyPassword),
        Topic: cdk.stringToCloudFormation(properties.topic),
    };
}
// @ts-ignore TS6133
function CfnEndpointKafkaSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('broker', 'Broker', properties.Broker != null ? cfn_parse.FromCloudFormation.getString(properties.Broker) : undefined);
    ret.addPropertyResult('includeControlDetails', 'IncludeControlDetails', properties.IncludeControlDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeControlDetails) : undefined);
    ret.addPropertyResult('includeNullAndEmpty', 'IncludeNullAndEmpty', properties.IncludeNullAndEmpty != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeNullAndEmpty) : undefined);
    ret.addPropertyResult('includeTableAlterOperations', 'IncludeTableAlterOperations', properties.IncludeTableAlterOperations != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTableAlterOperations) : undefined);
    ret.addPropertyResult('includeTransactionDetails', 'IncludeTransactionDetails', properties.IncludeTransactionDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTransactionDetails) : undefined);
    ret.addPropertyResult('noHexPrefix', 'NoHexPrefix', properties.NoHexPrefix != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoHexPrefix) : undefined);
    ret.addPropertyResult('partitionIncludeSchemaTable', 'PartitionIncludeSchemaTable', properties.PartitionIncludeSchemaTable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PartitionIncludeSchemaTable) : undefined);
    ret.addPropertyResult('saslPassword', 'SaslPassword', properties.SaslPassword != null ? cfn_parse.FromCloudFormation.getString(properties.SaslPassword) : undefined);
    ret.addPropertyResult('saslUserName', 'SaslUserName', properties.SaslUserName != null ? cfn_parse.FromCloudFormation.getString(properties.SaslUserName) : undefined);
    ret.addPropertyResult('securityProtocol', 'SecurityProtocol', properties.SecurityProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.SecurityProtocol) : undefined);
    ret.addPropertyResult('sslCaCertificateArn', 'SslCaCertificateArn', properties.SslCaCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslCaCertificateArn) : undefined);
    ret.addPropertyResult('sslClientCertificateArn', 'SslClientCertificateArn', properties.SslClientCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientCertificateArn) : undefined);
    ret.addPropertyResult('sslClientKeyArn', 'SslClientKeyArn', properties.SslClientKeyArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientKeyArn) : undefined);
    ret.addPropertyResult('sslClientKeyPassword', 'SslClientKeyPassword', properties.SslClientKeyPassword != null ? cfn_parse.FromCloudFormation.getString(properties.SslClientKeyPassword) : undefined);
    ret.addPropertyResult('topic', 'Topic', properties.Topic != null ? cfn_parse.FromCloudFormation.getString(properties.Topic) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `KinesisSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `KinesisSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_KinesisSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('includeControlDetails', cdk.validateBoolean)(properties.includeControlDetails));
    errors.collect(cdk.propertyValidator('includeNullAndEmpty', cdk.validateBoolean)(properties.includeNullAndEmpty));
    errors.collect(cdk.propertyValidator('includeTableAlterOperations', cdk.validateBoolean)(properties.includeTableAlterOperations));
    errors.collect(cdk.propertyValidator('includeTransactionDetails', cdk.validateBoolean)(properties.includeTransactionDetails));
    errors.collect(cdk.propertyValidator('messageFormat', cdk.validateString)(properties.messageFormat));
    errors.collect(cdk.propertyValidator('noHexPrefix', cdk.validateBoolean)(properties.noHexPrefix));
    errors.collect(cdk.propertyValidator('partitionIncludeSchemaTable', cdk.validateBoolean)(properties.partitionIncludeSchemaTable));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    errors.collect(cdk.propertyValidator('streamArn', cdk.validateString)(properties.streamArn));
    return errors.wrap('supplied properties not correct for "KinesisSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KinesisSettings` resource
 *
 * @param properties - the TypeScript properties of a `KinesisSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.KinesisSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointKinesisSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_KinesisSettingsPropertyValidator(properties).assertSuccess();
    return {
        IncludeControlDetails: cdk.booleanToCloudFormation(properties.includeControlDetails),
        IncludeNullAndEmpty: cdk.booleanToCloudFormation(properties.includeNullAndEmpty),
        IncludeTableAlterOperations: cdk.booleanToCloudFormation(properties.includeTableAlterOperations),
        IncludeTransactionDetails: cdk.booleanToCloudFormation(properties.includeTransactionDetails),
        MessageFormat: cdk.stringToCloudFormation(properties.messageFormat),
        NoHexPrefix: cdk.booleanToCloudFormation(properties.noHexPrefix),
        PartitionIncludeSchemaTable: cdk.booleanToCloudFormation(properties.partitionIncludeSchemaTable),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
        StreamArn: cdk.stringToCloudFormation(properties.streamArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointKinesisSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('includeControlDetails', 'IncludeControlDetails', properties.IncludeControlDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeControlDetails) : undefined);
    ret.addPropertyResult('includeNullAndEmpty', 'IncludeNullAndEmpty', properties.IncludeNullAndEmpty != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeNullAndEmpty) : undefined);
    ret.addPropertyResult('includeTableAlterOperations', 'IncludeTableAlterOperations', properties.IncludeTableAlterOperations != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTableAlterOperations) : undefined);
    ret.addPropertyResult('includeTransactionDetails', 'IncludeTransactionDetails', properties.IncludeTransactionDetails != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeTransactionDetails) : undefined);
    ret.addPropertyResult('messageFormat', 'MessageFormat', properties.MessageFormat != null ? cfn_parse.FromCloudFormation.getString(properties.MessageFormat) : undefined);
    ret.addPropertyResult('noHexPrefix', 'NoHexPrefix', properties.NoHexPrefix != null ? cfn_parse.FromCloudFormation.getBoolean(properties.NoHexPrefix) : undefined);
    ret.addPropertyResult('partitionIncludeSchemaTable', 'PartitionIncludeSchemaTable', properties.PartitionIncludeSchemaTable != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PartitionIncludeSchemaTable) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addPropertyResult('streamArn', 'StreamArn', properties.StreamArn != null ? cfn_parse.FromCloudFormation.getString(properties.StreamArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MicrosoftSqlServerSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MicrosoftSqlServerSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "MicrosoftSqlServerSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MicrosoftSqlServerSettings` resource
 *
 * @param properties - the TypeScript properties of a `MicrosoftSqlServerSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MicrosoftSqlServerSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMicrosoftSqlServerSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MicrosoftSqlServerSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointMicrosoftSqlServerSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MongoDbSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MongoDbSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MongoDbSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authMechanism', cdk.validateString)(properties.authMechanism));
    errors.collect(cdk.propertyValidator('authSource', cdk.validateString)(properties.authSource));
    errors.collect(cdk.propertyValidator('authType', cdk.validateString)(properties.authType));
    errors.collect(cdk.propertyValidator('databaseName', cdk.validateString)(properties.databaseName));
    errors.collect(cdk.propertyValidator('docsToInvestigate', cdk.validateString)(properties.docsToInvestigate));
    errors.collect(cdk.propertyValidator('extractDocId', cdk.validateString)(properties.extractDocId));
    errors.collect(cdk.propertyValidator('nestingLevel', cdk.validateString)(properties.nestingLevel));
    errors.collect(cdk.propertyValidator('password', cdk.validateString)(properties.password));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('username', cdk.validateString)(properties.username));
    return errors.wrap('supplied properties not correct for "MongoDbSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MongoDbSettings` resource
 *
 * @param properties - the TypeScript properties of a `MongoDbSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MongoDbSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMongoDbSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MongoDbSettingsPropertyValidator(properties).assertSuccess();
    return {
        AuthMechanism: cdk.stringToCloudFormation(properties.authMechanism),
        AuthSource: cdk.stringToCloudFormation(properties.authSource),
        AuthType: cdk.stringToCloudFormation(properties.authType),
        DatabaseName: cdk.stringToCloudFormation(properties.databaseName),
        DocsToInvestigate: cdk.stringToCloudFormation(properties.docsToInvestigate),
        ExtractDocId: cdk.stringToCloudFormation(properties.extractDocId),
        NestingLevel: cdk.stringToCloudFormation(properties.nestingLevel),
        Password: cdk.stringToCloudFormation(properties.password),
        Port: cdk.numberToCloudFormation(properties.port),
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        Username: cdk.stringToCloudFormation(properties.username),
    };
}
// @ts-ignore TS6133
function CfnEndpointMongoDbSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authMechanism', 'AuthMechanism', properties.AuthMechanism != null ? cfn_parse.FromCloudFormation.getString(properties.AuthMechanism) : undefined);
    ret.addPropertyResult('authSource', 'AuthSource', properties.AuthSource != null ? cfn_parse.FromCloudFormation.getString(properties.AuthSource) : undefined);
    ret.addPropertyResult('authType', 'AuthType', properties.AuthType != null ? cfn_parse.FromCloudFormation.getString(properties.AuthType) : undefined);
    ret.addPropertyResult('databaseName', 'DatabaseName', properties.DatabaseName != null ? cfn_parse.FromCloudFormation.getString(properties.DatabaseName) : undefined);
    ret.addPropertyResult('docsToInvestigate', 'DocsToInvestigate', properties.DocsToInvestigate != null ? cfn_parse.FromCloudFormation.getString(properties.DocsToInvestigate) : undefined);
    ret.addPropertyResult('extractDocId', 'ExtractDocId', properties.ExtractDocId != null ? cfn_parse.FromCloudFormation.getString(properties.ExtractDocId) : undefined);
    ret.addPropertyResult('nestingLevel', 'NestingLevel', properties.NestingLevel != null ? cfn_parse.FromCloudFormation.getString(properties.NestingLevel) : undefined);
    ret.addPropertyResult('password', 'Password', properties.Password != null ? cfn_parse.FromCloudFormation.getString(properties.Password) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('username', 'Username', properties.Username != null ? cfn_parse.FromCloudFormation.getString(properties.Username) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `MySqlSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `MySqlSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_MySqlSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "MySqlSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MySqlSettings` resource
 *
 * @param properties - the TypeScript properties of a `MySqlSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.MySqlSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointMySqlSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_MySqlSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointMySqlSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `NeptuneSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `NeptuneSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_NeptuneSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('errorRetryDuration', cdk.validateNumber)(properties.errorRetryDuration));
    errors.collect(cdk.propertyValidator('iamAuthEnabled', cdk.validateBoolean)(properties.iamAuthEnabled));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('maxRetryCount', cdk.validateNumber)(properties.maxRetryCount));
    errors.collect(cdk.propertyValidator('s3BucketFolder', cdk.validateString)(properties.s3BucketFolder));
    errors.collect(cdk.propertyValidator('s3BucketName', cdk.validateString)(properties.s3BucketName));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    return errors.wrap('supplied properties not correct for "NeptuneSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.NeptuneSettings` resource
 *
 * @param properties - the TypeScript properties of a `NeptuneSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.NeptuneSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointNeptuneSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_NeptuneSettingsPropertyValidator(properties).assertSuccess();
    return {
        ErrorRetryDuration: cdk.numberToCloudFormation(properties.errorRetryDuration),
        IamAuthEnabled: cdk.booleanToCloudFormation(properties.iamAuthEnabled),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        MaxRetryCount: cdk.numberToCloudFormation(properties.maxRetryCount),
        S3BucketFolder: cdk.stringToCloudFormation(properties.s3BucketFolder),
        S3BucketName: cdk.stringToCloudFormation(properties.s3BucketName),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
    };
}
// @ts-ignore TS6133
function CfnEndpointNeptuneSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('errorRetryDuration', 'ErrorRetryDuration', properties.ErrorRetryDuration != null ? cfn_parse.FromCloudFormation.getNumber(properties.ErrorRetryDuration) : undefined);
    ret.addPropertyResult('iamAuthEnabled', 'IamAuthEnabled', properties.IamAuthEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IamAuthEnabled) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('maxRetryCount', 'MaxRetryCount', properties.MaxRetryCount != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxRetryCount) : undefined);
    ret.addPropertyResult('s3BucketFolder', 'S3BucketFolder', properties.S3BucketFolder != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketFolder) : undefined);
    ret.addPropertyResult('s3BucketName', 'S3BucketName', properties.S3BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.S3BucketName) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `OracleSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `OracleSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_OracleSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerOracleAsmAccessRoleArn', cdk.validateString)(properties.secretsManagerOracleAsmAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerOracleAsmSecretId', cdk.validateString)(properties.secretsManagerOracleAsmSecretId));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "OracleSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.OracleSettings` resource
 *
 * @param properties - the TypeScript properties of a `OracleSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.OracleSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointOracleSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_OracleSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerOracleAsmAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerOracleAsmAccessRoleArn),
        SecretsManagerOracleAsmSecretId: cdk.stringToCloudFormation(properties.secretsManagerOracleAsmSecretId),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointOracleSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerOracleAsmAccessRoleArn', 'SecretsManagerOracleAsmAccessRoleArn', properties.SecretsManagerOracleAsmAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerOracleAsmAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerOracleAsmSecretId', 'SecretsManagerOracleAsmSecretId', properties.SecretsManagerOracleAsmSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerOracleAsmSecretId) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `PostgreSqlSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `PostgreSqlSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_PostgreSqlSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "PostgreSqlSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.PostgreSqlSettings` resource
 *
 * @param properties - the TypeScript properties of a `PostgreSqlSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.PostgreSqlSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointPostgreSqlSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_PostgreSqlSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointPostgreSqlSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RedisSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RedisSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_RedisSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('authPassword', cdk.validateString)(properties.authPassword));
    errors.collect(cdk.propertyValidator('authType', cdk.validateString)(properties.authType));
    errors.collect(cdk.propertyValidator('authUserName', cdk.validateString)(properties.authUserName));
    errors.collect(cdk.propertyValidator('port', cdk.validateNumber)(properties.port));
    errors.collect(cdk.propertyValidator('serverName', cdk.validateString)(properties.serverName));
    errors.collect(cdk.propertyValidator('sslCaCertificateArn', cdk.validateString)(properties.sslCaCertificateArn));
    errors.collect(cdk.propertyValidator('sslSecurityProtocol', cdk.validateString)(properties.sslSecurityProtocol));
    return errors.wrap('supplied properties not correct for "RedisSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedisSettings` resource
 *
 * @param properties - the TypeScript properties of a `RedisSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedisSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointRedisSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_RedisSettingsPropertyValidator(properties).assertSuccess();
    return {
        AuthPassword: cdk.stringToCloudFormation(properties.authPassword),
        AuthType: cdk.stringToCloudFormation(properties.authType),
        AuthUserName: cdk.stringToCloudFormation(properties.authUserName),
        Port: cdk.numberToCloudFormation(properties.port),
        ServerName: cdk.stringToCloudFormation(properties.serverName),
        SslCaCertificateArn: cdk.stringToCloudFormation(properties.sslCaCertificateArn),
        SslSecurityProtocol: cdk.stringToCloudFormation(properties.sslSecurityProtocol),
    };
}
// @ts-ignore TS6133
function CfnEndpointRedisSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('authPassword', 'AuthPassword', properties.AuthPassword != null ? cfn_parse.FromCloudFormation.getString(properties.AuthPassword) : undefined);
    ret.addPropertyResult('authType', 'AuthType', properties.AuthType != null ? cfn_parse.FromCloudFormation.getString(properties.AuthType) : undefined);
    ret.addPropertyResult('authUserName', 'AuthUserName', properties.AuthUserName != null ? cfn_parse.FromCloudFormation.getString(properties.AuthUserName) : undefined);
    ret.addPropertyResult('port', 'Port', properties.Port != null ? cfn_parse.FromCloudFormation.getNumber(properties.Port) : undefined);
    ret.addPropertyResult('serverName', 'ServerName', properties.ServerName != null ? cfn_parse.FromCloudFormation.getString(properties.ServerName) : undefined);
    ret.addPropertyResult('sslCaCertificateArn', 'SslCaCertificateArn', properties.SslCaCertificateArn != null ? cfn_parse.FromCloudFormation.getString(properties.SslCaCertificateArn) : undefined);
    ret.addPropertyResult('sslSecurityProtocol', 'SslSecurityProtocol', properties.SslSecurityProtocol != null ? cfn_parse.FromCloudFormation.getString(properties.SslSecurityProtocol) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `RedshiftSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `RedshiftSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_RedshiftSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "RedshiftSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedshiftSettings` resource
 *
 * @param properties - the TypeScript properties of a `RedshiftSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.RedshiftSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointRedshiftSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_RedshiftSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointRedshiftSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `S3SettingsProperty`
 *
 * @param properties - the TypeScript properties of a `S3SettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_S3SettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('addColumnName', cdk.validateBoolean)(properties.addColumnName));
    errors.collect(cdk.propertyValidator('bucketFolder', cdk.validateString)(properties.bucketFolder));
    errors.collect(cdk.propertyValidator('bucketName', cdk.validateString)(properties.bucketName));
    errors.collect(cdk.propertyValidator('cannedAclForObjects', cdk.validateString)(properties.cannedAclForObjects));
    errors.collect(cdk.propertyValidator('cdcInsertsAndUpdates', cdk.validateBoolean)(properties.cdcInsertsAndUpdates));
    errors.collect(cdk.propertyValidator('cdcInsertsOnly', cdk.validateBoolean)(properties.cdcInsertsOnly));
    errors.collect(cdk.propertyValidator('cdcMaxBatchInterval', cdk.validateNumber)(properties.cdcMaxBatchInterval));
    errors.collect(cdk.propertyValidator('cdcMinFileSize', cdk.validateNumber)(properties.cdcMinFileSize));
    errors.collect(cdk.propertyValidator('cdcPath', cdk.validateString)(properties.cdcPath));
    errors.collect(cdk.propertyValidator('compressionType', cdk.validateString)(properties.compressionType));
    errors.collect(cdk.propertyValidator('csvDelimiter', cdk.validateString)(properties.csvDelimiter));
    errors.collect(cdk.propertyValidator('csvNoSupValue', cdk.validateString)(properties.csvNoSupValue));
    errors.collect(cdk.propertyValidator('csvNullValue', cdk.validateString)(properties.csvNullValue));
    errors.collect(cdk.propertyValidator('csvRowDelimiter', cdk.validateString)(properties.csvRowDelimiter));
    errors.collect(cdk.propertyValidator('dataFormat', cdk.validateString)(properties.dataFormat));
    errors.collect(cdk.propertyValidator('dataPageSize', cdk.validateNumber)(properties.dataPageSize));
    errors.collect(cdk.propertyValidator('datePartitionDelimiter', cdk.validateString)(properties.datePartitionDelimiter));
    errors.collect(cdk.propertyValidator('datePartitionEnabled', cdk.validateBoolean)(properties.datePartitionEnabled));
    errors.collect(cdk.propertyValidator('datePartitionSequence', cdk.validateString)(properties.datePartitionSequence));
    errors.collect(cdk.propertyValidator('datePartitionTimezone', cdk.validateString)(properties.datePartitionTimezone));
    errors.collect(cdk.propertyValidator('dictPageSizeLimit', cdk.validateNumber)(properties.dictPageSizeLimit));
    errors.collect(cdk.propertyValidator('enableStatistics', cdk.validateBoolean)(properties.enableStatistics));
    errors.collect(cdk.propertyValidator('encodingType', cdk.validateString)(properties.encodingType));
    errors.collect(cdk.propertyValidator('encryptionMode', cdk.validateString)(properties.encryptionMode));
    errors.collect(cdk.propertyValidator('externalTableDefinition', cdk.validateString)(properties.externalTableDefinition));
    errors.collect(cdk.propertyValidator('ignoreHeaderRows', cdk.validateNumber)(properties.ignoreHeaderRows));
    errors.collect(cdk.propertyValidator('includeOpForFullLoad', cdk.validateBoolean)(properties.includeOpForFullLoad));
    errors.collect(cdk.propertyValidator('maxFileSize', cdk.validateNumber)(properties.maxFileSize));
    errors.collect(cdk.propertyValidator('parquetTimestampInMillisecond', cdk.validateBoolean)(properties.parquetTimestampInMillisecond));
    errors.collect(cdk.propertyValidator('parquetVersion', cdk.validateString)(properties.parquetVersion));
    errors.collect(cdk.propertyValidator('preserveTransactions', cdk.validateBoolean)(properties.preserveTransactions));
    errors.collect(cdk.propertyValidator('rfc4180', cdk.validateBoolean)(properties.rfc4180));
    errors.collect(cdk.propertyValidator('rowGroupLength', cdk.validateNumber)(properties.rowGroupLength));
    errors.collect(cdk.propertyValidator('serverSideEncryptionKmsKeyId', cdk.validateString)(properties.serverSideEncryptionKmsKeyId));
    errors.collect(cdk.propertyValidator('serviceAccessRoleArn', cdk.validateString)(properties.serviceAccessRoleArn));
    errors.collect(cdk.propertyValidator('timestampColumnName', cdk.validateString)(properties.timestampColumnName));
    errors.collect(cdk.propertyValidator('useCsvNoSupValue', cdk.validateBoolean)(properties.useCsvNoSupValue));
    errors.collect(cdk.propertyValidator('useTaskStartTimeForFullLoadTimestamp', cdk.validateBoolean)(properties.useTaskStartTimeForFullLoadTimestamp));
    return errors.wrap('supplied properties not correct for "S3SettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.S3Settings` resource
 *
 * @param properties - the TypeScript properties of a `S3SettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.S3Settings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointS3SettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_S3SettingsPropertyValidator(properties).assertSuccess();
    return {
        AddColumnName: cdk.booleanToCloudFormation(properties.addColumnName),
        BucketFolder: cdk.stringToCloudFormation(properties.bucketFolder),
        BucketName: cdk.stringToCloudFormation(properties.bucketName),
        CannedAclForObjects: cdk.stringToCloudFormation(properties.cannedAclForObjects),
        CdcInsertsAndUpdates: cdk.booleanToCloudFormation(properties.cdcInsertsAndUpdates),
        CdcInsertsOnly: cdk.booleanToCloudFormation(properties.cdcInsertsOnly),
        CdcMaxBatchInterval: cdk.numberToCloudFormation(properties.cdcMaxBatchInterval),
        CdcMinFileSize: cdk.numberToCloudFormation(properties.cdcMinFileSize),
        CdcPath: cdk.stringToCloudFormation(properties.cdcPath),
        CompressionType: cdk.stringToCloudFormation(properties.compressionType),
        CsvDelimiter: cdk.stringToCloudFormation(properties.csvDelimiter),
        CsvNoSupValue: cdk.stringToCloudFormation(properties.csvNoSupValue),
        CsvNullValue: cdk.stringToCloudFormation(properties.csvNullValue),
        CsvRowDelimiter: cdk.stringToCloudFormation(properties.csvRowDelimiter),
        DataFormat: cdk.stringToCloudFormation(properties.dataFormat),
        DataPageSize: cdk.numberToCloudFormation(properties.dataPageSize),
        DatePartitionDelimiter: cdk.stringToCloudFormation(properties.datePartitionDelimiter),
        DatePartitionEnabled: cdk.booleanToCloudFormation(properties.datePartitionEnabled),
        DatePartitionSequence: cdk.stringToCloudFormation(properties.datePartitionSequence),
        DatePartitionTimezone: cdk.stringToCloudFormation(properties.datePartitionTimezone),
        DictPageSizeLimit: cdk.numberToCloudFormation(properties.dictPageSizeLimit),
        EnableStatistics: cdk.booleanToCloudFormation(properties.enableStatistics),
        EncodingType: cdk.stringToCloudFormation(properties.encodingType),
        EncryptionMode: cdk.stringToCloudFormation(properties.encryptionMode),
        ExternalTableDefinition: cdk.stringToCloudFormation(properties.externalTableDefinition),
        IgnoreHeaderRows: cdk.numberToCloudFormation(properties.ignoreHeaderRows),
        IncludeOpForFullLoad: cdk.booleanToCloudFormation(properties.includeOpForFullLoad),
        MaxFileSize: cdk.numberToCloudFormation(properties.maxFileSize),
        ParquetTimestampInMillisecond: cdk.booleanToCloudFormation(properties.parquetTimestampInMillisecond),
        ParquetVersion: cdk.stringToCloudFormation(properties.parquetVersion),
        PreserveTransactions: cdk.booleanToCloudFormation(properties.preserveTransactions),
        Rfc4180: cdk.booleanToCloudFormation(properties.rfc4180),
        RowGroupLength: cdk.numberToCloudFormation(properties.rowGroupLength),
        ServerSideEncryptionKmsKeyId: cdk.stringToCloudFormation(properties.serverSideEncryptionKmsKeyId),
        ServiceAccessRoleArn: cdk.stringToCloudFormation(properties.serviceAccessRoleArn),
        TimestampColumnName: cdk.stringToCloudFormation(properties.timestampColumnName),
        UseCsvNoSupValue: cdk.booleanToCloudFormation(properties.useCsvNoSupValue),
        UseTaskStartTimeForFullLoadTimestamp: cdk.booleanToCloudFormation(properties.useTaskStartTimeForFullLoadTimestamp),
    };
}
// @ts-ignore TS6133
function CfnEndpointS3SettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('addColumnName', 'AddColumnName', properties.AddColumnName != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AddColumnName) : undefined);
    ret.addPropertyResult('bucketFolder', 'BucketFolder', properties.BucketFolder != null ? cfn_parse.FromCloudFormation.getString(properties.BucketFolder) : undefined);
    ret.addPropertyResult('bucketName', 'BucketName', properties.BucketName != null ? cfn_parse.FromCloudFormation.getString(properties.BucketName) : undefined);
    ret.addPropertyResult('cannedAclForObjects', 'CannedAclForObjects', properties.CannedAclForObjects != null ? cfn_parse.FromCloudFormation.getString(properties.CannedAclForObjects) : undefined);
    ret.addPropertyResult('cdcInsertsAndUpdates', 'CdcInsertsAndUpdates', properties.CdcInsertsAndUpdates != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CdcInsertsAndUpdates) : undefined);
    ret.addPropertyResult('cdcInsertsOnly', 'CdcInsertsOnly', properties.CdcInsertsOnly != null ? cfn_parse.FromCloudFormation.getBoolean(properties.CdcInsertsOnly) : undefined);
    ret.addPropertyResult('cdcMaxBatchInterval', 'CdcMaxBatchInterval', properties.CdcMaxBatchInterval != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcMaxBatchInterval) : undefined);
    ret.addPropertyResult('cdcMinFileSize', 'CdcMinFileSize', properties.CdcMinFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcMinFileSize) : undefined);
    ret.addPropertyResult('cdcPath', 'CdcPath', properties.CdcPath != null ? cfn_parse.FromCloudFormation.getString(properties.CdcPath) : undefined);
    ret.addPropertyResult('compressionType', 'CompressionType', properties.CompressionType != null ? cfn_parse.FromCloudFormation.getString(properties.CompressionType) : undefined);
    ret.addPropertyResult('csvDelimiter', 'CsvDelimiter', properties.CsvDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.CsvDelimiter) : undefined);
    ret.addPropertyResult('csvNoSupValue', 'CsvNoSupValue', properties.CsvNoSupValue != null ? cfn_parse.FromCloudFormation.getString(properties.CsvNoSupValue) : undefined);
    ret.addPropertyResult('csvNullValue', 'CsvNullValue', properties.CsvNullValue != null ? cfn_parse.FromCloudFormation.getString(properties.CsvNullValue) : undefined);
    ret.addPropertyResult('csvRowDelimiter', 'CsvRowDelimiter', properties.CsvRowDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.CsvRowDelimiter) : undefined);
    ret.addPropertyResult('dataFormat', 'DataFormat', properties.DataFormat != null ? cfn_parse.FromCloudFormation.getString(properties.DataFormat) : undefined);
    ret.addPropertyResult('dataPageSize', 'DataPageSize', properties.DataPageSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.DataPageSize) : undefined);
    ret.addPropertyResult('datePartitionDelimiter', 'DatePartitionDelimiter', properties.DatePartitionDelimiter != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionDelimiter) : undefined);
    ret.addPropertyResult('datePartitionEnabled', 'DatePartitionEnabled', properties.DatePartitionEnabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.DatePartitionEnabled) : undefined);
    ret.addPropertyResult('datePartitionSequence', 'DatePartitionSequence', properties.DatePartitionSequence != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionSequence) : undefined);
    ret.addPropertyResult('datePartitionTimezone', 'DatePartitionTimezone', properties.DatePartitionTimezone != null ? cfn_parse.FromCloudFormation.getString(properties.DatePartitionTimezone) : undefined);
    ret.addPropertyResult('dictPageSizeLimit', 'DictPageSizeLimit', properties.DictPageSizeLimit != null ? cfn_parse.FromCloudFormation.getNumber(properties.DictPageSizeLimit) : undefined);
    ret.addPropertyResult('enableStatistics', 'EnableStatistics', properties.EnableStatistics != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableStatistics) : undefined);
    ret.addPropertyResult('encodingType', 'EncodingType', properties.EncodingType != null ? cfn_parse.FromCloudFormation.getString(properties.EncodingType) : undefined);
    ret.addPropertyResult('encryptionMode', 'EncryptionMode', properties.EncryptionMode != null ? cfn_parse.FromCloudFormation.getString(properties.EncryptionMode) : undefined);
    ret.addPropertyResult('externalTableDefinition', 'ExternalTableDefinition', properties.ExternalTableDefinition != null ? cfn_parse.FromCloudFormation.getString(properties.ExternalTableDefinition) : undefined);
    ret.addPropertyResult('ignoreHeaderRows', 'IgnoreHeaderRows', properties.IgnoreHeaderRows != null ? cfn_parse.FromCloudFormation.getNumber(properties.IgnoreHeaderRows) : undefined);
    ret.addPropertyResult('includeOpForFullLoad', 'IncludeOpForFullLoad', properties.IncludeOpForFullLoad != null ? cfn_parse.FromCloudFormation.getBoolean(properties.IncludeOpForFullLoad) : undefined);
    ret.addPropertyResult('maxFileSize', 'MaxFileSize', properties.MaxFileSize != null ? cfn_parse.FromCloudFormation.getNumber(properties.MaxFileSize) : undefined);
    ret.addPropertyResult('parquetTimestampInMillisecond', 'ParquetTimestampInMillisecond', properties.ParquetTimestampInMillisecond != null ? cfn_parse.FromCloudFormation.getBoolean(properties.ParquetTimestampInMillisecond) : undefined);
    ret.addPropertyResult('parquetVersion', 'ParquetVersion', properties.ParquetVersion != null ? cfn_parse.FromCloudFormation.getString(properties.ParquetVersion) : undefined);
    ret.addPropertyResult('preserveTransactions', 'PreserveTransactions', properties.PreserveTransactions != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PreserveTransactions) : undefined);
    ret.addPropertyResult('rfc4180', 'Rfc4180', properties.Rfc4180 != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Rfc4180) : undefined);
    ret.addPropertyResult('rowGroupLength', 'RowGroupLength', properties.RowGroupLength != null ? cfn_parse.FromCloudFormation.getNumber(properties.RowGroupLength) : undefined);
    ret.addPropertyResult('serverSideEncryptionKmsKeyId', 'ServerSideEncryptionKmsKeyId', properties.ServerSideEncryptionKmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.ServerSideEncryptionKmsKeyId) : undefined);
    ret.addPropertyResult('serviceAccessRoleArn', 'ServiceAccessRoleArn', properties.ServiceAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.ServiceAccessRoleArn) : undefined);
    ret.addPropertyResult('timestampColumnName', 'TimestampColumnName', properties.TimestampColumnName != null ? cfn_parse.FromCloudFormation.getString(properties.TimestampColumnName) : undefined);
    ret.addPropertyResult('useCsvNoSupValue', 'UseCsvNoSupValue', properties.UseCsvNoSupValue != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseCsvNoSupValue) : undefined);
    ret.addPropertyResult('useTaskStartTimeForFullLoadTimestamp', 'UseTaskStartTimeForFullLoadTimestamp', properties.UseTaskStartTimeForFullLoadTimestamp != null ? cfn_parse.FromCloudFormation.getBoolean(properties.UseTaskStartTimeForFullLoadTimestamp) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `SybaseSettingsProperty`
 *
 * @param properties - the TypeScript properties of a `SybaseSettingsProperty`
 *
 * @returns the result of the validation.
 */
function CfnEndpoint_SybaseSettingsPropertyValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('secretsManagerAccessRoleArn', cdk.validateString)(properties.secretsManagerAccessRoleArn));
    errors.collect(cdk.propertyValidator('secretsManagerSecretId', cdk.validateString)(properties.secretsManagerSecretId));
    return errors.wrap('supplied properties not correct for "SybaseSettingsProperty"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::Endpoint.SybaseSettings` resource
 *
 * @param properties - the TypeScript properties of a `SybaseSettingsProperty`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::Endpoint.SybaseSettings` resource.
 */
// @ts-ignore TS6133
function cfnEndpointSybaseSettingsPropertyToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEndpoint_SybaseSettingsPropertyValidator(properties).assertSuccess();
    return {
        SecretsManagerAccessRoleArn: cdk.stringToCloudFormation(properties.secretsManagerAccessRoleArn),
        SecretsManagerSecretId: cdk.stringToCloudFormation(properties.secretsManagerSecretId),
    };
}
// @ts-ignore TS6133
function CfnEndpointSybaseSettingsPropertyFromCloudFormation(properties) {
    if (cdk.isResolvableObject(properties)) {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('secretsManagerAccessRoleArn', 'SecretsManagerAccessRoleArn', properties.SecretsManagerAccessRoleArn != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerAccessRoleArn) : undefined);
    ret.addPropertyResult('secretsManagerSecretId', 'SecretsManagerSecretId', properties.SecretsManagerSecretId != null ? cfn_parse.FromCloudFormation.getString(properties.SecretsManagerSecretId) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * Determine whether the given properties match those of a `CfnEventSubscriptionProps`
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the result of the validation.
 */
function CfnEventSubscriptionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('eventCategories', cdk.listValidator(cdk.validateString))(properties.eventCategories));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.requiredValidator)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('snsTopicArn', cdk.validateString)(properties.snsTopicArn));
    errors.collect(cdk.propertyValidator('sourceIds', cdk.listValidator(cdk.validateString))(properties.sourceIds));
    errors.collect(cdk.propertyValidator('sourceType', cdk.validateString)(properties.sourceType));
    errors.collect(cdk.propertyValidator('subscriptionName', cdk.validateString)(properties.subscriptionName));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnEventSubscriptionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::EventSubscription` resource
 *
 * @param properties - the TypeScript properties of a `CfnEventSubscriptionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::EventSubscription` resource.
 */
// @ts-ignore TS6133
function cfnEventSubscriptionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnEventSubscriptionPropsValidator(properties).assertSuccess();
    return {
        SnsTopicArn: cdk.stringToCloudFormation(properties.snsTopicArn),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EventCategories: cdk.listMapper(cdk.stringToCloudFormation)(properties.eventCategories),
        SourceIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.sourceIds),
        SourceType: cdk.stringToCloudFormation(properties.sourceType),
        SubscriptionName: cdk.stringToCloudFormation(properties.subscriptionName),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnEventSubscriptionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('snsTopicArn', 'SnsTopicArn', cfn_parse.FromCloudFormation.getString(properties.SnsTopicArn));
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('eventCategories', 'EventCategories', properties.EventCategories != null ? cfn_parse.FromCloudFormation.getStringArray(properties.EventCategories) : undefined);
    ret.addPropertyResult('sourceIds', 'SourceIds', properties.SourceIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.SourceIds) : undefined);
    ret.addPropertyResult('sourceType', 'SourceType', properties.SourceType != null ? cfn_parse.FromCloudFormation.getString(properties.SourceType) : undefined);
    ret.addPropertyResult('subscriptionName', 'SubscriptionName', properties.SubscriptionName != null ? cfn_parse.FromCloudFormation.getString(properties.SubscriptionName) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::EventSubscription`
 *
 * Use the `AWS::DMS::EventSubscription` resource to get notifications for AWS Database Migration Service events through the Amazon Simple Notification Service. For more information, see [Using AWS DMS Event Notification](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the *AWS Database Migration Service User Guide.*
 *
 * @cloudformationResource AWS::DMS::EventSubscription
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-eventsubscription.html
 */
class CfnEventSubscription extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::EventSubscription`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnEventSubscription.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnEventSubscriptionProps(props);
        cdk.requireProperty(props, 'snsTopicArn', this);
        this.snsTopicArn = props.snsTopicArn;
        this.enabled = props.enabled;
        this.eventCategories = props.eventCategories;
        this.sourceIds = props.sourceIds;
        this.sourceType = props.sourceType;
        this.subscriptionName = props.subscriptionName;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::EventSubscription", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnEventSubscriptionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnEventSubscription(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnEventSubscription.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            snsTopicArn: this.snsTopicArn,
            enabled: this.enabled,
            eventCategories: this.eventCategories,
            sourceIds: this.sourceIds,
            sourceType: this.sourceType,
            subscriptionName: this.subscriptionName,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnEventSubscriptionPropsToCloudFormation(props);
    }
}
exports.CfnEventSubscription = CfnEventSubscription;
_c = JSII_RTTI_SYMBOL_1;
CfnEventSubscription[_c] = { fqn: "monocdk.aws_dms.CfnEventSubscription", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnEventSubscription.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::EventSubscription";
/**
 * Determine whether the given properties match those of a `CfnReplicationInstanceProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationInstanceProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationInstancePropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('allocatedStorage', cdk.validateNumber)(properties.allocatedStorage));
    errors.collect(cdk.propertyValidator('allowMajorVersionUpgrade', cdk.validateBoolean)(properties.allowMajorVersionUpgrade));
    errors.collect(cdk.propertyValidator('autoMinorVersionUpgrade', cdk.validateBoolean)(properties.autoMinorVersionUpgrade));
    errors.collect(cdk.propertyValidator('availabilityZone', cdk.validateString)(properties.availabilityZone));
    errors.collect(cdk.propertyValidator('engineVersion', cdk.validateString)(properties.engineVersion));
    errors.collect(cdk.propertyValidator('kmsKeyId', cdk.validateString)(properties.kmsKeyId));
    errors.collect(cdk.propertyValidator('multiAz', cdk.validateBoolean)(properties.multiAz));
    errors.collect(cdk.propertyValidator('preferredMaintenanceWindow', cdk.validateString)(properties.preferredMaintenanceWindow));
    errors.collect(cdk.propertyValidator('publiclyAccessible', cdk.validateBoolean)(properties.publiclyAccessible));
    errors.collect(cdk.propertyValidator('replicationInstanceClass', cdk.requiredValidator)(properties.replicationInstanceClass));
    errors.collect(cdk.propertyValidator('replicationInstanceClass', cdk.validateString)(properties.replicationInstanceClass));
    errors.collect(cdk.propertyValidator('replicationInstanceIdentifier', cdk.validateString)(properties.replicationInstanceIdentifier));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupIdentifier', cdk.validateString)(properties.replicationSubnetGroupIdentifier));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('vpcSecurityGroupIds', cdk.listValidator(cdk.validateString))(properties.vpcSecurityGroupIds));
    return errors.wrap('supplied properties not correct for "CfnReplicationInstanceProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationInstance` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationInstanceProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationInstance` resource.
 */
// @ts-ignore TS6133
function cfnReplicationInstancePropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationInstancePropsValidator(properties).assertSuccess();
    return {
        ReplicationInstanceClass: cdk.stringToCloudFormation(properties.replicationInstanceClass),
        AllocatedStorage: cdk.numberToCloudFormation(properties.allocatedStorage),
        AllowMajorVersionUpgrade: cdk.booleanToCloudFormation(properties.allowMajorVersionUpgrade),
        AutoMinorVersionUpgrade: cdk.booleanToCloudFormation(properties.autoMinorVersionUpgrade),
        AvailabilityZone: cdk.stringToCloudFormation(properties.availabilityZone),
        EngineVersion: cdk.stringToCloudFormation(properties.engineVersion),
        KmsKeyId: cdk.stringToCloudFormation(properties.kmsKeyId),
        MultiAZ: cdk.booleanToCloudFormation(properties.multiAz),
        PreferredMaintenanceWindow: cdk.stringToCloudFormation(properties.preferredMaintenanceWindow),
        PubliclyAccessible: cdk.booleanToCloudFormation(properties.publiclyAccessible),
        ReplicationInstanceIdentifier: cdk.stringToCloudFormation(properties.replicationInstanceIdentifier),
        ReplicationSubnetGroupIdentifier: cdk.stringToCloudFormation(properties.replicationSubnetGroupIdentifier),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        VpcSecurityGroupIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.vpcSecurityGroupIds),
    };
}
// @ts-ignore TS6133
function CfnReplicationInstancePropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('replicationInstanceClass', 'ReplicationInstanceClass', cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceClass));
    ret.addPropertyResult('allocatedStorage', 'AllocatedStorage', properties.AllocatedStorage != null ? cfn_parse.FromCloudFormation.getNumber(properties.AllocatedStorage) : undefined);
    ret.addPropertyResult('allowMajorVersionUpgrade', 'AllowMajorVersionUpgrade', properties.AllowMajorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AllowMajorVersionUpgrade) : undefined);
    ret.addPropertyResult('autoMinorVersionUpgrade', 'AutoMinorVersionUpgrade', properties.AutoMinorVersionUpgrade != null ? cfn_parse.FromCloudFormation.getBoolean(properties.AutoMinorVersionUpgrade) : undefined);
    ret.addPropertyResult('availabilityZone', 'AvailabilityZone', properties.AvailabilityZone != null ? cfn_parse.FromCloudFormation.getString(properties.AvailabilityZone) : undefined);
    ret.addPropertyResult('engineVersion', 'EngineVersion', properties.EngineVersion != null ? cfn_parse.FromCloudFormation.getString(properties.EngineVersion) : undefined);
    ret.addPropertyResult('kmsKeyId', 'KmsKeyId', properties.KmsKeyId != null ? cfn_parse.FromCloudFormation.getString(properties.KmsKeyId) : undefined);
    ret.addPropertyResult('multiAz', 'MultiAZ', properties.MultiAZ != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiAZ) : undefined);
    ret.addPropertyResult('preferredMaintenanceWindow', 'PreferredMaintenanceWindow', properties.PreferredMaintenanceWindow != null ? cfn_parse.FromCloudFormation.getString(properties.PreferredMaintenanceWindow) : undefined);
    ret.addPropertyResult('publiclyAccessible', 'PubliclyAccessible', properties.PubliclyAccessible != null ? cfn_parse.FromCloudFormation.getBoolean(properties.PubliclyAccessible) : undefined);
    ret.addPropertyResult('replicationInstanceIdentifier', 'ReplicationInstanceIdentifier', properties.ReplicationInstanceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceIdentifier) : undefined);
    ret.addPropertyResult('replicationSubnetGroupIdentifier', 'ReplicationSubnetGroupIdentifier', properties.ReplicationSubnetGroupIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupIdentifier) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('vpcSecurityGroupIds', 'VpcSecurityGroupIds', properties.VpcSecurityGroupIds != null ? cfn_parse.FromCloudFormation.getStringArray(properties.VpcSecurityGroupIds) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationInstance`
 *
 * The `AWS::DMS::ReplicationInstance` resource creates an AWS DMS replication instance.
 *
 * @cloudformationResource AWS::DMS::ReplicationInstance
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationinstance.html
 */
class CfnReplicationInstance extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationInstance`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationInstanceProps(props);
        cdk.requireProperty(props, 'replicationInstanceClass', this);
        this.attrReplicationInstancePrivateIpAddresses = cdk.Token.asList(this.getAtt('ReplicationInstancePrivateIpAddresses'));
        this.attrReplicationInstancePublicIpAddresses = cdk.Token.asList(this.getAtt('ReplicationInstancePublicIpAddresses'));
        this.replicationInstanceClass = props.replicationInstanceClass;
        this.allocatedStorage = props.allocatedStorage;
        this.allowMajorVersionUpgrade = props.allowMajorVersionUpgrade;
        this.autoMinorVersionUpgrade = props.autoMinorVersionUpgrade;
        this.availabilityZone = props.availabilityZone;
        this.engineVersion = props.engineVersion;
        this.kmsKeyId = props.kmsKeyId;
        this.multiAz = props.multiAz;
        this.preferredMaintenanceWindow = props.preferredMaintenanceWindow;
        this.publiclyAccessible = props.publiclyAccessible;
        this.replicationInstanceIdentifier = props.replicationInstanceIdentifier;
        this.replicationSubnetGroupIdentifier = props.replicationSubnetGroupIdentifier;
        this.resourceIdentifier = props.resourceIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationInstance", props.tags, { tagPropertyName: 'tags' });
        this.vpcSecurityGroupIds = props.vpcSecurityGroupIds;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationInstancePropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationInstance(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            replicationInstanceClass: this.replicationInstanceClass,
            allocatedStorage: this.allocatedStorage,
            allowMajorVersionUpgrade: this.allowMajorVersionUpgrade,
            autoMinorVersionUpgrade: this.autoMinorVersionUpgrade,
            availabilityZone: this.availabilityZone,
            engineVersion: this.engineVersion,
            kmsKeyId: this.kmsKeyId,
            multiAz: this.multiAz,
            preferredMaintenanceWindow: this.preferredMaintenanceWindow,
            publiclyAccessible: this.publiclyAccessible,
            replicationInstanceIdentifier: this.replicationInstanceIdentifier,
            replicationSubnetGroupIdentifier: this.replicationSubnetGroupIdentifier,
            resourceIdentifier: this.resourceIdentifier,
            tags: this.tags.renderTags(),
            vpcSecurityGroupIds: this.vpcSecurityGroupIds,
        };
    }
    renderProperties(props) {
        return cfnReplicationInstancePropsToCloudFormation(props);
    }
}
exports.CfnReplicationInstance = CfnReplicationInstance;
_d = JSII_RTTI_SYMBOL_1;
CfnReplicationInstance[_d] = { fqn: "monocdk.aws_dms.CfnReplicationInstance", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationInstance.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationInstance";
/**
 * Determine whether the given properties match those of a `CfnReplicationSubnetGroupProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationSubnetGroupProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationSubnetGroupPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('replicationSubnetGroupDescription', cdk.requiredValidator)(properties.replicationSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupDescription', cdk.validateString)(properties.replicationSubnetGroupDescription));
    errors.collect(cdk.propertyValidator('replicationSubnetGroupIdentifier', cdk.validateString)(properties.replicationSubnetGroupIdentifier));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.requiredValidator)(properties.subnetIds));
    errors.collect(cdk.propertyValidator('subnetIds', cdk.listValidator(cdk.validateString))(properties.subnetIds));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicationSubnetGroupProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationSubnetGroup` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationSubnetGroupProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationSubnetGroup` resource.
 */
// @ts-ignore TS6133
function cfnReplicationSubnetGroupPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationSubnetGroupPropsValidator(properties).assertSuccess();
    return {
        ReplicationSubnetGroupDescription: cdk.stringToCloudFormation(properties.replicationSubnetGroupDescription),
        SubnetIds: cdk.listMapper(cdk.stringToCloudFormation)(properties.subnetIds),
        ReplicationSubnetGroupIdentifier: cdk.stringToCloudFormation(properties.replicationSubnetGroupIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicationSubnetGroupPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('replicationSubnetGroupDescription', 'ReplicationSubnetGroupDescription', cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupDescription));
    ret.addPropertyResult('subnetIds', 'SubnetIds', cfn_parse.FromCloudFormation.getStringArray(properties.SubnetIds));
    ret.addPropertyResult('replicationSubnetGroupIdentifier', 'ReplicationSubnetGroupIdentifier', properties.ReplicationSubnetGroupIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationSubnetGroupIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationSubnetGroup`
 *
 * The `AWS::DMS::ReplicationSubnetGroup` resource creates an AWS DMS replication subnet group. Subnet groups must contain at least two subnets in two different Availability Zones in the same region.
 *
 * > Resource creation will fail if the `dms-vpc-role` IAM role doesn't already exist. For more information, see [Creating the IAM Roles to Use With the AWS CLI and AWS DMS API](https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.APIRole.html) in the *AWS Database Migration Service User Guide.*
 *
 * @cloudformationResource AWS::DMS::ReplicationSubnetGroup
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationsubnetgroup.html
 */
class CfnReplicationSubnetGroup extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationSubnetGroup`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationSubnetGroupProps(props);
        cdk.requireProperty(props, 'replicationSubnetGroupDescription', this);
        cdk.requireProperty(props, 'subnetIds', this);
        this.replicationSubnetGroupDescription = props.replicationSubnetGroupDescription;
        this.subnetIds = props.subnetIds;
        this.replicationSubnetGroupIdentifier = props.replicationSubnetGroupIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationSubnetGroup", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationSubnetGroupPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationSubnetGroup(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            replicationSubnetGroupDescription: this.replicationSubnetGroupDescription,
            subnetIds: this.subnetIds,
            replicationSubnetGroupIdentifier: this.replicationSubnetGroupIdentifier,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicationSubnetGroupPropsToCloudFormation(props);
    }
}
exports.CfnReplicationSubnetGroup = CfnReplicationSubnetGroup;
_e = JSII_RTTI_SYMBOL_1;
CfnReplicationSubnetGroup[_e] = { fqn: "monocdk.aws_dms.CfnReplicationSubnetGroup", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationSubnetGroup.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationSubnetGroup";
/**
 * Determine whether the given properties match those of a `CfnReplicationTaskProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicationTaskProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicationTaskPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('cdcStartPosition', cdk.validateString)(properties.cdcStartPosition));
    errors.collect(cdk.propertyValidator('cdcStartTime', cdk.validateNumber)(properties.cdcStartTime));
    errors.collect(cdk.propertyValidator('cdcStopPosition', cdk.validateString)(properties.cdcStopPosition));
    errors.collect(cdk.propertyValidator('migrationType', cdk.requiredValidator)(properties.migrationType));
    errors.collect(cdk.propertyValidator('migrationType', cdk.validateString)(properties.migrationType));
    errors.collect(cdk.propertyValidator('replicationInstanceArn', cdk.requiredValidator)(properties.replicationInstanceArn));
    errors.collect(cdk.propertyValidator('replicationInstanceArn', cdk.validateString)(properties.replicationInstanceArn));
    errors.collect(cdk.propertyValidator('replicationTaskIdentifier', cdk.validateString)(properties.replicationTaskIdentifier));
    errors.collect(cdk.propertyValidator('replicationTaskSettings', cdk.validateString)(properties.replicationTaskSettings));
    errors.collect(cdk.propertyValidator('resourceIdentifier', cdk.validateString)(properties.resourceIdentifier));
    errors.collect(cdk.propertyValidator('sourceEndpointArn', cdk.requiredValidator)(properties.sourceEndpointArn));
    errors.collect(cdk.propertyValidator('sourceEndpointArn', cdk.validateString)(properties.sourceEndpointArn));
    errors.collect(cdk.propertyValidator('tableMappings', cdk.requiredValidator)(properties.tableMappings));
    errors.collect(cdk.propertyValidator('tableMappings', cdk.validateString)(properties.tableMappings));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    errors.collect(cdk.propertyValidator('targetEndpointArn', cdk.requiredValidator)(properties.targetEndpointArn));
    errors.collect(cdk.propertyValidator('targetEndpointArn', cdk.validateString)(properties.targetEndpointArn));
    errors.collect(cdk.propertyValidator('taskData', cdk.validateString)(properties.taskData));
    return errors.wrap('supplied properties not correct for "CfnReplicationTaskProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::DMS::ReplicationTask` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicationTaskProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::DMS::ReplicationTask` resource.
 */
// @ts-ignore TS6133
function cfnReplicationTaskPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicationTaskPropsValidator(properties).assertSuccess();
    return {
        MigrationType: cdk.stringToCloudFormation(properties.migrationType),
        ReplicationInstanceArn: cdk.stringToCloudFormation(properties.replicationInstanceArn),
        SourceEndpointArn: cdk.stringToCloudFormation(properties.sourceEndpointArn),
        TableMappings: cdk.stringToCloudFormation(properties.tableMappings),
        TargetEndpointArn: cdk.stringToCloudFormation(properties.targetEndpointArn),
        CdcStartPosition: cdk.stringToCloudFormation(properties.cdcStartPosition),
        CdcStartTime: cdk.numberToCloudFormation(properties.cdcStartTime),
        CdcStopPosition: cdk.stringToCloudFormation(properties.cdcStopPosition),
        ReplicationTaskIdentifier: cdk.stringToCloudFormation(properties.replicationTaskIdentifier),
        ReplicationTaskSettings: cdk.stringToCloudFormation(properties.replicationTaskSettings),
        ResourceIdentifier: cdk.stringToCloudFormation(properties.resourceIdentifier),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
        TaskData: cdk.stringToCloudFormation(properties.taskData),
    };
}
// @ts-ignore TS6133
function CfnReplicationTaskPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('migrationType', 'MigrationType', cfn_parse.FromCloudFormation.getString(properties.MigrationType));
    ret.addPropertyResult('replicationInstanceArn', 'ReplicationInstanceArn', cfn_parse.FromCloudFormation.getString(properties.ReplicationInstanceArn));
    ret.addPropertyResult('sourceEndpointArn', 'SourceEndpointArn', cfn_parse.FromCloudFormation.getString(properties.SourceEndpointArn));
    ret.addPropertyResult('tableMappings', 'TableMappings', cfn_parse.FromCloudFormation.getString(properties.TableMappings));
    ret.addPropertyResult('targetEndpointArn', 'TargetEndpointArn', cfn_parse.FromCloudFormation.getString(properties.TargetEndpointArn));
    ret.addPropertyResult('cdcStartPosition', 'CdcStartPosition', properties.CdcStartPosition != null ? cfn_parse.FromCloudFormation.getString(properties.CdcStartPosition) : undefined);
    ret.addPropertyResult('cdcStartTime', 'CdcStartTime', properties.CdcStartTime != null ? cfn_parse.FromCloudFormation.getNumber(properties.CdcStartTime) : undefined);
    ret.addPropertyResult('cdcStopPosition', 'CdcStopPosition', properties.CdcStopPosition != null ? cfn_parse.FromCloudFormation.getString(properties.CdcStopPosition) : undefined);
    ret.addPropertyResult('replicationTaskIdentifier', 'ReplicationTaskIdentifier', properties.ReplicationTaskIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationTaskIdentifier) : undefined);
    ret.addPropertyResult('replicationTaskSettings', 'ReplicationTaskSettings', properties.ReplicationTaskSettings != null ? cfn_parse.FromCloudFormation.getString(properties.ReplicationTaskSettings) : undefined);
    ret.addPropertyResult('resourceIdentifier', 'ResourceIdentifier', properties.ResourceIdentifier != null ? cfn_parse.FromCloudFormation.getString(properties.ResourceIdentifier) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addPropertyResult('taskData', 'TaskData', properties.TaskData != null ? cfn_parse.FromCloudFormation.getString(properties.TaskData) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::DMS::ReplicationTask`
 *
 * The `AWS::DMS::ReplicationTask` resource creates an AWS DMS replication task.
 *
 * @cloudformationResource AWS::DMS::ReplicationTask
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dms-replicationtask.html
 */
class CfnReplicationTask extends cdk.CfnResource {
    /**
     * Create a new `AWS::DMS::ReplicationTask`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicationTask.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_dms_CfnReplicationTaskProps(props);
        cdk.requireProperty(props, 'migrationType', this);
        cdk.requireProperty(props, 'replicationInstanceArn', this);
        cdk.requireProperty(props, 'sourceEndpointArn', this);
        cdk.requireProperty(props, 'tableMappings', this);
        cdk.requireProperty(props, 'targetEndpointArn', this);
        this.migrationType = props.migrationType;
        this.replicationInstanceArn = props.replicationInstanceArn;
        this.sourceEndpointArn = props.sourceEndpointArn;
        this.tableMappings = props.tableMappings;
        this.targetEndpointArn = props.targetEndpointArn;
        this.cdcStartPosition = props.cdcStartPosition;
        this.cdcStartTime = props.cdcStartTime;
        this.cdcStopPosition = props.cdcStopPosition;
        this.replicationTaskIdentifier = props.replicationTaskIdentifier;
        this.replicationTaskSettings = props.replicationTaskSettings;
        this.resourceIdentifier = props.resourceIdentifier;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::DMS::ReplicationTask", props.tags, { tagPropertyName: 'tags' });
        this.taskData = props.taskData;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicationTaskPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicationTask(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicationTask.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            migrationType: this.migrationType,
            replicationInstanceArn: this.replicationInstanceArn,
            sourceEndpointArn: this.sourceEndpointArn,
            tableMappings: this.tableMappings,
            targetEndpointArn: this.targetEndpointArn,
            cdcStartPosition: this.cdcStartPosition,
            cdcStartTime: this.cdcStartTime,
            cdcStopPosition: this.cdcStopPosition,
            replicationTaskIdentifier: this.replicationTaskIdentifier,
            replicationTaskSettings: this.replicationTaskSettings,
            resourceIdentifier: this.resourceIdentifier,
            tags: this.tags.renderTags(),
            taskData: this.taskData,
        };
    }
    renderProperties(props) {
        return cfnReplicationTaskPropsToCloudFormation(props);
    }
}
exports.CfnReplicationTask = CfnReplicationTask;
_f = JSII_RTTI_SYMBOL_1;
CfnReplicationTask[_f] = { fqn: "monocdk.aws_dms.CfnReplicationTask", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicationTask.CFN_RESOURCE_TYPE_NAME = "AWS::DMS::ReplicationTask";
//# sourceMappingURL=data:application/json;base64,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