"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReportDefinition = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2022-03-17T11:31:26.650Z","fingerprint":"potd7NdGJ7rEz+5jVhSlkuYIhZWHjikZCLm8dm+dFs8="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("../../core");
const cfn_parse = require("../../core/lib/cfn-parse");
/**
 * Determine whether the given properties match those of a `CfnReportDefinitionProps`
 *
 * @param properties - the TypeScript properties of a `CfnReportDefinitionProps`
 *
 * @returns the result of the validation.
 */
function CfnReportDefinitionPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('additionalArtifacts', cdk.listValidator(cdk.validateString))(properties.additionalArtifacts));
    errors.collect(cdk.propertyValidator('additionalSchemaElements', cdk.listValidator(cdk.validateString))(properties.additionalSchemaElements));
    errors.collect(cdk.propertyValidator('billingViewArn', cdk.validateString)(properties.billingViewArn));
    errors.collect(cdk.propertyValidator('compression', cdk.requiredValidator)(properties.compression));
    errors.collect(cdk.propertyValidator('compression', cdk.validateString)(properties.compression));
    errors.collect(cdk.propertyValidator('format', cdk.requiredValidator)(properties.format));
    errors.collect(cdk.propertyValidator('format', cdk.validateString)(properties.format));
    errors.collect(cdk.propertyValidator('refreshClosedReports', cdk.requiredValidator)(properties.refreshClosedReports));
    errors.collect(cdk.propertyValidator('refreshClosedReports', cdk.validateBoolean)(properties.refreshClosedReports));
    errors.collect(cdk.propertyValidator('reportName', cdk.requiredValidator)(properties.reportName));
    errors.collect(cdk.propertyValidator('reportName', cdk.validateString)(properties.reportName));
    errors.collect(cdk.propertyValidator('reportVersioning', cdk.requiredValidator)(properties.reportVersioning));
    errors.collect(cdk.propertyValidator('reportVersioning', cdk.validateString)(properties.reportVersioning));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.requiredValidator)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Bucket', cdk.validateString)(properties.s3Bucket));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.requiredValidator)(properties.s3Prefix));
    errors.collect(cdk.propertyValidator('s3Prefix', cdk.validateString)(properties.s3Prefix));
    errors.collect(cdk.propertyValidator('s3Region', cdk.requiredValidator)(properties.s3Region));
    errors.collect(cdk.propertyValidator('s3Region', cdk.validateString)(properties.s3Region));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.requiredValidator)(properties.timeUnit));
    errors.collect(cdk.propertyValidator('timeUnit', cdk.validateString)(properties.timeUnit));
    return errors.wrap('supplied properties not correct for "CfnReportDefinitionProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::CUR::ReportDefinition` resource
 *
 * @param properties - the TypeScript properties of a `CfnReportDefinitionProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::CUR::ReportDefinition` resource.
 */
// @ts-ignore TS6133
function cfnReportDefinitionPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReportDefinitionPropsValidator(properties).assertSuccess();
    return {
        Compression: cdk.stringToCloudFormation(properties.compression),
        Format: cdk.stringToCloudFormation(properties.format),
        RefreshClosedReports: cdk.booleanToCloudFormation(properties.refreshClosedReports),
        ReportName: cdk.stringToCloudFormation(properties.reportName),
        ReportVersioning: cdk.stringToCloudFormation(properties.reportVersioning),
        S3Bucket: cdk.stringToCloudFormation(properties.s3Bucket),
        S3Prefix: cdk.stringToCloudFormation(properties.s3Prefix),
        S3Region: cdk.stringToCloudFormation(properties.s3Region),
        TimeUnit: cdk.stringToCloudFormation(properties.timeUnit),
        AdditionalArtifacts: cdk.listMapper(cdk.stringToCloudFormation)(properties.additionalArtifacts),
        AdditionalSchemaElements: cdk.listMapper(cdk.stringToCloudFormation)(properties.additionalSchemaElements),
        BillingViewArn: cdk.stringToCloudFormation(properties.billingViewArn),
    };
}
// @ts-ignore TS6133
function CfnReportDefinitionPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('compression', 'Compression', cfn_parse.FromCloudFormation.getString(properties.Compression));
    ret.addPropertyResult('format', 'Format', cfn_parse.FromCloudFormation.getString(properties.Format));
    ret.addPropertyResult('refreshClosedReports', 'RefreshClosedReports', cfn_parse.FromCloudFormation.getBoolean(properties.RefreshClosedReports));
    ret.addPropertyResult('reportName', 'ReportName', cfn_parse.FromCloudFormation.getString(properties.ReportName));
    ret.addPropertyResult('reportVersioning', 'ReportVersioning', cfn_parse.FromCloudFormation.getString(properties.ReportVersioning));
    ret.addPropertyResult('s3Bucket', 'S3Bucket', cfn_parse.FromCloudFormation.getString(properties.S3Bucket));
    ret.addPropertyResult('s3Prefix', 'S3Prefix', cfn_parse.FromCloudFormation.getString(properties.S3Prefix));
    ret.addPropertyResult('s3Region', 'S3Region', cfn_parse.FromCloudFormation.getString(properties.S3Region));
    ret.addPropertyResult('timeUnit', 'TimeUnit', cfn_parse.FromCloudFormation.getString(properties.TimeUnit));
    ret.addPropertyResult('additionalArtifacts', 'AdditionalArtifacts', properties.AdditionalArtifacts != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdditionalArtifacts) : undefined);
    ret.addPropertyResult('additionalSchemaElements', 'AdditionalSchemaElements', properties.AdditionalSchemaElements != null ? cfn_parse.FromCloudFormation.getStringArray(properties.AdditionalSchemaElements) : undefined);
    ret.addPropertyResult('billingViewArn', 'BillingViewArn', properties.BillingViewArn != null ? cfn_parse.FromCloudFormation.getString(properties.BillingViewArn) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::CUR::ReportDefinition`
 *
 * The definition of AWS Cost and Usage Report. You can specify the report name, time unit, report format, compression format, S3 bucket, additional artifacts, and schema elements in the definition.
 *
 * @cloudformationResource AWS::CUR::ReportDefinition
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html
 */
class CfnReportDefinition extends cdk.CfnResource {
    /**
     * Create a new `AWS::CUR::ReportDefinition`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReportDefinition.CFN_RESOURCE_TYPE_NAME, properties: props });
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_cur_CfnReportDefinitionProps(props);
        cdk.requireProperty(props, 'compression', this);
        cdk.requireProperty(props, 'format', this);
        cdk.requireProperty(props, 'refreshClosedReports', this);
        cdk.requireProperty(props, 'reportName', this);
        cdk.requireProperty(props, 'reportVersioning', this);
        cdk.requireProperty(props, 's3Bucket', this);
        cdk.requireProperty(props, 's3Prefix', this);
        cdk.requireProperty(props, 's3Region', this);
        cdk.requireProperty(props, 'timeUnit', this);
        this.compression = props.compression;
        this.format = props.format;
        this.refreshClosedReports = props.refreshClosedReports;
        this.reportName = props.reportName;
        this.reportVersioning = props.reportVersioning;
        this.s3Bucket = props.s3Bucket;
        this.s3Prefix = props.s3Prefix;
        this.s3Region = props.s3Region;
        this.timeUnit = props.timeUnit;
        this.additionalArtifacts = props.additionalArtifacts;
        this.additionalSchemaElements = props.additionalSchemaElements;
        this.billingViewArn = props.billingViewArn;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReportDefinitionPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReportDefinition(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        jsiiDeprecationWarnings.monocdk_TreeInspector(inspector);
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReportDefinition.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            compression: this.compression,
            format: this.format,
            refreshClosedReports: this.refreshClosedReports,
            reportName: this.reportName,
            reportVersioning: this.reportVersioning,
            s3Bucket: this.s3Bucket,
            s3Prefix: this.s3Prefix,
            s3Region: this.s3Region,
            timeUnit: this.timeUnit,
            additionalArtifacts: this.additionalArtifacts,
            additionalSchemaElements: this.additionalSchemaElements,
            billingViewArn: this.billingViewArn,
        };
    }
    renderProperties(props) {
        return cfnReportDefinitionPropsToCloudFormation(props);
    }
}
exports.CfnReportDefinition = CfnReportDefinition;
_a = JSII_RTTI_SYMBOL_1;
CfnReportDefinition[_a] = { fqn: "monocdk.aws_cur.CfnReportDefinition", version: "1.149.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReportDefinition.CFN_RESOURCE_TYPE_NAME = "AWS::CUR::ReportDefinition";
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY3VyLmdlbmVyYXRlZC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImN1ci5nZW5lcmF0ZWQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsK0VBQStFO0FBQy9FLCtEQUErRDtBQUMvRCw4RkFBOEY7QUFDOUYsc0hBQXNIO0FBRXRILDRCQUE0QixDQUFDLGlFQUFpRTtBQUU5RixrQ0FBa0M7QUFDbEMsc0RBQXNEO0FBaUd0RDs7Ozs7O0dBTUc7QUFDSCxTQUFTLGlDQUFpQyxDQUFDLFVBQWU7SUFDdEQsSUFBSSxDQUFDLEdBQUcsQ0FBQyxVQUFVLENBQUMsVUFBVSxDQUFDLEVBQUU7UUFBRSxPQUFPLEdBQUcsQ0FBQyxrQkFBa0IsQ0FBQztLQUFFO0lBQ25FLE1BQU0sTUFBTSxHQUFHLElBQUksR0FBRyxDQUFDLGlCQUFpQixFQUFFLENBQUM7SUFDM0MsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLEdBQUcsQ0FBQyxnQkFBZ0IsQ0FBQyxvQ0FBb0MsR0FBRyxJQUFJLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMvRztJQUNELE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHFCQUFxQixFQUFFLEdBQUcsQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsVUFBVSxDQUFDLG1CQUFtQixDQUFDLENBQUMsQ0FBQztJQUNwSSxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQywwQkFBMEIsRUFBRSxHQUFHLENBQUMsYUFBYSxDQUFDLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyx3QkFBd0IsQ0FBQyxDQUFDLENBQUM7SUFDOUksTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDO0lBQ3ZHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsV0FBVyxDQUFDLENBQUMsQ0FBQztJQUNwRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO0lBQ2pHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxHQUFHLENBQUMsaUJBQWlCLENBQUMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUMxRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxRQUFRLEVBQUUsR0FBRyxDQUFDLGNBQWMsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ3ZGLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLHNCQUFzQixFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDdEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsR0FBRyxDQUFDLGVBQWUsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQyxDQUFDLENBQUM7SUFDcEgsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0lBQ2xHLE1BQU0sQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFlBQVksRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDL0YsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsa0JBQWtCLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUM5RyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxrQkFBa0IsRUFBRSxHQUFHLENBQUMsY0FBYyxDQUFDLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUMzRyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsR0FBRyxDQUFDLGlCQUFpQixDQUFDLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDOUYsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLEdBQUcsQ0FBQyxjQUFjLENBQUMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRixPQUFPLE1BQU0sQ0FBQyxJQUFJLENBQUMsZ0VBQWdFLENBQUMsQ0FBQztBQUN6RixDQUFDO0FBRUQ7Ozs7OztHQU1HO0FBQ0gsb0JBQW9CO0FBQ3BCLFNBQVMsd0NBQXdDLENBQUMsVUFBZTtJQUM3RCxJQUFJLENBQUMsR0FBRyxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsRUFBRTtRQUFFLE9BQU8sVUFBVSxDQUFDO0tBQUU7SUFDdkQsaUNBQWlDLENBQUMsVUFBVSxDQUFDLENBQUMsYUFBYSxFQUFFLENBQUM7SUFDOUQsT0FBTztRQUNILFdBQVcsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQztRQUMvRCxNQUFNLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUM7UUFDckQsb0JBQW9CLEVBQUUsR0FBRyxDQUFDLHVCQUF1QixDQUFDLFVBQVUsQ0FBQyxvQkFBb0IsQ0FBQztRQUNsRixVQUFVLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7UUFDN0QsZ0JBQWdCLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQztRQUN6RSxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsUUFBUSxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDO1FBQ3pELFFBQVEsRUFBRSxHQUFHLENBQUMsc0JBQXNCLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQztRQUN6RCxRQUFRLEVBQUUsR0FBRyxDQUFDLHNCQUFzQixDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUM7UUFDekQsbUJBQW1CLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsbUJBQW1CLENBQUM7UUFDL0Ysd0JBQXdCLEVBQUUsR0FBRyxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsc0JBQXNCLENBQUMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUM7UUFDekcsY0FBYyxFQUFFLEdBQUcsQ0FBQyxzQkFBc0IsQ0FBQyxVQUFVLENBQUMsY0FBYyxDQUFDO0tBQ3hFLENBQUM7QUFDTixDQUFDO0FBRUQsb0JBQW9CO0FBQ3BCLFNBQVMsMENBQTBDLENBQUMsVUFBZTtJQUMvRCxVQUFVLEdBQUcsVUFBVSxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUM7SUFDbEQsSUFBSSxPQUFPLFVBQVUsS0FBSyxRQUFRLEVBQUU7UUFDaEMsT0FBTyxJQUFJLFNBQVMsQ0FBQyx3QkFBd0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztLQUM3RDtJQUNELE1BQU0sR0FBRyxHQUFHLElBQUksU0FBUyxDQUFDLGdDQUFnQyxFQUE0QixDQUFDO0lBQ3ZGLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLEVBQUUsYUFBYSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDcEgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLFFBQVEsRUFBRSxRQUFRLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUNyRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsc0JBQXNCLEVBQUUsc0JBQXNCLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsb0JBQW9CLENBQUMsQ0FBQyxDQUFDO0lBQ2hKLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsWUFBWSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUM7SUFDakgsR0FBRyxDQUFDLGlCQUFpQixDQUFDLGtCQUFrQixFQUFFLGtCQUFrQixFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLGdCQUFnQixDQUFDLENBQUMsQ0FBQztJQUNuSSxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxVQUFVLEVBQUUsVUFBVSxFQUFFLFNBQVMsQ0FBQyxrQkFBa0IsQ0FBQyxTQUFTLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7SUFDM0csR0FBRyxDQUFDLGlCQUFpQixDQUFDLFVBQVUsRUFBRSxVQUFVLEVBQUUsU0FBUyxDQUFDLGtCQUFrQixDQUFDLFNBQVMsQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQztJQUMzRyxHQUFHLENBQUMsaUJBQWlCLENBQUMsVUFBVSxFQUFFLFVBQVUsRUFBRSxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDO0lBQzNHLEdBQUcsQ0FBQyxpQkFBaUIsQ0FBQyxxQkFBcUIsRUFBRSxxQkFBcUIsRUFBRSxVQUFVLENBQUMsbUJBQW1CLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsY0FBYyxDQUFDLFVBQVUsQ0FBQyxtQkFBbUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsQ0FBQztJQUN0TSxHQUFHLENBQUMsaUJBQWlCLENBQUMsMEJBQTBCLEVBQUUsMEJBQTBCLEVBQUUsVUFBVSxDQUFDLHdCQUF3QixJQUFJLElBQUksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxVQUFVLENBQUMsd0JBQXdCLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDMU4sR0FBRyxDQUFDLGlCQUFpQixDQUFDLGdCQUFnQixFQUFFLGdCQUFnQixFQUFFLFVBQVUsQ0FBQyxjQUFjLElBQUksSUFBSSxDQUFDLENBQUMsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLENBQUMsU0FBUyxDQUFDLFVBQVUsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUM7SUFDN0ssR0FBRyxDQUFDLGdDQUFnQyxDQUFDLFVBQVUsQ0FBQyxDQUFDO0lBQ2pELE9BQU8sR0FBRyxDQUFDO0FBQ2YsQ0FBQztBQUVEOzs7Ozs7Ozs7R0FTRztBQUNILE1BQWEsbUJBQW9CLFNBQVEsR0FBRyxDQUFDLFdBQVc7SUE2R3BEOzs7Ozs7T0FNRztJQUNILFlBQVksS0FBb0IsRUFBRSxFQUFVLEVBQUUsS0FBK0I7UUFDekUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsRUFBRSxJQUFJLEVBQUUsbUJBQW1CLENBQUMsc0JBQXNCLEVBQUUsVUFBVSxFQUFFLEtBQUssRUFBRSxDQUFDLENBQUM7OztRQUMxRixHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxhQUFhLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDaEQsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsUUFBUSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzNDLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLHNCQUFzQixFQUFFLElBQUksQ0FBQyxDQUFDO1FBQ3pELEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFlBQVksRUFBRSxJQUFJLENBQUMsQ0FBQztRQUMvQyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxrQkFBa0IsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUNyRCxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFDN0MsR0FBRyxDQUFDLGVBQWUsQ0FBQyxLQUFLLEVBQUUsVUFBVSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzdDLEdBQUcsQ0FBQyxlQUFlLENBQUMsS0FBSyxFQUFFLFVBQVUsRUFBRSxJQUFJLENBQUMsQ0FBQztRQUM3QyxHQUFHLENBQUMsZUFBZSxDQUFDLEtBQUssRUFBRSxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQUM7UUFFN0MsSUFBSSxDQUFDLFdBQVcsR0FBRyxLQUFLLENBQUMsV0FBVyxDQUFDO1FBQ3JDLElBQUksQ0FBQyxNQUFNLEdBQUcsS0FBSyxDQUFDLE1BQU0sQ0FBQztRQUMzQixJQUFJLENBQUMsb0JBQW9CLEdBQUcsS0FBSyxDQUFDLG9CQUFvQixDQUFDO1FBQ3ZELElBQUksQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDLFVBQVUsQ0FBQztRQUNuQyxJQUFJLENBQUMsZ0JBQWdCLEdBQUcsS0FBSyxDQUFDLGdCQUFnQixDQUFDO1FBQy9DLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFDL0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBQy9CLElBQUksQ0FBQyxRQUFRLEdBQUcsS0FBSyxDQUFDLFFBQVEsQ0FBQztRQUMvQixJQUFJLENBQUMsbUJBQW1CLEdBQUcsS0FBSyxDQUFDLG1CQUFtQixDQUFDO1FBQ3JELElBQUksQ0FBQyx3QkFBd0IsR0FBRyxLQUFLLENBQUMsd0JBQXdCLENBQUM7UUFDL0QsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO0tBQzlDO0lBdElEOzs7Ozs7T0FNRztJQUNJLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxLQUFvQixFQUFFLEVBQVUsRUFBRSxrQkFBdUIsRUFBRSxPQUE0QztRQUNySSxrQkFBa0IsR0FBRyxrQkFBa0IsSUFBSSxFQUFFLENBQUM7UUFDOUMsTUFBTSxrQkFBa0IsR0FBRyxPQUFPLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxrQkFBa0IsQ0FBQyxVQUFVLENBQUMsQ0FBQztRQUNwRixNQUFNLFdBQVcsR0FBRywwQ0FBMEMsQ0FBQyxrQkFBa0IsQ0FBQyxDQUFDO1FBQ25GLE1BQU0sR0FBRyxHQUFHLElBQUksbUJBQW1CLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbEUsS0FBSyxNQUFNLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxJQUFJLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVyxDQUFDLGVBQWUsQ0FBQyxFQUFHO1lBQzNFLEdBQUcsQ0FBQyxtQkFBbUIsQ0FBQyxPQUFPLEVBQUUsT0FBTyxDQUFDLENBQUM7U0FDN0M7UUFDRCxPQUFPLENBQUMsTUFBTSxDQUFDLGdCQUFnQixDQUFDLEdBQUcsRUFBRSxrQkFBa0IsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUM3RCxPQUFPLEdBQUcsQ0FBQztLQUNkO0lBdUhEOzs7OztPQUtHO0lBQ0ksT0FBTyxDQUFDLFNBQTRCOztRQUN2QyxTQUFTLENBQUMsWUFBWSxDQUFDLDZCQUE2QixFQUFFLG1CQUFtQixDQUFDLHNCQUFzQixDQUFDLENBQUM7UUFDbEcsU0FBUyxDQUFDLFlBQVksQ0FBQyw4QkFBOEIsRUFBRSxJQUFJLENBQUMsYUFBYSxDQUFDLENBQUM7S0FDOUU7SUFFRCxJQUFjLGFBQWE7UUFDdkIsT0FBTztZQUNILFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixNQUFNLEVBQUUsSUFBSSxDQUFDLE1BQU07WUFDbkIsb0JBQW9CLEVBQUUsSUFBSSxDQUFDLG9CQUFvQjtZQUMvQyxVQUFVLEVBQUUsSUFBSSxDQUFDLFVBQVU7WUFDM0IsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLGdCQUFnQjtZQUN2QyxRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsUUFBUSxFQUFFLElBQUksQ0FBQyxRQUFRO1lBQ3ZCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLG1CQUFtQjtZQUM3Qyx3QkFBd0IsRUFBRSxJQUFJLENBQUMsd0JBQXdCO1lBQ3ZELGNBQWMsRUFBRSxJQUFJLENBQUMsY0FBYztTQUN0QyxDQUFDO0tBQ0w7SUFFUyxnQkFBZ0IsQ0FBQyxLQUEyQjtRQUNsRCxPQUFPLHdDQUF3QyxDQUFDLEtBQUssQ0FBQyxDQUFDO0tBQzFEOztBQTVLTCxrREE2S0M7OztBQTVLRzs7R0FFRztBQUNvQiwwQ0FBc0IsR0FBRyw0QkFBNEIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8vIENvcHlyaWdodCAyMDEyLTIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbi8vIEdlbmVyYXRlZCBmcm9tIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gUmVzb3VyY2UgU3BlY2lmaWNhdGlvblxuLy8gU2VlOiBkb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvY2ZuLXJlc291cmNlLXNwZWNpZmljYXRpb24uaHRtbFxuLy8gQGNmbjJ0czptZXRhQCB7XCJnZW5lcmF0ZWRcIjpcIjIwMjItMDMtMTdUMTE6MzE6MjYuNjUwWlwiLFwiZmluZ2VycHJpbnRcIjpcInBvdGQ3TmRHSjdyRXorNWpWaFNsa3VZSWhaV0hqaWtaQ0xtOGRtK2RGczg9XCJ9XG5cbi8qIGVzbGludC1kaXNhYmxlIG1heC1sZW4gKi8gLy8gVGhpcyBpcyBnZW5lcmF0ZWQgY29kZSAtIGxpbmUgbGVuZ3RocyBhcmUgZGlmZmljdWx0IHRvIGNvbnRyb2xcblxuaW1wb3J0ICogYXMgY2RrIGZyb20gJy4uLy4uL2NvcmUnO1xuaW1wb3J0ICogYXMgY2ZuX3BhcnNlIGZyb20gJy4uLy4uL2NvcmUvbGliL2Nmbi1wYXJzZSc7XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQ2ZuUmVwb3J0RGVmaW5pdGlvbmBcbiAqXG4gKiBAc3RydWN0XG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbFxuICovXG5leHBvcnQgaW50ZXJmYWNlIENmblJlcG9ydERlZmluaXRpb25Qcm9wcyB7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgY29tcHJlc3Npb24gZm9ybWF0IHRoYXQgQW1hem9uIFdlYiBTZXJ2aWNlcyB1c2VzIGZvciB0aGUgcmVwb3J0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tY29tcHJlc3Npb25cbiAgICAgKi9cbiAgICByZWFkb25seSBjb21wcmVzc2lvbjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGZvcm1hdCB0aGF0IEFtYXpvbiBXZWIgU2VydmljZXMgc2F2ZXMgdGhlIHJlcG9ydCBpbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLWZvcm1hdFxuICAgICAqL1xuICAgIHJlYWRvbmx5IGZvcm1hdDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogV2hldGhlciB5b3Ugd2FudCBBbWF6b24gV2ViIFNlcnZpY2VzIHRvIHVwZGF0ZSB5b3VyIHJlcG9ydHMgYWZ0ZXIgdGhleSBoYXZlIGJlZW4gZmluYWxpemVkIGlmIEFXUyBkZXRlY3RzIGNoYXJnZXMgcmVsYXRlZCB0byBwcmV2aW91cyBtb250aHMuIFRoZXNlIGNoYXJnZXMgY2FuIGluY2x1ZGUgcmVmdW5kcywgY3JlZGl0cywgb3Igc3VwcG9ydCBmZWVzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tcmVmcmVzaGNsb3NlZHJlcG9ydHNcbiAgICAgKi9cbiAgICByZWFkb25seSByZWZyZXNoQ2xvc2VkUmVwb3J0czogYm9vbGVhbiB8IGNkay5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFRoZSBuYW1lIG9mIHRoZSByZXBvcnQgdGhhdCB5b3Ugd2FudCB0byBjcmVhdGUuIFRoZSBuYW1lIG11c3QgYmUgdW5pcXVlLCBpcyBjYXNlIHNlbnNpdGl2ZSwgYW5kIGNhbid0IGluY2x1ZGUgc3BhY2VzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tcmVwb3J0bmFtZVxuICAgICAqL1xuICAgIHJlYWRvbmx5IHJlcG9ydE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFdoZXRoZXIgeW91IHdhbnQgQW1hem9uIFdlYiBTZXJ2aWNlcyB0byBvdmVyd3JpdGUgdGhlIHByZXZpb3VzIHZlcnNpb24gb2YgZWFjaCByZXBvcnQgb3IgdG8gZGVsaXZlciB0aGUgcmVwb3J0IGluIGFkZGl0aW9uIHRvIHRoZSBwcmV2aW91cyB2ZXJzaW9ucy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLXJlcG9ydHZlcnNpb25pbmdcbiAgICAgKi9cbiAgICByZWFkb25seSByZXBvcnRWZXJzaW9uaW5nOiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBUaGUgUzMgYnVja2V0IHdoZXJlIEFtYXpvbiBXZWIgU2VydmljZXMgZGVsaXZlcnMgdGhlIHJlcG9ydC5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLXMzYnVja2V0XG4gICAgICovXG4gICAgcmVhZG9ubHkgczNCdWNrZXQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBwcmVmaXggdGhhdCBBbWF6b24gV2ViIFNlcnZpY2VzIGFkZHMgdG8gdGhlIHJlcG9ydCBuYW1lIHdoZW4gQW1hem9uIFdlYiBTZXJ2aWNlcyBkZWxpdmVycyB0aGUgcmVwb3J0LiBZb3VyIHByZWZpeCBjYW4ndCBpbmNsdWRlIHNwYWNlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLXMzcHJlZml4XG4gICAgICovXG4gICAgcmVhZG9ubHkgczNQcmVmaXg6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBSZWdpb24gb2YgdGhlIFMzIGJ1Y2tldCB0aGF0IEFtYXpvbiBXZWIgU2VydmljZXMgZGVsaXZlcnMgdGhlIHJlcG9ydCBpbnRvLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tczNyZWdpb25cbiAgICAgKi9cbiAgICByZWFkb25seSBzM1JlZ2lvbjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGdyYW51bGFyaXR5IG9mIHRoZSBsaW5lIGl0ZW1zIGluIHRoZSByZXBvcnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi10aW1ldW5pdFxuICAgICAqL1xuICAgIHJlYWRvbmx5IHRpbWVVbml0OiBzdHJpbmc7XG5cbiAgICAvKipcbiAgICAgKiBBIGxpc3Qgb2YgbWFuaWZlc3RzIHRoYXQgeW91IHdhbnQgQW1hem9uIFdlYiBTZXJ2aWNlcyB0byBjcmVhdGUgZm9yIHRoaXMgcmVwb3J0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tYWRkaXRpb25hbGFydGlmYWN0c1xuICAgICAqL1xuICAgIHJlYWRvbmx5IGFkZGl0aW9uYWxBcnRpZmFjdHM/OiBzdHJpbmdbXTtcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBzdHJpbmdzIHRoYXQgaW5kaWNhdGUgYWRkaXRpb25hbCBjb250ZW50IHRoYXQgQW1hem9uIFdlYiBTZXJ2aWNlcyBpbmNsdWRlcyBpbiB0aGUgcmVwb3J0LCBzdWNoIGFzIGluZGl2aWR1YWwgcmVzb3VyY2UgSURzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tYWRkaXRpb25hbHNjaGVtYWVsZW1lbnRzXG4gICAgICovXG4gICAgcmVhZG9ubHkgYWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzPzogc3RyaW5nW107XG5cbiAgICAvKipcbiAgICAgKiBUaGUgQW1hem9uIFJlc291cmNlIE5hbWUgKEFSTikgb2YgdGhlIGJpbGxpbmcgdmlldy4gWW91IGNhbiBnZXQgdGhpcyB2YWx1ZSBieSB1c2luZyB0aGUgYmlsbGluZyB2aWV3IHNlcnZpY2UgcHVibGljIEFQSXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1iaWxsaW5ndmlld2FyblxuICAgICAqL1xuICAgIHJlYWRvbmx5IGJpbGxpbmdWaWV3QXJuPzogc3RyaW5nO1xufVxuXG4vKipcbiAqIERldGVybWluZSB3aGV0aGVyIHRoZSBnaXZlbiBwcm9wZXJ0aWVzIG1hdGNoIHRob3NlIG9mIGEgYENmblJlcG9ydERlZmluaXRpb25Qcm9wc2BcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuUmVwb3J0RGVmaW5pdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSByZXN1bHQgb2YgdGhlIHZhbGlkYXRpb24uXG4gKi9cbmZ1bmN0aW9uIENmblJlcG9ydERlZmluaXRpb25Qcm9wc1ZhbGlkYXRvcihwcm9wZXJ0aWVzOiBhbnkpOiBjZGsuVmFsaWRhdGlvblJlc3VsdCB7XG4gICAgaWYgKCFjZGsuY2FuSW5zcGVjdChwcm9wZXJ0aWVzKSkgeyByZXR1cm4gY2RrLlZBTElEQVRJT05fU1VDQ0VTUzsgfVxuICAgIGNvbnN0IGVycm9ycyA9IG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdHMoKTtcbiAgICBpZiAodHlwZW9mIHByb3BlcnRpZXMgIT09ICdvYmplY3QnKSB7XG4gICAgICAgIGVycm9ycy5jb2xsZWN0KG5ldyBjZGsuVmFsaWRhdGlvblJlc3VsdCgnRXhwZWN0ZWQgYW4gb2JqZWN0LCBidXQgcmVjZWl2ZWQ6ICcgKyBKU09OLnN0cmluZ2lmeShwcm9wZXJ0aWVzKSkpO1xuICAgIH1cbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2FkZGl0aW9uYWxBcnRpZmFjdHMnLCBjZGsubGlzdFZhbGlkYXRvcihjZGsudmFsaWRhdGVTdHJpbmcpKShwcm9wZXJ0aWVzLmFkZGl0aW9uYWxBcnRpZmFjdHMpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2FkZGl0aW9uYWxTY2hlbWFFbGVtZW50cycsIGNkay5saXN0VmFsaWRhdG9yKGNkay52YWxpZGF0ZVN0cmluZykpKHByb3BlcnRpZXMuYWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdiaWxsaW5nVmlld0FybicsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5iaWxsaW5nVmlld0FybikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignY29tcHJlc3Npb24nLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuY29tcHJlc3Npb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ2NvbXByZXNzaW9uJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLmNvbXByZXNzaW9uKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdmb3JtYXQnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuZm9ybWF0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdmb3JtYXQnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuZm9ybWF0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZWZyZXNoQ2xvc2VkUmVwb3J0cycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5yZWZyZXNoQ2xvc2VkUmVwb3J0cykpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVmcmVzaENsb3NlZFJlcG9ydHMnLCBjZGsudmFsaWRhdGVCb29sZWFuKShwcm9wZXJ0aWVzLnJlZnJlc2hDbG9zZWRSZXBvcnRzKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXBvcnROYW1lJywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnJlcG9ydE5hbWUpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3JlcG9ydE5hbWUnLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMucmVwb3J0TmFtZSkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcigncmVwb3J0VmVyc2lvbmluZycsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5yZXBvcnRWZXJzaW9uaW5nKSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdyZXBvcnRWZXJzaW9uaW5nJywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnJlcG9ydFZlcnNpb25pbmcpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3MzQnVja2V0JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnMzQnVja2V0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzM0J1Y2tldCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy5zM0J1Y2tldCkpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignczNQcmVmaXgnLCBjZGsucmVxdWlyZWRWYWxpZGF0b3IpKHByb3BlcnRpZXMuczNQcmVmaXgpKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3MzUHJlZml4JywgY2RrLnZhbGlkYXRlU3RyaW5nKShwcm9wZXJ0aWVzLnMzUHJlZml4KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCdzM1JlZ2lvbicsIGNkay5yZXF1aXJlZFZhbGlkYXRvcikocHJvcGVydGllcy5zM1JlZ2lvbikpO1xuICAgIGVycm9ycy5jb2xsZWN0KGNkay5wcm9wZXJ0eVZhbGlkYXRvcignczNSZWdpb24nLCBjZGsudmFsaWRhdGVTdHJpbmcpKHByb3BlcnRpZXMuczNSZWdpb24pKTtcbiAgICBlcnJvcnMuY29sbGVjdChjZGsucHJvcGVydHlWYWxpZGF0b3IoJ3RpbWVVbml0JywgY2RrLnJlcXVpcmVkVmFsaWRhdG9yKShwcm9wZXJ0aWVzLnRpbWVVbml0KSk7XG4gICAgZXJyb3JzLmNvbGxlY3QoY2RrLnByb3BlcnR5VmFsaWRhdG9yKCd0aW1lVW5pdCcsIGNkay52YWxpZGF0ZVN0cmluZykocHJvcGVydGllcy50aW1lVW5pdCkpO1xuICAgIHJldHVybiBlcnJvcnMud3JhcCgnc3VwcGxpZWQgcHJvcGVydGllcyBub3QgY29ycmVjdCBmb3IgXCJDZm5SZXBvcnREZWZpbml0aW9uUHJvcHNcIicpO1xufVxuXG4vKipcbiAqIFJlbmRlcnMgdGhlIEFXUyBDbG91ZEZvcm1hdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGBBV1M6OkNVUjo6UmVwb3J0RGVmaW5pdGlvbmAgcmVzb3VyY2VcbiAqXG4gKiBAcGFyYW0gcHJvcGVydGllcyAtIHRoZSBUeXBlU2NyaXB0IHByb3BlcnRpZXMgb2YgYSBgQ2ZuUmVwb3J0RGVmaW5pdGlvblByb3BzYFxuICpcbiAqIEByZXR1cm5zIHRoZSBBV1MgQ2xvdWRGb3JtYXRpb24gcHJvcGVydGllcyBvZiBhbiBgQVdTOjpDVVI6OlJlcG9ydERlZmluaXRpb25gIHJlc291cmNlLlxuICovXG4vLyBAdHMtaWdub3JlIFRTNjEzM1xuZnVuY3Rpb24gY2ZuUmVwb3J0RGVmaW5pdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzOiBhbnkpOiBhbnkge1xuICAgIGlmICghY2RrLmNhbkluc3BlY3QocHJvcGVydGllcykpIHsgcmV0dXJuIHByb3BlcnRpZXM7IH1cbiAgICBDZm5SZXBvcnREZWZpbml0aW9uUHJvcHNWYWxpZGF0b3IocHJvcGVydGllcykuYXNzZXJ0U3VjY2VzcygpO1xuICAgIHJldHVybiB7XG4gICAgICAgIENvbXByZXNzaW9uOiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmNvbXByZXNzaW9uKSxcbiAgICAgICAgRm9ybWF0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLmZvcm1hdCksXG4gICAgICAgIFJlZnJlc2hDbG9zZWRSZXBvcnRzOiBjZGsuYm9vbGVhblRvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5yZWZyZXNoQ2xvc2VkUmVwb3J0cyksXG4gICAgICAgIFJlcG9ydE5hbWU6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVwb3J0TmFtZSksXG4gICAgICAgIFJlcG9ydFZlcnNpb25pbmc6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMucmVwb3J0VmVyc2lvbmluZyksXG4gICAgICAgIFMzQnVja2V0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnMzQnVja2V0KSxcbiAgICAgICAgUzNQcmVmaXg6IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuczNQcmVmaXgpLFxuICAgICAgICBTM1JlZ2lvbjogY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllcy5zM1JlZ2lvbiksXG4gICAgICAgIFRpbWVVbml0OiBjZGsuc3RyaW5nVG9DbG91ZEZvcm1hdGlvbihwcm9wZXJ0aWVzLnRpbWVVbml0KSxcbiAgICAgICAgQWRkaXRpb25hbEFydGlmYWN0czogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWRkaXRpb25hbEFydGlmYWN0cyksXG4gICAgICAgIEFkZGl0aW9uYWxTY2hlbWFFbGVtZW50czogY2RrLmxpc3RNYXBwZXIoY2RrLnN0cmluZ1RvQ2xvdWRGb3JtYXRpb24pKHByb3BlcnRpZXMuYWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzKSxcbiAgICAgICAgQmlsbGluZ1ZpZXdBcm46IGNkay5zdHJpbmdUb0Nsb3VkRm9ybWF0aW9uKHByb3BlcnRpZXMuYmlsbGluZ1ZpZXdBcm4pLFxuICAgIH07XG59XG5cbi8vIEB0cy1pZ25vcmUgVFM2MTMzXG5mdW5jdGlvbiBDZm5SZXBvcnREZWZpbml0aW9uUHJvcHNGcm9tQ2xvdWRGb3JtYXRpb24ocHJvcGVydGllczogYW55KTogY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblJlc3VsdDxDZm5SZXBvcnREZWZpbml0aW9uUHJvcHM+IHtcbiAgICBwcm9wZXJ0aWVzID0gcHJvcGVydGllcyA9PSBudWxsID8ge30gOiBwcm9wZXJ0aWVzO1xuICAgIGlmICh0eXBlb2YgcHJvcGVydGllcyAhPT0gJ29iamVjdCcpIHtcbiAgICAgICAgcmV0dXJuIG5ldyBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uUmVzdWx0KHByb3BlcnRpZXMpO1xuICAgIH1cbiAgICBjb25zdCByZXQgPSBuZXcgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvblByb3BlcnR5T2JqZWN0PENmblJlcG9ydERlZmluaXRpb25Qcm9wcz4oKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2NvbXByZXNzaW9uJywgJ0NvbXByZXNzaW9uJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5Db21wcmVzc2lvbikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnZm9ybWF0JywgJ0Zvcm1hdCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuRm9ybWF0KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyZWZyZXNoQ2xvc2VkUmVwb3J0cycsICdSZWZyZXNoQ2xvc2VkUmVwb3J0cycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0Qm9vbGVhbihwcm9wZXJ0aWVzLlJlZnJlc2hDbG9zZWRSZXBvcnRzKSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdyZXBvcnROYW1lJywgJ1JlcG9ydE5hbWUnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlJlcG9ydE5hbWUpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3JlcG9ydFZlcnNpb25pbmcnLCAnUmVwb3J0VmVyc2lvbmluZycsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUmVwb3J0VmVyc2lvbmluZykpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgnczNCdWNrZXQnLCAnUzNCdWNrZXQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlMzQnVja2V0KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdzM1ByZWZpeCcsICdTM1ByZWZpeCcsIGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nKHByb3BlcnRpZXMuUzNQcmVmaXgpKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ3MzUmVnaW9uJywgJ1MzUmVnaW9uJywgY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5TM1JlZ2lvbikpO1xuICAgIHJldC5hZGRQcm9wZXJ0eVJlc3VsdCgndGltZVVuaXQnLCAnVGltZVVuaXQnLCBjZm5fcGFyc2UuRnJvbUNsb3VkRm9ybWF0aW9uLmdldFN0cmluZyhwcm9wZXJ0aWVzLlRpbWVVbml0KSk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhZGRpdGlvbmFsQXJ0aWZhY3RzJywgJ0FkZGl0aW9uYWxBcnRpZmFjdHMnLCBwcm9wZXJ0aWVzLkFkZGl0aW9uYWxBcnRpZmFjdHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BZGRpdGlvbmFsQXJ0aWZhY3RzKSA6IHVuZGVmaW5lZCk7XG4gICAgcmV0LmFkZFByb3BlcnR5UmVzdWx0KCdhZGRpdGlvbmFsU2NoZW1hRWxlbWVudHMnLCAnQWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzJywgcHJvcGVydGllcy5BZGRpdGlvbmFsU2NoZW1hRWxlbWVudHMgIT0gbnVsbCA/IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb24uZ2V0U3RyaW5nQXJyYXkocHJvcGVydGllcy5BZGRpdGlvbmFsU2NoZW1hRWxlbWVudHMpIDogdW5kZWZpbmVkKTtcbiAgICByZXQuYWRkUHJvcGVydHlSZXN1bHQoJ2JpbGxpbmdWaWV3QXJuJywgJ0JpbGxpbmdWaWV3QXJuJywgcHJvcGVydGllcy5CaWxsaW5nVmlld0FybiAhPSBudWxsID8gY2ZuX3BhcnNlLkZyb21DbG91ZEZvcm1hdGlvbi5nZXRTdHJpbmcocHJvcGVydGllcy5CaWxsaW5nVmlld0FybikgOiB1bmRlZmluZWQpO1xuICAgIHJldC5hZGRVbnJlY29nbml6ZWRQcm9wZXJ0aWVzQXNFeHRyYShwcm9wZXJ0aWVzKTtcbiAgICByZXR1cm4gcmV0O1xufVxuXG4vKipcbiAqIEEgQ2xvdWRGb3JtYXRpb24gYEFXUzo6Q1VSOjpSZXBvcnREZWZpbml0aW9uYFxuICpcbiAqIFRoZSBkZWZpbml0aW9uIG9mIEFXUyBDb3N0IGFuZCBVc2FnZSBSZXBvcnQuIFlvdSBjYW4gc3BlY2lmeSB0aGUgcmVwb3J0IG5hbWUsIHRpbWUgdW5pdCwgcmVwb3J0IGZvcm1hdCwgY29tcHJlc3Npb24gZm9ybWF0LCBTMyBidWNrZXQsIGFkZGl0aW9uYWwgYXJ0aWZhY3RzLCBhbmQgc2NoZW1hIGVsZW1lbnRzIGluIHRoZSBkZWZpbml0aW9uLlxuICpcbiAqIEBjbG91ZGZvcm1hdGlvblJlc291cmNlIEFXUzo6Q1VSOjpSZXBvcnREZWZpbml0aW9uXG4gKiBAc3RhYmlsaXR5IGV4dGVybmFsXG4gKlxuICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbFxuICovXG5leHBvcnQgY2xhc3MgQ2ZuUmVwb3J0RGVmaW5pdGlvbiBleHRlbmRzIGNkay5DZm5SZXNvdXJjZSBpbXBsZW1lbnRzIGNkay5JSW5zcGVjdGFibGUge1xuICAgIC8qKlxuICAgICAqIFRoZSBDbG91ZEZvcm1hdGlvbiByZXNvdXJjZSB0eXBlIG5hbWUgZm9yIHRoaXMgcmVzb3VyY2UgY2xhc3MuXG4gICAgICovXG4gICAgcHVibGljIHN0YXRpYyByZWFkb25seSBDRk5fUkVTT1VSQ0VfVFlQRV9OQU1FID0gXCJBV1M6OkNVUjo6UmVwb3J0RGVmaW5pdGlvblwiO1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIENsb3VkRm9ybWF0aW9uIHByb3BlcnRpZXMgb2YgdGhpcyByZXNvdXJjZS5cbiAgICAgKiBVc2VkIGluIHRoZSBAYXdzLWNkay9jbG91ZGZvcm1hdGlvbi1pbmNsdWRlIG1vZHVsZS5cbiAgICAgKlxuICAgICAqIEBpbnRlcm5hbFxuICAgICAqL1xuICAgIHB1YmxpYyBzdGF0aWMgX2Zyb21DbG91ZEZvcm1hdGlvbihzY29wZTogY2RrLkNvbnN0cnVjdCwgaWQ6IHN0cmluZywgcmVzb3VyY2VBdHRyaWJ1dGVzOiBhbnksIG9wdGlvbnM6IGNmbl9wYXJzZS5Gcm9tQ2xvdWRGb3JtYXRpb25PcHRpb25zKTogQ2ZuUmVwb3J0RGVmaW5pdGlvbiB7XG4gICAgICAgIHJlc291cmNlQXR0cmlidXRlcyA9IHJlc291cmNlQXR0cmlidXRlcyB8fCB7fTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2VQcm9wZXJ0aWVzID0gb3B0aW9ucy5wYXJzZXIucGFyc2VWYWx1ZShyZXNvdXJjZUF0dHJpYnV0ZXMuUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHByb3BzUmVzdWx0ID0gQ2ZuUmVwb3J0RGVmaW5pdGlvblByb3BzRnJvbUNsb3VkRm9ybWF0aW9uKHJlc291cmNlUHJvcGVydGllcyk7XG4gICAgICAgIGNvbnN0IHJldCA9IG5ldyBDZm5SZXBvcnREZWZpbml0aW9uKHNjb3BlLCBpZCwgcHJvcHNSZXN1bHQudmFsdWUpO1xuICAgICAgICBmb3IgKGNvbnN0IFtwcm9wS2V5LCBwcm9wVmFsXSBvZiBPYmplY3QuZW50cmllcyhwcm9wc1Jlc3VsdC5leHRyYVByb3BlcnRpZXMpKSAge1xuICAgICAgICAgICAgcmV0LmFkZFByb3BlcnR5T3ZlcnJpZGUocHJvcEtleSwgcHJvcFZhbCk7XG4gICAgICAgIH1cbiAgICAgICAgb3B0aW9ucy5wYXJzZXIuaGFuZGxlQXR0cmlidXRlcyhyZXQsIHJlc291cmNlQXR0cmlidXRlcywgaWQpO1xuICAgICAgICByZXR1cm4gcmV0O1xuICAgIH1cblxuICAgIC8qKlxuICAgICAqIFRoZSBjb21wcmVzc2lvbiBmb3JtYXQgdGhhdCBBbWF6b24gV2ViIFNlcnZpY2VzIHVzZXMgZm9yIHRoZSByZXBvcnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1jb21wcmVzc2lvblxuICAgICAqL1xuICAgIHB1YmxpYyBjb21wcmVzc2lvbjogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIGZvcm1hdCB0aGF0IEFtYXpvbiBXZWIgU2VydmljZXMgc2F2ZXMgdGhlIHJlcG9ydCBpbi5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLWZvcm1hdFxuICAgICAqL1xuICAgIHB1YmxpYyBmb3JtYXQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFdoZXRoZXIgeW91IHdhbnQgQW1hem9uIFdlYiBTZXJ2aWNlcyB0byB1cGRhdGUgeW91ciByZXBvcnRzIGFmdGVyIHRoZXkgaGF2ZSBiZWVuIGZpbmFsaXplZCBpZiBBV1MgZGV0ZWN0cyBjaGFyZ2VzIHJlbGF0ZWQgdG8gcHJldmlvdXMgbW9udGhzLiBUaGVzZSBjaGFyZ2VzIGNhbiBpbmNsdWRlIHJlZnVuZHMsIGNyZWRpdHMsIG9yIHN1cHBvcnQgZmVlcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLXJlZnJlc2hjbG9zZWRyZXBvcnRzXG4gICAgICovXG4gICAgcHVibGljIHJlZnJlc2hDbG9zZWRSZXBvcnRzOiBib29sZWFuIHwgY2RrLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogVGhlIG5hbWUgb2YgdGhlIHJlcG9ydCB0aGF0IHlvdSB3YW50IHRvIGNyZWF0ZS4gVGhlIG5hbWUgbXVzdCBiZSB1bmlxdWUsIGlzIGNhc2Ugc2Vuc2l0aXZlLCBhbmQgY2FuJ3QgaW5jbHVkZSBzcGFjZXMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1yZXBvcnRuYW1lXG4gICAgICovXG4gICAgcHVibGljIHJlcG9ydE5hbWU6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFdoZXRoZXIgeW91IHdhbnQgQW1hem9uIFdlYiBTZXJ2aWNlcyB0byBvdmVyd3JpdGUgdGhlIHByZXZpb3VzIHZlcnNpb24gb2YgZWFjaCByZXBvcnQgb3IgdG8gZGVsaXZlciB0aGUgcmVwb3J0IGluIGFkZGl0aW9uIHRvIHRoZSBwcmV2aW91cyB2ZXJzaW9ucy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLXJlcG9ydHZlcnNpb25pbmdcbiAgICAgKi9cbiAgICBwdWJsaWMgcmVwb3J0VmVyc2lvbmluZzogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIFMzIGJ1Y2tldCB3aGVyZSBBbWF6b24gV2ViIFNlcnZpY2VzIGRlbGl2ZXJzIHRoZSByZXBvcnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1zM2J1Y2tldFxuICAgICAqL1xuICAgIHB1YmxpYyBzM0J1Y2tldDogc3RyaW5nO1xuXG4gICAgLyoqXG4gICAgICogVGhlIHByZWZpeCB0aGF0IEFtYXpvbiBXZWIgU2VydmljZXMgYWRkcyB0byB0aGUgcmVwb3J0IG5hbWUgd2hlbiBBbWF6b24gV2ViIFNlcnZpY2VzIGRlbGl2ZXJzIHRoZSByZXBvcnQuIFlvdXIgcHJlZml4IGNhbid0IGluY2x1ZGUgc3BhY2VzLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tczNwcmVmaXhcbiAgICAgKi9cbiAgICBwdWJsaWMgczNQcmVmaXg6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBSZWdpb24gb2YgdGhlIFMzIGJ1Y2tldCB0aGF0IEFtYXpvbiBXZWIgU2VydmljZXMgZGVsaXZlcnMgdGhlIHJlcG9ydCBpbnRvLlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tczNyZWdpb25cbiAgICAgKi9cbiAgICBwdWJsaWMgczNSZWdpb246IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIFRoZSBncmFudWxhcml0eSBvZiB0aGUgbGluZSBpdGVtcyBpbiB0aGUgcmVwb3J0LlxuICAgICAqXG4gICAgICogQGxpbmsgaHR0cDovL2RvY3MuYXdzLmFtYXpvbi5jb20vQVdTQ2xvdWRGb3JtYXRpb24vbGF0ZXN0L1VzZXJHdWlkZS9hd3MtcmVzb3VyY2UtY3VyLXJlcG9ydGRlZmluaXRpb24uaHRtbCNjZm4tY3VyLXJlcG9ydGRlZmluaXRpb24tdGltZXVuaXRcbiAgICAgKi9cbiAgICBwdWJsaWMgdGltZVVuaXQ6IHN0cmluZztcblxuICAgIC8qKlxuICAgICAqIEEgbGlzdCBvZiBtYW5pZmVzdHMgdGhhdCB5b3Ugd2FudCBBbWF6b24gV2ViIFNlcnZpY2VzIHRvIGNyZWF0ZSBmb3IgdGhpcyByZXBvcnQuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1hZGRpdGlvbmFsYXJ0aWZhY3RzXG4gICAgICovXG4gICAgcHVibGljIGFkZGl0aW9uYWxBcnRpZmFjdHM6IHN0cmluZ1tdIHwgdW5kZWZpbmVkO1xuXG4gICAgLyoqXG4gICAgICogQSBsaXN0IG9mIHN0cmluZ3MgdGhhdCBpbmRpY2F0ZSBhZGRpdGlvbmFsIGNvbnRlbnQgdGhhdCBBbWF6b24gV2ViIFNlcnZpY2VzIGluY2x1ZGVzIGluIHRoZSByZXBvcnQsIHN1Y2ggYXMgaW5kaXZpZHVhbCByZXNvdXJjZSBJRHMuXG4gICAgICpcbiAgICAgKiBAbGluayBodHRwOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9BV1NDbG91ZEZvcm1hdGlvbi9sYXRlc3QvVXNlckd1aWRlL2F3cy1yZXNvdXJjZS1jdXItcmVwb3J0ZGVmaW5pdGlvbi5odG1sI2Nmbi1jdXItcmVwb3J0ZGVmaW5pdGlvbi1hZGRpdGlvbmFsc2NoZW1hZWxlbWVudHNcbiAgICAgKi9cbiAgICBwdWJsaWMgYWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzOiBzdHJpbmdbXSB8IHVuZGVmaW5lZDtcblxuICAgIC8qKlxuICAgICAqIFRoZSBBbWF6b24gUmVzb3VyY2UgTmFtZSAoQVJOKSBvZiB0aGUgYmlsbGluZyB2aWV3LiBZb3UgY2FuIGdldCB0aGlzIHZhbHVlIGJ5IHVzaW5nIHRoZSBiaWxsaW5nIHZpZXcgc2VydmljZSBwdWJsaWMgQVBJcy5cbiAgICAgKlxuICAgICAqIEBsaW5rIGh0dHA6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FXU0Nsb3VkRm9ybWF0aW9uL2xhdGVzdC9Vc2VyR3VpZGUvYXdzLXJlc291cmNlLWN1ci1yZXBvcnRkZWZpbml0aW9uLmh0bWwjY2ZuLWN1ci1yZXBvcnRkZWZpbml0aW9uLWJpbGxpbmd2aWV3YXJuXG4gICAgICovXG4gICAgcHVibGljIGJpbGxpbmdWaWV3QXJuOiBzdHJpbmcgfCB1bmRlZmluZWQ7XG5cbiAgICAvKipcbiAgICAgKiBDcmVhdGUgYSBuZXcgYEFXUzo6Q1VSOjpSZXBvcnREZWZpbml0aW9uYC5cbiAgICAgKlxuICAgICAqIEBwYXJhbSBzY29wZSAtIHNjb3BlIGluIHdoaWNoIHRoaXMgcmVzb3VyY2UgaXMgZGVmaW5lZFxuICAgICAqIEBwYXJhbSBpZCAgICAtIHNjb3BlZCBpZCBvZiB0aGUgcmVzb3VyY2VcbiAgICAgKiBAcGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IGNkay5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBDZm5SZXBvcnREZWZpbml0aW9uUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7IHR5cGU6IENmblJlcG9ydERlZmluaXRpb24uQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSwgcHJvcGVydGllczogcHJvcHMgfSk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdjb21wcmVzc2lvbicsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnZm9ybWF0JywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdyZWZyZXNoQ2xvc2VkUmVwb3J0cycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAncmVwb3J0TmFtZScsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAncmVwb3J0VmVyc2lvbmluZycsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAnczNCdWNrZXQnLCB0aGlzKTtcbiAgICAgICAgY2RrLnJlcXVpcmVQcm9wZXJ0eShwcm9wcywgJ3MzUHJlZml4JywgdGhpcyk7XG4gICAgICAgIGNkay5yZXF1aXJlUHJvcGVydHkocHJvcHMsICdzM1JlZ2lvbicsIHRoaXMpO1xuICAgICAgICBjZGsucmVxdWlyZVByb3BlcnR5KHByb3BzLCAndGltZVVuaXQnLCB0aGlzKTtcblxuICAgICAgICB0aGlzLmNvbXByZXNzaW9uID0gcHJvcHMuY29tcHJlc3Npb247XG4gICAgICAgIHRoaXMuZm9ybWF0ID0gcHJvcHMuZm9ybWF0O1xuICAgICAgICB0aGlzLnJlZnJlc2hDbG9zZWRSZXBvcnRzID0gcHJvcHMucmVmcmVzaENsb3NlZFJlcG9ydHM7XG4gICAgICAgIHRoaXMucmVwb3J0TmFtZSA9IHByb3BzLnJlcG9ydE5hbWU7XG4gICAgICAgIHRoaXMucmVwb3J0VmVyc2lvbmluZyA9IHByb3BzLnJlcG9ydFZlcnNpb25pbmc7XG4gICAgICAgIHRoaXMuczNCdWNrZXQgPSBwcm9wcy5zM0J1Y2tldDtcbiAgICAgICAgdGhpcy5zM1ByZWZpeCA9IHByb3BzLnMzUHJlZml4O1xuICAgICAgICB0aGlzLnMzUmVnaW9uID0gcHJvcHMuczNSZWdpb247XG4gICAgICAgIHRoaXMudGltZVVuaXQgPSBwcm9wcy50aW1lVW5pdDtcbiAgICAgICAgdGhpcy5hZGRpdGlvbmFsQXJ0aWZhY3RzID0gcHJvcHMuYWRkaXRpb25hbEFydGlmYWN0cztcbiAgICAgICAgdGhpcy5hZGRpdGlvbmFsU2NoZW1hRWxlbWVudHMgPSBwcm9wcy5hZGRpdGlvbmFsU2NoZW1hRWxlbWVudHM7XG4gICAgICAgIHRoaXMuYmlsbGluZ1ZpZXdBcm4gPSBwcm9wcy5iaWxsaW5nVmlld0FybjtcbiAgICB9XG5cbiAgICAvKipcbiAgICAgKiBFeGFtaW5lcyB0aGUgQ2xvdWRGb3JtYXRpb24gcmVzb3VyY2UgYW5kIGRpc2Nsb3NlcyBhdHRyaWJ1dGVzLlxuICAgICAqXG4gICAgICogQHBhcmFtIGluc3BlY3RvciAtIHRyZWUgaW5zcGVjdG9yIHRvIGNvbGxlY3QgYW5kIHByb2Nlc3MgYXR0cmlidXRlc1xuICAgICAqXG4gICAgICovXG4gICAgcHVibGljIGluc3BlY3QoaW5zcGVjdG9yOiBjZGsuVHJlZUluc3BlY3Rvcikge1xuICAgICAgICBpbnNwZWN0b3IuYWRkQXR0cmlidXRlKFwiYXdzOmNkazpjbG91ZGZvcm1hdGlvbjp0eXBlXCIsIENmblJlcG9ydERlZmluaXRpb24uQ0ZOX1JFU09VUkNFX1RZUEVfTkFNRSk7XG4gICAgICAgIGluc3BlY3Rvci5hZGRBdHRyaWJ1dGUoXCJhd3M6Y2RrOmNsb3VkZm9ybWF0aW9uOnByb3BzXCIsIHRoaXMuY2ZuUHJvcGVydGllcyk7XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIGdldCBjZm5Qcm9wZXJ0aWVzKCk6IHsgW2tleTogc3RyaW5nXTogYW55IH0gIHtcbiAgICAgICAgcmV0dXJuIHtcbiAgICAgICAgICAgIGNvbXByZXNzaW9uOiB0aGlzLmNvbXByZXNzaW9uLFxuICAgICAgICAgICAgZm9ybWF0OiB0aGlzLmZvcm1hdCxcbiAgICAgICAgICAgIHJlZnJlc2hDbG9zZWRSZXBvcnRzOiB0aGlzLnJlZnJlc2hDbG9zZWRSZXBvcnRzLFxuICAgICAgICAgICAgcmVwb3J0TmFtZTogdGhpcy5yZXBvcnROYW1lLFxuICAgICAgICAgICAgcmVwb3J0VmVyc2lvbmluZzogdGhpcy5yZXBvcnRWZXJzaW9uaW5nLFxuICAgICAgICAgICAgczNCdWNrZXQ6IHRoaXMuczNCdWNrZXQsXG4gICAgICAgICAgICBzM1ByZWZpeDogdGhpcy5zM1ByZWZpeCxcbiAgICAgICAgICAgIHMzUmVnaW9uOiB0aGlzLnMzUmVnaW9uLFxuICAgICAgICAgICAgdGltZVVuaXQ6IHRoaXMudGltZVVuaXQsXG4gICAgICAgICAgICBhZGRpdGlvbmFsQXJ0aWZhY3RzOiB0aGlzLmFkZGl0aW9uYWxBcnRpZmFjdHMsXG4gICAgICAgICAgICBhZGRpdGlvbmFsU2NoZW1hRWxlbWVudHM6IHRoaXMuYWRkaXRpb25hbFNjaGVtYUVsZW1lbnRzLFxuICAgICAgICAgICAgYmlsbGluZ1ZpZXdBcm46IHRoaXMuYmlsbGluZ1ZpZXdBcm4sXG4gICAgICAgIH07XG4gICAgfVxuXG4gICAgcHJvdGVjdGVkIHJlbmRlclByb3BlcnRpZXMocHJvcHM6IHtba2V5OiBzdHJpbmddOiBhbnl9KTogeyBba2V5OiBzdHJpbmddOiBhbnkgfSAge1xuICAgICAgICByZXR1cm4gY2ZuUmVwb3J0RGVmaW5pdGlvblByb3BzVG9DbG91ZEZvcm1hdGlvbihwcm9wcyk7XG4gICAgfVxufVxuIl19