"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const targets = require("../../aws-events-targets");
const lambda = require("../../aws-lambda");
const sns = require("../../aws-sns");
const cdk = require("../../core");
const config = require("../lib");
const app = new cdk.App();
class ConfigStack extends cdk.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        /// !show
        // A custom rule that runs on configuration changes of EC2 instances
        const fn = new lambda.Function(this, 'CustomFunction', {
            code: lambda.AssetCode.fromInline('exports.handler = (event) => console.log(event);'),
            handler: 'index.handler',
            runtime: lambda.Runtime.NODEJS_10_X,
        });
        new config.CustomRule(this, 'Custom', {
            configurationChanges: true,
            lambdaFunction: fn,
            ruleScope: config.RuleScope.fromResources([config.ResourceType.EC2_INSTANCE]),
        });
        // A rule to detect stacks drifts
        const driftRule = new config.CloudFormationStackDriftDetectionCheck(this, 'Drift');
        // Topic for compliance events
        const complianceTopic = new sns.Topic(this, 'ComplianceTopic');
        // Send notification on compliance change
        driftRule.onComplianceChange('ComplianceChange', {
            target: new targets.SnsTopic(complianceTopic),
        });
    }
}
new ConfigStack(app, 'aws-cdk-config-rule-integ');
app.synth();
//# sourceMappingURL=data:application/json;base64,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