"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolAuthenticationProvider = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const constructs_1 = require("constructs");
/**
 * Defines a User Pool Authentication Provider
 */
class UserPoolAuthenticationProvider {
    constructor(props) {
        var _b;
        jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_UserPoolAuthenticationProviderProps(props);
        this.userPool = props.userPool;
        this.userPoolClient = props.userPoolClient || this.userPool.addClient('UserPoolAuthenticationProviderClient');
        this.disableServerSideTokenCheck = (_b = props.disableServerSideTokenCheck) !== null && _b !== void 0 ? _b : false;
    }
    bind(scope, identityPool, _options) {
        jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_IIdentityPool(identityPool);
        jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_UserPoolAuthenticationProviderBindOptions(_options);
        constructs_1.Node.of(identityPool).addDependency(this.userPool);
        constructs_1.Node.of(identityPool).addDependency(this.userPoolClient);
        const region = core_1.Stack.of(scope).region;
        const urlSuffix = core_1.Stack.of(scope).urlSuffix;
        return {
            clientId: this.userPoolClient.userPoolClientId,
            providerName: `cognito-idp.${region}.${urlSuffix}/${this.userPool.userPoolId}`,
            serverSideTokenCheck: !this.disableServerSideTokenCheck,
        };
    }
}
exports.UserPoolAuthenticationProvider = UserPoolAuthenticationProvider;
_a = JSII_RTTI_SYMBOL_1;
UserPoolAuthenticationProvider[_a] = { fqn: "monocdk.aws_cognito_identitypool.UserPoolAuthenticationProvider", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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