"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IdentityPoolRoleAttachment = exports.RoleMappingMatchType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cognito_1 = require("../../aws-cognito");
const core_1 = require("../../core");
/**
 * Types of matches allowed for Role Mapping
 */
var RoleMappingMatchType;
(function (RoleMappingMatchType) {
    /**
     * The Claim from the token must equal the given value in order for a match
     */
    RoleMappingMatchType["EQUALS"] = "Equals";
    /**
     * The Claim from the token must contain the given value in order for a match
     */
    RoleMappingMatchType["CONTAINS"] = "Contains";
    /**
     * The Claim from the token must start with the given value in order for a match
     */
    RoleMappingMatchType["STARTS_WITH"] = "StartsWith";
    /**
     * The Claim from the token must not equal the given value in order for a match
     */
    RoleMappingMatchType["NOTEQUAL"] = "NotEqual";
})(RoleMappingMatchType = exports.RoleMappingMatchType || (exports.RoleMappingMatchType = {}));
/**
 * Defines an Identity Pool Role Attachment
 *
 * @resource AWS::Cognito::IdentityPoolRoleAttachment
 */
class IdentityPoolRoleAttachment extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        jsiiDeprecationWarnings.monocdk_aws_cognito_identitypool_IdentityPoolRoleAttachmentProps(props);
        this.identityPoolId = props.identityPool.identityPoolId;
        const mappings = props.roleMappings || [];
        let roles = undefined, roleMappings = undefined;
        if (props.authenticatedRole || props.unauthenticatedRole) {
            roles = {};
            if (props.authenticatedRole)
                roles.authenticated = props.authenticatedRole.roleArn;
            if (props.unauthenticatedRole)
                roles.unauthenticated = props.unauthenticatedRole.roleArn;
        }
        if (mappings) {
            roleMappings = this.configureRoleMappings(...mappings);
        }
        new aws_cognito_1.CfnIdentityPoolRoleAttachment(this, 'Resource', {
            identityPoolId: this.identityPoolId,
            roles,
            roleMappings,
        });
    }
    /**
     * Configures Role Mappings for Identity Pool Role Attachment
     */
    configureRoleMappings(...props) {
        if (!props || !props.length)
            return undefined;
        return props.reduce((acc, prop) => {
            let roleMapping = {
                ambiguousRoleResolution: prop.resolveAmbiguousRoles ? 'AuthenticatedRole' : 'Deny',
                type: prop.useToken ? 'Token' : 'Rules',
                identityProvider: prop.providerUrl.value,
            };
            if (roleMapping.type === 'Rules') {
                if (!prop.rules) {
                    throw new Error('IdentityPoolRoleMapping.rules is required when useToken is false');
                }
                roleMapping.rulesConfiguration = {
                    rules: prop.rules.map(rule => {
                        return {
                            claim: rule.claim,
                            value: rule.claimValue,
                            matchType: rule.matchType || RoleMappingMatchType.EQUALS,
                            roleArn: rule.mappedRole.roleArn,
                        };
                    }),
                };
            }
            ;
            acc[prop.providerUrl.value] = roleMapping;
            return acc;
        }, {});
    }
}
exports.IdentityPoolRoleAttachment = IdentityPoolRoleAttachment;
_a = JSII_RTTI_SYMBOL_1;
IdentityPoolRoleAttachment[_a] = { fqn: "monocdk.aws_cognito_identitypool.IdentityPoolRoleAttachment", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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