"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationRule = exports.DetailType = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("../../core");
const codestarnotifications_generated_1 = require("./codestarnotifications.generated");
/**
 * The level of detail to include in the notifications for this resource.
 */
var DetailType;
(function (DetailType) {
    /**
     * BASIC will include only the contents of the event as it would appear in AWS CloudWatch
     */
    DetailType["BASIC"] = "BASIC";
    /**
     * FULL will include any supplemental information provided by AWS CodeStar Notifications and/or the service for the resource for which the notification is created.
     */
    DetailType["FULL"] = "FULL";
})(DetailType = exports.DetailType || (exports.DetailType = {}));
/**
 * A new notification rule
 *
 * @resource AWS::CodeStarNotifications::NotificationRule
 */
class NotificationRule extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        this.targets = [];
        this.events = [];
        jsiiDeprecationWarnings.monocdk_aws_codestarnotifications_NotificationRuleProps(props);
        const source = props.source.bindAsNotificationRuleSource(this);
        this.addEvents(props.events);
        const resource = new codestarnotifications_generated_1.CfnNotificationRule(this, 'Resource', {
            // It has a 64 characters limit for the name
            name: props.notificationRuleName || core_1.Names.uniqueId(this).slice(-64),
            detailType: props.detailType || DetailType.FULL,
            targets: this.targets,
            eventTypeIds: this.events,
            resource: source.sourceArn,
            status: props.enabled !== undefined
                ? (props.enabled ? 'ENABLED' : 'DISABLED')
                : undefined,
        });
        this.notificationRuleArn = resource.ref;
        (_b = props.targets) === null || _b === void 0 ? void 0 : _b.forEach((target) => {
            this.addTarget(target);
        });
    }
    /**
     * Import an existing notification rule provided an ARN
     * @param scope The parent creating construct
     * @param id The construct's name
     * @param notificationRuleArn Notification rule ARN (i.e. arn:aws:codestar-notifications:::notificationrule/01234abcde)
     */
    static fromNotificationRuleArn(scope, id, notificationRuleArn) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.notificationRuleArn = notificationRuleArn;
            }
            addTarget(_target) {
                return false;
            }
        }
        return new Import(scope, id, {
            environmentFromArn: notificationRuleArn,
        });
    }
    /**
     * Adds target to notification rule
     * @param target The SNS topic or AWS Chatbot Slack target
     */
    addTarget(target) {
        jsiiDeprecationWarnings.monocdk_aws_codestarnotifications_INotificationRuleTarget(target);
        this.targets.push(target.bindAsNotificationRuleTarget(this));
        return true;
    }
    /**
     * Adds events to notification rule
     *
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline
     * @see https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject
     * @param events The list of event types for AWS Codebuild and AWS CodePipeline
     */
    addEvents(events) {
        events.forEach((event) => {
            if (this.events.includes(event)) {
                return;
            }
            this.events.push(event);
        });
    }
}
exports.NotificationRule = NotificationRule;
_a = JSII_RTTI_SYMBOL_1;
NotificationRule[_a] = { fqn: "monocdk.aws_codestarnotifications.NotificationRule", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,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