"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FullActionDescriptor = void 0;
/**
 * This class is private to the aws-codepipeline package.
 */
class FullActionDescriptor {
    constructor(props) {
        var _a, _b;
        this.action = props.action;
        const actionProperties = props.action.actionProperties;
        this.actionName = actionProperties.actionName;
        this.category = actionProperties.category;
        this.owner = actionProperties.owner || 'AWS';
        this.provider = actionProperties.provider;
        this.version = actionProperties.version || '1';
        this.runOrder = (_a = actionProperties.runOrder) !== null && _a !== void 0 ? _a : 1;
        this.artifactBounds = actionProperties.artifactBounds;
        this.namespace = actionProperties.variablesNamespace;
        this.inputs = deduplicateArtifacts(actionProperties.inputs);
        this.outputs = deduplicateArtifacts(actionProperties.outputs);
        this.region = props.actionRegion || actionProperties.region;
        this.role = (_b = actionProperties.role) !== null && _b !== void 0 ? _b : props.actionRole;
        this.configuration = props.actionConfig.configuration;
    }
}
exports.FullActionDescriptor = FullActionDescriptor;
function deduplicateArtifacts(artifacts) {
    const ret = new Array();
    for (const artifact of artifacts || []) {
        if (artifact.artifactName) {
            if (ret.find(a => a.artifactName === artifact.artifactName)) {
                continue;
            }
        }
        else {
            if (ret.find(a => a === artifact)) {
                continue;
            }
        }
        ret.push(artifact);
    }
    return ret;
}
//# sourceMappingURL=data:application/json;base64,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