"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionInvokeAction = exports.StateMachineInput = void 0;
const jsiiDeprecationWarnings = require("../../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../../aws-codepipeline");
const iam = require("../../../aws-iam");
const cdk = require("../../../core");
const action_1 = require("../action");
/**
 * Represents the input for the StateMachine.
 */
class StateMachineInput {
    constructor(input, inputArtifact, inputType) {
        this.input = input;
        this.inputArtifact = inputArtifact;
        this.inputType = inputType;
    }
    /**
     * When the input type is FilePath, input artifact and
     * filepath must be specified.
     */
    static filePath(inputFile) {
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ArtifactPath(inputFile);
        return new StateMachineInput(inputFile.location, inputFile.artifact, 'FilePath');
    }
    /**
     * When the input type is Literal, input value is passed
     * directly to the state machine input.
     */
    static literal(object) {
        return new StateMachineInput(JSON.stringify(object), undefined, 'Literal');
    }
}
exports.StateMachineInput = StateMachineInput;
_a = JSII_RTTI_SYMBOL_1;
StateMachineInput[_a] = { fqn: "monocdk.aws_codepipeline_actions.StateMachineInput", version: "1.149.0" };
/**
 * StepFunctionInvokeAction that is provided by an AWS CodePipeline.
 */
class StepFunctionInvokeAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            resource: props.stateMachine,
            category: codepipeline.ActionCategory.INVOKE,
            provider: 'StepFunctions',
            artifactBounds: {
                minInputs: 0,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 1,
            },
            inputs: (props.stateMachineInput && props.stateMachineInput.inputArtifact) ? [props.stateMachineInput.inputArtifact] : [],
            outputs: (props.output) ? [props.output] : [],
        });
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_StepFunctionsInvokeActionProps(props);
        this.props = props;
    }
    bound(_scope, _stage, options) {
        var _c, _d, _e, _f, _g;
        jsiiDeprecationWarnings.monocdk_Construct(_scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(_stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        // allow pipeline to invoke this step function
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:StartExecution', 'states:DescribeStateMachine'],
            resources: [this.props.stateMachine.stateMachineArn],
        }));
        // allow state machine executions to be inspected
        options.role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['states:DescribeExecution'],
            resources: [cdk.Stack.of(this.props.stateMachine).formatArn({
                    service: 'states',
                    resource: 'execution',
                    resourceName: `${cdk.Stack.of(this.props.stateMachine).splitArn(this.props.stateMachine.stateMachineArn, cdk.ArnFormat.COLON_RESOURCE_NAME).resourceName}:${(_c = this.props.executionNamePrefix) !== null && _c !== void 0 ? _c : ''}*`,
                    arnFormat: cdk.ArnFormat.COLON_RESOURCE_NAME,
                })],
        }));
        // allow the Role access to the Bucket, if there are any inputs/outputs
        if (((_d = this.actionProperties.inputs) !== null && _d !== void 0 ? _d : []).length > 0) {
            options.bucket.grantRead(options.role);
        }
        if (((_e = this.actionProperties.outputs) !== null && _e !== void 0 ? _e : []).length > 0) {
            options.bucket.grantWrite(options.role);
        }
        return {
            configuration: {
                StateMachineArn: this.props.stateMachine.stateMachineArn,
                Input: (_f = this.props.stateMachineInput) === null || _f === void 0 ? void 0 : _f.input,
                InputType: (_g = this.props.stateMachineInput) === null || _g === void 0 ? void 0 : _g.inputType,
                ExecutionNamePrefix: this.props.executionNamePrefix,
            },
        };
    }
}
exports.StepFunctionInvokeAction = StepFunctionInvokeAction;
_b = JSII_RTTI_SYMBOL_1;
StepFunctionInvokeAction[_b] = { fqn: "monocdk.aws_codepipeline_actions.StepFunctionInvokeAction", version: "1.149.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW52b2tlLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludm9rZS1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsMERBQTBEO0FBQzFELHdDQUF3QztBQUV4QyxxQ0FBcUM7QUFDckMsc0NBQW1DO0FBTW5DOztHQUVHO0FBQ0gsTUFBYSxpQkFBaUI7SUErQzVCLFlBQW9CLEtBQVUsRUFBRSxhQUFnRCxFQUFFLFNBQWlCO1FBQ2pHLElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ25CLElBQUksQ0FBQyxhQUFhLEdBQUcsYUFBYSxDQUFDO1FBQ25DLElBQUksQ0FBQyxTQUFTLEdBQUcsU0FBUyxDQUFDO0tBQzVCO0lBbEREOzs7T0FHRztJQUNJLE1BQU0sQ0FBQyxRQUFRLENBQUMsU0FBb0M7O1FBQ3pELE9BQU8sSUFBSSxpQkFBaUIsQ0FBQyxTQUFTLENBQUMsUUFBUSxFQUFFLFNBQVMsQ0FBQyxRQUFRLEVBQUUsVUFBVSxDQUFDLENBQUM7S0FDbEY7SUFFRDs7O09BR0c7SUFDSSxNQUFNLENBQUMsT0FBTyxDQUFDLE1BQWM7UUFDbEMsT0FBTyxJQUFJLGlCQUFpQixDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLEVBQUUsU0FBUyxFQUFFLFNBQVMsQ0FBQyxDQUFDO0tBQzVFOztBQWZILDhDQW9EQzs7O0FBc0NEOztHQUVHO0FBQ0gsTUFBYSx3QkFBeUIsU0FBUSxlQUFNO0lBR2xELFlBQVksS0FBcUM7UUFDL0MsS0FBSyxDQUFDO1lBQ0osR0FBRyxLQUFLO1lBQ1IsUUFBUSxFQUFFLEtBQUssQ0FBQyxZQUFZO1lBQzVCLFFBQVEsRUFBRSxZQUFZLENBQUMsY0FBYyxDQUFDLE1BQU07WUFDNUMsUUFBUSxFQUFFLGVBQWU7WUFDekIsY0FBYyxFQUFFO2dCQUNkLFNBQVMsRUFBRSxDQUFDO2dCQUNaLFNBQVMsRUFBRSxDQUFDO2dCQUNaLFVBQVUsRUFBRSxDQUFDO2dCQUNiLFVBQVUsRUFBRSxDQUFDO2FBQ2Q7WUFDRCxNQUFNLEVBQUUsQ0FBQyxLQUFLLENBQUMsaUJBQWlCLElBQUksS0FBSyxDQUFDLGlCQUFpQixDQUFDLGFBQWEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtZQUN6SCxPQUFPLEVBQUUsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO1NBQzlDLENBQUMsQ0FBQzs7UUFDSCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztLQUNwQjtJQUVTLEtBQUssQ0FBQyxNQUFpQixFQUFFLE1BQTJCLEVBQUUsT0FBdUM7Ozs7O1FBRXJHLDhDQUE4QztRQUM5QyxPQUFPLENBQUMsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUN4RCxPQUFPLEVBQUUsQ0FBQyx1QkFBdUIsRUFBRSw2QkFBNkIsQ0FBQztZQUNqRSxTQUFTLEVBQUUsQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLFlBQVksQ0FBQyxlQUFlLENBQUM7U0FDckQsQ0FBQyxDQUFDLENBQUM7UUFFSixpREFBaUQ7UUFDakQsT0FBTyxDQUFDLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDeEQsT0FBTyxFQUFFLENBQUMsMEJBQTBCLENBQUM7WUFDckMsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxTQUFTLENBQUM7b0JBQzFELE9BQU8sRUFBRSxRQUFRO29CQUNqQixRQUFRLEVBQUUsV0FBVztvQkFDckIsWUFBWSxFQUFFLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsZUFBZSxFQUFFLEdBQUcsQ0FBQyxTQUFTLENBQUMsbUJBQW1CLENBQUMsQ0FBQyxZQUFZLElBQUksTUFBQSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQixtQ0FBSSxFQUFFLEdBQUc7b0JBQ25NLFNBQVMsRUFBRSxHQUFHLENBQUMsU0FBUyxDQUFDLG1CQUFtQjtpQkFDN0MsQ0FBQyxDQUFDO1NBQ0osQ0FBQyxDQUFDLENBQUM7UUFFSix1RUFBdUU7UUFDdkUsSUFBSSxPQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxNQUFNLG1DQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDbkQsT0FBTyxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ3hDO1FBQ0QsSUFBSSxPQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxPQUFPLG1DQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDcEQsT0FBTyxDQUFDLE1BQU0sQ0FBQyxVQUFVLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO1NBQ3pDO1FBRUQsT0FBTztZQUNMLGFBQWEsRUFBRTtnQkFDYixlQUFlLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxZQUFZLENBQUMsZUFBZTtnQkFDeEQsS0FBSyxRQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsaUJBQWlCLDBDQUFFLEtBQUs7Z0JBQzFDLFNBQVMsUUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQiwwQ0FBRSxTQUFTO2dCQUNsRCxtQkFBbUIsRUFBRSxJQUFJLENBQUMsS0FBSyxDQUFDLG1CQUFtQjthQUNwRDtTQUNGLENBQUM7S0FDSDs7QUF4REgsNERBeURDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY29kZXBpcGVsaW5lIGZyb20gJy4uLy4uLy4uL2F3cy1jb2RlcGlwZWxpbmUnO1xuaW1wb3J0ICogYXMgaWFtIGZyb20gJy4uLy4uLy4uL2F3cy1pYW0nO1xuaW1wb3J0ICogYXMgc3RlcGZ1bmN0aW9uIGZyb20gJy4uLy4uLy4uL2F3cy1zdGVwZnVuY3Rpb25zJztcbmltcG9ydCAqIGFzIGNkayBmcm9tICcuLi8uLi8uLi9jb3JlJztcbmltcG9ydCB7IEFjdGlvbiB9IGZyb20gJy4uL2FjdGlvbic7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi8uLi9jb3JlJztcblxuLyoqXG4gKiBSZXByZXNlbnRzIHRoZSBpbnB1dCBmb3IgdGhlIFN0YXRlTWFjaGluZS5cbiAqL1xuZXhwb3J0IGNsYXNzIFN0YXRlTWFjaGluZUlucHV0IHtcbiAgLyoqXG4gICAqIFdoZW4gdGhlIGlucHV0IHR5cGUgaXMgRmlsZVBhdGgsIGlucHV0IGFydGlmYWN0IGFuZFxuICAgKiBmaWxlcGF0aCBtdXN0IGJlIHNwZWNpZmllZC5cbiAgICovXG4gIHB1YmxpYyBzdGF0aWMgZmlsZVBhdGgoaW5wdXRGaWxlOiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3RQYXRoKTogU3RhdGVNYWNoaW5lSW5wdXQge1xuICAgIHJldHVybiBuZXcgU3RhdGVNYWNoaW5lSW5wdXQoaW5wdXRGaWxlLmxvY2F0aW9uLCBpbnB1dEZpbGUuYXJ0aWZhY3QsICdGaWxlUGF0aCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFdoZW4gdGhlIGlucHV0IHR5cGUgaXMgTGl0ZXJhbCwgaW5wdXQgdmFsdWUgaXMgcGFzc2VkXG4gICAqIGRpcmVjdGx5IHRvIHRoZSBzdGF0ZSBtYWNoaW5lIGlucHV0LlxuICAgKi9cbiAgcHVibGljIHN0YXRpYyBsaXRlcmFsKG9iamVjdDogb2JqZWN0KTogU3RhdGVNYWNoaW5lSW5wdXQge1xuICAgIHJldHVybiBuZXcgU3RhdGVNYWNoaW5lSW5wdXQoSlNPTi5zdHJpbmdpZnkob2JqZWN0KSwgdW5kZWZpbmVkLCAnTGl0ZXJhbCcpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBvcHRpb25hbCBpbnB1dCBBcnRpZmFjdCBvZiB0aGUgQWN0aW9uLlxuICAgKiBJZiBJbnB1dFR5cGUgaXMgc2V0IHRvIEZpbGVQYXRoLCB0aGlzIGFydGlmYWN0IGlzIHJlcXVpcmVkXG4gICAqIGFuZCBpcyB1c2VkIHRvIHNvdXJjZSB0aGUgaW5wdXQgZm9yIHRoZSBzdGF0ZSBtYWNoaW5lIGV4ZWN1dGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0aGUgQWN0aW9uIHdpbGwgbm90IGhhdmUgYW55IGlucHV0c1xuICAgKiBAc2VlIGh0dHBzOi8vZG9jcy5hd3MuYW1hem9uLmNvbS9jb2RlcGlwZWxpbmUvbGF0ZXN0L3VzZXJndWlkZS9hY3Rpb24tcmVmZXJlbmNlLVN0ZXBGdW5jdGlvbnMuaHRtbCNhY3Rpb24tcmVmZXJlbmNlLVN0ZXBGdW5jdGlvbnMtZXhhbXBsZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGlucHV0QXJ0aWZhY3Q/OiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3Q7XG5cbiAgLyoqXG4gICAqIE9wdGlvbmFsIFN0YXRlTWFjaGluZSBJbnB1dFR5cGVcbiAgICogSW5wdXRUeXBlIGNhbiBiZSBMaXRlcmFsIG9yIEZpbGVQYXRoXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTGl0ZXJhbFxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGlucHV0VHlwZT86IHN0cmluZztcblxuICAvKipcbiAgICogV2hlbiBJbnB1dFR5cGUgaXMgc2V0IHRvIExpdGVyYWwgKGRlZmF1bHQpLCB0aGUgSW5wdXQgZmllbGQgaXMgdXNlZFxuICAgKiBkaXJlY3RseSBhcyB0aGUgaW5wdXQgZm9yIHRoZSBzdGF0ZSBtYWNoaW5lIGV4ZWN1dGlvbi5cbiAgICogT3RoZXJ3aXNlLCB0aGUgc3RhdGUgbWFjaGluZSBpcyBpbnZva2VkIHdpdGggYW4gZW1wdHkgSlNPTiBvYmplY3Qge30uXG4gICAqXG4gICAqIFdoZW4gSW5wdXRUeXBlIGlzIHNldCB0byBGaWxlUGF0aCwgdGhpcyBmaWVsZCBpcyByZXF1aXJlZC5cbiAgICogQW4gaW5wdXQgYXJ0aWZhY3QgaXMgYWxzbyByZXF1aXJlZCB3aGVuIElucHV0VHlwZSBpcyBzZXQgdG8gRmlsZVBhdGguXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gbm9uZVxuICAgKi9cbiAgcHVibGljIHJlYWRvbmx5IGlucHV0OiBhbnk7XG5cbiAgcHJpdmF0ZSBjb25zdHJ1Y3RvcihpbnB1dDogYW55LCBpbnB1dEFydGlmYWN0OiBjb2RlcGlwZWxpbmUuQXJ0aWZhY3QgfCB1bmRlZmluZWQsIGlucHV0VHlwZTogc3RyaW5nKSB7XG4gICAgdGhpcy5pbnB1dCA9IGlucHV0O1xuICAgIHRoaXMuaW5wdXRBcnRpZmFjdCA9IGlucHV0QXJ0aWZhY3Q7XG4gICAgdGhpcy5pbnB1dFR5cGUgPSBpbnB1dFR5cGU7XG4gIH1cbn1cblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBvZiB0aGUge0BsaW5rIFN0ZXBGdW5jdGlvbnNJbnZva2VBY3Rpb24gU3RlcEZ1bmN0aW9uIEludm9rZSBBY3Rpb259LlxuICovXG5leHBvcnQgaW50ZXJmYWNlIFN0ZXBGdW5jdGlvbnNJbnZva2VBY3Rpb25Qcm9wcyBleHRlbmRzIGNvZGVwaXBlbGluZS5Db21tb25Bd3NBY3Rpb25Qcm9wcyB7XG4gIC8qKlxuICAgKiBUaGUgb3B0aW9uYWwgb3V0cHV0IEFydGlmYWN0IG9mIHRoZSBBY3Rpb24uXG4gICAqXG4gICAqIEBkZWZhdWx0IHRoZSBBY3Rpb24gd2lsbCBub3QgaGF2ZSBhbnkgb3V0cHV0c1xuICAgKi9cbiAgcmVhZG9ubHkgb3V0cHV0PzogY29kZXBpcGVsaW5lLkFydGlmYWN0O1xuXG4gIC8qKlxuICAgKiBUaGUgc3RhdGUgbWFjaGluZSB0byBpbnZva2UuXG4gICAqL1xuICByZWFkb25seSBzdGF0ZU1hY2hpbmU6IHN0ZXBmdW5jdGlvbi5JU3RhdGVNYWNoaW5lO1xuXG4gIC8qKlxuICAgKiBSZXByZXNlbnRzIHRoZSBpbnB1dCB0byB0aGUgU3RhdGVNYWNoaW5lLlxuICAgKiBUaGlzIGluY2x1ZGVzIGlucHV0IGFydGlmYWN0LCBpbnB1dCB0eXBlIGFuZCB0aGUgc3RhdGVtYWNoaW5lIGlucHV0LlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vbmVcbiAgICovXG4gIHJlYWRvbmx5IHN0YXRlTWFjaGluZUlucHV0PzogU3RhdGVNYWNoaW5lSW5wdXQ7XG5cbiAgLyoqXG4gICAqIFByZWZpeCAob3B0aW9uYWwpXG4gICAqXG4gICAqIEJ5IGRlZmF1bHQsIHRoZSBhY3Rpb24gZXhlY3V0aW9uIElEIGlzIHVzZWQgYXMgdGhlIHN0YXRlIG1hY2hpbmUgZXhlY3V0aW9uIG5hbWUuXG4gICAqIElmIGEgcHJlZml4IGlzIHByb3ZpZGVkLCBpdCBpcyBwcmVwZW5kZWQgdG8gdGhlIGFjdGlvbiBleGVjdXRpb24gSUQgd2l0aCBhIGh5cGhlbiBhbmRcbiAgICogdG9nZXRoZXIgdXNlZCBhcyB0aGUgc3RhdGUgbWFjaGluZSBleGVjdXRpb24gbmFtZS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBhY3Rpb24gZXhlY3V0aW9uIElEXG4gICAqL1xuICByZWFkb25seSBleGVjdXRpb25OYW1lUHJlZml4Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFN0ZXBGdW5jdGlvbkludm9rZUFjdGlvbiB0aGF0IGlzIHByb3ZpZGVkIGJ5IGFuIEFXUyBDb2RlUGlwZWxpbmUuXG4gKi9cbmV4cG9ydCBjbGFzcyBTdGVwRnVuY3Rpb25JbnZva2VBY3Rpb24gZXh0ZW5kcyBBY3Rpb24ge1xuICBwcml2YXRlIHJlYWRvbmx5IHByb3BzOiBTdGVwRnVuY3Rpb25zSW52b2tlQWN0aW9uUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IFN0ZXBGdW5jdGlvbnNJbnZva2VBY3Rpb25Qcm9wcykge1xuICAgIHN1cGVyKHtcbiAgICAgIC4uLnByb3BzLFxuICAgICAgcmVzb3VyY2U6IHByb3BzLnN0YXRlTWFjaGluZSxcbiAgICAgIGNhdGVnb3J5OiBjb2RlcGlwZWxpbmUuQWN0aW9uQ2F0ZWdvcnkuSU5WT0tFLFxuICAgICAgcHJvdmlkZXI6ICdTdGVwRnVuY3Rpb25zJyxcbiAgICAgIGFydGlmYWN0Qm91bmRzOiB7XG4gICAgICAgIG1pbklucHV0czogMCxcbiAgICAgICAgbWF4SW5wdXRzOiAxLFxuICAgICAgICBtaW5PdXRwdXRzOiAwLFxuICAgICAgICBtYXhPdXRwdXRzOiAxLFxuICAgICAgfSxcbiAgICAgIGlucHV0czogKHByb3BzLnN0YXRlTWFjaGluZUlucHV0ICYmIHByb3BzLnN0YXRlTWFjaGluZUlucHV0LmlucHV0QXJ0aWZhY3QpID8gW3Byb3BzLnN0YXRlTWFjaGluZUlucHV0LmlucHV0QXJ0aWZhY3RdIDogW10sXG4gICAgICBvdXRwdXRzOiAocHJvcHMub3V0cHV0KSA/IFtwcm9wcy5vdXRwdXRdIDogW10sXG4gICAgfSk7XG4gICAgdGhpcy5wcm9wcyA9IHByb3BzO1xuICB9XG5cbiAgcHJvdGVjdGVkIGJvdW5kKF9zY29wZTogQ29uc3RydWN0LCBfc3RhZ2U6IGNvZGVwaXBlbGluZS5JU3RhZ2UsIG9wdGlvbnM6IGNvZGVwaXBlbGluZS5BY3Rpb25CaW5kT3B0aW9ucyk6XG4gIGNvZGVwaXBlbGluZS5BY3Rpb25Db25maWcge1xuICAgIC8vIGFsbG93IHBpcGVsaW5lIHRvIGludm9rZSB0aGlzIHN0ZXAgZnVuY3Rpb25cbiAgICBvcHRpb25zLnJvbGUuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydzdGF0ZXM6U3RhcnRFeGVjdXRpb24nLCAnc3RhdGVzOkRlc2NyaWJlU3RhdGVNYWNoaW5lJ10sXG4gICAgICByZXNvdXJjZXM6IFt0aGlzLnByb3BzLnN0YXRlTWFjaGluZS5zdGF0ZU1hY2hpbmVBcm5dLFxuICAgIH0pKTtcblxuICAgIC8vIGFsbG93IHN0YXRlIG1hY2hpbmUgZXhlY3V0aW9ucyB0byBiZSBpbnNwZWN0ZWRcbiAgICBvcHRpb25zLnJvbGUuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydzdGF0ZXM6RGVzY3JpYmVFeGVjdXRpb24nXSxcbiAgICAgIHJlc291cmNlczogW2Nkay5TdGFjay5vZih0aGlzLnByb3BzLnN0YXRlTWFjaGluZSkuZm9ybWF0QXJuKHtcbiAgICAgICAgc2VydmljZTogJ3N0YXRlcycsXG4gICAgICAgIHJlc291cmNlOiAnZXhlY3V0aW9uJyxcbiAgICAgICAgcmVzb3VyY2VOYW1lOiBgJHtjZGsuU3RhY2sub2YodGhpcy5wcm9wcy5zdGF0ZU1hY2hpbmUpLnNwbGl0QXJuKHRoaXMucHJvcHMuc3RhdGVNYWNoaW5lLnN0YXRlTWFjaGluZUFybiwgY2RrLkFybkZvcm1hdC5DT0xPTl9SRVNPVVJDRV9OQU1FKS5yZXNvdXJjZU5hbWV9OiR7dGhpcy5wcm9wcy5leGVjdXRpb25OYW1lUHJlZml4ID8/ICcnfSpgLFxuICAgICAgICBhcm5Gb3JtYXQ6IGNkay5Bcm5Gb3JtYXQuQ09MT05fUkVTT1VSQ0VfTkFNRSxcbiAgICAgIH0pXSxcbiAgICB9KSk7XG5cbiAgICAvLyBhbGxvdyB0aGUgUm9sZSBhY2Nlc3MgdG8gdGhlIEJ1Y2tldCwgaWYgdGhlcmUgYXJlIGFueSBpbnB1dHMvb3V0cHV0c1xuICAgIGlmICgodGhpcy5hY3Rpb25Qcm9wZXJ0aWVzLmlucHV0cyA/PyBbXSkubGVuZ3RoID4gMCkge1xuICAgICAgb3B0aW9ucy5idWNrZXQuZ3JhbnRSZWFkKG9wdGlvbnMucm9sZSk7XG4gICAgfVxuICAgIGlmICgodGhpcy5hY3Rpb25Qcm9wZXJ0aWVzLm91dHB1dHMgPz8gW10pLmxlbmd0aCA+IDApIHtcbiAgICAgIG9wdGlvbnMuYnVja2V0LmdyYW50V3JpdGUob3B0aW9ucy5yb2xlKTtcbiAgICB9XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlndXJhdGlvbjoge1xuICAgICAgICBTdGF0ZU1hY2hpbmVBcm46IHRoaXMucHJvcHMuc3RhdGVNYWNoaW5lLnN0YXRlTWFjaGluZUFybixcbiAgICAgICAgSW5wdXQ6IHRoaXMucHJvcHMuc3RhdGVNYWNoaW5lSW5wdXQ/LmlucHV0LFxuICAgICAgICBJbnB1dFR5cGU6IHRoaXMucHJvcHMuc3RhdGVNYWNoaW5lSW5wdXQ/LmlucHV0VHlwZSxcbiAgICAgICAgRXhlY3V0aW9uTmFtZVByZWZpeDogdGhpcy5wcm9wcy5leGVjdXRpb25OYW1lUHJlZml4LFxuICAgICAgfSxcbiAgICB9O1xuICB9XG59Il19