"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManualApprovalAction = void 0;
const jsiiDeprecationWarnings = require("../../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const codepipeline = require("../../aws-codepipeline");
const iam = require("../../aws-iam");
const sns = require("../../aws-sns");
const subs = require("../../aws-sns-subscriptions");
const action_1 = require("./action");
/**
 * Manual approval action.
 */
class ManualApprovalAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            category: codepipeline.ActionCategory.APPROVAL,
            provider: 'Manual',
            artifactBounds: { minInputs: 0, maxInputs: 0, minOutputs: 0, maxOutputs: 0 },
        });
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_actions_ManualApprovalActionProps(props);
        this.props = props;
    }
    get notificationTopic() {
        return this._notificationTopic;
    }
    /**
     * grant the provided principal the permissions to approve or reject this manual approval action
     *
     * For more info see:
     * https://docs.aws.amazon.com/codepipeline/latest/userguide/approvals-iam-permissions.html
     *
     * @param grantable the grantable to attach the permissions to
     */
    grantManualApproval(grantable) {
        jsiiDeprecationWarnings.monocdk_aws_iam_IGrantable(grantable);
        if (!this.stage) {
            throw new Error('Cannot grant permissions before binding action to a stage');
        }
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:ListPipelines'],
            resources: ['*'],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:GetPipeline', 'codepipeline:GetPipelineState', 'codepipeline:GetPipelineExecution'],
            resources: [this.stage.pipeline.pipelineArn],
        }));
        grantable.grantPrincipal.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['codepipeline:PutApprovalResult'],
            resources: [`${this.stage.pipeline.pipelineArn}/${this.stage.stageName}/${this.props.actionName}`],
        }));
    }
    bound(scope, stage, options) {
        var _b;
        jsiiDeprecationWarnings.monocdk_Construct(scope);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_IStage(stage);
        jsiiDeprecationWarnings.monocdk_aws_codepipeline_ActionBindOptions(options);
        if (this.props.notificationTopic) {
            this._notificationTopic = this.props.notificationTopic;
        }
        else if ((this.props.notifyEmails || []).length > 0) {
            this._notificationTopic = new sns.Topic(scope, 'TopicResource');
        }
        if (this._notificationTopic) {
            this._notificationTopic.grantPublish(options.role);
            for (const notifyEmail of this.props.notifyEmails || []) {
                this._notificationTopic.addSubscription(new subs.EmailSubscription(notifyEmail));
            }
        }
        this.stage = stage;
        return {
            configuration: undefinedIfAllValuesAreEmpty({
                NotificationArn: (_b = this._notificationTopic) === null || _b === void 0 ? void 0 : _b.topicArn,
                CustomData: this.props.additionalInformation,
                ExternalEntityLink: this.props.externalEntityLink,
            }),
        };
    }
}
exports.ManualApprovalAction = ManualApprovalAction;
_a = JSII_RTTI_SYMBOL_1;
ManualApprovalAction[_a] = { fqn: "monocdk.aws_codepipeline_actions.ManualApprovalAction", version: "1.149.0" };
function undefinedIfAllValuesAreEmpty(object) {
    return Object.values(object).some(v => v !== undefined) ? object : undefined;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibWFudWFsLWFwcHJvdmFsLWFjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1hbnVhbC1hcHByb3ZhbC1hY3Rpb24udHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsdURBQXVEO0FBQ3ZELHFDQUFxQztBQUNyQyxxQ0FBcUM7QUFDckMsb0RBQW9EO0FBQ3BELHFDQUFrQztBQW1DbEM7O0dBRUc7QUFDSCxNQUFhLG9CQUFxQixTQUFRLGVBQU07SUFVOUMsWUFBWSxLQUFnQztRQUMxQyxLQUFLLENBQUM7WUFDSixHQUFHLEtBQUs7WUFDUixRQUFRLEVBQUUsWUFBWSxDQUFDLGNBQWMsQ0FBQyxRQUFRO1lBQzlDLFFBQVEsRUFBRSxRQUFRO1lBQ2xCLGNBQWMsRUFBRSxFQUFFLFNBQVMsRUFBRSxDQUFDLEVBQUUsU0FBUyxFQUFFLENBQUMsRUFBRSxVQUFVLEVBQUUsQ0FBQyxFQUFFLFVBQVUsRUFBRSxDQUFDLEVBQUU7U0FDN0UsQ0FBQyxDQUFDOztRQUVILElBQUksQ0FBQyxLQUFLLEdBQUcsS0FBSyxDQUFDO0tBQ3BCO0lBRUQsSUFBVyxpQkFBaUI7UUFDMUIsT0FBTyxJQUFJLENBQUMsa0JBQWtCLENBQUM7S0FDaEM7SUFFRDs7Ozs7OztPQU9HO0lBQ0ksbUJBQW1CLENBQUMsU0FBeUI7O1FBQ2xELElBQUksQ0FBQyxJQUFJLENBQUMsS0FBSyxFQUFFO1lBQ2YsTUFBTSxJQUFJLEtBQUssQ0FBQywyREFBMkQsQ0FBQyxDQUFDO1NBQzlFO1FBQ0QsU0FBUyxDQUFDLGNBQWMsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDcEUsT0FBTyxFQUFFLENBQUMsNEJBQTRCLENBQUM7WUFDdkMsU0FBUyxFQUFFLENBQUMsR0FBRyxDQUFDO1NBQ2pCLENBQUMsQ0FBQyxDQUFDO1FBQ0osU0FBUyxDQUFDLGNBQWMsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDcEUsT0FBTyxFQUFFLENBQUMsMEJBQTBCLEVBQUUsK0JBQStCLEVBQUUsbUNBQW1DLENBQUM7WUFDM0csU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDO1NBQzdDLENBQUMsQ0FBQyxDQUFDO1FBQ0osU0FBUyxDQUFDLGNBQWMsQ0FBQyxvQkFBb0IsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQUM7WUFDcEUsT0FBTyxFQUFFLENBQUMsZ0NBQWdDLENBQUM7WUFDM0MsU0FBUyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxXQUFXLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxTQUFTLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUUsQ0FBQztTQUNuRyxDQUFDLENBQUMsQ0FBQztLQUNMO0lBRVMsS0FBSyxDQUFDLEtBQWdCLEVBQUUsS0FBMEIsRUFBRSxPQUF1Qzs7Ozs7UUFDbkcsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixFQUFFO1lBQ2hDLElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGlCQUFpQixDQUFDO1NBQ3hEO2FBQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxJQUFJLEVBQUUsQ0FBQyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUU7WUFDckQsSUFBSSxDQUFDLGtCQUFrQixHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsZUFBZSxDQUFDLENBQUM7U0FDakU7UUFFRCxJQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRTtZQUMzQixJQUFJLENBQUMsa0JBQWtCLENBQUMsWUFBWSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztZQUNuRCxLQUFLLE1BQU0sV0FBVyxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsWUFBWSxJQUFJLEVBQUUsRUFBRTtnQkFDdkQsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGVBQWUsQ0FBQyxJQUFJLElBQUksQ0FBQyxpQkFBaUIsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO2FBQ2xGO1NBQ0Y7UUFFRCxJQUFJLENBQUMsS0FBSyxHQUFHLEtBQUssQ0FBQztRQUVuQixPQUFPO1lBQ0wsYUFBYSxFQUFFLDRCQUE0QixDQUFDO2dCQUMxQyxlQUFlLFFBQUUsSUFBSSxDQUFDLGtCQUFrQiwwQ0FBRSxRQUFRO2dCQUNsRCxVQUFVLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxxQkFBcUI7Z0JBQzVDLGtCQUFrQixFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsa0JBQWtCO2FBQ2xELENBQUM7U0FDSCxDQUFDO0tBQ0g7O0FBMUVILG9EQTRFQzs7O0FBRUQsU0FBUyw0QkFBNEIsQ0FBQyxNQUFjO0lBQ2xELE9BQU8sTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEtBQUssU0FBUyxDQUFDLENBQUMsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO0FBQy9FLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBjb2RlcGlwZWxpbmUgZnJvbSAnLi4vLi4vYXdzLWNvZGVwaXBlbGluZSc7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnLi4vLi4vYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBzbnMgZnJvbSAnLi4vLi4vYXdzLXNucyc7XG5pbXBvcnQgKiBhcyBzdWJzIGZyb20gJy4uLy4uL2F3cy1zbnMtc3Vic2NyaXB0aW9ucyc7XG5pbXBvcnQgeyBBY3Rpb24gfSBmcm9tICcuL2FjdGlvbic7XG5cbi8vIGtlZXAgdGhpcyBpbXBvcnQgc2VwYXJhdGUgZnJvbSBvdGhlciBpbXBvcnRzIHRvIHJlZHVjZSBjaGFuY2UgZm9yIG1lcmdlIGNvbmZsaWN0cyB3aXRoIHYyLW1haW5cbi8vIGVzbGludC1kaXNhYmxlLW5leHQtbGluZSBuby1kdXBsaWNhdGUtaW1wb3J0cywgaW1wb3J0L29yZGVyXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICcuLi8uLi9jb3JlJztcblxuLyoqXG4gKiBDb25zdHJ1Y3Rpb24gcHJvcGVydGllcyBvZiB0aGUge0BsaW5rIE1hbnVhbEFwcHJvdmFsQWN0aW9ufS5cbiAqL1xuZXhwb3J0IGludGVyZmFjZSBNYW51YWxBcHByb3ZhbEFjdGlvblByb3BzIGV4dGVuZHMgY29kZXBpcGVsaW5lLkNvbW1vbkF3c0FjdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIE9wdGlvbmFsIFNOUyB0b3BpYyB0byBzZW5kIG5vdGlmaWNhdGlvbnMgdG8gd2hlbiBhbiBhcHByb3ZhbCBpcyBwZW5kaW5nLlxuICAgKi9cbiAgcmVhZG9ubHkgbm90aWZpY2F0aW9uVG9waWM/OiBzbnMuSVRvcGljO1xuXG4gIC8qKlxuICAgKiBBIGxpc3Qgb2YgZW1haWwgYWRkcmVzc2VzIHRvIHN1YnNjcmliZSB0byBub3RpZmljYXRpb25zIHdoZW4gdGhpcyBBY3Rpb24gaXMgcGVuZGluZyBhcHByb3ZhbC5cbiAgICogSWYgdGhpcyBoYXMgYmVlbiBwcm92aWRlZCwgYnV0IG5vdCBgbm90aWZpY2F0aW9uVG9waWNgLFxuICAgKiBhIG5ldyBUb3BpYyB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqL1xuICByZWFkb25seSBub3RpZnlFbWFpbHM/OiBzdHJpbmdbXTtcblxuICAvKipcbiAgICogQW55IGFkZGl0aW9uYWwgaW5mb3JtYXRpb24gdGhhdCB5b3Ugd2FudCB0byBpbmNsdWRlIGluIHRoZSBub3RpZmljYXRpb24gZW1haWwgbWVzc2FnZS5cbiAgICovXG4gIHJlYWRvbmx5IGFkZGl0aW9uYWxJbmZvcm1hdGlvbj86IHN0cmluZztcblxuICAvKipcbiAgICogVVJMIHlvdSB3YW50IHRvIHByb3ZpZGUgdG8gdGhlIHJldmlld2VyIGFzIHBhcnQgb2YgdGhlIGFwcHJvdmFsIHJlcXVlc3QuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gdGhlIGFwcHJvdmFsIHJlcXVlc3Qgd2lsbCBub3QgaGF2ZSBhbiBleHRlcm5hbCBsaW5rXG4gICAqL1xuICByZWFkb25seSBleHRlcm5hbEVudGl0eUxpbms/OiBzdHJpbmc7XG59XG5cbi8qKlxuICogTWFudWFsIGFwcHJvdmFsIGFjdGlvbi5cbiAqL1xuZXhwb3J0IGNsYXNzIE1hbnVhbEFwcHJvdmFsQWN0aW9uIGV4dGVuZHMgQWN0aW9uIHtcbiAgLyoqXG4gICAqIFRoZSBTTlMgVG9waWMgcGFzc2VkIHdoZW4gY29uc3RydWN0aW5nIHRoZSBBY3Rpb24uXG4gICAqIElmIG5vIFRvcGljIHdhcyBwYXNzZWQsIGJ1dCBgbm90aWZ5RW1haWxzYCB3ZXJlIHByb3ZpZGVkLFxuICAgKiBhIG5ldyBUb3BpYyB3aWxsIGJlIGNyZWF0ZWQuXG4gICAqL1xuICBwcml2YXRlIF9ub3RpZmljYXRpb25Ub3BpYz86IHNucy5JVG9waWM7XG4gIHByaXZhdGUgcmVhZG9ubHkgcHJvcHM6IE1hbnVhbEFwcHJvdmFsQWN0aW9uUHJvcHM7XG4gIHByaXZhdGUgc3RhZ2U/OiBjb2RlcGlwZWxpbmUuSVN0YWdlO1xuXG4gIGNvbnN0cnVjdG9yKHByb3BzOiBNYW51YWxBcHByb3ZhbEFjdGlvblByb3BzKSB7XG4gICAgc3VwZXIoe1xuICAgICAgLi4ucHJvcHMsXG4gICAgICBjYXRlZ29yeTogY29kZXBpcGVsaW5lLkFjdGlvbkNhdGVnb3J5LkFQUFJPVkFMLFxuICAgICAgcHJvdmlkZXI6ICdNYW51YWwnLFxuICAgICAgYXJ0aWZhY3RCb3VuZHM6IHsgbWluSW5wdXRzOiAwLCBtYXhJbnB1dHM6IDAsIG1pbk91dHB1dHM6IDAsIG1heE91dHB1dHM6IDAgfSxcbiAgICB9KTtcblxuICAgIHRoaXMucHJvcHMgPSBwcm9wcztcbiAgfVxuXG4gIHB1YmxpYyBnZXQgbm90aWZpY2F0aW9uVG9waWMoKTogc25zLklUb3BpYyB8IHVuZGVmaW5lZCB7XG4gICAgcmV0dXJuIHRoaXMuX25vdGlmaWNhdGlvblRvcGljO1xuICB9XG5cbiAgLyoqXG4gICAqIGdyYW50IHRoZSBwcm92aWRlZCBwcmluY2lwYWwgdGhlIHBlcm1pc3Npb25zIHRvIGFwcHJvdmUgb3IgcmVqZWN0IHRoaXMgbWFudWFsIGFwcHJvdmFsIGFjdGlvblxuICAgKlxuICAgKiBGb3IgbW9yZSBpbmZvIHNlZTpcbiAgICogaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL2NvZGVwaXBlbGluZS9sYXRlc3QvdXNlcmd1aWRlL2FwcHJvdmFscy1pYW0tcGVybWlzc2lvbnMuaHRtbFxuICAgKlxuICAgKiBAcGFyYW0gZ3JhbnRhYmxlIHRoZSBncmFudGFibGUgdG8gYXR0YWNoIHRoZSBwZXJtaXNzaW9ucyB0b1xuICAgKi9cbiAgcHVibGljIGdyYW50TWFudWFsQXBwcm92YWwoZ3JhbnRhYmxlOiBpYW0uSUdyYW50YWJsZSk6IHZvaWQge1xuICAgIGlmICghdGhpcy5zdGFnZSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKCdDYW5ub3QgZ3JhbnQgcGVybWlzc2lvbnMgYmVmb3JlIGJpbmRpbmcgYWN0aW9uIHRvIGEgc3RhZ2UnKTtcbiAgICB9XG4gICAgZ3JhbnRhYmxlLmdyYW50UHJpbmNpcGFsLmFkZFRvUHJpbmNpcGFsUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KHtcbiAgICAgIGFjdGlvbnM6IFsnY29kZXBpcGVsaW5lOkxpc3RQaXBlbGluZXMnXSxcbiAgICAgIHJlc291cmNlczogWycqJ10sXG4gICAgfSkpO1xuICAgIGdyYW50YWJsZS5ncmFudFByaW5jaXBhbC5hZGRUb1ByaW5jaXBhbFBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ2NvZGVwaXBlbGluZTpHZXRQaXBlbGluZScsICdjb2RlcGlwZWxpbmU6R2V0UGlwZWxpbmVTdGF0ZScsICdjb2RlcGlwZWxpbmU6R2V0UGlwZWxpbmVFeGVjdXRpb24nXSxcbiAgICAgIHJlc291cmNlczogW3RoaXMuc3RhZ2UucGlwZWxpbmUucGlwZWxpbmVBcm5dLFxuICAgIH0pKTtcbiAgICBncmFudGFibGUuZ3JhbnRQcmluY2lwYWwuYWRkVG9QcmluY2lwYWxQb2xpY3kobmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoe1xuICAgICAgYWN0aW9uczogWydjb2RlcGlwZWxpbmU6UHV0QXBwcm92YWxSZXN1bHQnXSxcbiAgICAgIHJlc291cmNlczogW2Ake3RoaXMuc3RhZ2UucGlwZWxpbmUucGlwZWxpbmVBcm59LyR7dGhpcy5zdGFnZS5zdGFnZU5hbWV9LyR7dGhpcy5wcm9wcy5hY3Rpb25OYW1lfWBdLFxuICAgIH0pKTtcbiAgfVxuXG4gIHByb3RlY3RlZCBib3VuZChzY29wZTogQ29uc3RydWN0LCBzdGFnZTogY29kZXBpcGVsaW5lLklTdGFnZSwgb3B0aW9uczogY29kZXBpcGVsaW5lLkFjdGlvbkJpbmRPcHRpb25zKTogY29kZXBpcGVsaW5lLkFjdGlvbkNvbmZpZyB7XG4gICAgaWYgKHRoaXMucHJvcHMubm90aWZpY2F0aW9uVG9waWMpIHtcbiAgICAgIHRoaXMuX25vdGlmaWNhdGlvblRvcGljID0gdGhpcy5wcm9wcy5ub3RpZmljYXRpb25Ub3BpYztcbiAgICB9IGVsc2UgaWYgKCh0aGlzLnByb3BzLm5vdGlmeUVtYWlscyB8fCBbXSkubGVuZ3RoID4gMCkge1xuICAgICAgdGhpcy5fbm90aWZpY2F0aW9uVG9waWMgPSBuZXcgc25zLlRvcGljKHNjb3BlLCAnVG9waWNSZXNvdXJjZScpO1xuICAgIH1cblxuICAgIGlmICh0aGlzLl9ub3RpZmljYXRpb25Ub3BpYykge1xuICAgICAgdGhpcy5fbm90aWZpY2F0aW9uVG9waWMuZ3JhbnRQdWJsaXNoKG9wdGlvbnMucm9sZSk7XG4gICAgICBmb3IgKGNvbnN0IG5vdGlmeUVtYWlsIG9mIHRoaXMucHJvcHMubm90aWZ5RW1haWxzIHx8IFtdKSB7XG4gICAgICAgIHRoaXMuX25vdGlmaWNhdGlvblRvcGljLmFkZFN1YnNjcmlwdGlvbihuZXcgc3Vicy5FbWFpbFN1YnNjcmlwdGlvbihub3RpZnlFbWFpbCkpO1xuICAgICAgfVxuICAgIH1cblxuICAgIHRoaXMuc3RhZ2UgPSBzdGFnZTtcblxuICAgIHJldHVybiB7XG4gICAgICBjb25maWd1cmF0aW9uOiB1bmRlZmluZWRJZkFsbFZhbHVlc0FyZUVtcHR5KHtcbiAgICAgICAgTm90aWZpY2F0aW9uQXJuOiB0aGlzLl9ub3RpZmljYXRpb25Ub3BpYz8udG9waWNBcm4sXG4gICAgICAgIEN1c3RvbURhdGE6IHRoaXMucHJvcHMuYWRkaXRpb25hbEluZm9ybWF0aW9uLFxuICAgICAgICBFeHRlcm5hbEVudGl0eUxpbms6IHRoaXMucHJvcHMuZXh0ZXJuYWxFbnRpdHlMaW5rLFxuICAgICAgfSksXG4gICAgfTtcbiAgfVxuXG59XG5cbmZ1bmN0aW9uIHVuZGVmaW5lZElmQWxsVmFsdWVzQXJlRW1wdHkob2JqZWN0OiBvYmplY3QpOiBvYmplY3QgfCB1bmRlZmluZWQge1xuICByZXR1cm4gT2JqZWN0LnZhbHVlcyhvYmplY3QpLnNvbWUodiA9PiB2ICE9PSB1bmRlZmluZWQpID8gb2JqZWN0IDogdW5kZWZpbmVkO1xufVxuIl19